/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;

public class StorePurchaseRecDrawPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_query", "btn_confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.getView().getModel().setItemValueByID("org", parameter.getCustomParam("orgid"));
        this.query();
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (ctrl.getKey()) {
            case "btn_query": {
                this.query();
                break;
            }
            case "btn_confirm": {
                this.returnDataToParent();
                break;
            }
        }
    }

    private void query() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("billtype", "=", (Object)1145072539484278784L);
        String recBillNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"recbillno");
        if (!StringUtils.isEmpty((Object)recBillNo)) {
            filter.and("billno", "=", (Object)recBillNo);
        }
        if (dataEntity.get("startdate") != null) {
            filter.and("biztime", ">=", (Object)DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"startdate"));
            filter.and("biztime", "<", (Object)this.getDayAfter(DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"enddate")));
        }
        if (dataEntity.get("org") != null) {
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"org");
            filter.and("org", "=", (Object)orgId);
        }
        filter.and(QFilter.of((String)"entryentity.baseqty > entryentity.returnbaseqty", (Object[])new Object[0]));
        DynamicObject[] recBillList = BusinessDataServiceHelper.load((String)"ocpos_store_receive", (String)this.getCheckSheetField(), (QFilter[])filter.toArray());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.clear();
        for (DynamicObject recBill : recBillList) {
            for (DynamicObject billEntry : recBill.getDynamicObjectCollection("entryentity")) {
                DynamicObject entry = new DynamicObject(entryEntity.getDynamicObjectType());
                entry.set("billid", recBill.getPkValue());
                entry.set("billno", (Object)DynamicObjectUtils.getString((DynamicObject)recBill, (String)"billno"));
                entry.set("supplier", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)recBill, (String)"supplierfield"));
                entry.set("receiveorg", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)recBill, (String)"org"));
                entry.set("unit", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)billEntry, (String)"unit"));
                entry.set("qty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)billEntry, (String)"qty"));
                entry.set("bizorg", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)recBill, (String)"bizorg"));
                entry.set("warehouse", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)billEntry, (String)"warehouse"));
                entry.set("material", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)billEntry, (String)"material"));
                entry.set("goods", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)billEntry, (String)"goodsid"));
                entry.set("bizdate", (Object)DynamicObjectUtils.getDate((DynamicObject)recBill, (String)"bizdate"));
                entry.set("entryid", (Object)DynamicObjectUtils.getLong((DynamicObject)billEntry, (String)"id"));
                entryEntity.add((Object)entry);
            }
        }
        this.getView().updateView("entryentity");
    }

    private void returnDataToParent() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection docEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        int selectBillNum = this.getSelectBill(docEntry, selectRows);
        if (selectRows.length == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (IFormView)this.getView());
        } else if (selectBillNum > 1) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u6761\u8ba2\u5355\u8fdb\u884c\u5904\u7406\u3002", (IFormView)this.getView());
        } else {
            ArrayList<Object> selRows = new ArrayList<Object>(0);
            for (int selectRow : selectRows) {
                selRows.add(docEntry.get(selectRow));
            }
            if (selRows.size() > 0) {
                this.getView().returnDataToParent(selRows);
                this.getView().close();
            }
        }
    }

    private int getSelectBill(DynamicObjectCollection docEntry, int[] selectRows) {
        ArrayList<String> billList = new ArrayList<String>();
        for (int selectIndex : selectRows) {
            String billNo = ((DynamicObject)docEntry.get(selectIndex)).getString("billno");
            if (billList.contains(billNo)) continue;
            billList.add(billNo);
        }
        return billList.size();
    }

    private String getCheckSheetField() {
        return "id,billno,bizdate,billstatus,supplierfield,bizorg,biztype,org,entryentity.unit,entryentity.id,entryentity.qty,entryentity.warehouse,entryentity.material,entryentity.goodsid";
    }

    private Date getDayAfter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int days = calendar.get(5);
        calendar.set(5, days + 1);
        return calendar.getTime();
    }
}

