/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.botp.ReleaseConvertDataMutexPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.botp.ConvertService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.business.helper.PrecisionAccountHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormRuleUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.commonhelper.AmountHelper;
import kd.occ.ocpos.business.commonhelper.CurrencyHelper;
import kd.occ.ocpos.business.inventory.FillBatchHelper;
import kd.occ.ocpos.business.inventory.OtherInInvSchemeService;
import kd.occ.ocpos.business.inventory.OwnerHelper;
import kd.occ.ocpos.business.inventory.SerialNumberHelper;
import kd.occ.ocpos.business.inventory.TaxAlgorithmForForm;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.OwnerUtil;
import kd.occ.ocpos.common.vo.AmountInfo;
import org.apache.commons.lang3.StringUtils;

public class StoreReceiveEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String BTN_GENERATELOT = "generatelot";
    public static final String OTHER_FORMID = "im_otherinbill";
    public static final String BUY_FORMID = "im_purinbill";
    public static final String KEY_IM_TRANSOUTBILL = "im_transoutbill";
    public static final String OP_CHOOSEBILL = "choosebill";
    public static final String ACTION_CHOOSEBILLCLOSE = "choosebillclose";
    private DynamicObject invScheme;
    private final String CUR_AMTPRECISION = "amtprecision";
    private final String CUR_PRICEPRECISION = "priceprecision";
    private static final String PROP_INVOICESUPPLIER = "invoicesupplierid";
    private static final String PROP_RECEIVINGSUPPLIER = "receivingsupplierid";
    private static final String PROP_DELIVERSUPPLIER = "deliversupplierid";
    private static final String PROP_ENTRY_LINKMAN = "entry_linkman";
    private static final String PROP_ISDEFAULT_LINKMAN = "isdefault_linkman";
    private static final String PROP_SUPPLIERID = "supplierid";
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String[] SERIAL_NUMBER_OPS = new String[]{"checksnnumber", "entersnnumber", "importsnnumber"};
    private static final String[] INCHECKFIELDS = new String[]{"entryreqorg", "entrysettleorg", "supplierfield", "settlecurrency", "exratetable", "exchangerate", "paymode", "exratedate", "owner", "keeper"};
    private static boolean isRepeat = false;
    private List<RowDataEntity> dataEntities;
    private static Log logger = LogFactory.getLog(StoreReceiveEdit.class);
    private static String[] clearFields = new String[]{"auxpty", "producedate", "expirydate", "unit", "qty", "baseunit", "baseqty", "unit2nd", "qtyunit2nd", "lotnumber", "lot", "serialnumber", "mversion"};
    private TaxAlgorithmForForm algo = null;

    protected TaxAlgorithmForForm getAlgorithm() {
        if (this.algo == null) {
            this.algo = new TaxAlgorithmForForm(this.getView());
        }
        return this.algo;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CommonUtil.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"receivebranchid", "receiveorg", "biztype", "warehouse", "location", "goodsid", "providerlinkman", "bizoperator"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.initBaseInfo(dataEntity);
        this.afterCreateNewDetailData(this.getView());
        this.initializeReceiver();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (key) {
            case "receiveorg": {
                this.handleBizDeptF7Logic(showParameter);
                break;
            }
            case "biztype": {
                this.beforeBizType(showParameter, billTypeId);
                break;
            }
            case "receivebranchid": {
                this.beforeReceiveBranch(showParameter);
                break;
            }
            case "providerlinkman": {
                this.providerLinkmanSelect(e, rowIndex, showParameter);
                break;
            }
            case "goodsid": {
                this.setGoodsFilter(showParameter);
                break;
            }
            case "warehouse": {
                this.beforeWarehouse(e, showParameter);
                break;
            }
            case "location": {
                this.setPositionFilter(showParameter, e.getRow());
                break;
            }
            case "taxrateid": {
                this.taxrateSelect(e, showParameter);
                break;
            }
            case "bizoperator": {
                this.bizOperatorSelect(e, showParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String parentKey = e.getProperty().getParent().getName();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)parentKey, (CharSequence)"entryentity")) {
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                return;
            }
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)key, (CharSequence)"goodsid")) {
                this.goodsIdChanged(e.getChangeSet(), entryEntities);
            }
            for (ChangeData changeData : e.getChangeSet()) {
                if (CommonUtil.checkChanged((ChangeData)changeData)) continue;
                int rowIndex = changeData.getRowIndex();
                DynamicObject entry = (DynamicObject)entryEntities.get(rowIndex);
                switch (key) {
                    case "material": {
                        this.handleMaterialChangeEvent(changeData, entry, rowIndex);
                        break;
                    }
                    case "price": {
                        this.handlePriceChangeEvent(entry);
                        break;
                    }
                    case "amount": {
                        this.handleAmountChangeEvent(entry);
                        break;
                    }
                    case "qty": {
                        this.handleQtyChangeEvent(entry, rowIndex);
                        this.changeQtyOrUnit(entry, key, changeData, rowIndex);
                        this.handleTaxAndAmount(entry, rowIndex);
                        break;
                    }
                    case "qtyunit2nd": {
                        this.handleQtyUnit2ndChangeEvent(entry, rowIndex);
                        break;
                    }
                    case "providersupplier": {
                        this.handleProviceSupplier(changeData);
                        break;
                    }
                    case "priceandtax": 
                    case "discountrate": 
                    case "discountamount": {
                        this.handleTaxAndAmount(entry, rowIndex);
                        break;
                    }
                    case "discounttype": {
                        this.setControlEnable(entry, changeData, rowIndex);
                        break;
                    }
                    case "taxrateid": {
                        this.changeTaxRateID(entry, changeData);
                        break;
                    }
                    case "entryreqorg": 
                    case "entrysettleorg": {
                        this.setDefaltOwnerAndKeeper(rowIndex);
                        break;
                    }
                }
                this.getAlgorithm().calByChange(e);
            }
        } else {
            block44: for (ChangeData changeData : e.getChangeSet()) {
                if (CommonUtil.checkChanged((ChangeData)changeData)) continue;
                switch (key) {
                    case "supplierfield": {
                        this.handleSupplierChangeEvent(changeData);
                        continue block44;
                    }
                    case "settlecurrency": {
                        this.changeSettleCurrency(changeData);
                        continue block44;
                    }
                    case "biztype": {
                        this.setQtyMustinput();
                        this.setQtyEnable();
                        this.setInvScheme();
                        continue block44;
                    }
                    case "bizoperator": {
                        this.changeBizOperator(changeData);
                        continue block44;
                    }
                    case "bizorg": {
                        this.changeBizOrg(changeData);
                        continue block44;
                    }
                    case "receivebranchid": {
                        this.changeBranch(changeData);
                        continue block44;
                    }
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "fillbatch": {
                FillBatchHelper.batchFill((IFormView)this.getView());
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setQtyMustinput();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("entryentity".equals(entryName)) {
            RowDataEntity[] rows = e.getRowDataEntities();
            IFormView view = this.getView();
            for (RowDataEntity row : rows) {
                int rowIndex = row.getRowIndex();
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"baseqty"});
            }
            this.afterCreateNewDetailData(this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (Arrays.asList(SERIAL_NUMBER_OPS).contains(operateKey)) {
            SerialNumberHelper.beforeHandleSerialNumber((AbstractBillPlugIn)this, (BeforeDoOperationEventArgs)e);
        } else if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            boolean isCheck;
            DynamicObjectCollection goodList = dataEntity.getDynamicObjectCollection("entryentity");
            goodList.removeIf(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") == 0L);
            if (CollectionUtils.isEmpty((Collection)goodList)) {
                this.getView().showErrorNotification("\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u3002");
                e.setCancel(true);
            }
            if (!(isCheck = this.checkLotAndSerialCode(operateKey))) {
                e.setCancel(true);
            }
            this.getView().updateView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (Arrays.asList(SERIAL_NUMBER_OPS).contains(opKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows != null && selectRows.length == 1) {
                DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
                SerialNumberHelper.handleSerialNumber((AbstractBillPlugIn)this, (DynamicObject)dataEntity, (DynamicObject)((DynamicObject)entryEntities.get(selectRows[0])), (String)opKey);
            }
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)opKey, (CharSequence)"searchinventory")) {
            this.showQueryInventory();
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)opKey, (CharSequence)OP_CHOOSEBILL)) {
            this.showSrcBillForm();
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)opKey, (CharSequence)"submit")) {
            this.setReceiveQty();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)actionId, (CharSequence)ACTION_CHOOSEBILLCLOSE)) {
            Object returnData = e.getReturnData();
            if (ObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
            if (returnData instanceof List) {
                List selRows = (List)returnData;
                this.drawConvertBill(billTypeId, selRows);
                this.afterDraw();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        DynamicObject newSettleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
        switch (key) {
            case "switchsettlecurrency": {
                if ("Yes".equals(messageBoxClosedEvent.getResultValue())) {
                    DynamicObject exRateTable = (DynamicObject)this.getModel().getValue("exratetable");
                    Date bizTime = (Date)this.getModel().getValue("exratedate");
                    BigDecimal exchange = BigDecimal.ZERO;
                    if (exRateTable != null) {
                        exchange = CurrencyHelper.getExChangeRate((Long)Long.valueOf(this.getPageCache().get("oldSettleCurrency")), (Long)((Long)newSettleCurrency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)bizTime);
                    }
                    if (exchange == null || exchange == BigDecimal.ZERO) {
                        String oldName = this.getPageCache().get("oldSettleCurrencyName");
                        NotificationUtil.showDefaultTipNotify((String)String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u201c%s\u201d\u548c\u201c%s\u201d\u95f4\u7684\u6709\u6548\u6c47\u7387\uff0c\u5355\u4ef7\u3001\u91d1\u989d\u4fe1\u606f\u672a\u66f4\u65b0\u3002", (String)"BillTplPlugin_27", (String)"scmc-pm-formplugin", (Object[])new Object[0]), oldName, newSettleCurrency.getString("name")), (IFormView)this.getView());
                        if (Integer.parseInt(this.getPageCache().get("oldAmtprecision")) == newSettleCurrency.getInt("amtprecision") && Integer.parseInt(this.getPageCache().get("oldPriceprecision")) == newSettleCurrency.getInt("priceprecision")) {
                            return;
                        }
                        this.calAllAmount();
                        return;
                    }
                    Boolean istax = (Boolean)this.getModel().getValue("istax");
                    DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                    if (istax.booleanValue()) {
                        for (int i = 0; i < entrys.size(); ++i) {
                            BigDecimal priceandtax = (BigDecimal)this.getModel().getValue("priceandtax", i);
                            priceandtax = priceandtax.multiply(exchange);
                            this.getModel().beginInit();
                            this.getModel().setValue("priceandtax", (Object)priceandtax, i);
                            this.getModel().endInit();
                        }
                    } else {
                        for (int i = 0; i < entrys.size(); ++i) {
                            BigDecimal price = (BigDecimal)this.getModel().getValue("price", i);
                            price = price.multiply(exchange);
                            this.getModel().beginInit();
                            this.getModel().setValue("price", (Object)price, i);
                            this.getModel().endInit();
                        }
                    }
                    this.getView().updateView("entryentity");
                    this.calAllAmount();
                    break;
                }
                if (Integer.parseInt(this.getPageCache().get("oldAmtprecision")) == newSettleCurrency.getInt("amtprecision") && Integer.parseInt(this.getPageCache().get("oldPriceprecision")) == newSettleCurrency.getInt("priceprecision")) {
                    return;
                }
                this.calAllAmount();
            }
        }
    }

    private void afterDraw() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        DynamicObject[] goodsArray = this.getItemByMaterial(entryEntity);
        if (goodsArray == null || goodsArray.length == 0) {
            entryEntity.clear();
            return;
        }
        for (DynamicObject entry : entryEntity) {
            DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)entry, (String)"material");
            long materialId = DynamicObjectUtils.getPkValue((DynamicObject)material, (String)"masterid");
            DynamicObject goods = Arrays.stream(goodsArray).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x.getDynamicObject("materialmasterid")) == materialId).findFirst().orElse(null);
            if (goods == null) continue;
            entry.set("goodsid", (Object)goods);
            entry.set("brand", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)goods, (String)"itembrands"));
            entry.set("goodsclass", (Object)PosItemUtil.queryItemClass((DynamicObject)goods));
        }
        this.afterCreateNewDetailData(this.getView());
        DynamicObject receiveBranch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"receivebranchid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)receiveBranch);
        this.initStock(branchId);
        this.getView().updateView("entryentity");
    }

    private DynamicObject[] getItemByMaterial(DynamicObjectCollection docItemEntry) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdbd_iteminfo");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        List lstMaterialId = docItemEntry.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"material"), (String)"masterid")).collect(Collectors.toList());
        filter.and("materialmasterid", "in", lstMaterialId);
        return BusinessDataServiceHelper.load((String)"ocdbd_iteminfo", (String)kd.bos.dataentity.utils.StringUtils.join((Object[])fieldKeys, (String)","), (QFilter[])filter.toArray());
    }

    private void initializeReceiver() {
        DynamicObject receiveBranch = this.getModel().getDataEntity(true).getDynamicObject("receivebranchid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)receiveBranch);
        QFilter qFilter = new QFilter("owner", "=", (Object)branchId);
        qFilter.and("sysuser", "=", (Object)Long.parseLong(RequestContext.get().getUserId()));
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject channelUser = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"id", (QFilter[])qFilter.toArray());
        if (channelUser != null) {
            this.getModel().setValue("receiver", channelUser.get("id"));
        }
    }

    private DynamicObject[] getBarCodeInfo(List<Long> lstGoodsId) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdbd_item_barcode");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        return BusinessDataServiceHelper.load((String)"ocdbd_item_barcode", (String)kd.bos.dataentity.utils.StringUtils.join((Object[])fieldKeys, (String)","), (QFilter[])new QFilter[]{new QFilter("item", "in", lstGoodsId)});
    }

    private void showQueryInventory() {
        DynamicObjectCollection entryEntities;
        EntryGrid entryGrid;
        int[] selectRows;
        long currencyId;
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"receivebranchid");
        customParams.put("owner", branchId);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"org");
        if (orgId > 0L) {
            customParams.put("stockOrgId", Collections.singletonList(orgId));
        }
        if ((currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currency")) > 0L) {
            customParams.put("currency", currencyId);
        }
        if ((selectRows = (entryGrid = (EntryGrid)this.getView().getControl("entryentity")).getSelectRows()) != null && selectRows.length > 0 && !CollectionUtils.isEmpty((Collection)(entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity")))) {
            HashSet<Long> itemIds = new HashSet<Long>();
            for (int selectRow : selectRows) {
                DynamicObject entryRow = (DynamicObject)entryEntities.get(selectRow);
                long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryRow, (String)"goodsid");
                if (goodsId <= 0L) continue;
                itemIds.add(goodsId);
            }
            customParams.put("itemIdSet", itemIds);
        }
        customParams.put("extQTyShow", Boolean.TRUE);
        ListShowParameter listShowParameter = FormShowUtils.openNewList((String)"", (String)"ocpos_valiableinv_stand", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showSrcBillForm() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"org");
        String formId = null;
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("billtypeid", billTypeId);
        if (billTypeId == 1153534418477108224L) {
            if (orgId == 0L) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5f55\u5165\u8c03\u5165\u7ec4\u7ec7\u3002", (IFormView)this.getView());
                return;
            }
            customParams.put("orgid", orgId);
            long recChannelId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"receivebranchid");
            customParams.put("receivebranchid", recChannelId);
            formId = "ocpos_selectsrcbill";
        } else if (billTypeId == 1145072539484278784L) {
            customParams.put("org", dataEntity.getDynamicObject("org").getPkValue());
            formId = "ocpos_storebuy_pick";
        }
        customParams.put("formid", "ocpos_store_receive");
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"\u9009\u62e9\u6e90\u5355", (String)formId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setShowTitle(true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_CHOOSEBILLCLOSE));
        this.getView().showForm(parameter);
    }

    private void initBaseInfo(DynamicObject dataEntity) {
        long branchId = OwnerUtil.getDefaultOwnerId();
        this.getModel().setValue("receivebranchid", (Object)branchId);
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"receivebranchid");
        this.initInvOrg(branch);
        this.initStock(branchId);
        this.getView().updateView("entryentity");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        FormShowParameter parentFormShowParameter = this.getView().getParentView().getFormShowParameter();
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)((CharSequence)parentFormShowParameter.getCustomParam("billtype")))) {
            formShowParameter = parentFormShowParameter;
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)((CharSequence)formShowParameter.getCustomParam("billtype")))) {
            this.getModel().setValue("billtype", formShowParameter.getCustomParam("billtype"));
            String formId = null;
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)((CharSequence)formShowParameter.getCustomParam("billtype")), (CharSequence)"1142844869962777600")) {
                formId = OTHER_FORMID;
                this.getModel().setValue("biztype", (Object)"738270780932080640");
            } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)((CharSequence)formShowParameter.getCustomParam("billtype")), (CharSequence)"1145072539484278784")) {
                formId = BUY_FORMID;
                this.getModel().setValue("biztype", (Object)"422857170485263360");
                long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"saleorg");
                long orgId = InventoryUtils.getDefaultInvOrgId((long)saleOrgId);
                this.getModel().setValue("entrysettleorg", (Object)orgId, 0);
                this.getModel().setValue("entryreqorg", (Object)orgId, 0);
                this.setBuyMustInput();
            } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)((CharSequence)formShowParameter.getCustomParam("billtype")), (CharSequence)"1153534418477108224")) {
                this.getView().getModel().setItemValueByID("biztype", (Object)422889961931423744L);
            }
            this.initInvSchemeData(formId);
        }
    }

    private void initInvOrg(DynamicObject branch) {
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"saleorg");
        long orgId = InventoryUtils.getDefaultInvOrgId((long)saleOrgId);
        this.getModel().setItemValueByID("org", (Object)orgId);
        this.getModel().setItemValueByID("receiveorg", (Object)orgId);
        this.getModel().setItemValueByID("bizorg", (Object)orgId);
        this.getModel().setItemValueByID("bizdept", (Object)orgId);
        this.initCurrency(orgId);
    }

    private void initStock(Long branchId) {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        QFilter filter = new QFilter("ownerchannelid", "=", (Object)branchId);
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        DynamicObject[] dycObjs = BusinessDataServiceHelper.load((String)"ococic_warehouse", (String)"erpwarehouseid", (QFilter[])filter.toArray());
        if (dycObjs == null || dycObjs.length == 0) {
            return;
        }
        DynamicObject dycObj = Arrays.stream(dycObjs).findFirst().orElse(null);
        DynamicObject doStock = DynamicObjectUtils.getDynamicObject((DynamicObject)dycObj, (String)"erpwarehouseid");
        DynamicObjectCollection entry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        if (!CollectionUtils.isEmpty((Collection)entry)) {
            for (DynamicObject doEntry : entry) {
                doEntry.set("warehouse", (Object)doStock);
            }
        }
    }

    private void setBuyMustInput() {
        for (int i = 0; i < INCHECKFIELDS.length; ++i) {
            FieldEdit control = (FieldEdit)this.getView().getControl(INCHECKFIELDS[i]);
            if (control == null) continue;
            control.setMustInput(true);
        }
    }

    private void setQtyMustinput() {
        String[] inCheckFields = new String[]{"qty", "baseqty"};
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject biztype = (DynamicObject)model.getValue("biztype");
        if (null == biztype) {
            StoreReceiveEdit.setControlMustInput(view, true, inCheckFields);
            return;
        }
        String biztypeNum = biztype.getString("number");
        if (!"350".equals(biztypeNum)) {
            StoreReceiveEdit.setControlMustInput(view, true, inCheckFields);
        } else {
            StoreReceiveEdit.setControlMustInput(view, false, inCheckFields);
        }
    }

    private void setInvScheme() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
        long bizTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"biztype");
        String formId = null;
        if (billTypeId == 1153534418477108224L) {
            formId = KEY_IM_TRANSOUTBILL;
        } else if (billTypeId == 1145072539484278784L) {
            formId = BUY_FORMID;
        } else if (billTypeId == 1142844869962777600L) {
            formId = OTHER_FORMID;
        }
        DynamicObject invScheme = StoreReceiveEdit.getInvSchemeByEntityAndBizType(formId, bizTypeId);
        this.getModel().setValue("invscheme", (Object)DynamicObjectUtils.getPkValue((DynamicObject)invScheme));
        this.getView().updateView("invscheme");
    }

    private void changeBizOperator(ChangeData changeData) {
        DynamicObject bizOperator = (DynamicObject)changeData.getNewValue();
        if (bizOperator != null) {
            bizOperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizOperator.getPkValue(), (String)"bd_operator");
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", bizOperator.get("operatorgrpid"));
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
            if (bizOrg == null) {
                return;
            }
            List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)((Long)bizOrg.getPkValue()), (boolean)true);
            if (deptids != null && deptids.size() > 0) {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    for (Long deptId : userdeptIds) {
                        if (!deptids.contains(deptId)) continue;
                        this.getModel().beginInit();
                        this.getModel().setValue("bizdept", (Object)deptId);
                        this.getModel().endInit();
                        this.getView().updateView("bizdept");
                        break;
                    }
                }
            } else {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatoridS").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    this.getModel().beginInit();
                    this.getModel().setValue("bizdept", userdeptIds.get(0));
                    this.getModel().endInit();
                    this.getView().updateView("bizdept");
                }
            }
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", null);
            this.getModel().setValue("bizdept", null);
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            this.getView().updateView("bizdept");
        }
    }

    private void changeBizOrg(ChangeData changeData) {
        DynamicObject bizOrg = (DynamicObject)changeData.getNewValue();
        Long bizOrgId = (Long)bizOrg.getPkValue();
        this.initCurrencyAndExrateTable(bizOrgId);
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.initBizOrg(bizOrg, i);
        }
        this.changeBizDept(bizOrgId);
        this.getModel().setValue("bizoperator", null);
        this.getModel().setValue("bizoperatorgroup", null);
    }

    private void changeBranch(ChangeData changeData) {
        DynamicObject branch = (DynamicObject)changeData.getNewValue();
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
        this.initStock(branchId);
        this.getView().updateView("entryentity");
    }

    private void initCurrencyAndExrateTable(Long bizOrg) {
        if (bizOrg != 0L) {
            DynamicObject exRateTable;
            IDataModel model = this.getModel();
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)bizOrg);
            if (map == null) {
                return;
            }
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            if (currency == null) {
                model.setValue("currency", map.get("baseCurrencyID"));
            }
            if ((exRateTable = (DynamicObject)model.getValue("exratetable")) == null) {
                model.setValue("exratetable", map.get("exchangeRateTableID"));
            }
        }
    }

    private void initBizOrg(DynamicObject bizOrg, int rowIndex) {
        IDataModel model = this.getModel();
        if (bizOrg != null) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)bizOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (map != null) {
                model.setValue("entrysettleorg", (Object)((Long)map.get("id")), rowIndex);
            } else {
                model.setValue("entrysettleorg", null, rowIndex);
            }
        }
    }

    private void changeBizDept(Long orgId) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && deptIds.size() > 0) {
            this.getModel().setValue("bizdept", deptIds.get(0));
        }
        if ((deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true)) != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
            this.getModel().setValue("bizdept", (Object)orgId);
            return;
        }
        this.getModel().setValue("bizdept", null);
    }

    private void setQtyEnable() {
        int size = this.getModel().getEntryEntity("entryentity").size();
        for (int index = 0; index < size; ++index) {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{"qty"});
        }
    }

    private void goodsIdChanged(ChangeData[] changeSet, DynamicObjectCollection entryEntities) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
        DynamicObject classStdApply = PosItemUtil.getClassStandardApply();
        DynamicObject supplier = dataEntity.getDynamicObject("supplierfield");
        if (isRepeat) {
            isRepeat = false;
            return;
        }
        DataSetBuilder goodsDataBuilder = this.getGoodsDataBuilder();
        HashSet<Long> materialIds = new HashSet<Long>(changeSet.length);
        for (ChangeData changeData : changeSet) {
            if (CommonUtil.checkChanged((ChangeData)changeData)) {
                return;
            }
            int index = changeData.getRowIndex();
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
            if (1145072539484278784L == billTypeId && supplier == null) {
                isRepeat = true;
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u7ef4\u62a4\u4f9b\u5e94\u5546", (IFormView)this.getView());
                entryEntity.set("goodsid", changeData.getOldValue());
                return;
            }
            DynamicObject goods = (DynamicObject)changeData.getNewValue();
            if (goods == null) {
                isRepeat = true;
                entryEntity.set("goodsid", changeData.getOldValue());
                return;
            }
            DynamicObject materialinventoryinfo = this.getInventoryMaterial(goods);
            if (null == materialinventoryinfo) {
                NotificationUtil.showDefaultTipNotify((String)("\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1" + goods.getString("number") + "\u7269\u6599\u5e93\u5b58\u4fe1\u606f"), (IFormView)this.getView());
                isRepeat = true;
                entryEntity.set("goodsid", changeData.getOldValue());
                return;
            }
            DynamicObject goodsClass = null;
            if (goods != null) {
                goodsClass = PosItemUtil.queryItemClass((DynamicObject)classStdApply, (DynamicObject)goods);
            }
            entryEntity.set("goodsclass", (Object)goodsClass);
            DynamicObject taxRate = DynamicObjectUtils.getDynamicObject((DynamicObject)this.getMaterial(goods), (String)"taxrate");
            if (taxRate != null) {
                entryEntity.set("taxrateid", (Object)taxRate);
                entryEntity.set("taxrate", taxRate.get("taxrate"));
            }
            long materialId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"material");
            materialIds.add(materialId);
            goodsDataBuilder.append(new Object[]{index, materialId});
        }
        if (!CollectionUtils.isEmpty(materialIds)) {
            DataSet goodsData = goodsDataBuilder.build();
            this.dataEntities = new ArrayList<RowDataEntity>();
            this.initMaterial(entryEntities, goodsData, materialIds);
            if (!CollectionUtils.isEmpty(this.dataEntities)) {
                DynamicProperty property = entryEntities.getDynamicObjectType().getProperty("material");
                FormRuleUtils.raiseFormRules((IFormView)this.getView(), this.dataEntities, (IDataEntityProperty)property);
            }
        }
        this.getView().updateView("entryentity");
    }

    private DataSetBuilder getGoodsDataBuilder() {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        fields.add(new Field("index", (DataType)DataType.IntegerType));
        fields.add(new Field("material", (DataType)DataType.LongType));
        RowMeta meta = new RowMeta(fields.toArray(new Field[0]));
        return Algo.create((String)"goodsid").createDataSetBuilder(meta);
    }

    private String getGoodsMaterialInvInfoFields() {
        Object[] fields = new String[]{"index", "case when id is null then 0 else id end as id"};
        return kd.bos.dataentity.utils.StringUtils.join((Object[])fields, (char)',');
    }

    private void initMaterial(DynamicObjectCollection entryEntities, DataSet goodsData, Set<Long> materialIds) {
        QFilter filter = F7Util.getMaterialInvFilter();
        filter.and("masterid.id", "in", materialIds);
        DataSet materialInvData = QueryServiceHelper.queryDataSet((String)"materialmasterid", (String)"bd_materialinventoryinfo", (String)"id, masterid.id as masterid", (QFilter[])filter.toArray(), null);
        DataSet data = goodsData.fullJoin(materialInvData).on("material", "masterid").select(new String[]{"index", "id"}).finish();
        if (data != null) {
            DataSet dataSet = data.select(this.getGoodsMaterialInvInfoFields());
            this.getModel().beginInit();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                int index = row.getInteger("index");
                long materialInvId = row.getLong("id");
                if (materialInvId == 0L) continue;
                this.getModel().setValue("material", (Object)materialInvId, index);
                this.dataEntities.add((RowDataEntity)new ChangeData(index, (DynamicObject)entryEntities.get(index), (Object)0L, (Object)materialInvId));
            }
            this.getModel().endInit();
        }
    }

    private DynamicObject getInventoryMaterial(DynamicObject item) {
        return BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (String)"masterid,inventoryunit,baseunit,enablelot,lotcoderule,enableserial,serialrule,enableshelflifemgr,shelflife", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)item.getDynamicObject("material")))});
    }

    private DynamicObject getMaterial(DynamicObject item) {
        return BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"id,taxrate", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)item.getDynamicObject("material")))});
    }

    private void handleMaterialChangeEvent(ChangeData changeData, DynamicObject entry, int rowIndex) {
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        if (((DynamicObject)newValue).getBoolean("enablelot")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_GENERATELOT});
        }
        this.changeMaterial((DynamicObject)newValue, entry, rowIndex);
    }

    private void changeMaterial(DynamicObject materialInvInfo, DynamicObject entry, int rowIndex) {
        IDataModel bill = this.getModel();
        for (String key : clearFields) {
            entry.set(key, null);
        }
        if (materialInvInfo != null) {
            this.resetMaterialInfo(bill, materialInvInfo, entry, rowIndex);
        }
    }

    private void resetMaterialInfo(IDataModel bill, DynamicObject materialInvInfo, DynamicObject entry, int rowIndex) {
        DynamicObject material = null;
        material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u7269\u6599\u5b9a\u4e49\u9519\u8bef\uff0c\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\uff01", (IFormView)this.getView());
            return;
        }
        this.resetMaterialUnits(materialInvInfo, material, entry, rowIndex);
        Boolean isuseauxpty = material.getBoolean("isuseauxpty");
        this.getView().setEnable(isuseauxpty, rowIndex, new String[]{"auxpty"});
        entry.set("lotnumber", null);
        Boolean enablelot = materialInvInfo.getBoolean("enablelot");
        this.getView().setEnable(enablelot, rowIndex, new String[]{"lotnumber"});
        boolean isOnShelf = materialInvInfo.getBoolean("enableshelflifemgr");
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"producedate"});
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"expirydate"});
        BigDecimal baseqty = (BigDecimal)bill.getValue("baseqty", rowIndex);
        boolean enableSerialNum = material.getBoolean("enableserial") && baseqty != null && BigDecimal.ONE.compareTo(baseqty) == 0;
        this.getView().setEnable(Boolean.valueOf(enableSerialNum), rowIndex, new String[]{"serialnumber"});
    }

    private void resetMaterialUnits(DynamicObject materialInvInfo, DynamicObject material, DynamicObject entry, int rowIndex) {
        DynamicObject baseUnit = material.getDynamicObject("baseunit");
        if (baseUnit == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u7269\u6599\u5b9a\u4e49\u9519\u8bef\uff0c\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\uff01", (IFormView)this.getView());
            return;
        }
        Object auxptyUnitId = null;
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        Boolean isUseAuxptyUnit = auxptyUnit != null;
        this.getView().setEnable(isUseAuxptyUnit, rowIndex, new String[]{"qtyunit2nd"});
        DynamicObject unit = materialInvInfo.getDynamicObject("inventoryunit");
        if (unit == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u7269\u6599\u5b9a\u4e49\u9519\u8bef\uff0c\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\uff01", (IFormView)this.getView());
            return;
        }
        entry.set("unit", (Object)unit);
        entry.set("baseunit", (Object)baseUnit);
        entry.set("unit2nd", (Object)auxptyUnit);
    }

    public void initInvSchemeData(String formId) {
        IFormView view = this.getView();
        IDataModel bill = view.getModel();
        DynamicObject bizType = (DynamicObject)bill.getValue("biztype");
        if (bizType == null) {
            return;
        }
        DynamicObject invScheme = StoreReceiveEdit.getInvSchemeByEntityAndBizType(formId, bizType.getLong("id"));
        Object invSchemeId = null;
        if (invScheme != null) {
            invSchemeId = invScheme.getPkValue();
        }
        this.getModel().setValue("invscheme", invSchemeId);
    }

    public static DynamicObject getInvSchemeByEntityAndBizType(String billFormID, Long bizTypeID) {
        if (billFormID == null || bizTypeID == null || bizTypeID == 0L) {
            return null;
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"im_invscheme");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        QFilter qFilter1 = new QFilter("billform", "=", (Object)billFormID);
        QFilter qFilter2 = new QFilter("bitypeentry.biztype", "=", (Object)bizTypeID);
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter4 = new QFilter("bitypeentry.allowmanualadd", "=", (Object)"1");
        LinkedHashMap invSchemesMap = (LinkedHashMap)BusinessDataServiceHelper.loadFromCache((String)"im_invscheme", (String)kd.bos.dataentity.utils.StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4}, (String)"number");
        if (invSchemesMap == null || invSchemesMap.isEmpty()) {
            return null;
        }
        Collection values = invSchemesMap.values();
        DynamicObject[] invSchemes = values.toArray(new DynamicObject[values.size()]);
        return invSchemes[0];
    }

    private void handleSupplierChangeEvent(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
        DynamicObject supplier = (DynamicObject)newValue;
        this.getModel().setValue("invoicesupplier", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)supplier, (String)PROP_INVOICESUPPLIER));
        this.getModel().setValue("receivesupplier", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)supplier, (String)PROP_RECEIVINGSUPPLIER));
        this.getModel().setValue("providersupplier", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)supplier, (String)PROP_DELIVERSUPPLIER));
        if (1153534418477108224L != billTypeId) {
            DynamicObject invScheme = this.getInvScheme();
            if (invScheme == null) {
                dataEntity.set("supplierfield", null);
                this.getView().showErrorNotification("\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002");
                return;
            }
            String ownerType = invScheme.getString("ownertype");
            String outOwnerType = invScheme.getString("outownertype");
            boolean isInUpdate = invScheme.getBoolean("isinupdate");
            boolean isOutUpdate = invScheme.getBoolean("isnotupdate");
            if (!"bd_supplier".equals(ownerType) && !"bd_supplier".equals(outOwnerType)) {
                return;
            }
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                if (isInUpdate) {
                    this.getModel().setValue("owner", (Object)supplier, rowIndex);
                }
                if (!isOutUpdate) continue;
                this.getModel().setValue("outowner", (Object)supplier, rowIndex);
            }
        }
    }

    private void handleProviceSupplier(ChangeData changeData) {
        DynamicObject providerSupplier = (DynamicObject)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        String providerAddress = null;
        DynamicObjectCollection linkmans = null;
        if (providerSupplier != null) {
            providerAddress = StoreReceiveEdit.getValidDefaultMultilingualAddress(providerSupplier);
            linkmans = providerSupplier.getDynamicObjectCollection(PROP_ENTRY_LINKMAN);
        }
        Long supplierLinkmanId = null;
        if (linkmans != null) {
            for (DynamicObject linkman : linkmans) {
                boolean isDefault = linkman.getBoolean(PROP_ISDEFAULT_LINKMAN);
                boolean isInvalid = linkman.getBoolean("invalid");
                if (!isDefault || isInvalid) continue;
                supplierLinkmanId = (Long)linkman.getPkValue();
            }
        }
        if (supplierLinkmanId == null && linkmans != null && linkmans.size() > 0) {
            for (DynamicObject linkman : linkmans) {
                boolean isInvalid = linkman.getBoolean("invalid");
                if (isInvalid) continue;
                supplierLinkmanId = (Long)linkman.getPkValue();
                break;
            }
        }
        this.getModel().setValue("provideraddress", (Object)providerAddress, rowIndex);
        this.getModel().setValue("providerlinkman", supplierLinkmanId, rowIndex);
    }

    private static String getValidDefaultMultilingualAddress(DynamicObject supplier) {
        QFilter filter = new QFilter(PROP_SUPPLIERID, "=", (Object)supplier.getString("id"));
        filter.and("default", "=", (Object)Boolean.TRUE);
        filter.and("invalid", "=", (Object)Boolean.FALSE);
        ArrayList<String> properties = new ArrayList<String>(2);
        properties.add("id");
        properties.add("detailaddress");
        String selectProperties = StringUtils.join(properties, (char)',');
        DynamicObject address = BusinessDataServiceHelper.loadSingle((String)"bd_address", (String)selectProperties, (QFilter[])filter.toArray());
        return address == null ? null : address.getString("detailaddress");
    }

    private void handleQtyChangeEvent(DynamicObject entry, int rowIndex) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
        BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
        int precision = this.getPrecision("settlecurrency", "amtprecision");
        BigDecimal amount_all = qty.multiply(price);
        BigDecimal amount = amount_all.setScale(precision, 4);
        entry.set("amount", (Object)amount);
    }

    private void handleQtyUnit2ndChangeEvent(DynamicObject entry, int rowIndex) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
        BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
        int precision = this.getPrecision("settlecurrency", "amtprecision");
        BigDecimal amount_all = qty.multiply(price);
        BigDecimal amount = amount_all.setScale(precision, 4);
        entry.set("amount", (Object)amount);
    }

    private void handleTaxAndAmount(DynamicObject entry, int rowIndex) {
        BigDecimal taxPrice;
        BigDecimal qty = entry.getBigDecimal("qty") != null ? entry.getBigDecimal("qty") : BigDecimal.ZERO;
        BigDecimal bigDecimal = taxPrice = entry.getBigDecimal("priceandtax") != null ? entry.getBigDecimal("priceandtax") : BigDecimal.ZERO;
        if (taxPrice.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        entry.set("price", (Object)taxPrice);
        BigDecimal discountAmount = entry.getBigDecimal("discountamount") != null ? entry.getBigDecimal("discountamount") : BigDecimal.ZERO;
        int precision = this.getPrecision("settlecurrency", "amtprecision");
        BigDecimal discountRate = entry.getBigDecimal("discountrate") != null ? entry.getBigDecimal("discountrate") : BigDecimal.ZERO;
        String discountType = (String)this.getModel().getValue("discounttype");
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"A", (CharSequence)discountType)) {
            discountAmount = qty.multiply(taxPrice).multiply(discountRate.divide(new BigDecimal(100)));
            entry.set("discountamount", (Object)discountAmount);
            this.getView().updateView("discountamount", rowIndex);
        }
        BigDecimal amount_all = qty.multiply(taxPrice).subtract(discountAmount);
        BigDecimal amountAndTax = amount_all.setScale(precision, 4);
        BigDecimal amountSingle = qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : amountAndTax.divide(qty).setScale(2);
        entry.set("amountandtax", (Object)amountAndTax);
        entry.set("amount", (Object)amountAndTax);
        entry.set("actualprice", (Object)amountSingle);
        entry.set("actualtaxprice", (Object)amountSingle);
        this.getView().updateView("price", rowIndex);
        this.getView().updateView("amountandtax", rowIndex);
        this.getView().updateView("actualprice", rowIndex);
        this.getView().updateView("actualtaxprice", rowIndex);
        this.getView().updateView("amount", rowIndex);
    }

    private void handleAmountChangeEvent(DynamicObject entry) {
        BigDecimal amount = entry.getBigDecimal("amount");
        BigDecimal qty = entry.getBigDecimal("qty");
        int pricePrecision = this.getPrecision("settlecurrency", "priceprecision");
        BigDecimal price = amount.divide(qty, pricePrecision, 4);
        entry.set("price", (Object)price);
    }

    protected int getPrecision(String currencyf, String pref) {
        int precision = 2;
        if ("priceprecision".equals(pref)) {
            return 10;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue(currencyf);
        if (currency != null) {
            precision = currency.getInt(pref);
        }
        return precision;
    }

    private void handlePriceChangeEvent(DynamicObject entry) {
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal price = entry.getBigDecimal("price");
        int precision = this.getPrecision("settlecurrency", "amtprecision");
        BigDecimal amount_all = qty.multiply(price);
        entry.set("amount", (Object)amount_all.setScale(precision, 4));
    }

    private void handleBizDeptF7Logic(ListShowParameter showParameter) {
        DynamicObject orgDyc = (DynamicObject)this.getModel().getValue("org");
        if (orgDyc == null) {
            return;
        }
        long orgId = (Long)orgDyc.getPkValue();
        List depts = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (depts != null && depts.size() > 0) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)depts));
        }
    }

    private void beforeBizType(ListShowParameter showParameter, Long billTypeId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        QFilter qFilter1 = new QFilter("billentity.billform", "=", (Object)OTHER_FORMID);
        if (billTypeId == 1142844869962777600L) {
            qFilter1 = new QFilter("billentity.billform", "=", (Object)OTHER_FORMID);
        } else if (billTypeId == 1145072539484278784L) {
            qFilter1 = new QFilter("billentity.billform", "=", (Object)BUY_FORMID);
        } else if (billTypeId == 1153534418477108224L) {
            qFilter1 = new QFilter("billentity.billform", "=", (Object)KEY_IM_TRANSOUTBILL);
        }
        QFilter qFilter2 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        filterList.add(qFilter1);
        filterList.add(qFilter2);
        filterList.add(qFilter3);
        showParameter.getListFilterParameter().setQFilters(filterList);
    }

    private void beforeWarehouse(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u6536\u8d27\u7ec4\u7ec7!", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        QFilter warehouseF7Filter = StoreReceiveEdit.getCustomWarehouseF7Filter(formId, org);
        if (warehouseF7Filter == null) {
            return;
        }
        showParameter.getListFilterParameter().setFilter(warehouseF7Filter);
        Long[] allWhs = StoreReceiveEdit.getAllWarehouse(Collections.singletonList(org.getPkValue())).toArray(new Long[0]);
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
    }

    private void setGoodsFilter(ListShowParameter showParameter) {
        QFilter qFilter = new QFilter("masterid.status", "=", (Object)StatusEnum.AUDIT.getValue());
        qFilter.and("masterid.enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        qFilter.and(F7Utils.getCommonStatusFilter());
        DynamicObjectCollection materialInv = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"id,masterid", (QFilter[])qFilter.toArray());
        QFilter filter = new QFilter("material", "in", materialInv.stream().map(x -> x.get("masterid")).collect(Collectors.toList()));
        showParameter.getListFilterParameter().setFilter(filter);
    }

    private void beforeReceiveBranch(ListShowParameter showParameter) {
        showParameter.getListFilterParameter().setFilter(F7Util.getBranchSalerFilter());
    }

    private void providerLinkmanSelect(BeforeF7SelectEvent e, int rowIndex, ListShowParameter showParameter) {
        DynamicObject providerSupplier = (DynamicObject)this.getModel().getValue("providersupplier", rowIndex);
        if (providerSupplier == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u4f9b\u5e94\u5546\uff01", (IFormView)this.getView());
            e.setCancel(true);
        } else {
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter(PROP_SUPPLIERID, "=", providerSupplier.getPkValue()).and("invalid", "=", (Object)Boolean.FALSE)));
        }
    }

    public static List<Long> getAllWarehouse(List<Object> orgIds) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (orgIds == null || orgIds.size() == 0) {
            return result;
        }
        QFilter orgf = new QFilter("org", "in", (Object)orgIds.toArray());
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        String selects = "warehouse.id";
        Map warehouseDycs = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)selects, (QFilter[])new QFilter[]{orgf});
        Map warehouseMap = StoreReceiveEdit.getDynamicObjectMap(selects, warehouseDycs.values().toArray(new DynamicObject[0]));
        result = new ArrayList(warehouseMap.keySet());
        return result;
    }

    public static <K> Map<K, DynamicObject> getDynamicObjectMap(String key, DynamicObject[] dyc) {
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>();
        if (dyc != null && dyc.length > 0) {
            for (DynamicObject item : dyc) {
                result.put(item.get(key), item);
            }
        }
        return result;
    }

    public static QFilter getCustomWarehouseF7Filter(String formId, DynamicObject org) {
        long userId = UserServiceHelper.getCurrentUserId();
        List<DynamicObject> wareHouses = StoreReceiveEdit.getWarehouseByUserIdAndOrgId(userId, Collections.singletonList(org.getLong("id")));
        if (CollectionUtils.isEmpty(wareHouses)) {
            return null;
        }
        ArrayList<Long> wareHouseIds = new ArrayList<Long>(16);
        for (DynamicObject wareHose : wareHouses) {
            Long wareHosePkValue = (Long)wareHose.getPkValue();
            wareHouseIds.add(wareHosePkValue);
        }
        return new QFilter("id", "in", wareHouseIds);
    }

    public static List<DynamicObject> getWarehouseByUserIdAndOrgId(Long userId, List<Long> orgIds) {
        ArrayList<DynamicObject> warehouses = new ArrayList<DynamicObject>(16);
        if (orgIds.isEmpty()) {
            return warehouses;
        }
        Set<Long> operatorIds = StoreReceiveEdit.getOperatorIds(userId);
        DynamicObject[] warehouseSetups = StoreReceiveEdit.getWarehouseSetups(orgIds, operatorIds);
        StoreReceiveEdit.warehouseCorrection(orgIds, warehouses, warehouseSetups);
        return warehouses;
    }

    private static Set<Long> getOperatorIds(Long userId) {
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userId);
        qFilter1.and(new QFilter("opergrptype", "=", (Object)"KCZ"));
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bd_operator", (String)"id", (QFilter[])qFilter1.toArray());
        HashSet<Long> operatorIds = new HashSet<Long>(ids.length);
        if (ids.length <= 0) {
            return operatorIds;
        }
        for (DynamicObject id : ids) {
            operatorIds.add(Long.parseLong(id.getPkValue().toString()));
        }
        return operatorIds;
    }

    private static DynamicObject[] getWarehouseSetups(List<Long> orgIds, Set<Long> operatorIds) {
        QFilter qFilter = new QFilter("org", "in", orgIds);
        qFilter.and(new QFilter("operatorentity.operatoruser", "in", operatorIds));
        qFilter.and(new QFilter("startstatus", "=", (Object)"B"));
        return BusinessDataServiceHelper.load((String)"im_warehousesetup", (String)"org,warehouse", (QFilter[])qFilter.toArray());
    }

    private static void warehouseCorrection(List<Long> orgIds, List<DynamicObject> warehouses, DynamicObject[] warehouseSetups) {
        ArrayList<Long> notOperatorOrgIds = new ArrayList<Long>(orgIds);
        for (DynamicObject warehouseSetup : warehouseSetups) {
            warehouses.add(warehouseSetup.getDynamicObject("warehouse"));
            DynamicObject org = warehouseSetup.getDynamicObject("org");
            Object orgId = org.getPkValue();
            notOperatorOrgIds.remove(orgId);
        }
        if (!notOperatorOrgIds.isEmpty()) {
            QFilter orgf = new QFilter("org", "in", (Object)notOperatorOrgIds.toArray());
            orgf.and(new QFilter("startstatus", "=", (Object)"B"));
            Map warehouseDycs = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"warehouse", (QFilter[])new QFilter[]{orgf});
            for (Map.Entry objectEntry : warehouseDycs.entrySet()) {
                DynamicObject warehouse = ((DynamicObject)objectEntry.getValue()).getDynamicObject("warehouse");
                warehouses.add(warehouse);
            }
        }
    }

    private void initCurrency(Long bizOrg) {
        Map<String, Long> map = StoreReceiveEdit.getCurrencyAndExRateTable(bizOrg);
        if (map == null) {
            return;
        }
        this.getModel().setValue("currency", (Object)map.get("baseCurrencyID"));
        this.getModel().setValue("standardcurrency", (Object)map.get("baseCurrencyID"));
        this.getModel().setValue("exratetable", (Object)map.get("exchangeRateTableID"));
        BigDecimal rate = CurrencyHelper.getExChangeRate((Long)map.get("baseCurrencyID"), (Long)map.get("baseCurrencyID"), (Long)map.get("exchangeRateTableID"), (Date)new Date());
        if (rate != null) {
            this.getModel().setValue("exchangerate", (Object)rate);
        }
        DynamicObject receiveBranch = this.getModel().getDataEntity(true).getDynamicObject("receivebranchid");
        Map currencyMap = CurrencyHelper.initCurrency((DynamicObject)receiveBranch, (long)bizOrg);
        this.getModel().setItemValueByID("settlecurrency", currencyMap.get("currencyid"));
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        this.getModel().setValue("exratedate", (Object)bizDate);
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != 0L && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return null;
    }

    public static void setControlMustInput(IFormView view, boolean isMustInput, String ... keys) {
        for (int i = 0; i < keys.length; ++i) {
            FieldEdit control = (FieldEdit)view.getControl(keys[i]);
            if (control == null) continue;
            control.setMustInput(isMustInput);
        }
    }

    private void afterCreateNewDetailData(IFormView view) {
        DynamicObjectCollection InvBillEntryList = (DynamicObjectCollection)view.getModel().getValue("entryentity");
        int entrySize = InvBillEntryList.size();
        for (int rowIndex = 0; rowIndex < entrySize; ++rowIndex) {
            DynamicObject invScheme = this.getInvScheme();
            this.initEntrysValue(view, invScheme, rowIndex);
            OtherInInvSchemeService invSchemeService = this.getInvSchemeService();
            this.setEntrySchemeEnable(invSchemeService, view, rowIndex);
            this.setDefalutOwnerAndKeeeper(invSchemeService, view, rowIndex);
            this.setSupplierInfo(rowIndex);
        }
    }

    private void setSupplierInfo(int rowIndex) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject supplier = dataEntity.getDynamicObject("supplierfield");
        if (supplier != null) {
            this.getModel().setValue("invoicesupplier", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)supplier, (String)PROP_INVOICESUPPLIER), rowIndex);
            this.getModel().setValue("receivesupplier", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)supplier, (String)PROP_RECEIVINGSUPPLIER), rowIndex);
            this.getModel().setValue("providersupplier", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)supplier, (String)PROP_DELIVERSUPPLIER), rowIndex);
        }
        DynamicObject providerSupplier = (DynamicObject)this.getModel().getValue("providersupplier", rowIndex);
        String providerAddress = null;
        DynamicObjectCollection linkmans = null;
        if (providerSupplier != null) {
            providerAddress = StoreReceiveEdit.getValidDefaultMultilingualAddress(providerSupplier);
            linkmans = providerSupplier.getDynamicObjectCollection(PROP_ENTRY_LINKMAN);
        }
        Long supplierLinkmanId = null;
        if (linkmans != null) {
            for (DynamicObject linkman : linkmans) {
                boolean isDefault = linkman.getBoolean(PROP_ISDEFAULT_LINKMAN);
                boolean isInvalid = linkman.getBoolean("invalid");
                if (!isDefault || isInvalid) continue;
                supplierLinkmanId = (Long)linkman.getPkValue();
            }
        }
        if (supplierLinkmanId == null && linkmans != null && linkmans.size() > 0) {
            for (DynamicObject linkman : linkmans) {
                boolean isInvalid = linkman.getBoolean("invalid");
                if (isInvalid) continue;
                supplierLinkmanId = (Long)linkman.getPkValue();
                break;
            }
        }
        this.getModel().setValue("provideraddress", (Object)providerAddress, rowIndex);
        this.getModel().setValue("providerlinkman", supplierLinkmanId, rowIndex);
    }

    public void setEntrySchemeEnable(OtherInInvSchemeService service, IFormView view, int i) {
        if (service != null) {
            service.setOutKeeperEnable(i);
            service.setKeeperEnable(i);
        }
    }

    protected OtherInInvSchemeService getInvSchemeService() {
        OtherInInvSchemeService invSchemeService = new OtherInInvSchemeService(this.getView());
        invSchemeService.setBill(this.getView().getModel().getDataEntity(true));
        return invSchemeService;
    }

    public void setDefalutOwnerAndKeeeper(OtherInInvSchemeService service, IFormView view, int i) {
        IDataModel model = view.getModel();
        boolean initialized = model.isInitialized();
        if (service != null) {
            if (!initialized) {
                model.beginInit();
            }
            String outKeeperType = (String)model.getValue("outkeepertype", i);
            Object defalutOutKeeperId = null;
            if (!StringUtils.isEmpty((CharSequence)outKeeperType)) {
                defalutOutKeeperId = service.getDefalutOutKeeper(outKeeperType, i);
            }
            model.setValue("outkeeper", defalutOutKeeperId, i);
            String outOwnerType = (String)model.getValue("outownertype", i);
            Object defalutOutOwnerId = null;
            if (!StringUtils.isEmpty((CharSequence)outOwnerType)) {
                defalutOutOwnerId = service.getDefalutOutOwner(outOwnerType, i);
            }
            model.setValue("outowner", defalutOutOwnerId, i);
            String keeperType = (String)model.getValue("keepertype", i);
            Object defalutKeeperId = null;
            if (!StringUtils.isEmpty((CharSequence)keeperType)) {
                defalutKeeperId = service.getDefalutKeeper(keeperType, i);
            }
            model.setValue("keeper", defalutKeeperId, i);
            String ownerType = (String)model.getValue("ownertype", i);
            Object defalutOwnerId = null;
            if (!StringUtils.isEmpty((CharSequence)ownerType)) {
                defalutOwnerId = service.getDefalutOwner(ownerType, i);
            }
            model.setValue("owner", defalutOwnerId, i);
            if (!initialized) {
                model.endInit();
                view.updateView("outkeeper", i);
                view.updateView("outowner", i);
                view.updateView("keeper", i);
                view.updateView("owner", i);
            }
        }
    }

    private DynamicObject getInvScheme() {
        if (this.invScheme == null) {
            IDataModel bill = this.getModel();
            this.invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getValue("invscheme"), (String)"im_invscheme");
        }
        return this.invScheme;
    }

    public void initEntrysValue(IFormView view, DynamicObject invScheme, int ... rows) {
        IDataModel bill = view.getModel();
        boolean initialized = bill.isInitialized();
        if (invScheme == null || rows == null || rows.length == 0) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        String ownerType = null;
        String keeperType = null;
        DynamicObject invStatus = null;
        DynamicObject invType = null;
        Object invStatusId = null;
        Object invTypeId = null;
        if (isInUpdate) {
            ownerType = invScheme.getString("ownertype");
            keeperType = invScheme.getString("keepertype");
            invStatus = StoreReceiveEdit.getDefaultInvStatus(invScheme);
            invType = StoreReceiveEdit.getDefaltInvtype(invScheme);
            invStatusId = invStatus == null ? null : invStatus.getPkValue();
            invTypeId = invType == null ? null : invType.getPkValue();
        }
        String outOwnerType = null;
        String outKeeperType = null;
        DynamicObject outInvTtatus = null;
        DynamicObject outInvType = null;
        Object outInvStatusId = null;
        Object outInvTypeId = null;
        if (isOutUpdate) {
            outOwnerType = invScheme.getString("outownertype");
            outKeeperType = invScheme.getString("outkeepertype");
            outInvTtatus = StoreReceiveEdit.getDefaultOutInvStatus(invScheme);
            outInvType = StoreReceiveEdit.getDefaltOutInvtype(invScheme);
            outInvStatusId = outInvTtatus == null ? null : outInvTtatus.getPkValue();
            outInvTypeId = outInvType == null ? null : outInvType.getPkValue();
        }
        for (int i = 0; i < rows.length; ++i) {
            int rowIndex = rows[i];
            if (!initialized) {
                bill.beginInit();
            }
            bill.setValue("owner", null, rowIndex);
            bill.setValue("keeper", null, rowIndex);
            bill.setValue("ownertype", (Object)ownerType, rowIndex);
            bill.setValue("keepertype", (Object)keeperType, rowIndex);
            bill.setValue("outowner", null, rowIndex);
            bill.setValue("outkeeper", null, rowIndex);
            bill.setValue("outownertype", (Object)outOwnerType, rowIndex);
            bill.setValue("outkeepertype", (Object)outKeeperType, rowIndex);
            bill.setValue("invstatus", invStatusId, rowIndex);
            bill.setValue("invtype", invTypeId, rowIndex);
            bill.setValue("outinvstatus", outInvStatusId, rowIndex);
            bill.setValue("outinvtype", outInvTypeId, rowIndex);
            if (initialized) continue;
            bill.endInit();
            view.updateView("owner", rowIndex);
            view.updateView("keeper", rowIndex);
            view.updateView("ownertype", rowIndex);
            view.updateView("keepertype", rowIndex);
            view.updateView("invstatus", rowIndex);
            view.updateView("invtype", rowIndex);
            view.updateView("outowner", rowIndex);
            view.updateView("outkeeper", rowIndex);
            view.updateView("outownertype", rowIndex);
            view.updateView("outkeepertype", rowIndex);
            view.updateView("outinvstatus", rowIndex);
            view.updateView("outinvtype", rowIndex);
        }
    }

    public static DynamicObject getDefaultInvStatus(DynamicObject invScheme) {
        return StoreReceiveEdit.getDefaultInvTypeOrStatus(invScheme, "invstatusentry", "invstatusisdefault", "invstatus");
    }

    public static DynamicObject getDefaultOutInvStatus(DynamicObject invScheme) {
        return StoreReceiveEdit.getDefaultInvTypeOrStatus(invScheme, "outinvstatusentry", "outinvstatusisdefault", "outinvstatus");
    }

    public static DynamicObject getDefaltInvtype(DynamicObject invScheme) {
        return StoreReceiveEdit.getDefaultInvTypeOrStatus(invScheme, "invtypeentry", "invtypeisdefault", "invtype");
    }

    public static DynamicObject getDefaltOutInvtype(DynamicObject invScheme) {
        return StoreReceiveEdit.getDefaultInvTypeOrStatus(invScheme, "outinvtypeentry", "outinvtypeisdefault", "outinvtype");
    }

    private static DynamicObject getDefaultInvTypeOrStatus(DynamicObject invScheme, String invTypeOrStatusEntry, String invTypeOrStatusIsDefault, String invTypeOrStatus) {
        DynamicObjectCollection entries = invScheme.getDynamicObjectCollection(invTypeOrStatusEntry);
        DynamicObject defaultInvTypeOrStatus = null;
        if (entries != null && entries.size() > 0) {
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean(invTypeOrStatusIsDefault)) continue;
                defaultInvTypeOrStatus = entry.getDynamicObject(invTypeOrStatus);
                break;
            }
            if (defaultInvTypeOrStatus == null) {
                defaultInvTypeOrStatus = ((DynamicObject)entries.get(0)).getDynamicObject(invTypeOrStatus);
            }
        }
        return defaultInvTypeOrStatus;
    }

    private void changeQtyOrUnit(DynamicObject entry, String propName, ChangeData changeData, int rowIndex) {
        DynamicObject bizType;
        Object newValue = changeData.getNewValue();
        if ("unit".equals(propName)) {
            this.getView().setEnable(Boolean.valueOf(newValue != null), rowIndex, new String[]{"qty"});
        }
        IDataModel bill = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!"im_initbill".equals(formId) && (bizType = (DynamicObject)bill.getValue("biztype")) != null && ("370".equals(bizType.get("number")) || "380".equals(bizType.get("number")))) {
            return;
        }
        DynamicObject material = entry.getDynamicObject("material");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((Object)material)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f", (IFormView)this.getView());
        }
        StoreReceiveEdit.setBizQtyAndUnit(entry, bill, rowIndex, propName, newValue);
    }

    public static void setBizQtyAndUnit(DynamicObject entry, IDataModel bill, int rowIndex, String fieldName, Object newValue) {
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        DynamicObject unit = entry.getDynamicObject("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal unitRate = BigDecimal.ZERO;
        if (baseUnit != null && unit != null) {
            unitRate = StoreReceiveEdit.getUnitRateConv((Long)materialInvInfo.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
        }
        switch (fieldName) {
            case "qty": {
                qty = (BigDecimal)newValue;
                if (unitRate != null) {
                    baseQty = qty.multiply(unitRate);
                    baseQty = PrecisionAccountHelper.dealWithprecision((IDataModel)bill, (String)"baseunit", (int)rowIndex, (BigDecimal)baseQty);
                }
                entry.set("baseqty", (Object)baseQty);
                break;
            }
            case "unit": {
                if (newValue == null) {
                    return;
                }
                unit = (DynamicObject)newValue;
                int precision = unit.getInt("precision");
                String precisionAccountString = unit.getString("precisionaccount");
                int precisionAccount = 4;
                if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)precisionAccountString)) {
                    precisionAccount = Integer.parseInt(precisionAccountString);
                }
                qty = qty.setScale(precision, precisionAccount);
                entry.set("qty", (Object)qty);
                if (material != null && unit != null && baseUnit != null) {
                    unitRate = StoreReceiveEdit.getUnitRateConv((Long)material.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
                }
                if (unitRate != null) {
                    baseQty = qty.multiply(unitRate);
                }
                entry.set("baseqty", (Object)baseQty);
                break;
            }
        }
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            try {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("numerator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }

    private ConvertOperationResult draw(DrawArgs args) {
        String argsJson = SerializationUtils.toJsonString((Object)args);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)args.getSourceEntityNumber());
        String resultStr = (String)DispatchServiceHelper.invokeBOSService((String)dt.getAppId(), (String)ConvertService.class.getSimpleName(), (String)"draw", (Object[])new Object[]{argsJson});
        return (ConvertOperationResult)SerializationUtils.fromJsonString((String)resultStr, ConvertOperationResult.class);
    }

    private void drawConvertBill(Long billTypeId, List<DynamicObject> selRows) {
        String ruleId = null;
        String sourceEntity = null;
        String targetEntity = null;
        String entryEntity = null;
        if (selRows == null || selRows.size() == 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u672a\u9009\u62e9\u4efb\u4f55\u6e90\u5355\u6570\u636e\u3002", (IFormView)this.getView());
            return;
        }
        if (billTypeId == 1145072539484278784L) {
            ruleId = "1154175946299831296";
            sourceEntity = "pm_purorderbill";
        } else if (billTypeId == 1153534418477108224L) {
            ruleId = "1153465342719179776";
            sourceEntity = KEY_IM_TRANSOUTBILL;
        } else if (billTypeId == 1142844869962777600L) {
            // empty if block
        }
        targetEntity = "ocpos_store_receive";
        entryEntity = "billentry";
        try {
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(0);
            for (DynamicObject row : selRows) {
                ListSelectedRow selectedRow = new ListSelectedRow((Object)DynamicObjectUtils.getLong((DynamicObject)row, (String)"billid"));
                selectedRow.setEntryEntityKey(entryEntity);
                selectedRow.setEntryPrimaryKeyValue((Object)DynamicObjectUtils.getLong((DynamicObject)row, (String)"entryid"));
                selectedRows.add(selectedRow);
            }
            DrawArgs args = new DrawArgs();
            args.setSourceEntityNumber(sourceEntity);
            args.setTargetEntityNumber(targetEntity);
            args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
            args.getSelectedRows().addAll(selectedRows);
            args.setTargetPageId(this.getView().getPageId());
            args.setRuleId(ruleId);
            args.setBuildConvReport(true);
            ConvertOperationResult result = this.draw(args);
            if (!result.isSuccess() || result.getCachePageIds().size() == 0) {
                Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
            } else {
                IBillView billView = (IBillView)this.getView();
                IRefrencedataProvider refProvider = BusinessDataReader::loadRefence;
                List dataEntities = result.loadTargetDataObjects(refProvider, billView.getModel().getDataEntityType());
                this.addReleaseSourceDataMutexPlugin((IFormView)billView, result);
                ((IBillModel)billView.getModel()).push(dataEntities.get(0));
                billView.updateView();
                this.getView().sendFormAction((IFormView)billView);
                result.release(refProvider, billView.getModel().getDataEntityType());
            }
        }
        catch (Exception ex) {
            NotificationUtil.showDefaultTipNotify((String)ex.getMessage(), (IFormView)this.getView());
        }
    }

    private void addReleaseSourceDataMutexPlugin(IFormView billView, ConvertOperationResult drawResult) {
        boolean exist = false;
        String plugInName = ReleaseConvertDataMutexPlugin.class.getName();
        for (Plugin plugin : billView.getFormShowParameter().getFormConfig().getPlugins()) {
            if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)plugin.getClassName(), (CharSequence)plugInName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            billView.getFormShowParameter().addCustPlugin(plugInName);
            billView.cacheFormShowParameter();
        }
        ReleaseConvertDataMutexPlugin.addConvertDataMutex((IFormView)billView, (String)drawResult.getSourceEntityNumber(), (Collection)drawResult.getDataMutexSrcBillIds());
    }

    private boolean checkLotAndSerialCode(String operateKey) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
            DynamicObject entry = (DynamicObject)entryEntity.get(rowIndex);
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) {
                NotificationUtil.showDefaultTipNotify((String)("\u7b2c" + (rowIndex + 1) + "\u884c\u5546\u54c1\u5bf9\u5e94\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a,\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f"), (IFormView)this.getView());
                return false;
            }
            if (!material.getBoolean("enablelot") || !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)entry.getString("lotnumber"))) continue;
            NotificationUtil.showDefaultTipNotify((String)("\u7b2c" + (rowIndex + 1) + "\u884c\u5546\u54c1\u5bf9\u5e94\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u542f\u7528\u4e86\u6279\u53f7,\u8bf7\u5f55\u5165\u6279\u53f7"), (IFormView)this.getView());
            return false;
        }
        return true;
    }

    private void changeSettleCurrency(ChangeData changeData) {
        DynamicObject oldSettleCurrency = (DynamicObject)changeData.getOldValue();
        DynamicObject newSettleCurrency = (DynamicObject)changeData.getNewValue();
        this.changeCurOrTable();
        if (oldSettleCurrency == null || newSettleCurrency == null) {
            this.getPageCache().put("changeSupply", "0");
            this.getPageCache().put("gainprice", "0");
            this.calAllAmount();
            return;
        }
        this.getPageCache().put("oldSettleCurrency", String.valueOf(oldSettleCurrency.getPkValue()));
        this.getPageCache().put("oldAmtprecision", String.valueOf(oldSettleCurrency.getInt("priceprecision")));
        this.getPageCache().put("oldPriceprecision", String.valueOf(oldSettleCurrency.getInt("amtprecision")));
        this.getPageCache().put("oldSettleCurrencyName", oldSettleCurrency.getString("name"));
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("switchsettlecurrency", StoreReceiveEdit.class.getTypeName());
        this.getView().showConfirm(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u522b\u5207\u6362\u540e\uff0c\u662f\u5426\u6309\u65b0\u65e7\u7ed3\u7b97\u5e01\u522b\u95f4\u7684\u6c47\u7387\uff0c\u91cd\u7b97\u5355\u4ef7\u3001\u91d1\u989d\u4fe1\u606f\uff1f", (String)"BillTplPlugin_26", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
    }

    private void changeTaxRateID(DynamicObject entry, ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        if (null != newValue) {
            DynamicObject taxRateID = (DynamicObject)newValue;
            entry.set("taxrate", taxRateID.get("taxrate"));
        } else {
            entry.set("taxrate", (Object)0);
        }
        this.getView().updateView("taxrate", changeData.getRowIndex());
    }

    private void setDefaltOwnerAndKeeper(int rowIndex) {
        this.setOwner(rowIndex);
        this.setKeeper(rowIndex);
        this.setOutOwner(rowIndex);
        this.setOutKeeper(rowIndex);
    }

    private Long setOwner(int rowIndex) {
        Long owner = null;
        IDataModel bill = this.getModel();
        DynamicObject reqOrg = (DynamicObject)bill.getValue("entryreqorg", rowIndex);
        DynamicObject supplier = (DynamicObject)bill.getValue("supplierfield");
        Map orgMap = new HashMap();
        String ownerType = (String)this.getModel().getValue("ownertype", rowIndex);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)ownerType)) {
            bill.setValue("owner", owner, rowIndex);
            return owner;
        }
        switch (ownerType) {
            case "bos_org": {
                if (reqOrg != null) {
                    orgMap = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)reqOrg.getPkValue()), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                }
                owner = (Long)orgMap.get("id");
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"owner"});
                break;
            }
            case "bd_customer": {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"owner"});
                break;
            }
            case "bd_supplier": {
                if (supplier != null) {
                    owner = (Long)supplier.getPkValue();
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"owner"});
                break;
            }
        }
        bill.setValue("owner", owner, rowIndex);
        return owner;
    }

    private void setOutOwner(int rowIndex) {
        Long outOwner = null;
        IDataModel bill = this.getModel();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject supplier = (DynamicObject)bill.getValue("supplierfield");
        HashMap orgMap = new HashMap();
        String outOwnerType = (String)this.getModel().getValue("outownertype", rowIndex);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)outOwnerType)) {
            bill.setValue("outowner", null, rowIndex);
            return;
        }
        switch (outOwnerType) {
            case "bos_org": {
                ArrayList orgIds;
                outOwner = (Long)orgMap.get("id");
                if (org == null || (orgIds = OwnerHelper.getOwners((Long)Long.parseLong(org.getPkValue().toString()))) == null || orgIds.size() <= 0) break;
                outOwner = Long.valueOf(orgIds.get(0).toString());
                break;
            }
            case "bd_customer": {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"owner"});
                break;
            }
            case "bd_supplier": {
                if (supplier == null) break;
                outOwner = (Long)supplier.getPkValue();
                break;
            }
        }
        bill.setValue("outowner", (Object)outOwner, rowIndex);
    }

    private Long setKeeper(int rowIndex) {
        Long keeperId = null;
        IDataModel bill = this.getModel();
        DynamicObject org = (DynamicObject)bill.getValue("org");
        DynamicObject supplier = (DynamicObject)bill.getValue("supplierfield");
        String keeperType = (String)this.getModel().getValue("keepertype", rowIndex);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)keeperType)) {
            bill.setValue("keeper", keeperId, rowIndex);
            return keeperId;
        }
        switch (keeperType) {
            case "bos_org": {
                if (org != null) {
                    keeperId = (Long)org.getPkValue();
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keeper"});
                break;
            }
            case "bd_customer": {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"keeper"});
                break;
            }
            case "bd_supplier": {
                if (supplier != null) {
                    keeperId = (Long)supplier.getPkValue();
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"keeper"});
                break;
            }
        }
        bill.setValue("keeper", keeperId, rowIndex);
        return keeperId;
    }

    private Long setOutKeeper(int rowIndex) {
        Long outKeeperId = null;
        IDataModel bill = this.getModel();
        DynamicObject supplier = (DynamicObject)bill.getValue("supplierfield");
        String keeperType = (String)this.getModel().getValue("outkeepertype", rowIndex);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)keeperType)) {
            bill.setValue("outkeeper", outKeeperId, rowIndex);
            return outKeeperId;
        }
        switch (keeperType) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)bill.getValue("org");
                if (org != null) {
                    outKeeperId = (Long)org.getPkValue();
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"outkeeper"});
                break;
            }
            case "bd_customer": {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"outkeeper"});
                break;
            }
            case "bd_supplier": {
                if (supplier != null) {
                    outKeeperId = (Long)supplier.getPkValue();
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"outkeeper"});
                break;
            }
        }
        bill.setValue("outkeeper", outKeeperId, rowIndex);
        return outKeeperId;
    }

    protected void taxrateSelect(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        IDataModel dataModel = this.getModel();
        Object bizTime = dataModel.getValue("bizdate");
        if (bizTime == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u65e5\u671f!", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        QFilter f = new QFilter("activedate", "<=", bizTime);
        QFilter fExpdate = new QFilter("expdate", ">=", bizTime);
        fExpdate.or(new QFilter("expdate", "is null", null));
        f.and(fExpdate);
        showParameter.getListFilterParameter().setFilter(f);
    }

    private void bizOperatorSelect(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        QFilter enableFilter;
        long bizOrgId;
        QFilter operatorGroupIdFilter;
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification("\u8bf7\u9009\u62e9" + displayName);
            e.setCancel(true);
            return;
        }
        BasedataEdit control = (BasedataEdit)this.getControl("bizoperatorgroup");
        BasedataProp property = (BasedataProp)control.getProperty();
        FilterBuilder buildCoreFilter = property.buildCoreFilter(this.getModel());
        QFilter filterGridFilter = buildCoreFilter.getQFilter();
        Map currentBizOrgBizOperatorGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{filterGridFilter, operatorGroupIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)(bizOrgId = Long.parseLong(bizOrg.getPkValue().toString()))), enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (currentBizOrgBizOperatorGroup != null && !currentBizOrgBizOperatorGroup.isEmpty()) {
            HashSet keySet = new HashSet(currentBizOrgBizOperatorGroup.keySet());
            QFilter qFilter = new QFilter("operatorgrpid", "in", new ArrayList(keySet));
            QFilter qFilter1 = new QFilter("invalid", "=", (Object)"0");
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter, qFilter1));
        } else {
            showParameter.getListFilterParameter().setFilter(new QFilter("operatorgrpid", "in", null));
        }
    }

    private String getBizOrgDisplayName() {
        BasedataEdit bizOrgEdit = (BasedataEdit)this.getControl("bizorg");
        IDataEntityProperty orgProp = bizOrgEdit.getProperty();
        LocaleString displayName = orgProp.getDisplayName();
        return displayName.toString();
    }

    private void changeCurOrTable() {
        IDataModel model = this.getModel();
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        DynamicObject exRateTable = (DynamicObject)model.getValue("exratetable");
        Date bizTime = (Date)model.getValue("exratedate");
        if (currency != null && settleCurrency != null && exRateTable != null && bizTime != null) {
            model.setValue("exchangerate", (Object)CurrencyHelper.getExChangeRate((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)bizTime));
        } else {
            model.setValue("exchangerate", null);
        }
    }

    private void calAllAmount() {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        BigDecimal totalAmountAndTax = ZERO;
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (entrys != null && !entrys.isEmpty()) {
            DataEntityPropertyCollection properties = ((DynamicObject)entrys.get(0)).getDynamicObjectType().getProperties();
            DynamicProperty qtyP = (DynamicProperty)properties.get((Object)"qty");
            DynamicProperty priceP = (DynamicProperty)properties.get((Object)"price");
            DynamicProperty priceAndTaxP = (DynamicProperty)properties.get((Object)"priceandtax");
            DynamicProperty taxRateP = (DynamicProperty)properties.get((Object)"taxrate");
            DynamicProperty discountTypeP = (DynamicProperty)properties.get((Object)"discounttype");
            DynamicProperty discountRateP = (DynamicProperty)properties.get((Object)"discountrate");
            DynamicProperty amountP = (DynamicProperty)properties.get((Object)"amount");
            DynamicProperty discountAmountP = (DynamicProperty)properties.get((Object)"discountamount");
            DynamicProperty amountAndTaxP = (DynamicProperty)properties.get((Object)"amountandtax");
            DynamicProperty curAmountP = (DynamicProperty)properties.get((Object)"curamount");
            DynamicProperty curTaxAmountP = (DynamicProperty)properties.get((Object)"curtaxamount");
            DynamicProperty curAmountAndTaxP = (DynamicProperty)properties.get((Object)"amountandtax");
            for (DynamicObject entry : entrys) {
                BigDecimal qty = (BigDecimal)qtyP.getValueFast((Object)entry);
                BigDecimal price = (BigDecimal)priceP.getValueFast((Object)entry);
                BigDecimal priceAndTax = (BigDecimal)priceAndTaxP.getValueFast((Object)entry);
                BigDecimal taxRate = (BigDecimal)taxRateP.getValueFast((Object)entry);
                String discountType = (String)discountTypeP.getValueFast((Object)entry);
                BigDecimal discountRate = (BigDecimal)discountRateP.getValueFast((Object)entry);
                AmountInfo amountInfo = new AmountInfo();
                amountInfo.setTax(isTax);
                amountInfo.setQty(qty);
                amountInfo.setPrice(price);
                amountInfo.setPriceAndTax(priceAndTax);
                amountInfo.setTaxRate(taxRate);
                amountInfo.setDiscountType(discountType);
                amountInfo.setDiscountRate(discountRate);
                amountInfo.setExChangeRate(exChangeRate);
                amountInfo.setSettleAmtPrecision(settleAmtPrecision);
                amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
                amountInfo = AmountHelper.getAmount((AmountInfo)amountInfo);
                if (isTax) {
                    priceP.setValueFast((Object)entry, (Object)amountInfo.getPrice());
                } else {
                    priceAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getPriceAndTax());
                }
                amountP.setValueFast((Object)entry, (Object)amountInfo.getAmount());
                discountAmountP.setValueFast((Object)entry, (Object)amountInfo.getDiscountAmount());
                amountAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getAmountAndTax());
                curAmountP.setValueFast((Object)entry, (Object)amountInfo.getCurAmount());
                curTaxAmountP.setValueFast((Object)entry, (Object)amountInfo.getCurTaxAmount());
                curAmountAndTaxP.setValueFast((Object)entry, (Object)amountInfo.getCurAmountAndTax());
                totalAmount = totalAmount.add(amountInfo.getAmount());
                totalTaxAmount = totalTaxAmount.add(amountInfo.getTaxAmount());
                totalAmountAndTax = totalAmountAndTax.add(amountInfo.getAmountAndTax());
            }
        }
    }

    private void setPositionFilter(ListShowParameter showParameter, int index) {
        QFilter filter;
        DynamicObject stock = (DynamicObject)this.getModel().getValue("warehouse", index);
        if (stock == null) {
            filter = F7Utils.getEveFalseFilter();
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u4ed3\u5e93\u3002", (IFormView)this.getView());
        } else {
            long stockId = DynamicObjectUtils.getPkValue((DynamicObject)stock);
            filter = F7Util.getErpStockPositionidFilter((long)stockId);
        }
        showParameter.getListFilterParameter().setFilter(filter);
    }

    private void setControlEnable(DynamicObject entry, ChangeData changeData, int rowIndex) {
        DynamicObject good = entry.getDynamicObject("goodsid");
        if (good == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1!", (IFormView)this.getView());
            entry.set("discounttype", changeData.getOldValue());
            return;
        }
        String discountType = (String)changeData.getNewValue();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"A", (CharSequence)discountType)) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"discountamount"});
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"B", (CharSequence)discountType)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"discountamount"});
        }
    }

    private void setReceiveQty() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryList = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryList) {
            BigDecimal qty = entry.getBigDecimal("qty");
            entry.set("remaintransinqty", (Object)qty);
            entry.set("remaintransinbaseqty", (Object)qty);
        }
        this.getView().updateView("entryentity");
    }
}

