/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.OwnerUtil;
import org.apache.commons.lang.math.NumberUtils;

public class VisualiZationEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String KEY_LONGNUMBER = "longnumber";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List branchIds = OwnerUtil.getOwnerIds((String[])new String[0]);
        if (!CollectionUtils.isEmpty((Collection)branchIds)) {
            Object[] basedataIds = new Object[]{branchIds.get(0)};
            this.getModel().setValue("branchfilter", (Object)basedataIds);
        }
        this.getModel().setValue("bizdaterange_startdate", (Object)DateUtil.getBeforeDay((Date)TimeServiceHelper.now(), (int)30));
        this.getModel().setValue("bizdaterange_enddate", (Object)TimeServiceHelper.now());
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardap", "tabap"});
        Container flexPanelAp = (Container)this.getView().getControl("filterap");
        flexPanelAp.setCollapse(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"querybutton", "billcount", "tobedeliveredcount", "olstorebillcount", "offlinebillcount", "tobesignedcount", "abnormalbillcount", "returnbillcount", "bookingbillcount"});
        CommonUtil.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"salerfilter", "branchfilter"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        DynamicObjectCollection branch;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if ("querybutton".equals(source.getKey()) && CollectionUtils.isEmpty((Collection)(branch = this.getModel().getDataEntity(true).getDynamicObjectCollection("branchfilter")))) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u9500\u552e\u95e8\u5e97\u3002", (IFormView)this.getView());
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        boolean isShowReturnBill = true;
        QFilter qFilter = new QFilter("id", "!=", (Object)-1);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "querybutton": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"cardap", "tabap"});
                Container flexPanelAp = (Container)this.getView().getControl("filterap");
                flexPanelAp.setCollapse(true);
                this.setBillLabel();
                break;
            }
            case "tobedeliveredcount": {
                qFilter.and("goodsentryentity.salesorderdelivery.deliverystatus", "=", (Object)Long.parseLong("1026065142993238016"));
                break;
            }
            case "olstorebillcount": {
                qFilter.and("ordersource", "in", (Object)new String[]{"D", "E"});
                break;
            }
            case "offlinebillcount": {
                qFilter.and("ordersource", "=", (Object)"A");
                break;
            }
            case "tobesignedcount": {
                qFilter.and("goodsentryentity.salesorderdelivery.signstatus", "in", (Object)new String[]{"A", "B"});
                isShowReturnBill = false;
                break;
            }
            case "returnbillcount": {
                Tab tab = (Tab)this.getView().getControl("tabap");
                tab.activeTab("returntab");
                break;
            }
            case "bookingbillcount": {
                Tab tab = (Tab)this.getView().getControl("tabap");
                tab.activeTab("bookingtab");
                break;
            }
            case "billcount": {
                Tab tab = (Tab)this.getView().getControl("tabap");
                tab.activeTab("saleordertab");
                break;
            }
        }
        this.showBill(qFilter, isShowReturnBill);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ArrayList<Long> branchList = new ArrayList<Long>();
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (key.equals("salerfilter")) {
            DynamicObjectCollection branchS = this.getModel().getDataEntity(true).getDynamicObjectCollection("branchfilter");
            for (DynamicObject branch : branchS) {
                branchList.add(NumberUtils.toLong((String)branch.getDynamicObject("fbasedataid").getPkValue().toString()));
            }
            if (CollectionUtils.isEmpty(branchList)) {
                showParameter.getListFilterParameter().setFilter(F7Utils.getEveFalseFilter());
            } else {
                QFilter filter = this.getSalerFilter(branchList);
                showParameter.getListFilterParameter().setFilter(filter);
            }
        } else if (key.equals("branchfilter")) {
            showParameter.getListFilterParameter().setFilter(F7Util.getBranchIdFilter());
        }
    }

    public QFilter getSalerFilter(List<Long> branchIds) {
        QFilter filter = F7Utils.getEnableStatus();
        filter.and("owner", "in", branchIds);
        filter.and("issaler", "=", (Object)"1");
        return filter;
    }

    private void setBillLabel() {
        this.setSaleOrderLabel();
        this.setReturnSaleOrderLabel();
        this.setAbNormalOrder();
        this.setBookingOrder();
    }

    private void setBookingOrder() {
        QFilter qFilter = this.getFilter("ocpos_saleorder");
        qFilter.and("goodsentryentity.isbook", "=", (Object)Boolean.TRUE);
        qFilter.and("basebilltype", "in", (Object)new Long[]{BillTypeEnum.RETAIL.getId(), BillTypeEnum.RESERVE.getId()});
        long bookingBillCount = this.getBillCount(qFilter, "ocpos_saleorder");
        long guideBillCount = this.getFinalBillCount(BillTypeEnum.GUIDE.getId());
        long groupBillCount = this.getFinalBillCount(BillTypeEnum.GROUP.getId());
        this.setLabelValue(bookingBillCount + guideBillCount + groupBillCount, "bookingbillcount");
    }

    private long getFinalBillCount(Long baseBillTypeId) {
        QFilter qFilter = this.getFilter("ocpos_saleorder");
        qFilter.and("basebilltype", "=", (Object)baseBillTypeId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)"id", (QFilter[])qFilter.toArray(), null);
        DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(dataSet);
        return dynamicObjectCollection.stream().map(s -> s.getString("id")).distinct().count();
    }

    private long getBillCount(QFilter qFilter, String number) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)number, (String)"id", (QFilter[])qFilter.toArray(), null);
        DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(dataSet);
        return dynamicObjectCollection.stream().map(s -> s.getString("id")).distinct().count();
    }

    private QFilter getFilter(String entityName) {
        DynamicObject dyo = this.getModel().getDataEntity(true);
        List<Long> branchIds = this.getLongs(dyo, "branchfilter");
        List<Long> salerIds = this.getLongs(dyo, "salerfilter");
        Date startDate = dyo.getDate("bizdaterange_startdate");
        Date endDate = dyo.getDate("bizdaterange_enddate");
        List<Long> customerIds = this.getLongs(dyo, "customerid");
        List<Long> memberIds = this.getLongs(dyo, "member");
        String phoneNumber = dyo.getString("phonenumber");
        String billNumber = dyo.getString("billnumber");
        Date distributionStartDate = dyo.getDate("distribution_startdate");
        Date distributionEndDate = dyo.getDate("distribution_enddate");
        List<String> deliveryMode = null;
        String deliveryModeStr = dyo.getString("deliverymode");
        if (!StringUtils.isEmpty((Object)deliveryModeStr)) {
            deliveryMode = Arrays.asList(deliveryModeStr.substring(0, deliveryModeStr.length() - 1).split(","));
        }
        List<String> deliveryStatus = null;
        String deliveryStatusStr = dyo.getString("deliverystatus");
        if (!StringUtils.isEmpty((Object)deliveryStatusStr)) {
            deliveryStatus = Arrays.asList(deliveryStatusStr.substring(0, deliveryStatusStr.length() - 1).split(","));
        }
        Long adminDivisionId = dyo.getLong("admindivisionid");
        String str = dyo.getString("signedstate");
        List<Object> signedState = new ArrayList();
        if (!StringUtils.isEmpty((Object)str)) {
            signedState = Arrays.asList(str.substring(0, str.length() - 1).split(","));
            signedState = signedState.stream().filter(s -> !StringUtils.isEmpty((Object)s)).collect(Collectors.toList());
        }
        QFilter qFilter = new QFilter("salebranchid", "in", branchIds);
        if (startDate != null) {
            qFilter.and("bizdate", ">=", (Object)startDate);
        }
        if (endDate != null) {
            qFilter.and("bizdate", "<=", (Object)endDate);
        }
        if (!CollectionUtils.isEmpty(salerIds)) {
            qFilter.and("saler", "in", salerIds);
        }
        if (!Objects.equals(entityName, "ocpos_abnormalorder") && !CollectionUtils.isEmpty(customerIds)) {
            qFilter.and("customerid", "in", customerIds);
        } else if (Objects.equals(entityName, "ocpos_abnormalorder") && !CollectionUtils.isEmpty(customerIds)) {
            return F7Utils.getEveFalseFilter();
        }
        if (!CollectionUtils.isEmpty(memberIds)) {
            qFilter.and("member", "in", memberIds);
        }
        if (!Objects.equals(entityName, "ocpos_abnormalorder") && !CollectionUtils.isEmpty(deliveryMode)) {
            qFilter.and("goodsentryentity.salesorderdelivery.deliverymode.number", "in", deliveryMode);
        } else if (Objects.equals(entityName, "ocpos_abnormalorder") && !CollectionUtils.isEmpty(deliveryMode)) {
            return F7Utils.getEveFalseFilter();
        }
        if (Objects.equals(entityName, "ocpos_saleorder") && !CollectionUtils.isEmpty(signedState)) {
            qFilter.and("goodsentryentity.salesorderdelivery.signstatus", "in", signedState);
        } else if (!Objects.equals(entityName, "ocpos_saleorder") && !CollectionUtils.isEmpty(signedState)) {
            return F7Utils.getEveFalseFilter();
        }
        if (!Objects.equals(entityName, "ocpos_abnormalorder") && distributionStartDate != null) {
            qFilter.and("goodsentryentity.salesorderdelivery.deliverdeliverytime", ">=", (Object)distributionStartDate);
        } else if (Objects.equals(entityName, "ocpos_abnormalorder") && !CollectionUtils.isEmpty(deliveryMode)) {
            return F7Utils.getEveFalseFilter();
        }
        if (!Objects.equals(entityName, "ocpos_abnormalorder") && distributionEndDate != null) {
            qFilter.and("goodsentryentity.salesorderdelivery.deliverdeliverytime", "<=", (Object)distributionEndDate);
        } else if (Objects.equals(entityName, "ocpos_abnormalorder") && !CollectionUtils.isEmpty(deliveryMode)) {
            return F7Utils.getEveFalseFilter();
        }
        if (!StringUtils.isEmpty((Object)phoneNumber)) {
            qFilter.and("customerphone", "=", (Object)phoneNumber);
        }
        if (!StringUtils.isEmpty((Object)billNumber)) {
            qFilter.and("billno", "like", (Object)("%" + billNumber + "%"));
        }
        if (!Objects.equals(entityName, "ocpos_abnormalorder") && !CollectionUtils.isEmpty(deliveryStatus)) {
            List<Long> deliveryStatusId = this.getDeliveryStatusId(deliveryStatus);
            qFilter.and("goodsentryentity.salesorderdelivery.deliverystatus", "in", deliveryStatusId);
        } else if (Objects.equals(entityName, "ocpos_abnormalorder") && !CollectionUtils.isEmpty(deliveryStatus)) {
            return F7Utils.getEveFalseFilter();
        }
        if (!StringUtils.isEmpty((Object)adminDivisionId) && adminDivisionId != 0L) {
            List<String> adminDivisionIds = this.getAdminDivisionIds(adminDivisionId);
            qFilter.and("admindivisionid", "in", adminDivisionIds);
        }
        return qFilter;
    }

    private List<String> getAdminDivisionIds(Long adminDivisionId) {
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)adminDivisionId, (String)"bd_admindivision", (String)KEY_LONGNUMBER);
        String longNumber = dyo.getString(KEY_LONGNUMBER);
        QFilter qFilter = new QFilter(KEY_LONGNUMBER, "like", (Object)(longNumber + "%"));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_admindivision", (String)"id", (QFilter[])qFilter.toArray());
        return collection.stream().map(s -> s.getString("id")).collect(Collectors.toList());
    }

    private List<Long> getDeliveryStatusId(List<String> deliveryStatus) {
        ArrayList<Long> result = new ArrayList<Long>();
        Iterator<String> iterator = deliveryStatus.iterator();
        while (iterator.hasNext()) {
            String str;
            switch (str = iterator.next()) {
                case "A": {
                    result.add(DeliveryStatus.SALE_WAIT_DELIVERY);
                    break;
                }
                case "B": {
                    result.add(DeliveryStatus.SALE_TRUCK_LOADING);
                    break;
                }
                case "C": {
                    result.add(DeliveryStatus.SALE_OUTBOUND);
                    break;
                }
                case "D": {
                    result.add(DeliveryStatus.SALE_SIGNED);
                    break;
                }
                case "E": {
                    result.add(DeliveryStatus.RETURN_WAIT_PICK);
                    break;
                }
                case "F": {
                    result.add(DeliveryStatus.RETURN_HAVE_PICK);
                    break;
                }
                case "G": {
                    result.add(DeliveryStatus.RETURN_INBOUND);
                    break;
                }
            }
        }
        return result;
    }

    private List<Long> getLongs(DynamicObject dyo, String key) {
        DynamicObjectCollection branch = dyo.getDynamicObjectCollection(key);
        return branch.stream().map(s -> NumberUtils.toLong((String)s.getDynamicObject("fbasedataid").getPkValue().toString())).collect(Collectors.toList());
    }

    private void showBill(QFilter qFilter, Boolean isShowReturnBill) {
        if (isShowReturnBill.booleanValue()) {
            this.showSaleOrderBill(this.getFilter("ocpos_saleorder_return").and(qFilter), "returnlistap", "ocpos_visualist_return");
        } else {
            this.showSaleOrderBill(F7Utils.getEveFalseFilter(), "returnlistap", "ocpos_visualist_return");
        }
        this.showSaleOrderBill(qFilter.and(this.getFilter("ocpos_saleorder")), "listap", "ocpos_visualizationlist");
        QFilter filter = new QFilter("goodsentryentity.isbook", "=", (Object)Boolean.TRUE);
        qFilter.and(filter);
        this.showSaleOrderBill(qFilter, "bookinglistap", "ocpos_visualist_booking");
    }

    private void showSaleOrderBill(QFilter qFilter, String flexName, String formId) {
        ListShowParameter param = new ListShowParameter();
        ListFilterParameter filter = param.getListFilterParameter();
        filter.setFilter(qFilter);
        param.setListFilterParameter(filter);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.setFormId("bos_list");
        param.setShowTitle(false);
        param.setBillFormId(formId);
        param.getOpenStyle().setTargetKey(flexName);
        this.getView().showForm((FormShowParameter)param);
    }

    private void setAbNormalOrder() {
        QFilter qFilter = this.getFilter("ocpos_abnormalorder");
        long abnormalBillCount = this.getBillCount(qFilter, "ocpos_abnormalorder");
        this.setLabelValue(abnormalBillCount, "abnormalbillcount");
    }

    private void setReturnSaleOrderLabel() {
        QFilter qFilter = this.getFilter("ocpos_saleorder_return");
        long returnBillCount = this.getBillCount(qFilter, "ocpos_saleorder_return");
        this.setLabelValue(returnBillCount, "returnbillcount");
    }

    private void setSaleOrderLabel() {
        QFilter qFilter = this.getFilter("ocpos_saleorder");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)this.getSelectField(), (QFilter[])qFilter.toArray(), null);
        DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(dataSet);
        QFilter fFilter = this.getFilter("ocpos_saleorder_return");
        DataSet returnDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder_return", (String)"id", (QFilter[])fFilter.toArray(), null);
        DynamicObjectCollection returnDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(returnDataSet);
        long billCount = dynamicObjectCollection.stream().map(s -> s.getString("id")).distinct().count() + returnDynamicObjectCollection.stream().map(s -> s.getString("id")).distinct().count();
        long olStoreBillCount = dynamicObjectCollection.stream().filter(s -> "D".equals(s.getString("ordersource")) || "E".equals(s.getString("ordersource"))).map(s -> s.get("id")).distinct().count();
        long offLineBillCount = dynamicObjectCollection.stream().filter(s -> "A".equals(s.getString("ordersource"))).map(s -> s.get("id")).distinct().count();
        long toBeDeliveredCount = dynamicObjectCollection.stream().filter(s -> "1026065142993238016".equals(s.getString("deliverystatus"))).map(s -> s.get("id")).distinct().count();
        long toBeSignedCount = dynamicObjectCollection.stream().filter(s -> "A".equals(s.getString("signstatus")) || "B".equals(s.getString("signstatus"))).map(s -> s.get("id")).distinct().count();
        this.setLabelValue(billCount, "billcount");
        this.setLabelValue(olStoreBillCount, "olstorebillcount");
        this.setLabelValue(offLineBillCount, "offlinebillcount");
        this.setLabelValue(toBeDeliveredCount, "tobedeliveredcount");
        this.setLabelValue(toBeSignedCount, "tobesignedcount");
    }

    private String getSelectField() {
        return String.join((CharSequence)",", "ordersource", "id", "goodsentryentity.goodsid as goodsid", "goodsentryentity.salesorderdelivery.deliverystatus as deliverystatus", "goodsentryentity.salesorderdelivery.signstatus as signstatus");
    }

    private void setLabelValue(long abnormalBillCount, String labAbnormalBillCount) {
        Label label = (Label)this.getView().getControl(labAbnormalBillCount);
        String abnormalBillCountText = Long.toString(abnormalBillCount);
        label.setText(abnormalBillCountText);
    }
}

