/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory.serial;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;

public class BatchCreateSerialNumberFormPlugin
extends AbstractFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Map customParams = e.getFormShowParameter().getCustomParams();
        int qty = CommonUtil.formatObjectToInt(customParams.get("qty"));
        if (qty <= 0) {
            e.setCancelMessage("\u5df2\u7ecf\u5f55\u5165\u4e86\u8db3\u591f\u6570\u91cf\u7684\u5e8f\u5217\u53f7\uff0c\u4e0d\u9700\u8981\u518d\u751f\u6210\u3002");
            e.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object qty = customParams.get("qty");
        this.getModel().setValue("qty", qty);
        Object rule = customParams.get("snrule");
        if (rule != null) {
            this.setExampleAndLengthValue(rule);
        } else {
            DynamicObject materialInv;
            long serialRuleId;
            long materialId = CommonUtil.formatObejctToLong(customParams.get("material"));
            if (materialId != 0L && (serialRuleId = DynamicObjectUtils.getPkValue((DynamicObject)(materialInv = BusinessDataServiceHelper.loadSingle((Object)materialId, (String)"bd_materialinventoryinfo")), (String)"serialrule")) != 0L) {
                this.getModel().setValue("snrule", (Object)serialRuleId);
                this.setExampleAndLengthValue(serialRuleId);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        IntegerEdit qtyEdit;
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (source instanceof IntegerEdit && StringUtils.equals((CharSequence)(qtyEdit = (IntegerEdit)source).getKey(), (CharSequence)"qty")) {
            this.beforeQtyPostBack(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        Object newValue = changeSet[0].getNewValue();
        if (ObjectUtils.isEmpty((Object)newValue)) {
            return;
        }
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"snrule")) {
            DynamicObject rule = (DynamicObject)newValue;
            this.setExampleAndLengthValue(rule.getPkValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        OperationResult result;
        super.afterDoOperation(e);
        if (StringUtils.equals((CharSequence)e.getOperateKey(), (CharSequence)"confirm") && (result = e.getOperationResult()) != null && result.isSuccess()) {
            this.returnData();
        }
    }

    private void beforeQtyPostBack(BeforeFieldPostBackEvent e) {
        Map customParams;
        int maxQty;
        int qty = CommonUtil.formatObjectToInt((Object)e.getValue());
        if (qty > (maxQty = CommonUtil.formatObjectToInt((customParams = this.getView().getFormShowParameter().getCustomParams()).get("qty")))) {
            NotificationUtil.showDefaultTipNotify((String)String.format("\u6240\u8f93\u5165\u6570\u91cf\u5df2\u8d85\u8fc7\u5141\u8bb8\u7684\u6700\u5927\u751f\u6210\u6570\u91cf\uff0c\u8bf7\u4e0d\u8981\u8d85\u8fc7%d\u3002", maxQty), (IFormView)this.getView());
            this.getView().updateView("qty");
            e.setCancel(true);
            return;
        }
        int maxGenerateSize = 100000;
        if (qty > maxGenerateSize) {
            NotificationUtil.showDefaultTipNotify((String)String.format("\u5f53\u524d\u751f\u6210\u6570\u91cf\u5df2\u8d85\u8fc7\u4e00\u6b21\u6700\u5927\u751f\u6210\u6570\u91cf\uff0c\u8bf7\u4e0d\u8981\u8d85\u8fc7%d\u3002", maxGenerateSize), (IFormView)this.getView());
            this.getView().updateView("qty");
            e.setCancel(true);
        }
    }

    private void setExampleAndLengthValue(Object lotCodeRuleId) {
        DynamicObject codeRule = BusinessDataServiceHelper.loadSingle((Object)lotCodeRuleId, (String)"bd_lotcoderule");
        String example = (String)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"buildExampleData", (Object[])new Object[]{DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)codeRule, (String)"entryentity")});
        this.getModel().setValue("example", (Object)example);
        this.getModel().setValue("length", (Object)example.length());
    }

    private void returnData() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        int qty = DynamicObjectUtils.getInt((DynamicObject)dataEntity, (String)"qty");
        if (qty > 10000) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u9700\u8981\u751f\u6210\u6570\u91cf\u8f83\u591a\uff0c\u8bf7\u7a0d\u7b49\u2026\u2026", (IFormView)this.getView());
        }
        HashMap<String, Object> param = new HashMap<String, Object>(6);
        DynamicObject rule = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"snrule");
        param.put("snrule", rule);
        param.put("size", qty);
        param.put("blanksize", qty);
        param.put("entryfield", "billentry");
        param.put("snentryfield", "subentryentity");
        param.put("sn", "sn");
        this.getView().returnDataToParent(param);
        this.getView().close();
    }
}

