/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory.serial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;

public class BillSerialNumberRelationEdit
extends AbstractBasePlugIn {
    private static final String KEY_BATCH_GENERATE = "batchgenerate";
    private static final String KEY_ADD = "add";
    private static final Log LOG = LogFactory.getLog(BillSerialNumberRelationEdit.class, (String)"ocpos");

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (pkValue == null || pkValue.equals(0L)) {
            this.getModel().setValue("billid", customParams.get("billid"));
            this.getModel().setValue("billtype", customParams.get("billtype"));
            this.getModel().setValue("billtypeid", customParams.get("billtypeid"));
            this.getModel().setValue("entrykey", customParams.get("entrykey"));
            this.getModel().setValue("entryid", customParams.get("entryid"));
        }
        this.setBillEntryInfoFromParam();
        this.specialBillHandle(CommonUtil.formatObejctToLong(customParams.get("billtypeid")));
    }

    public void afterLoadData(EventObject e) {
        this.setBillEntryInfoFromParam();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.specialBillHandle(CommonUtil.formatObejctToLong(customParams.get("billtypeid")));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "batchgenerate": {
                this.deleteEntryRow();
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                int sumQty = CommonUtil.formatObjectToInt(customParams.get("qty"));
                int size = this.getModel().getEntryRowCount("entryentity");
                int maxGenerateQty = sumQty - size;
                if (maxGenerateQty <= 0) {
                    NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5f55\u5165\u5e8f\u5217\u53f7\u6570\u91cf\u5df2\u7b49\u4e8e\u6216\u8d85\u8fc7\u5206\u5f55\u57fa\u672c\u6570\u91cf\uff0c\u65e0\u6cd5\u6279\u91cf\u751f\u6210\u5e8f\u5217\u53f7\u3002", (IFormView)this.getView());
                    break;
                }
                customParams.put("qty", maxGenerateQty);
                this.showModalPage("ocpos_batchcreatesn", customParams);
                break;
            }
            case "selectsn": {
                this.deleteEntryRow();
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                this.showModalPage("ocpos_selectedsn", customParams);
                break;
            }
            case "clear": {
                ConfirmCallBackListener listener = new ConfirmCallBackListener("clear", (IFormPlugin)this);
                this.getView().showConfirm("\u662f\u5426\u6e05\u9664\u5df2\u586b\u6570\u636e?", MessageBoxOptions.OKCancel, listener);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)"clear") && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "ocpos_selectedsn": {
                this.selectedSnClosedCallBack(returnData);
                break;
            }
            case "ocpos_batchcreatesn": {
                this.batchCreateSnClosedCallBack(returnData);
                break;
            }
        }
    }

    private void selectedSnClosedCallBack(Object returnData) {
        if (returnData instanceof List) {
            List data = (List)returnData;
            if (CollectionUtils.isEmpty((Collection)data)) {
                return;
            }
            ArrayList<Object> handleSns = new ArrayList<Object>(1000);
            for (Object datum : data) {
                handleSns.add(datum);
                if (handleSns.size() != 1000) continue;
                this.batchCreateLine(handleSns);
            }
            if (handleSns.size() > 0) {
                this.batchCreateLine(handleSns);
            }
            this.getView().updateView("entryentity");
        }
    }

    private void batchCreateSnClosedCallBack(Object returnData) {
        if (returnData instanceof Map) {
            IFormView parentView = this.getView().getParentView();
            String parentEntityId = this.getEntryKey(parentView);
            int seq = parentView.getModel().getEntryCurrentRowIndex(parentEntityId);
            Map returnParams = (Map)returnData;
            returnParams.put("seq", seq);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"material");
            returnParams.put("material", material);
            DynamicObject parentEntity = parentView.getModel().getDataEntity(true);
            long time1 = System.currentTimeMillis();
            List serialNumbers = (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"getSnCodeNum", (Object[])new Object[]{parentEntity, returnParams});
            long time2 = System.currentTimeMillis();
            int snSize = serialNumbers.size();
            LOG.info(snSize + "\u4e2a\u5e8f\u5217\u53f7\u751f\u6210\u7684\u65f6\u95f4\uff1a" + (time2 - time1) + "ms");
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            if (entryEntities == null) {
                return;
            }
            for (String serialNumber : serialNumbers) {
                DynamicObject entryEntity = entryEntities.addNew();
                entryEntity.set("snnumber", (Object)serialNumber);
            }
            this.getView().updateView("entryentity");
        }
    }

    private void batchCreateLine(List<Object> handleSns) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        if (entryEntities == null) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bd_snmainfile");
        Object[] selectFields = dataEntityType.getAllFields().values().toArray();
        QFilter filter = new QFilter("id", "in", handleSns);
        DynamicObject[] snMainFiles = BusinessDataServiceHelper.load((String)"bd_snmainfile", (String)StringUtils.join((Object[])selectFields, (char)','), (QFilter[])filter.toArray(), (String)"number");
        if (snMainFiles == null || snMainFiles.length <= 0) {
            return;
        }
        for (DynamicObject snMainFile : snMainFiles) {
            DynamicObject entryEntity = entryEntities.addNew();
            entryEntity.set("snnumber", (Object)DynamicObjectUtils.getString((DynamicObject)snMainFile, (String)"number"));
            entryEntity.set("snmainfile", (Object)snMainFile);
        }
        handleSns.clear();
    }

    private void setBillEntryInfoFromParam() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("goods", customParams.get("goods"));
        this.getModel().setValue("material", customParams.get("material"));
        this.getModel().setValue("unit", customParams.get("unit"));
        this.getModel().setValue("qty", customParams.get("qty"));
        this.getModel().setDataChanged(false);
    }

    public void specialBillHandle(long billTypeId) {
        if (billTypeId == 1153534418477108224L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BATCH_GENERATE, KEY_ADD});
            this.deleteEntryRow();
        }
    }

    private void deleteEntryRow() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        if (entryEntities == null) {
            return;
        }
        entryEntities.removeIf(x -> StringUtils.isBlank((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"snnumber")));
        this.getView().updateView("entryentity");
    }

    private void showModalPage(String formId, Map<String, Object> customParams) {
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)formId, (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm(parameter);
    }

    private String getEntryKey(IFormView view) {
        String entityId = view.getEntityId();
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_store_purrefapply")) {
            return "billentry";
        }
        return "entryentity";
    }
}

