/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory.serial;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CheckSerialNumberFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_SHEET = "sheet1";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsId = customParams.get("goods");
        this.getModel().setValue("goods", goodsId);
        Object materialId = customParams.get("material");
        this.getModel().setValue("material", materialId);
        Object unitId = customParams.get("unit");
        this.getModel().setValue("unit", unitId);
        Object qty = customParams.get("qty");
        this.getModel().setValue("qty", qty);
        long relationId = CommonUtil.formatObejctToLong(customParams.get("billsnrelationid"));
        if (relationId != 0L) {
            DynamicObject relation = BusinessDataServiceHelper.loadSingle((Object)relationId, (String)"ocpos_billsnrelation");
            DynamicObjectCollection relationEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)relation, (String)"entryentity");
            if (CollectionUtils.isEmpty((Collection)relationEntry)) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            entryEntities.clear();
            for (DynamicObject item : relationEntry) {
                DynamicObject entryEntity = entryEntities.addNew();
                entryEntity.set("snnumber", DynamicObjectUtils.get((DynamicObject)item, (String)"snnumber"));
                entryEntity.set("snmainfile", DynamicObjectUtils.get((DynamicObject)item, (String)"snmainfile"));
                entryEntity.set("note", DynamicObjectUtils.get((DynamicObject)item, (String)"note"));
            }
            this.getView().updateView("entryentity");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (StringUtils.equals((CharSequence)e.getOperateKey(), (CharSequence)"export")) {
            this.exportExcel();
            NotificationUtil.showDefaultSuccessNotification((String)"\u5bfc\u51fa\u6210\u529f\u3002", (IFormView)this.getView());
        }
    }

    private void exportExcel() {
        long templateId = 1169687069476423680L;
        try {
            String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
            String url = this.export(routeAppId, "ocpos_serialnumber_tpl", templateId);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.getView().download(url);
                this.getView().sendFormAction(this.getView());
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String export(String routeAppId, String formId, long templateId) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet(KEY_SHEET);
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = this.getExportWriterFormatAndWriteHead(wb, sheet, styles, routeAppId, formId, templateId);
        if (format == null) {
            return null;
        }
        int currRowIndex = sheet.getLastRowNum();
        int rowIndex = currRowIndex + 1;
        DynamicObjectCollection pageData = this.getModel().getEntryEntity("entryentity");
        ArrayList<DynamicObject> exportData = new ArrayList<DynamicObject>(pageData.size());
        for (DynamicObject rowData : pageData) {
            DynamicObject exportRow = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_serialnumber_tpl");
            exportRow.set("number", DynamicObjectUtils.get((DynamicObject)rowData, (String)"snnumber"));
            exportRow.set("description", DynamicObjectUtils.get((DynamicObject)rowData, (String)"note"));
            exportData.add(exportRow);
        }
        String json = SerializationUtils.toJsonString(exportData);
        JSONArray billArr = JSONArray.parseArray((String)json);
        String fileName = this.exportFileName();
        for (int i = 0; i < billArr.size(); ++i) {
            JSONObject bill = billArr.getJSONObject(i);
            int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)rowIndex, (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)true);
            if (offset > 1) {
                rowIndex += offset;
                continue;
            }
            ++rowIndex;
        }
        return this.writeFile(wb, fileName);
    }

    private ExportWriterFormat getExportWriterFormatAndWriteHead(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, String routeAppId, Object formId, Object template) {
        ExportWriterFormat format = null;
        String exportJson = CommonUtil.formatStringToEmpty((Object)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, template, "", null}));
        if (StringUtils.isNotBlank((CharSequence)exportJson) && exportJson.startsWith("[")) {
            List formats = JSONArray.parseArray((String)exportJson, ExportWriterFormat.class);
            if (formats != null && formats.size() > 0) {
                format = (ExportWriterFormat)formats.get(0);
            }
        } else {
            format = (ExportWriterFormat)JSONObject.parseObject((String)exportJson, ExportWriterFormat.class);
        }
        ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, Collections.singletonList(format));
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        String url = "";
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return url;
    }

    private String exportFileName() {
        Date date = TimeServiceHelper.today();
        String dateFormat = new SimpleDateFormat("MMdd").format(date);
        return "\u5f15\u51fa\u6570\u636e_\u5e8f\u5217\u53f7_" + dateFormat + ".xlsx";
    }
}

