/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory.serial;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;

public class ImportSerialNumberFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BTN_IMPORT = "btn_import";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnImport = (Button)this.getView().getControl(BTN_IMPORT);
        btnImport.addUploadListener((UploadListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        super.afterDoOperation(e);
        switch (opKey = e.getOperateKey()) {
            case "downloadtpl": {
                this.downloadExcelTpl();
                break;
            }
            case "confirm": {
                this.returnData();
                break;
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            String fileUrl = urls[0].toString();
            this.importData(fileUrl);
        }
    }

    private void importData(String fileUrl) {
        ExcelReader reader = new ExcelReader();
        FileService service = FileServiceFactory.getAttachmentFileService();
        final ArrayList realData = new ArrayList();
        final HashSet serialNumbers = new HashSet(10);
        final HashMap repeat = new HashMap(10);
        try {
            reader.read(service.getInputStream(fileUrl), new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow parsedRow) {
                    int rowNum = parsedRow.getRowNum() + 1;
                    if (rowNum == 1 || rowNum == 2 || rowNum == 3 || rowNum == 4) {
                        return;
                    }
                    Map data = parsedRow.getData();
                    if (data.size() == 2 || data.size() == 1) {
                        String value = (String)data.get(0);
                        if (value.isEmpty()) {
                            return;
                        }
                        if (serialNumbers.contains(value)) {
                            repeat.put(rowNum, value);
                            return;
                        }
                        serialNumbers.add(value);
                        realData.add(data);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        if (entryEntities != null) {
            for (Object realDatum : realData) {
                DynamicObject dynamicObject = entryEntities.addNew();
                dynamicObject.set("snnumber", realDatum.get(0));
                dynamicObject.set("note", realDatum.get(1));
            }
        }
        this.getView().updateView("entryentity");
        if (!CollectionUtils.isEmpty(repeat)) {
            ArrayList<String> repeatData = new ArrayList<String>(4);
            for (Map.Entry entry : repeat.entrySet()) {
                repeatData.add(String.format("\u5e8f\u5217\u53f7\u7b2c%s\u884c[%s]", entry.getKey(), entry.getValue()));
            }
            if (!CollectionUtils.isEmpty(repeatData)) {
                String tip = StringUtils.join((Object[])repeatData.toArray(), (char)'\uff0c') + "\u6709\u91cd\u590d\u3002";
                NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            }
        }
    }

    private void downloadExcelTpl() {
        String url = this.getUrl();
        this.getView().download(url);
        this.getView().sendFormAction(this.getView());
    }

    private void returnData() {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            this.getView().returnDataToParent((Object)"\u5bfc\u5165\u660e\u7ec6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u6216\u53d6\u6d88\u3002");
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long relationId = CommonUtil.formatObejctToLong(customParams.get("billsnrelationid"));
        if (relationId == 0L) {
            this.createRelation(customParams, entryEntities);
        } else {
            this.updateRelation(relationId, entryEntities);
        }
        this.getView().returnDataToParent((Object)"\u5bfc\u5165\u6210\u529f\u3002");
        this.getView().close();
    }

    private void createRelation(Map<String, Object> customParams, DynamicObjectCollection entryEntities) {
        DynamicObject relation = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_billsnrelation");
        relation.set("billtype", customParams.get("billtype"));
        relation.set("billtypeid", customParams.get("billtypeid"));
        relation.set("unit", customParams.get("unit"));
        relation.set("material", customParams.get("material"));
        relation.set("billid", customParams.get("billid"));
        relation.set("qty", customParams.get("qty"));
        relation.set("entryid", customParams.get("entryid"));
        relation.set("entrykey", customParams.get("entrykey"));
        this.updateRelationEntry(entryEntities, relation);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{relation});
    }

    private void updateRelation(long relationId, DynamicObjectCollection entryEntities) {
        DynamicObject relation = BusinessDataServiceHelper.loadSingle((Object)relationId, (String)"ocpos_billsnrelation");
        this.updateRelationEntry(entryEntities, relation);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{relation});
    }

    private void updateRelationEntry(DynamicObjectCollection entryEntities, DynamicObject relation) {
        DynamicObjectCollection relationEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)relation, (String)"entryentity");
        if (relationEntry != null) {
            int i = 1;
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObject relationRow = relationEntry.addNew();
                relationRow.set("snnumber", DynamicObjectUtils.get((DynamicObject)entryEntity, (String)"snnumber"));
                relationRow.set("note", DynamicObjectUtils.get((DynamicObject)entryEntity, (String)"note"));
                relationRow.set("seq", (Object)i);
                ++i;
            }
        }
    }

    private String getUrl() {
        Date date = TimeServiceHelper.today();
        String dateFormat = new SimpleDateFormat("MMdd").format(date);
        long templateId = 1169687069476423680L;
        DynamicObject templateData = null;
        String ctxPath = RequestContext.get().getClientFullContextPath();
        templateData = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bos_importtemplate");
        String fileName = "\u9884\u7f6e_" + templateData.get("name");
        try {
            return ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + templateId + "&formid=" + "ocpos_serialnumber_tpl" + "&plugin=&filename=" + URLEncoder.encode(fileName + "_" + dateFormat + ".xlsx", StandardCharsets.UTF_8.name()) + "&extenddata=" + null + "&routeappid=" + this.getView().getFormShowParameter().getServiceAppId() + "&a=t";
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

