/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory.serial;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.AssistantEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.inventory.SerialNumberHelper;
import kd.occ.ocpos.common.consts.inventory.SerialNumberPage;
import kd.occ.ocpos.common.util.CommonUtil;

public class SelectedSerialNumberFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
SetFilterListener {
    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String paramInvFlu = CommonUtil.formatStringToEmpty(customParams.get("invflu"));
        String direction = CommonUtil.formatStringToEmpty(customParams.get("direction"));
        long billTypeId = CommonUtil.formatObejctToLong(customParams.get("billtypeid"));
        this.specialBillHandle(billTypeId, paramInvFlu, direction);
        this.handleBillInfo();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearData();
    }

    public void registerListener(EventObject e) {
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        AssistantEdit snStatusEdit = (AssistantEdit)this.getView().getControl("snstatushead");
        snStatusEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
        this.addClickListeners(new String[]{"btn_query", "btn_confirm"});
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        TextEdit textEdit;
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (source instanceof TextEdit && StringUtils.equals((CharSequence)(textEdit = (TextEdit)source).getKey(), (CharSequence)"snto")) {
            this.beforeSnToPostBack(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"snfrom")) {
            Object newValue = changeSet[0].getNewValue();
            this.snFromChanged(newValue);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (ctrl.getKey()) {
            case "btn_query": {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                billList.refresh();
                break;
            }
            case "btn_confirm": {
                this.returnSelectedResult();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "snstatushead": {
                this.setSnStatusFilter(e);
                break;
            }
            case "org": {
                this.setOrgFilter(e);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setCustomQFilters(Collections.singletonList(this.getFilter()));
    }

    private void setSnStatusFilter(BeforeF7SelectEvent e) {
        String invFluctuation = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("invfluctuation"));
        HashSet<Long> invStatus = new HashSet<Long>(2);
        switch (invFluctuation) {
            case "3": 
            case "2": {
                invStatus.add(SerialNumberPage.SN_STATUS_IN_INV_ID);
                break;
            }
            case "1": {
                invStatus.add(SerialNumberPage.SN_STATUS_PENDING_IN_INV_ID);
                invStatus.add(SerialNumberPage.SN_STATUS_OUT_INV_ID);
                break;
            }
        }
        if (!CollectionUtils.isEmpty(invStatus)) {
            QFilter filter = new QFilter("id", "in", invStatus);
            F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
        }
    }

    private void setOrgFilter(BeforeF7SelectEvent e) {
        String orgId = this.getPageCache().get("org");
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            QFilter filter = new QFilter("id", "in", (Object)Long.parseLong(orgId));
            F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
        }
    }

    public void specialBillHandle(long billTypeId, String inFlu, String direction) {
        if (billTypeId == 1153534418477108224L) {
            if (StringUtils.equals((CharSequence)"1", (CharSequence)inFlu)) {
                this.getModel().setValue("snstatushead", (Object)SerialNumberPage.SN_STATUS_TRANS_OUT_INV_ID);
            } else {
                this.getModel().setValue("snstatushead", (Object)SerialNumberPage.SN_STATUS_IN_INV_ID);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"snstatushead"});
        } else if (StringUtils.equals((CharSequence)"0", (CharSequence)inFlu)) {
            this.getModel().setValue("snstatushead", (Object)SerialNumberPage.SN_STATUS_IN_INV_ID);
            this.getView().setEnable(Boolean.FALSE, new String[]{"snstatushead"});
        } else {
            boolean isIncrease = StringUtils.equals((CharSequence)"3", (CharSequence)inFlu) || StringUtils.equals((CharSequence)"1", (CharSequence)inFlu);
            boolean isNeg = StringUtils.equals((CharSequence)"1", (CharSequence)direction);
            if (isIncrease && isNeg) {
                this.getModel().setValue("snstatushead", (Object)SerialNumberPage.SN_STATUS_OUT_INV_ID);
                this.getView().setEnable(Boolean.FALSE, new String[]{"snstatushead"});
            }
        }
    }

    private void handleBillInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgId = customParams.get("invorg");
        this.getModel().setValue("org", orgId);
        this.getPageCache().put("org", CommonUtil.formatStringToEmpty(orgId));
        this.getModel().setValue("invfluctuation", customParams.get("invflu"));
    }

    private void snFromChanged(Object newValue) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            this.getModel().setValue("snto", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"snto"});
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String updateNewValue = CommonUtil.formatStringToEmpty((Object)newValue).trim();
            String[] snFrom = updateNewValue.split("\\s+");
            if (snFrom.length > 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"snto"});
                this.getModel().setValue("snto", null);
                StringBuilder result = new StringBuilder();
                for (int i = 0; i <= snFrom.length - 1; ++i) {
                    result.append(snFrom[i]);
                    result.append(' ');
                }
                dataEntity.set("snfrom", (Object)result.toString());
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"snto"});
                dataEntity.set("snfrom", (Object)updateNewValue);
            }
            this.getView().updateView("snfrom");
        }
    }

    private void beforeSnToPostBack(BeforeFieldPostBackEvent e) {
        String newValue = CommonUtil.formatStringToEmpty((Object)e.getValue());
        if (StringUtils.isBlank((CharSequence)newValue)) {
            return;
        }
        String[] strLotNumberToValues = newValue.trim().split("\\s+");
        if (strLotNumberToValues.length > 1) {
            NotificationUtil.showDefaultTipNotify((String)"\u5e8f\u5217\u53f7\u81f3\u4e0d\u80fd\u586b\u5165\u591a\u4e2a\u4ee5\u7a7a\u683c\u5206\u5f00\u7684\u503c\u3002", (IFormView)this.getView());
            this.getView().updateView("snto");
            e.setCancel(true);
        }
    }

    private void returnSelectedResult() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        LinkedList<Object> snIds = new LinkedList<Object>();
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            snIds.add(selectedRow.getPrimaryKeyValue());
        }
        this.getView().returnDataToParent(snIds);
        this.getView().close();
    }

    private QFilter getFilter() {
        DynamicObject snStatus;
        String snTo;
        String snFrom;
        String lotNumberHead;
        Object materialId;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        QFilter filter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"org");
        if (orgId != 0L) {
            filter.and("invorg", "=", (Object)orgId);
        }
        if ((materialId = customParams.get("material")) != null) {
            DynamicObject materialInv = BusinessDataServiceHelper.loadSingle(materialId, (String)"bd_materialinventoryinfo", (String)"masterid");
            filter.and("material", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)materialInv, (String)"masterid"));
        }
        if (StringUtils.isNotBlank((CharSequence)(lotNumberHead = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"lotnumberhead")))) {
            filter.and("lotnumberhead", "=", (Object)lotNumberHead.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(snFrom = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"snfrom")))) {
            filter.and("number", ">=", (Object)snFrom.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(snTo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"snto")))) {
            filter.and("number", "<=", (Object)snTo.trim());
        }
        if ((snStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"snstatushead")) != null) {
            String status = SerialNumberHelper.transferSnStatus((String)DynamicObjectUtils.getString((DynamicObject)snStatus, (String)"number"));
            filter.and("snstatus", "=", (Object)status);
            if (StringUtils.equals((CharSequence)status, (CharSequence)"A")) {
                filter.and("billid", "=", (Object)0L);
            }
        } else {
            String invFluctuation;
            switch (invFluctuation = (String)this.getModel().getValue("invfluctuation")) {
                case "3": 
                case "2": {
                    filter.and("snstatus", "=", (Object)"B");
                    break;
                }
                case "1": {
                    QFilter statusFilterIn = new QFilter("snstatus", "=", (Object)"A");
                    statusFilterIn.and("billid", "=", (Object)0L);
                    QFilter statusFilterOut = new QFilter("snstatus", "=", (Object)"D");
                    filter.and(statusFilterIn.or(statusFilterOut));
                    break;
                }
            }
        }
        return filter;
    }
}

