/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.inventory.serial;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.DbUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.enums.PageSizeEnum;
import kd.occ.ocpos.common.util.CommonUtil;

public class SerialNumberQueryFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
SearchEnterListener {
    private static final String SIGN_CACHE = "SN_";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"first", "previous", "next", "last", "btn_confirm"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getView().getControl("search");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultPageSizeAndIndex();
        String searchText = this.getSearchText();
        List<JSONObject> data = this.getData(0, 20, true, searchText);
        if (!CollectionUtils.isEmpty(data)) {
            this.fillData(data, true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int totalCount = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("totalcount"));
        this.setTotalPageSize(totalCount);
        this.setEnable(1, totalCount);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.setSplitPage(false);
        HashMap<String, Boolean> style = new HashMap<String, Boolean>(1);
        Boolean isMulti = (Boolean)this.getView().getFormShowParameter().getCustomParam("ismul");
        style.put("ismul", isMulti);
        this.getView().updateControlMetadata("entryentity", style);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        FieldEdit edit;
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (source instanceof FieldEdit && StringUtils.equals((CharSequence)(edit = (FieldEdit)source).getKey(), (CharSequence)"pageindex")) {
            int totalCount;
            int value = CommonUtil.formatObjectToInt((Object)e.getValue());
            if (value < 1) {
                this.getView().updateView("pageindex");
                e.setCancel(true);
            }
            if (value > (totalCount = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("totalcount")))) {
                this.getView().updateView("pageindex");
                e.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        String key = e.getProperty().getName();
        Object newValue = changeSet[0].getNewValue();
        switch (key) {
            case "pageindex": {
                this.pageIndexChanged(newValue);
                break;
            }
            case "pagesize": {
                this.pageSizeChanged(newValue);
                break;
            }
        }
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (key = ctrl.getKey()) {
            case "first": {
                this.updatePageIndex(1);
                break;
            }
            case "previous": {
                int pageIndex = this.getPageIndex() - 1;
                if (pageIndex <= 0) break;
                this.updatePageIndex(pageIndex);
                break;
            }
            case "next": {
                int pageIndex = this.getPageIndex() + 1;
                int totalCount = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("totalcount"));
                if (pageIndex > totalCount) break;
                this.updatePageIndex(pageIndex);
                break;
            }
            case "last": {
                int pageIndex = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("totalcount"));
                this.updatePageIndex(pageIndex);
                break;
            }
            case "btn_confirm": {
                this.returnData();
                break;
            }
        }
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)search.getKey(), (CharSequence)"search")) {
            String searchText = e.getText();
            this.getPageCache().put(this.getView().getPageId(), searchText);
            int pageSize = this.getPageSize();
            this.setDefaultPageIndex(false);
            this.fillData(1, pageSize, true, searchText);
            int totalCount = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("totalcount"));
            this.setEnable(1, totalCount);
        }
    }

    public void entryRowDoubleClick(RowClickEvent e) {
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        if (StringUtils.equals((CharSequence)entryGrid.getEntryKey(), (CharSequence)"entryentity")) {
            int index = e.getRow();
            this.returnData(index);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(SIGN_CACHE + this.getView().getPageId());
    }

    private void fillData(int pageIndex, int pageSize, boolean isStatisticsCount, String searchText) {
        int start = this.getStart(pageIndex, pageSize);
        int end = this.getEnd(pageIndex, pageSize);
        List<JSONObject> data = this.getData(start, end, isStatisticsCount, searchText);
        if (isStatisticsCount) {
            int totalCount = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("totalcount"));
            this.setTotalPageSize(totalCount);
        }
        this.fillData(data, false);
    }

    private void fillData(List<JSONObject> data, boolean isCreateNewData) {
        if (!isCreateNewData) {
            this.getModel().beginInit();
        }
        this.getModel().deleteEntryData("entryentity");
        for (JSONObject datum : data) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("snmainfile", (Object)datum.getLong("id"), index);
            this.getModel().setValue("sn", (Object)datum.getString("sn"), index);
            this.getModel().setValue("stockorg", (Object)datum.getLong("stockorg"), index);
            this.getModel().setValue("stock", (Object)datum.getLong("stock"), index);
            this.getModel().setValue("lotnum", (Object)datum.getString("lotnum"), index);
            this.getModel().setValue("snstatus", (Object)datum.getString("snstatus"), index);
        }
        if (!isCreateNewData) {
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void setTotalPageSize(int totalCount) {
        Label totalPageSize = (Label)this.getView().getControl("totalpage");
        totalPageSize.setText(String.format("\u5171%d\u9875", totalCount));
    }

    private void setDefaultPageIndex(boolean isNew) {
        if (!isNew) {
            this.getModel().beginInit();
        }
        this.updatePageIndex(1);
        if (!isNew) {
            this.getModel().endInit();
            this.getView().updateView("pageindex");
        }
    }

    private void setDefaultPageSizeAndIndex() {
        this.getModel().setValue("pagesize", (Object)"C");
        this.setDefaultPageIndex(true);
    }

    private void pageIndexChanged(Object newValue) {
        int pageIndex = CommonUtil.formatObjectToInt((Object)newValue);
        int pageSize = this.getPageSize();
        String searchText = this.getSearchText();
        this.fillData(pageIndex, pageSize, false, searchText);
        int totalCount = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("totalcount"));
        this.setEnable(pageIndex, totalCount);
    }

    private void pageSizeChanged(Object newValue) {
        this.setDefaultPageIndex(false);
        int pageSize = PageSizeEnum.getValue((String)CommonUtil.formatStringToEmpty((Object)newValue));
        String searchText = this.getSearchText();
        this.fillData(1, pageSize, true, searchText);
        int totalCount = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("totalcount"));
        this.setEnable(1, totalCount);
    }

    private void updatePageIndex(int pageIndex) {
        this.getModel().setValue("pageindex", (Object)pageIndex);
    }

    private void returnData() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length < 1) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (IFormView)this.getView());
            return;
        }
        Boolean isMultiSelect = (Boolean)this.getView().getFormShowParameter().getCustomParam("ismul");
        if (isMultiSelect.booleanValue()) {
            this.returnData(selectRows);
        } else {
            this.returnData(selectRows[0]);
        }
        this.getView().close();
    }

    private void returnData(int index) {
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entryentity", index);
        JSONObject returnData = this.getReturnData(entryEntity);
        this.getView().returnDataToParent((Object)returnData);
    }

    private void returnData(int[] indexes) {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        ArrayList<JSONObject> returnData = new ArrayList<JSONObject>(indexes.length);
        for (int index : indexes) {
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
            returnData.add(this.getReturnData(entryEntity));
        }
        this.getView().returnDataToParent(returnData);
    }

    private void setTotalCount(String sqlFormat, long stockOrgId, long stockId, long materialId, long auxPtyId, String likeSql) {
        int pageSize;
        List<Object> params;
        int size;
        int totalCount;
        String sql = String.format(sqlFormat, "count(1) as totalcount");
        if (StringUtils.isNotBlank((CharSequence)likeSql)) {
            sql = sql + likeSql;
        }
        if ((totalCount = CommonUtil.formatObjectToInt((Object)Math.ceil((double)(size = ((Integer)DB.query((DBRoute)DbUtil.SYS, (String)sql, (Object[])(params = this.getCommonParams(stockOrgId, stockId, materialId, auxPtyId)).toArray(), rh -> {
            int count = 0;
            if (rh.next()) {
                count = rh.getInt("totalcount");
            }
            return count;
        })).intValue()) * 1.0 / (double)(pageSize = this.getPageSize())))) <= 0) {
            totalCount = 1;
        }
        this.getModel().setValue("totalcount", (Object)totalCount);
    }

    private void setEnable(int pageIndex, int totalCount) {
        if (pageIndex == 1) {
            if (totalCount != 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"first", "previous"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"next", "last"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"first", "previous", "next", "last"});
            }
        } else if (pageIndex == totalCount) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"first", "previous"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"next", "last"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"first", "previous", "next", "last"});
        }
    }

    private int getPageSize() {
        String pageSizeKey = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("pagesize"));
        if (StringUtils.isBlank((CharSequence)pageSizeKey)) {
            pageSizeKey = "C";
        }
        return PageSizeEnum.getValue((String)pageSizeKey);
    }

    private int getPageIndex() {
        int pageIndex = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("pageindex"));
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        return pageIndex;
    }

    private int getStart(int pageIndex, int pageSize) {
        return (pageIndex - 1) * pageSize;
    }

    private int getEnd(int pageIndex, int pageSize) {
        return pageIndex * pageSize;
    }

    private List<JSONObject> getData(int start, int end, boolean isStatisticsCount, String searchText) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long stockOrgId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("stockorg", 0L));
        long stockId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("stock", 0L));
        long materialId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("material", 0L));
        long auxPtyId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("auxpty", 0L));
        String lockSnIds = CommonUtil.formatStringToEmpty((Object)customParams.getOrDefault("locksnmainfiles", ""));
        String except = CommonUtil.formatStringToEmpty((Object)customParams.getOrDefault("snmainfile", ""));
        String sqlFormat = this.getSqlFormat(stockOrgId, stockId, materialId, auxPtyId, lockSnIds, except);
        String likeSql = this.getLikeSql(searchText);
        if (isStatisticsCount) {
            this.setTotalCount(sqlFormat, stockOrgId, stockId, materialId, auxPtyId, likeSql);
        }
        String selectFields = this.getSelectFields();
        String querySql = String.format(sqlFormat, selectFields);
        if (StringUtils.isNotBlank((CharSequence)likeSql)) {
            querySql = querySql + likeSql;
        }
        String sql = "select * from (" + querySql + ") tsn where tsn.rowNum > ? and tsn.rowNum <= ? ";
        Object[] params = this.getParams(stockOrgId, stockId, materialId, auxPtyId, start, end);
        return (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params, rs -> {
            ArrayList<JSONObject> data = new ArrayList<JSONObject>(0);
            while (rs.next()) {
                JSONObject datum = new JSONObject();
                datum.put("id", (Object)rs.getLong("id"));
                datum.put("sn", (Object)rs.getString("sn"));
                datum.put("stockorg", (Object)rs.getLong("stockorg"));
                datum.put("stock", (Object)rs.getLong("stock"));
                datum.put("lotnum", (Object)rs.getString("lotnum"));
                datum.put("snstatus", (Object)rs.getString("snstatus"));
                data.add(datum);
            }
            return data;
        });
    }

    private JSONObject getReturnData(DynamicObject entryEntity) {
        JSONObject returnData = new JSONObject();
        long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"snmainfile");
        returnData.put("snmainfile", (Object)snMainFileId);
        String sn = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"sn");
        returnData.put("deliveryserialnumber", (Object)sn);
        long stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"stockorg");
        returnData.put("inventoryorgid", (Object)stockOrgId);
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"stock");
        returnData.put("erpstockid", (Object)stockId);
        String lotNum = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"lotnum");
        returnData.put("deliverylotnum", (Object)lotNum);
        return returnData;
    }

    private List<Object> getCommonParams(long stockOrgId, long stockId, long materialId, long auxPtyId) {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add("B");
        if (stockOrgId != 0L) {
            params.add(stockOrgId);
        }
        if (stockId != 0L) {
            params.add(stockId);
        }
        if (materialId != 0L) {
            params.add(materialId);
        }
        if (auxPtyId != 0L) {
            params.add(auxPtyId);
        }
        return params;
    }

    private Object[] getParams(long stockOrgId, long stockId, long materialId, long auxPtyId, int start, int end) {
        List<Object> params = this.getCommonParams(stockOrgId, stockId, materialId, auxPtyId);
        params.add(start);
        params.add(end);
        return params.toArray();
    }

    private String getSelectFields() {
        return "row_number() over(order by ts.fid) as rowNum, ts.fid as id, ts.fnumber as sn, tst.fkeeporgid as stockorg, tst.fwarehouseid as stock, tst.finlotnum as lotnum, ts.fsnstatus as snstatus, ts.fmaterialid as material";
    }

    private String getSearchText() {
        return this.getPageCache().get(this.getView().getPageId());
    }

    private String getSqlFormat(long stockOrgId, long stockId, long materialId, long auxPtyId, String lockSnIds, String except) {
        String sql = "select %s from t_bd_snmainfile ts left join t_bd_snmovetrack_rel tsr on ts.ffinalaudittrailid = tsr.fid left join t_bd_snmovetrack tst on tsr.ftrackid = tst.fid where tst.fkeeporgid <> 0 and tst.fwarehouseid <> 0 ";
        sql = StringUtils.isNotBlank((CharSequence)except) ? sql + String.format("and (ts.fsnstatus = ? or ts.fid in (%s)) ", except) : sql + "and ts.fsnstatus = ? ";
        if (stockOrgId != 0L) {
            sql = sql + "and tst.fkeeporgid = ? ";
        }
        if (stockId != 0L) {
            sql = sql + "and tst.fwarehouseid = ? ";
        }
        if (materialId != 0L) {
            sql = sql + "and ts.fmaterialid = ? ";
        }
        if (auxPtyId != 0L) {
            sql = sql + "and ts.fauxptyid = ? ";
        }
        if (StringUtils.isNotBlank((CharSequence)lockSnIds)) {
            sql = sql + String.format("and not exists (select 1 from t_bd_snmainfile ts1 where ts1.fid in (%s) and ts1.fid = ts.fid)", lockSnIds);
        }
        return sql;
    }

    private String getLikeSql(String searchText) {
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            return "and ts.fnumber like '%" + searchText + "%' ";
        }
        return "";
    }
}

