/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.util.CalendarUtil;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.BigDecimalUtil;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.AbstractQueryFilterEvent;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.service.admindivision.AdminDivisionHelper;
import kd.occ.ocpos.business.olstore.OlstoreCartHelper;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.business.olstore.OlstorePromotionTransferHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.common.enums.RecomItemTypeEnum;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;

public class CartListMobPlugin
extends ExtBillViewPlugin {
    private static Log logger = LogFactory.getLog(CartListMobPlugin.class);
    private static final String cid_cartlist = "cartlist";
    private static final String cid_storename = "address";
    private static final String cid_carttypebar = "carttypebar";
    private static final String cid_carttype = "carttype";
    private static final String cid_promotion = "promotion";
    private static final String cid_promotionpanel = "promotionpanel";

    public void afterDataLoad(LoadDataEvent event) {
        long customerId = OlstoreUtil.getStoreId((ClientEvent)event);
        long memberId = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        ((BillFormData)this.billData).updateValue("customerid", (Object)customerId);
        boolean inventoryStatus = Boolean.TRUE;
        ((ExtBillView)this.view).setActiveByValue(cid_carttypebar, "B");
        String isOnlinePurchase = event.getLocalStorage().getString("isonlinepurchase" + memberId + customerId, "0");
        logger.info("\u7ebf\u4e0a\u95e8\u5e97\u8d2d\u7269\u8f66isOnlinePurchase:" + isOnlinePurchase);
        if (isOnlinePurchase.equals("1")) {
            ((ExtBillView)this.view).setActiveByValue(cid_carttypebar, "A");
            ((BillFormData)this.billData).updateValue(cid_carttype, (Object)"A");
            ((ExtBillView)this.view).updateFrontValue(cid_storename, (Object)OlstoreUtil.getStoreName((ClientEvent)event));
        } else {
            ((ExtBillView)this.view).setActiveByValue(cid_carttypebar, "B");
            ((BillFormData)this.billData).updateValue(cid_carttype, (Object)"B");
            this.getCurDistrictId((AbstractQueryFilterEvent)event, customerId);
        }
        DynamicObject olstoreConfig = OlstoreConfigHelper.getOlstoreConfig();
        if (olstoreConfig.getBoolean("isscan")) {
            ((ExtBillView)this.view).hide(cid_carttypebar, false);
        } else {
            ((ExtBillView)this.view).hide(cid_carttypebar, true);
        }
        if (memberId == 0L) {
            ((ExtBillView)this.view).hide(cid_cartlist, true);
            ((ExtBillView)this.view).hide("btn_panel", true);
            ((ExtBillView)this.view).hide("select_panel", true);
            ((ExtBillView)this.view).hide("cart_none_panel", true);
            ((ExtBillView)this.view).hide("login_panel", false);
            ((ExtBillView)this.view).hide("recompanel", true);
            ((ExtBillView)this.view).hide("sum", true);
        } else {
            ((ExtBillView)this.view).hide("login_panel", true);
            ((ExtBillView)this.view).hide("sum", false);
            DynamicObjectCollection olstoreCartList = OlstoreCartHelper.getOlstoreCartList((long)memberId, (long)customerId, (int)Integer.parseInt(isOnlinePurchase), (int)0, (int)200);
            boolean isShow = olstoreCartList != null && olstoreCartList.size() > 0;
            DynamicObjectCollection stockItemList = new DynamicObjectCollection();
            DynamicObjectCollection noStockItemList = new DynamicObjectCollection();
            if (isShow) {
                int index;
                for (index = 0; index < olstoreCartList.size(); ++index) {
                    String auxptyId;
                    DynamicObject cartItem = (DynamicObject)olstoreCartList.get(index);
                    DynamicObject finCartItem = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(cid_cartlist);
                    String itemId = cartItem.getString("itemid");
                    JSONObject itemInfo = this.getItemInfo(itemId, auxptyId = cartItem.getString("auxptyid"), customerId);
                    if (itemInfo == null) continue;
                    finCartItem.set("memberprice", (Object)itemInfo.getBigDecimal("memberprice"));
                    finCartItem.set("specname", (Object)this.querySpecName(itemInfo));
                    finCartItem.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + itemInfo.getString("thumbnail")));
                    finCartItem.set("itemname", (Object)itemInfo.getString("itemname"));
                    this.copyToDynamicObject(cartItem, finCartItem);
                    finCartItem.set("nostock", (Object)"/static/image/olstore/no_stock.png");
                    finCartItem.set("inventorystatus", (Object)inventoryStatus);
                    if (inventoryStatus) {
                        stockItemList.add((Object)finCartItem);
                        continue;
                    }
                    noStockItemList.add((Object)finCartItem);
                }
                if (stockItemList.size() > 0) {
                    for (index = 0; index < stockItemList.size(); ++index) {
                        DynamicObject stockItem = (DynamicObject)stockItemList.get(index);
                        ((BillFormData)this.getBillData()).addEntryRow(cid_cartlist, stockItem);
                        ((ExtBillView)this.view).disableGridSelBox(cid_cartlist, false, index);
                        ((ExtBillView)this.view).hide("nostockpanel", true, index);
                        ((ExtBillView)this.view).hide("memberprice", false, index);
                        ((ExtBillView)this.view).hide("qty", false, index);
                    }
                }
                int stockItemSize = stockItemList.size();
                if (noStockItemList.size() > 0) {
                    for (int index2 = 0; index2 < noStockItemList.size(); ++index2) {
                        DynamicObject noStockItem = (DynamicObject)noStockItemList.get(index2);
                        ((BillFormData)this.getBillData()).addEntryRow(cid_cartlist, noStockItem);
                        ((ExtBillView)this.view).disableGridSelBox(cid_cartlist, true, stockItemSize + index2);
                        ((ExtBillView)this.view).hide("nostockpanel", false, stockItemSize + index2);
                        ((ExtBillView)this.view).hide("memberprice", true, stockItemSize + index2);
                        ((ExtBillView)this.view).hide("qty", true, stockItemSize + index2);
                        ((ExtBillView)this.view).hide(cid_promotionpanel, true, stockItemSize + index2);
                    }
                }
                for (int index3 = 0; index3 < stockItemList.size(); ++index3) {
                    DynamicObject itemRow = (DynamicObject)stockItemList.get(index3);
                    if (!itemRow.getBoolean("inventorystatus")) continue;
                    String promotion = OlstorePromotionTransferHelper.queryPromotion((DynamicObjectCollection)stockItemList, (int)index3, (long)customerId, (long)memberId, (boolean)true);
                    if (StringUtil.isNotNull((String)promotion)) {
                        ((ExtBillView)this.view).hide(cid_promotionpanel, false, index3);
                        itemRow.set(cid_promotion, (Object)promotion);
                        continue;
                    }
                    ((ExtBillView)this.view).hide(cid_promotionpanel, true, index3);
                }
            }
            this.initItemRecom(customerId);
            ((ExtBillView)this.view).hide(cid_cartlist, !isShow);
            ((ExtBillView)this.view).hide("btn_panel", !isShow);
            ((ExtBillView)this.view).hide("select_panel", !isShow);
            ((ExtBillView)this.view).hide("cart_none_panel", isShow);
            ((BillFormData)this.getBillData()).updateValue("totalamount", (Object)BigDecimal.ZERO);
        }
    }

    private long getCurDistrictId(AbstractQueryFilterEvent event, Long customerId) {
        ((BillFormData)this.billData).updateValue("customerid", (Object)customerId);
        long districtId = 0L;
        JSONObject currentAddress = OlstoreUtil.getCurrentAddress((ClientEvent)event);
        if (currentAddress != null) {
            ((BillFormData)this.billData).updateValue("districtid", (Object)currentAddress.getString("districtid"));
            ((ExtBillView)this.view).updateFrontValue(cid_storename, (Object)currentAddress.getString(cid_storename));
            ((BillFormData)this.billData).updateValue("addressid", (Object)currentAddress.getString("addressid"));
            districtId = Long.parseLong(currentAddress.getString("districtid"));
        } else {
            String addressId;
            String addressName;
            JSONObject addressObject = OlstoreMemberHelper.queryDefaultDeliveryAddress((long)((ExtBillView)this.view).getExtCtx().getMemberId());
            if (addressObject != null) {
                districtId = OlstoreStoreInfoHelper.getNewListrictId((long)addressObject.getLong("districtId"));
                String districtName = AdminDivisionHelper.getDivisionName((long)districtId);
                addressName = districtName + addressObject.getString("detailedAddress");
                addressId = addressObject.getString("id");
            } else {
                SimpleMap localStorage = event.getLocalStorage();
                String latitude = localStorage.getString("latitude");
                String longitude = localStorage.getString("longitude");
                logger.info("\u5546\u54c1\u8be6\u60c5\u63d2\u4ef6-\u83b7\u53d6\u672c\u5730\u7f13\u5b58\u6240\u6709\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)localStorage));
                JSONObject division = OlstoreInventoryHelper.getDivisionIdByLatLng((String)latitude, (String)longitude);
                districtId = division.getLong("districtId");
                addressName = division.getString(cid_storename);
                addressId = null;
            }
            ((BillFormData)this.billData).updateValue("districtid", (Object)districtId);
            ((ExtBillView)this.view).updateFrontValue(cid_storename, (Object)addressName);
            ((BillFormData)this.billData).updateValue("addressid", (Object)addressId);
            JSONObject addressJson = new JSONObject();
            addressJson.put("districtid", (Object)String.valueOf(districtId));
            addressJson.put(cid_storename, (Object)addressName);
            addressJson.put("addressid", (Object)addressId);
            OlstoreUtil.setCurrentAddress((ExtDynamicView)((ExtDynamicView)this.view), (String)addressJson.toJSONString());
        }
        ((BillFormData)this.billData).updateValue("deliverytime", (Object)CalendarUtil.getNextDayTime());
        return districtId;
    }

    private void initItemRecom(long customerId) {
        JSONObject result = OlstoreConfigHelper.getItemRecomList((long)customerId, (String)RecomItemTypeEnum.RECOMITEM_CART.getValue());
        if (result != null) {
            JSONArray itemRecomList = result.getJSONArray("itemRecomList");
            if (itemRecomList != null && itemRecomList.size() > 0) {
                ((BillFormData)this.billData).updateValue("recompanelname", (Object)result.getString("operatingsubject"));
                for (int i = 0; i < itemRecomList.size(); ++i) {
                    JSONObject itemRecom = itemRecomList.getJSONObject(i);
                    DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject("recomitemlist");
                    dataObject.set("recomitemid", (Object)itemRecom.getLong("itemid"));
                    dataObject.set("recomauxptyid", (Object)itemRecom.getLong("auxptyid"));
                    dataObject.set("recomspuid", (Object)itemRecom.getLong("spuid"));
                    dataObject.set("recomunitid", (Object)itemRecom.getLong("unitid"));
                    dataObject.set("recombarcodeid", (Object)itemRecom.getLong("barcodeid"));
                    dataObject.set("recomitemname", (Object)itemRecom.getString("itemname"));
                    dataObject.set("recomitemthumbnail", (Object)PictureUtil.getServerPictureUrl((String)itemRecom.getString("thumbnail")));
                    dataObject.set("recomitemprice", (Object)itemRecom.getBigDecimal("minmemberprice"));
                    ((BillFormData)this.getBillData()).addEntryRow("recomitemlist", dataObject);
                }
                ((ExtBillView)this.view).hide("recompanel", false);
            } else {
                ((ExtBillView)this.view).hide("recompanel", true);
            }
        } else {
            ((ExtBillView)this.view).hide("recompanel", true);
        }
    }

    private void copyToDynamicObject(DynamicObject row, DynamicObject dataObject) {
        dataObject.set("id", (Object)row.getString("id"));
        dataObject.set("thumbnail", (Object)row.getString("itemid.thumbnail"));
        dataObject.set("itemname", (Object)row.getString("itemid.name"));
        dataObject.set("unitid", (Object)row.getString("unitid"));
        dataObject.set("itemid", (Object)row.getString("itemid"));
        dataObject.set("qty", (Object)row.getBigDecimal("qty"));
    }

    private String querySpecName(JSONObject itemInfo) {
        String spuId = itemInfo.getString("spuid");
        Long itemId = itemInfo.getLong("itemid");
        Long auxptyId = itemInfo.getLong("auxptyid");
        if (spuId.length() > 1) {
            DynamicObject spuMapName = OlstoreItemHelper.getSpuMapName((long)itemId, (long)auxptyId);
            String mapName = spuMapName.getString("entryentity_specmap.spumapname");
            return mapName;
        }
        String auxptyName = ((BillFormData)this.billData).getAuxpty(auxptyId.longValue(), false).getAuxptyName();
        return auxptyName.replace(':', '\uff1a');
    }

    private JSONObject getItemInfo(String itemId, String auxptyId, long customerId) {
        String appendStr = OlstoreUtil.buildItemParamAppendStr();
        JSONObject returnData = OlstoreItemHelper.getItemDetail((String)String.valueOf(customerId), (String)"0", (String)itemId, (String)appendStr);
        if ("0000".equals(returnData.get((Object)"code").toString()) && returnData.getJSONArray("data").size() > 0) {
            JSONArray products = returnData.getJSONArray("data");
            if (StringUtil.isNotNull((String)auxptyId) && auxptyId.length() > 1) {
                List list = JSONObject.parseArray((String)products.toJSONString(), JSONObject.class);
                return list.stream().filter(p -> p.getString("itemid").equals(itemId) && p.getString("auxptyid").equals(auxptyId)).findFirst().orElse(null);
            }
            return products.getJSONObject(0);
        }
        return null;
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        long memberId = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        long customerId = OlstoreUtil.getStoreId((ClientEvent)event);
        switch (eventId) {
            case "thumbnail": 
            case "nostockpanel": {
                int rowid = event.getCurrentRow().getRow();
                DynamicObject currentRow = ((BillFormData)this.getBillData()).getEntryRowData(cid_cartlist, rowid);
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_itemdetails");
                openParam.addCustomParam("itemid", String.valueOf(currentRow.getLong("itemid")));
                openParam.addCustomParam("auxptyid", String.valueOf(currentRow.getLong("auxptyid")));
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "address": {
                String isOnlinePurchase = event.getLocalStorage().getString("isonlinepurchase" + memberId + customerId, "0");
                logger.info("\u7ebf\u4e0a\u95e8\u5e97\u8d2d\u7269\u8f66isOnlinePurchase:" + isOnlinePurchase);
                if (isOnlinePurchase.equals("1")) {
                    OpenParam openParam = new OpenParam();
                    openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                    openParam.setViewId("ocpos_selectstore");
                    openParam.addCustomParam("sourceviewid", ((ExtBillView)this.view).getViewId());
                    ((ExtBillView)this.getView()).showView(openParam);
                    break;
                }
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.Pop);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("addressid", ((BillFormData)this.billData).getString("addressid"));
                openParam.setViewId("ocpos_memberaddressm");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "createorderbtn": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_confirmorder");
                openParam.addCustomParam(cid_carttype, ((BillFormData)this.billData).getString(cid_carttype));
                openParam.addCustomParam("sourceviewid", "ocpos_cartlistm");
                openParam.addCustomParam("addressid", ((BillFormData)this.billData).getString("addressid"));
                StringBuilder cartIds = new StringBuilder();
                List selectionRowIds = event.getSelectionRowIds();
                BigDecimal totalamount = ((BillFormData)this.getBillData()).getBigDecimal("totalamount");
                if (selectionRowIds == null || selectionRowIds.size() == 0 || totalamount.compareTo(BigDecimal.ZERO) == 0) {
                    ((ExtBillView)this.view).showMessage("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u6709\u5e93\u5b58\u7684\u5546\u54c1");
                    return;
                }
                Iterator iterator = selectionRowIds.iterator();
                while (iterator.hasNext()) {
                    int row = (Integer)iterator.next();
                    DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(cid_cartlist, row);
                    if (!entryRowData.getBoolean("inventorystatus")) continue;
                    cartIds.append(entryRowData.getString("id")).append(',');
                }
                openParam.addCustomParam("cartIds", cartIds.toString());
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "deletebtn": {
                Object cartId = event.getCurrentRow().getPkValue();
                ArrayList<Object> lstCartId = new ArrayList<Object>();
                lstCartId.add(cartId);
                OlstoreCartHelper.deleteCartById(lstCartId);
                ((BillFormData)this.billData).delEntryRow(cid_cartlist, event.getCurrentRow().getRow());
                this.updatePromotionByQty(customerId);
                break;
            }
            case "scancode": {
                ((ExtBillView)this.view).showMessage("\u529f\u80fd\u5f00\u53d1\u4e2d\u3002\u3002\u3002");
                ((ExtBillView)this.view).hide("scancode", true);
                ((ExtBillView)this.view).setActiveByValue(cid_carttypebar, "B", false);
                break;
            }
            case "carttypebar": {
                ((ExtBillView)this.view).hide("cart_none_panel", true);
                long curDistrictId = 0L;
                if ("A".equals(event.getBillData().getString(cid_carttypebar))) {
                    ((ExtBillView)this.view).putLocalStorage("isonlinepurchase" + memberId + customerId, "1");
                    ((ExtBillView)this.view).updateFrontValue(cid_storename, (Object)OlstoreUtil.getStoreName((ClientEvent)event));
                } else {
                    ((ExtBillView)this.view).putLocalStorage("isonlinepurchase" + memberId + customerId, "0");
                    curDistrictId = this.getCurDistrictId((AbstractQueryFilterEvent)event, customerId);
                }
                if (memberId == 0L) {
                    return;
                }
                int cartType = "A".equals(event.getBillData().getString(cid_carttypebar)) ? 1 : 0;
                ((BillFormData)this.billData).updateValue(cid_carttype, (Object)event.getBillData().getString(cid_carttypebar));
                this.updateCartList(cartType, customerId, curDistrictId);
                break;
            }
            case "login": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_cartlistm_login");
                openParam.setEnabelHistory(false);
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "more": {
                OpenParam openParam = new OpenParam();
                DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(cid_cartlist, event.getCurrentRow());
                openParam.setTarget(OpenParam.OpenTarget.Pop);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam(cid_promotion, entryRowData.getString(cid_promotion));
                openParam.setViewId("ocpos_cartpromotion");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "recomitemthumbnail": 
            case "recomitemname": {
                DynamicObject data = ((BillFormData)this.getBillData()).getEntryRowData("recomitemlist", event.getCurrentRow());
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_itemdetails");
                openParam.addCustomParam("itemid", data.getString("recomitemid"));
                openParam.addCustomParam("auxptyid", data.getString("recomauxptyid"));
                openParam.addCustomParam("spuid", data.getString("recomspuid"));
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "addcart": {
                DynamicObject data = ((BillFormData)this.getBillData()).getEntryRowData("recomitemlist", event.getCurrentRow());
                this.addCart(data);
                break;
            }
        }
        super.onClick(event);
    }

    private void addCart(DynamicObject data) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        long customerId = ((BillFormData)this.billData).getLong("customerid");
        long itemId = data.getLong("recomitemid");
        long auxptyId = data.getLong("recomauxptyid");
        long unitId = data.getLong("recomunitid");
        long barcodeId = data.getLong("recombarcodeid");
        BigDecimal qty = BigDecimal.ONE;
        int preCartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        OlstoreCartHelper.addCart((long)customerId, (long)memberId, (long)itemId, (long)unitId, (long)auxptyId, (long)barcodeId, (BigDecimal)qty, (int)0);
        int cartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        if (preCartSumCount != cartSumCount) {
            ((BillFormData)this.billData).updateValue("cartcount", (Object)cartSumCount);
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", MessageBoxType.Toast);
        } else {
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u3002", MessageBoxType.Toast);
        }
    }

    private void updatePromotionByQty(long customerId) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        DynamicObjectCollection entryRowData = ((BillFormData)this.billData).getEntryRowData(cid_cartlist);
        for (int index = 0; index < entryRowData.size(); ++index) {
            String promotion = OlstorePromotionTransferHelper.queryPromotion((DynamicObjectCollection)entryRowData, (int)index, (long)customerId, (long)memberId, (boolean)true);
            ((BillFormData)this.billData).updateValue(cid_promotion, index, (Object)promotion);
            if (StringUtil.isNotNull((String)promotion)) {
                ((ExtBillView)this.view).hide(cid_promotionpanel, false, index);
                continue;
            }
            ((ExtBillView)this.view).hide(cid_promotionpanel, true, index);
        }
    }

    private void updateCartList(int cartType, long customerId, long curDistrictId) {
        ((BillFormData)this.billData).updateValue(cid_cartlist, null);
        this.getCartListByCartType(cartType, customerId, curDistrictId);
    }

    private void getCartListByCartType(int cartType, long customerId, long curDistrictId) {
        int index;
        long memberId = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        boolean inventoryStatus = Boolean.TRUE;
        DynamicObjectCollection olstoreCartList = OlstoreCartHelper.getOlstoreCartList((long)memberId, (long)customerId, (int)cartType, (int)0, (int)200);
        DynamicObjectCollection stockItemList = new DynamicObjectCollection();
        DynamicObjectCollection noStockItemList = new DynamicObjectCollection();
        for (index = 0; index < olstoreCartList.size(); ++index) {
            DynamicObject olstoreCart = (DynamicObject)olstoreCartList.get(index);
            String itemId = olstoreCart.getString("itemid");
            String auxptyId = olstoreCart.getString("auxptyid");
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(cid_cartlist);
            JSONObject itemInfo = this.getItemInfo(itemId, auxptyId, customerId);
            if (itemInfo == null) continue;
            dataObject.set("memberprice", (Object)itemInfo.getBigDecimal("memberprice"));
            dataObject.set("specname", (Object)this.querySpecName(itemInfo));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + itemInfo.getString("thumbnail")));
            dataObject.set("unitid", (Object)olstoreCart.getString("unitid"));
            dataObject.set("itemid", (Object)olstoreCart.getString("itemid"));
            dataObject.set("itemname", (Object)olstoreCart.getString("itemid.name"));
            dataObject.set("id", (Object)olstoreCart.getString("id"));
            dataObject.set("qty", (Object)olstoreCart.getString("qty"));
            dataObject.set("auxptyid", (Object)olstoreCart.getString("auxptyid"));
            dataObject.set("barcodeid", (Object)olstoreCart.getString("barcodeid"));
            dataObject.set("nostock", (Object)"/static/image/olstore/no_stock.png");
            dataObject.set("inventorystatus", (Object)inventoryStatus);
            if (inventoryStatus) {
                stockItemList.add((Object)dataObject);
                continue;
            }
            noStockItemList.add((Object)dataObject);
        }
        if (stockItemList.size() > 0) {
            for (index = 0; index < stockItemList.size(); ++index) {
                DynamicObject stockItem = (DynamicObject)stockItemList.get(index);
                ((BillFormData)this.getBillData()).addEntryRow(cid_cartlist, stockItem);
                ((ExtBillView)this.view).disableGridSelBox(cid_cartlist, false, index);
                ((ExtBillView)this.view).hide("nostockpanel", true, index);
                ((ExtBillView)this.view).hide("memberprice", false, index);
                ((ExtBillView)this.view).hide("qty", false, index);
            }
        }
        int stockItemSize = stockItemList.size();
        if (noStockItemList.size() > 0) {
            for (int index2 = 0; index2 < noStockItemList.size(); ++index2) {
                DynamicObject noStockItem = (DynamicObject)noStockItemList.get(index2);
                ((BillFormData)this.getBillData()).addEntryRow(cid_cartlist, noStockItem);
                ((ExtBillView)this.view).disableGridSelBox(cid_cartlist, true, stockItemSize + index2);
                ((ExtBillView)this.view).hide("nostockpanel", false, stockItemSize + index2);
                ((ExtBillView)this.view).hide("memberprice", true, stockItemSize + index2);
                ((ExtBillView)this.view).hide("qty", true, stockItemSize + index2);
                ((ExtBillView)this.view).hide(cid_promotionpanel, true, stockItemSize + index2);
            }
        }
        for (int index3 = 0; index3 < stockItemList.size(); ++index3) {
            DynamicObject cartItem = (DynamicObject)stockItemList.get(index3);
            String promotion = OlstorePromotionTransferHelper.queryPromotion((DynamicObjectCollection)stockItemList, (int)index3, (long)customerId, (long)memberId, (boolean)true);
            cartItem.set(cid_promotion, (Object)promotion);
            if (StringUtil.isNotNull((String)promotion)) {
                ((ExtBillView)this.view).hide(cid_promotionpanel, false, index3);
                continue;
            }
            ((ExtBillView)this.view).hide(cid_promotionpanel, true, index3);
        }
        if (olstoreCartList == null || olstoreCartList.size() == 0) {
            ((ExtBillView)this.view).hide(cid_cartlist, true);
            ((ExtBillView)this.view).hide("btn_panel", true);
            ((ExtBillView)this.view).hide("select_panel", true);
            ((ExtBillView)this.view).hide("cart_none_panel", false);
            return;
        }
        ((ExtBillView)this.view).hide(cid_cartlist, false);
        ((ExtBillView)this.view).hide("btn_panel", false);
        ((ExtBillView)this.view).hide("select_panel", false);
        ((ExtBillView)this.view).hide("cart_none_panel", true);
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId = event.getId();
        long memberId = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        long customerId = ((BillFormData)this.billData).getLong("customerid");
        switch (eventId) {
            case "qty": {
                int rowId = event.getRow();
                ((ExtBillView)this.view).setRowSelection(cid_cartlist, rowId, true);
                DynamicObject currentRow = ((BillFormData)this.getBillData()).getEntryRowData(cid_cartlist, rowId);
                BigDecimal qty = BigDecimalUtil.toBigDecimal((Object)event.getValue());
                if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                    qty = BigDecimal.ONE;
                    ((BillFormData)this.getBillData()).updateValue("qty", event.getRow(), (Object)qty);
                }
                OlstoreCartHelper.updateCartQtyById((long)currentRow.getLong("id"), (BigDecimal)qty);
                Map selections = (Map)event.getEventParam().get((Object)"selections");
                if (selections != null && selections.size() > 0) {
                    List selectMap = (List)selections.get(cid_cartlist);
                    ArrayList<DynamicObject> selectEntry = new ArrayList<DynamicObject>();
                    for (Map select : selectMap) {
                        rowId = Integer.parseInt(select.get("row").toString());
                        if (rowId != event.getRow()) {
                            selectEntry.add(((BillFormData)this.getBillData()).getEntryRowData(cid_cartlist, rowId));
                            continue;
                        }
                        currentRow.set("qty", (Object)qty);
                        selectEntry.add(currentRow);
                    }
                    this.countTotalAmount(selectEntry);
                }
                this.updatePromotionByQty(customerId);
                break;
            }
            case "districtid": 
            case "address": {
                long districtid = ((BillFormData)this.billData).getLong("districtid");
                String isOnlinePurchase = event.getLocalStorage().getString("isonlinepurchase" + memberId + customerId, "0");
                this.updateCartList(Integer.parseInt(isOnlinePurchase), customerId, districtid);
                JSONObject addressJson = new JSONObject();
                addressJson.put("districtid", (Object)districtid);
                addressJson.put(cid_storename, (Object)((BillFormData)this.billData).getString(cid_storename));
                addressJson.put("addressid", (Object)((BillFormData)this.billData).getString("addressid"));
                OlstoreUtil.setCurrentAddress((ExtDynamicView)((ExtDynamicView)this.view), (String)addressJson.toJSONString());
                break;
            }
        }
        super.onDataChange(event);
    }

    protected void onRowSelected(SelectAllEvent event) {
        DynamicObjectCollection selectdata = ((BillFormData)this.getBillData()).getEntryRowData(cid_cartlist, event.getSelections());
        if (selectdata != null && selectdata.size() > 0) {
            this.countTotalAmount((List<DynamicObject>)selectdata);
            return;
        }
        ((BillFormData)this.getBillData()).updateValue("totalamount", (Object)BigDecimal.ZERO);
        super.onRowSelected(event);
    }

    private void countTotalAmount(List<DynamicObject> selectedArray) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject data : selectedArray) {
            if (!data.getBoolean("inventorystatus")) continue;
            totalAmount = totalAmount.add(data.getBigDecimal("memberprice").multiply(data.getBigDecimal("qty")));
        }
        ((BillFormData)this.getBillData()).updateValue("totalamount", (Object)totalAmount);
    }

    protected void onRowSelectedAll(SelectAllEvent event) {
        if (event.isAllSelected()) {
            DynamicObjectCollection dataList = ((BillFormData)this.getBillData()).getEntryRowData(cid_cartlist);
            this.countTotalAmount((List<DynamicObject>)dataList);
            return;
        }
        ((BillFormData)this.getBillData()).updateValue("totalamount", (Object)BigDecimal.ZERO);
        super.onRowSelectedAll(event);
    }
}

