/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.pojo.dto.member.user.AddAddressDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryAddressByIdDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.UpdateAddressDTO;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;

public class DeliveryAddressEditMobPlugin
extends ExtBillViewPlugin {
    private static Log logger = LogFactory.getLog(DeliveryAddressEditMobPlugin.class);

    public DynamicObject onDataLoad(LoadDataEvent event) {
        long adminDivisionId;
        DynamicObject data = super.onDataLoad(event);
        long addressId = event.getCustomParam().getLong("id");
        ((BillFormData)this.billData).updateValue("sourceviewid", (Object)event.getCustomParam().getString("sourceviewid"));
        if (addressId != 0L) {
            long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
            QueryAddressByIdDTO dto = new QueryAddressByIdDTO();
            dto.setUserId(Long.valueOf(memberId));
            dto.setAddressId(Long.valueOf(addressId));
            JSONObject deliveryAddressResult = OlstoreMemberHelper.getDeliveryAddressByIdDTO((QueryAddressByIdDTO)dto);
            if (deliveryAddressResult == null || deliveryAddressResult.getInteger("code") != 0) {
                return data;
            }
            JSONObject jsonData = deliveryAddressResult.getJSONObject("data");
            data.set("address", (Object)jsonData.getString("detailedAddress"));
            data.set("addressid", (Object)jsonData.getLong("id"));
            data.set("isdefaultaddr", (Object)jsonData.getBoolean("defaultAddress"));
            data.set("linkphone", (Object)jsonData.getString("phone"));
            data.set("linkman", (Object)jsonData.getString("contact"));
            data.set("districtid", (Object)jsonData.getLong("districtId"));
        }
        if ((adminDivisionId = event.getCustomParam().getLong("adminDivisionId").longValue()) > 0L) {
            String userName = event.getCustomParam().getString("userName");
            String telNumber = event.getCustomParam().getString("telNumber");
            String detailInfo = event.getCustomParam().getString("detailInfo");
            data.set("address", (Object)detailInfo);
            data.set("linkphone", (Object)telNumber);
            data.set("linkman", (Object)userName);
            data.set("districtid", (Object)adminDivisionId);
        }
        return data;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "savebtn": {
                if (!this.checkFormRequired()) {
                    return;
                }
                DynamicObject data = ((BillFormData)this.getBillData()).getDataObject();
                HashMap<String, Object> addressMap = new HashMap<String, Object>();
                String linkphone = data.getString("linkphone");
                Pattern pattern = Pattern.compile("^1[3|4|5|7|8][0-9]\\d{4,8}$");
                boolean phoneCheck = pattern.matcher(linkphone).matches();
                if (!phoneCheck) {
                    ((ExtBillView)this.view).showMessage("\u624b\u673a\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002");
                    return;
                }
                addressMap.put("address", data.getString("address"));
                addressMap.put("linkman", data.getString("linkman"));
                addressMap.put("linkphone", linkphone);
                addressMap.put("addrtypeid", "shippingaddress");
                addressMap.put("isdefaultaddr", data.getBoolean("isdefaultaddr"));
                logger.info("DeliveryAddressEditMobPlugin addressMap:" + JSONObject.toJSONString(addressMap));
                addressMap.put("districtid", data.getLong("districtid"));
                UpdateAddressDTO dto = new UpdateAddressDTO();
                dto.setContact(data.getString("linkman"));
                dto.setPhone(linkphone);
                dto.setAddressTypeId(Long.valueOf(OlstoreMemberHelper.queryAddressTypeList()));
                dto.setDistrictId(Long.valueOf(data.getLong("districtid")));
                dto.setDetailedAddress(data.getString("address"));
                dto.setDefaultAddress(data.getBoolean("isdefaultaddr"));
                long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
                dto.setUserId(Long.valueOf(memberId));
                long pkValue = data.getLong("addressid");
                if (pkValue != 0L) {
                    dto.setAddressId(Long.valueOf(pkValue));
                    JSONObject updateResult = OlstoreMemberHelper.updateDeliveryAddress((UpdateAddressDTO)dto);
                    if (updateResult == null || updateResult.getInteger("code") != 0) {
                        logger.info("\u66f4\u65b0\u7684\u6536\u8d27\u5730\u5740\uff1a" + addressMap);
                        if (updateResult == null) {
                            ((ExtBillView)this.view).showMessage("\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1aupdateResult is null");
                        } else {
                            ((ExtBillView)this.view).showMessage("\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + updateResult.getString("message"));
                        }
                        return;
                    }
                    ((ExtBillView)this.view).showMessage("\u66f4\u65b0\u6210\u529f\u3002");
                } else {
                    AddAddressDTO addAddressDTO = new AddAddressDTO();
                    addAddressDTO.setAddressTypeId(Long.valueOf(OlstoreMemberHelper.queryAddressTypeList()));
                    addAddressDTO.setUserId(Long.valueOf(memberId));
                    addAddressDTO.setContact(data.getString("linkman"));
                    addAddressDTO.setPhone(linkphone);
                    addAddressDTO.setDistrictId(Long.valueOf(data.getLong("districtid")));
                    addAddressDTO.setDetailedAddress(data.getString("address"));
                    addAddressDTO.setDefaultAddress(data.getBoolean("isdefaultaddr"));
                    JSONObject insertResult = OlstoreMemberHelper.insertDeliveryAddress((AddAddressDTO)addAddressDTO);
                    if (insertResult == null || insertResult.getInteger("code") != 0) {
                        logger.info("\u4fdd\u5b58\u7684\u6536\u8d27\u5730\u5740\uff1a" + addressMap);
                        if (insertResult == null) {
                            ((ExtBillView)this.view).showMessage("\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1ainsertResult is null");
                        } else {
                            ((ExtBillView)this.view).showMessage("\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + insertResult.getString("message"));
                        }
                        return;
                    }
                    JSONObject jsonData = insertResult.getJSONObject("data");
                    ((BillFormData)this.billData).updateValue("addressid", (Object)jsonData.getLong("id"));
                    ((ExtBillView)this.view).showMessage("\u4fdd\u5b58\u6210\u529f\u3002");
                }
                if ("ocpos_memberaddressm".equals(((BillFormData)this.billData).getString("sourceviewid"))) {
                    ((ExtBillView)this.view).closeView();
                    break;
                }
                OpenParam openParam = new OpenParam();
                openParam.setViewId("ocpos_deliveryaddresslistm");
                openParam.setEnabelHistory(false);
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                ((ExtBillView)this.view).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }
}

