/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.CustomEvent;
import kd.occ.ocepfp.core.form.event.GoHistoryEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocepfp.core.service.admindivision.AdminDivisionHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;

public class DeliveryAddressListMobPlugin
extends ExtListViewPlugin {
    private static final String editImage = "/static/image/olstore/edit.png";
    private static Log logger = LogFactory.getLog(DeliveryAddressListMobPlugin.class);

    public ListDataSet<DynamicObjectCollection> onDataLoad(LoadDataEvent event) {
        ListDataSet listDataSet = super.onDataLoad(event);
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        DynamicObjectCollection pageDate = this.getDeliveryAddressList(memberId);
        if (pageDate != null && pageDate.size() > 0) {
            listDataSet.setRows((Object)pageDate);
        }
        ((ExtListView)this.view).hide("addressList", pageDate.size() <= 0);
        ((ExtListView)this.view).hide("address_none_panel", pageDate.size() > 0);
        return listDataSet;
    }

    private DynamicObjectCollection getDeliveryAddressList(long memberId) {
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        JSONObject deliveryAddressResult = OlstoreMemberHelper.getDeliveryAddressList((long)memberId);
        if (deliveryAddressResult == null || deliveryAddressResult.getInteger("code") != 0) {
            return entryList;
        }
        JSONArray dataList = deliveryAddressResult.getJSONArray("data");
        if (dataList != null && dataList.size() > 0) {
            List jsonList = dataList.toJavaList(JSONObject.class);
            AtomicInteger index = new AtomicInteger();
            for (JSONObject jsondata : jsonList) {
                DynamicObject entryData = ((ListFormData)this.getBillData()).createNewEntryDynamicObject("addressList");
                int rowid = index.getAndIncrement();
                Boolean defaultAddress = jsondata.getBoolean("defaultAddress");
                if (defaultAddress.booleanValue()) {
                    ((ExtListView)this.view).hide("default", false, rowid);
                }
                entryData.set("id", (Object)jsondata.getString("id"));
                String districtName = AdminDivisionHelper.getDivisionName((long)jsondata.getLong("districtId"));
                entryData.set("address", (Object)(districtName + jsondata.getString("detailedAddress")));
                entryData.set("name", (Object)jsondata.getString("contact"));
                entryData.set("tel", (Object)jsondata.getString("phone"));
                entryData.set("editimage", (Object)editImage);
                entryList.add((Object)entryData);
            }
        }
        return entryList;
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        switch (eventId) {
            case "addbtn": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.addCustomParam("sourceviewid", ((ExtListView)this.view).getViewId());
                openParam.setViewId("ocpos_deliveryaddresseditm");
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
            case "editimage": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.addCustomParam("sourceviewid", ((ExtListView)this.view).getViewId());
                openParam.setViewId("ocpos_deliveryaddresseditm");
                openParam.addCustomParam("id", event.getCurrentRow().getPkValue().toString());
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
            case "delbtn": {
                long addressId = Long.parseLong(event.getCurrentRow().getPkValue().toString());
                JSONObject deleteResult = OlstoreMemberHelper.deleteDeliveryAddressById((Long)memberId, (Long)addressId);
                if (deleteResult == null || deleteResult.getInteger("code") != 0) {
                    ((ExtListView)this.view).showMessage("\u5220\u9664\u5730\u5740\u5931\u8d25!");
                    return;
                }
                ((ExtListView)this.view).showMessage("\u5220\u9664\u5730\u5740\u6210\u529f!");
                ((ExtListView)this.view).refresh();
                break;
            }
        }
        super.onClick(event);
    }

    public void onGoHistory(GoHistoryEvent event) {
        OpenParam openParam = new OpenParam();
        openParam.setViewId("ocpos_userinfom");
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        ((ExtListView)this.view).showView(openParam);
    }

    protected void onCustomEvent(CustomEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "importwxaddr": {
                SimpleMap eventParam = event.getEventParam();
                Map customInfo = (Map)eventParam.get((Object)"custom");
                Map addressInfo = (Map)customInfo.get("value");
                logger.info("\u5fae\u4fe1\u5bfc\u5165customInfo\uff1a" + customInfo + "\u5fae\u4fe1\u5bfc\u5165addressInfo\uff1a" + addressInfo);
                String nation = "\u4e2d\u56fd";
                String province = (String)addressInfo.get("provinceName");
                String city = (String)addressInfo.get("cityName");
                String district = (String)addressInfo.get("countyName");
                String userName = (String)addressInfo.get("userName");
                String telNumber = (String)addressInfo.get("telNumber");
                String detailInfo = (String)addressInfo.get("detailInfo");
                DynamicObject adminDivisionInfo = OlstoreStoreInfoHelper.getDivisionIdByAddress((String)nation, (String)province, (String)city, (String)district);
                long adminDivisionId = adminDivisionInfo == null ? 0L : DynamicObjectUtils.getPkValue((DynamicObject)adminDivisionInfo);
                logger.info("\u884c\u653f\u533a\u5212adminDivisionId\uff1a" + adminDivisionId);
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_deliveryaddresseditm");
                openParam.addCustomParam("adminDivisionId", String.valueOf(adminDivisionId));
                openParam.addCustomParam("userName", userName);
                openParam.addCustomParam("telNumber", telNumber);
                openParam.addCustomParam("detailInfo", detailInfo);
                logger.info("\u884c\u653f\u533a\u5212openParam\uff1a" + openParam);
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onCustomEvent(event);
    }
}

