/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.business.handle.SetBranchRangeHelper;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocpos.business.olstore.ItemHelper;
import kd.occ.ocpos.common.enums.ActivityTypeEnum;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class OlsActivityCfgPlugin
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        Date startTime = new Date();
        startTime.setHours(0);
        startTime.setMinutes(0);
        startTime.setSeconds(0);
        this.getModel().setValue("starttime", (Object)startTime);
        Date endTime = new Date();
        endTime.setHours(23);
        endTime.setMinutes(59);
        endTime.setSeconds(59);
        this.getModel().setValue("endtime", (Object)endTime);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_item", "btn_itembrand", "btn_itemclass", "btn_itemlabel"});
        this.addItemClickListeners(new String[]{"bar_item", "bar_itembrand", "bar_itemclass", "bar_itemlabel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "btn_item": {
                this.showPage("ocdbd_iteminfo", "itemck");
                break;
            }
            case "btn_itemclass": {
                this.showPage("mdr_item_class", "itemclassck");
                break;
            }
            case "btn_itembrand": {
                this.showPage("mdr_item_brand", "itembrandck");
                break;
            }
            case "btn_itemlabel": {
                this.showPage("ocdbd_item_label", "itemlabelck");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        IDataModel dataModel = this.getView().getModel();
        if (e.getChangeSet().length <= 0) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "orgrange": {
                DynamicObjectCollection customerGroup = (DynamicObjectCollection)dataModel.getValue("channelclassification");
                if (customerGroup != null && customerGroup.size() > 0) {
                    dataModel.beginInit();
                    dataModel.setValue("channelclassification", null);
                    this.getView().updateView("channelclassification");
                    dataModel.endInit();
                }
                DynamicObjectCollection range = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                SetBranchRangeHelper.setBranchRange((IDataModel)dataModel, (DynamicObjectCollection)range, (boolean)true, (String)"branchreeentryentity", (String)"applyorgid", (String)"branchid");
                this.expand();
                break;
            }
            case "channelclassification": {
                DynamicObjectCollection orgRange = (DynamicObjectCollection)dataModel.getValue("orgrange");
                if (orgRange != null && orgRange.size() > 0) {
                    this.getView().getModel().beginInit();
                    this.getView().getModel().setValue("orgrange", null);
                    this.getView().updateView("orgrange");
                    this.getView().getModel().endInit();
                }
                DynamicObjectCollection group = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                SetBranchRangeHelper.setBranchRange((IDataModel)dataModel, (DynamicObjectCollection)group, (boolean)false, (String)"branchreeentryentity", (String)"applyorgid", (String)"branchid");
                this.expand();
                break;
            }
            case "controlmethod": {
                String controlMethod = String.valueOf(e.getChangeSet()[0].getNewValue());
                if (!"A".equals(controlMethod)) break;
                dataModel.deleteEntryData("branchreeentryentity");
                break;
            }
            case "itemselected": {
                this.getModel().deleteEntryData("itemlistentry");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)e.getReturnData();
        String callBack = e.getActionId();
        DynamicObjectCollection itemEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("itemlistentry");
        switch (callBack) {
            case "itemck": {
                ItemHelper.fillItemEntity((ListSelectedRowCollection)returnDatas, (DynamicObjectCollection)itemEntry, (String)"ocdbd_iteminfo");
                break;
            }
            case "itemclassck": {
                ItemHelper.fillItemEntity((ListSelectedRowCollection)returnDatas, (DynamicObjectCollection)itemEntry, (String)"mdr_item_class");
                break;
            }
            case "itembrandck": {
                ItemHelper.fillItemEntity((ListSelectedRowCollection)returnDatas, (DynamicObjectCollection)itemEntry, (String)"mdr_item_brand");
                break;
            }
            case "itemlabelck": {
                ItemHelper.fillItemEntity((ListSelectedRowCollection)returnDatas, (DynamicObjectCollection)itemEntry, (String)"ocdbd_item_label");
                break;
            }
        }
        this.getView().updateView("itemlistentry");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (key.equals("save") || key.equals("submit")) {
            this.checkDate();
            this.checkEntryIsEmpty();
            this.checkItemIsExist();
        }
        if (key.equals("audit")) {
            this.setActivityStatus();
        }
        if (key.equals("unaudit")) {
            this.getModel().setValue("activitystatus", null);
        }
    }

    public void checkEntryIsEmpty() {
        DynamicObjectCollection itemlistentry;
        String itemselected = (String)this.getModel().getValue("itemselected");
        if (itemselected.equals("3") && (itemlistentry = this.getModel().getEntryEntity("itemlistentry")).size() < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlsActivityCfgPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
        }
    }

    public void checkDate() {
        Date startTime = (Date)this.getModel().getValue("starttime");
        Date endTime = (Date)this.getModel().getValue("endtime");
        if (startTime != null && endTime != null && startTime.compareTo(endTime) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6d3b\u52a8\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u6d3b\u52a8\u7ed3\u675f\u65e5\u671f", (String)"OlsActivityCfgPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
        }
    }

    public void setActivityStatus() {
        Date startTime = (Date)this.getModel().getValue("starttime");
        Date endTime = (Date)this.getModel().getValue("endtime");
        Date nowTime = new Date();
        if (nowTime.compareTo(startTime) < 0) {
            this.getModel().setValue("activitystatus", (Object)ActivityTypeEnum.getValue((String)"invalid"));
        } else if (nowTime.compareTo(startTime) > 0 && nowTime.compareTo(endTime) < 0) {
            this.getModel().setValue("activitystatus", (Object)ActivityTypeEnum.getValue((String)"enable"));
        } else if (nowTime.compareTo(endTime) > 0) {
            this.getModel().setValue("activitystatus", (Object)ActivityTypeEnum.getValue((String)"disable"));
        }
    }

    public void checkItemIsExist() {
        String itemselected = (String)this.getModel().getValue("itemselected");
        if (itemselected.equals("1")) {
            QFilter qFilter = new QFilter("activitystatus", "=", (Object)"1");
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("billstatus", "=", (Object)"C");
            DynamicObjectCollection result = QueryServiceHelper.query((String)"ocpos_olsactivitycfg", (String)"billno", (QFilter[])qFilter.toArray());
            if (result.size() > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5168\u90e8\u5546\u54c1\u4e2d\u5df2\u5b58\u5728\u53c2\u4e0e\u5176\u4ed6\u6d3b\u52a8\u7684\u5546\u54c1\u3002", (String)"OlsActivityCfgPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
        } else if (itemselected.equals("2")) {
            DynamicObjectCollection items = this.getModel().getEntryEntity("itemlistentry");
            QFilter qFilter = new QFilter("itemselected", "=", (Object)"1");
            qFilter.and("activitystatus", "=", (Object)"1");
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("billstatus", "=", (Object)"C");
            DynamicObjectCollection result = QueryServiceHelper.query((String)"ocpos_olsactivitycfg", (String)"billno", (QFilter[])qFilter.toArray());
            if (result.size() > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5168\u90e8\u5546\u54c1\u9664\u5916\u4e2d\u5df2\u5b58\u5728\u53c2\u4e0e\u5176\u4ed6\u6d3b\u52a8\u7684\u5546\u54c1\u3002", (String)"OlsActivityCfgPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)items)) {
                for (DynamicObject item : items) {
                    QFilter qFilter3;
                    DynamicObjectCollection resultItem;
                    DynamicObject itemDy = DynamicObjectUtil.getDynamicObject((DynamicObject)item, (String)"itemid");
                    long itemId = (Long)itemDy.getPkValue();
                    DynamicObject classDy = DynamicObjectUtil.getDynamicObject((DynamicObject)item, (String)"itemclassid");
                    QFilter qFilter1 = new QFilter("itemlistentry.itemid", "not in", (Object)itemId);
                    qFilter1.and("itemselected", "=", (Object)"3");
                    qFilter1.and("activitystatus", "=", (Object)"1");
                    qFilter1.and("enable", "=", (Object)"1");
                    qFilter1.and("billstatus", "=", (Object)"C");
                    QFilter qFilter2 = null;
                    if (classDy != null) {
                        long classId = (Long)classDy.getPkValue();
                        qFilter2 = new QFilter("itemlistentry.itemclassid", "not in", (Object)classId);
                        qFilter2.and("itemselected", "=", (Object)"3");
                        qFilter2.and("activitystatus", "=", (Object)"1");
                        qFilter2.and("enable", "=", (Object)"1");
                        qFilter2.and("billstatus", "=", (Object)"C");
                    }
                    if ((resultItem = QueryServiceHelper.query((String)"ocpos_olsactivitycfg", (String)"billno", (QFilter[])(qFilter3 = qFilter1.or(qFilter2)).toArray())).size() <= 0) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5168\u90e8\u5546\u54c1\u9664\u5916\u4e2d\u5b58\u5728\u53c2\u4e0e\u5176\u4ed6\u6d3b\u52a8\u7684\u5546\u54c1\u3002", (String)"OlsActivityCfgPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (itemselected.equals("3")) {
            DynamicObjectCollection items = this.getModel().getEntryEntity("itemlistentry");
            QFilter qFilter = new QFilter("itemselected", "=", (Object)"1");
            qFilter.and("activitystatus", "=", (Object)"1");
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("billstatus", "=", (Object)"C");
            DynamicObjectCollection result = QueryServiceHelper.query((String)"ocpos_olsactivitycfg", (String)"billno", (QFilter[])qFilter.toArray());
            if (result.size() > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u5b58\u5728\u53c2\u4e0e\u5176\u4ed6\u6d3b\u52a8\u4e2d\u3002", (String)"OlsActivityCfgPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)items)) {
                int i = 1;
                StringBuilder msg = new StringBuilder();
                for (DynamicObject item : items) {
                    QFilter qFilter5;
                    DynamicObjectCollection resultAll;
                    DynamicObject itemDy = DynamicObjectUtil.getDynamicObject((DynamicObject)item, (String)"itemid");
                    long itemId = (Long)itemDy.getPkValue();
                    String type = item.getString("type");
                    DynamicObject classDy = DynamicObjectUtil.getDynamicObject((DynamicObject)item, (String)"itemclassid");
                    QFilter qFilter1 = new QFilter("itemlistentry.itemid", "=", (Object)itemId);
                    qFilter1.and("itemselected", "=", (Object)"3");
                    qFilter1.and("activitystatus", "=", (Object)"1");
                    qFilter1.and("enable", "=", (Object)"1");
                    qFilter1.and("billstatus", "=", (Object)"C");
                    QFilter qFilter4 = new QFilter("itemlistentry.itemid", "!=", (Object)itemId);
                    qFilter4.and("itemselected", "=", (Object)"2");
                    qFilter4.and("activitystatus", "=", (Object)"1");
                    qFilter4.and("enable", "=", (Object)"1");
                    qFilter4.and("billstatus", "=", (Object)"C");
                    QFilter qFilter2 = null;
                    QFilter qFilter3 = null;
                    if (classDy != null) {
                        long classId = (Long)classDy.getPkValue();
                        qFilter2 = new QFilter("itemlistentry.itemclassid", "=", (Object)classId);
                        qFilter2.and("itemselected", "=", (Object)"3");
                        qFilter2.and("activitystatus", "=", (Object)"1");
                        qFilter2.and("enable", "=", (Object)"1");
                        qFilter2.and("billstatus", "=", (Object)"C");
                        qFilter3 = new QFilter("itemselected", "=", (Object)"2");
                        qFilter3.and("itemlistentry.itemclassid", "!=", (Object)classId);
                        qFilter3.and("activitystatus", "=", (Object)"1");
                        qFilter3.and("enable", "=", (Object)"1");
                        qFilter3.and("billstatus", "=", (Object)"C");
                    }
                    if ((resultAll = QueryServiceHelper.query((String)"ocpos_olsactivitycfg", (String)"billno", (QFilter[])(qFilter5 = qFilter1.or(qFilter2).or(qFilter3).or(qFilter4)).toArray())).size() > 0) {
                        if (type.equals("1")) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u5546\u54c1\u5df2\u5b58\u5728\u4e4b\u524d\u7684\u6d3b\u52a8\u914d\u7f6e\u4e2d\u3002", (String)"OlsActivityCfgPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), i));
                            ++i;
                            continue;
                        }
                        if (type.equals("2")) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u5546\u54c1\u5206\u7c7b\u5df2\u5b58\u5728\u4e4b\u524d\u7684\u6d3b\u52a8\u914d\u7f6e\u4e2d\u3002", (String)"OlsActivityCfgPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]), i));
                            ++i;
                            continue;
                        }
                    }
                    ++i;
                }
                String showMsg = msg.toString();
                if (!StringUtils.isEmpty((String)showMsg)) {
                    throw new KDBizException(showMsg);
                }
            }
        }
    }

    public void expand() {
        this.getView().updateView("branchreeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("branchreeentryentity");
        grid.setCollapse(false);
        grid.selectRows(-1);
    }

    public void showPage(String datasourceFormid, String callbacktag) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        ListShowParameter listParam = FormShowUtils.openChooseList(null, (String)datasourceFormid, (ShowType)ShowType.Modal, Arrays.asList(filter.toArray()), (boolean)true, (boolean)true);
        listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callbacktag));
        this.getView().showForm((FormShowParameter)listParam);
    }
}

