/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.pojo.dto.member.user.UpdateUserByIdDTO;
import kd.occ.ocbase.common.pojo.vo.member.user.QueryUserByIdVO;
import kd.occ.ocdbd.common.util.StringUtil;
import kd.occ.ocepfp.common.constant.Enums;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;

public class OlsMemberEditPlugin
extends ExtBillViewPlugin {
    private Log log = LogFactory.getLog(OlsMemberEditPlugin.class, (String)"ocpos");

    public DynamicObject onDataLoad(LoadDataEvent event) {
        DynamicObject data;
        block7: {
            data = super.onDataLoad(event);
            long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
            JSONObject resultJson = OlstoreMemberHelper.getMemberInfoById((long)memberId);
            if (resultJson != null && resultJson.getInteger("code") == 0) {
                JSONObject jsonData = resultJson.getJSONObject("data");
                QueryUserByIdVO vo = (QueryUserByIdVO)JSONObject.toJavaObject((JSON)jsonData, QueryUserByIdVO.class);
                data.set("name", (Object)vo.getName());
                data.set("tel", (Object)vo.getMobile());
                try {
                    data.set("membershiptime", (Object)vo.getCreateTime());
                    int sex = vo.getSex();
                    data.set("sex", (Object)sex);
                    data.set("email", (Object)vo.getEmail());
                    ((BillFormData)this.billData).updateValue("occupation", (Object)vo.getOccupationId());
                    Date defaultDate = new SimpleDateFormat("yyyy-MM-dd").parse("1990-1-1");
                    if (StringUtils.isNotBlank((CharSequence)vo.getBirthday())) {
                        Date birthDate = new SimpleDateFormat("yyyy-MM-dd").parse(vo.getBirthday());
                        data.set("birthdate", (Object)birthDate);
                        kd.occ.ocepfp.core.form.control.controls.Date birthdate = (kd.occ.ocepfp.core.form.control.controls.Date)((ExtBillView)this.view).getControl("birthdate");
                        birthdate.setDisable(true);
                        break block7;
                    }
                    data.set("birthdate", (Object)defaultDate);
                }
                catch (ParseException e) {
                    this.log.info(StringUtil.getErrorMsg((Exception)e));
                    ((ExtBillView)this.view).showMessage("\u5f53\u524d\u4f1a\u5458\uff1a" + JSONObject.toJSONString((Object)jsonData));
                }
            } else if (resultJson == null) {
                ((ExtBillView)this.view).showMessage("\u5f53\u524d\u4f1a\u5458id\uff1a" + memberId + "\uff0cresultJson is null");
            } else {
                ((ExtBillView)this.view).showMessage("\u5f53\u524d\u4f1a\u5458id\uff1a" + memberId + "\uff0c" + resultJson.getString("message"));
            }
        }
        return data;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "savebtn": {
                String pattern;
                boolean isMatch;
                long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
                DynamicObject data = ((BillFormData)this.getBillData()).getDataObject();
                Date birthdate = data.getDate("birthdate");
                if (birthdate.compareTo(new Date()) > 0) {
                    ((ExtBillView)this.view).showMessage("\u4fdd\u5b58\u5931\u8d25,\u751f\u65e5\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002");
                    return;
                }
                String email = data.getString("email");
                if (StringUtils.isNotEmpty((CharSequence)email) && !(isMatch = Pattern.matches(pattern = "^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$", email))) {
                    ((ExtBillView)this.view).showMessage("\u4fdd\u5b58\u5931\u8d25,\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\u3002");
                    return;
                }
                UpdateUserByIdDTO dto = new UpdateUserByIdDTO();
                dto.setUserId(Long.valueOf(memberId));
                dto.setSex(data.getInt("sex"));
                dto.setBirthday(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(birthdate));
                dto.setOccupationId(Long.valueOf(data.getLong("occupation_id")));
                dto.setEmail(email);
                JSONObject resultJson = OlstoreMemberHelper.updateMemberInfo((UpdateUserByIdDTO)dto);
                if (resultJson == null || resultJson.getInteger("code") != 0) {
                    ((ExtBillView)this.view).showMessage("\u4fdd\u5b58\u5931\u8d25\u3002");
                    return;
                }
                ((ExtBillView)this.view).showMessage("\u4fdd\u5b58\u6210\u529f\u3002");
                break;
            }
        }
        super.onClick(event);
    }

    protected void beforeQueryF7(SelectDataEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "occupation": {
                event.getQueryFilter().addFilter("group", Enums.SqlCompareOperator.equal, (Object)926705082425274368L);
                break;
            }
        }
        super.beforeQueryF7(event);
    }
}

