/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;

public class OlsSearchPlugin
extends ExtBillViewPlugin {
    public DynamicObject onDataLoad(LoadDataEvent event) {
        String keyword = "";
        if (event.getEventParam().getString("search") != null) {
            keyword = event.getEventParam().getString("search");
            JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
            String customerId = currentStore.getString("id");
            String sourceviewId = event.getCustomParam().getString("sourceviewid");
            if (StringUtil.isNotNull((String)keyword)) {
                this.search(customerId, sourceviewId, keyword);
                this.putSearchHistory(keyword);
            }
        }
        return super.onDataLoad(event);
    }

    public void onSearch(LoadDataEvent event) {
        String keyword = "";
        if (event.getFilterParam() != null && event.getFilterParam().containsKey("search")) {
            keyword = event.getFilterParam().get("search").toString();
            JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
            String customerId = currentStore.getString("id");
            String sourceviewId = event.getCustomParam().getString("sourceviewid");
            if (StringUtil.isNotNull((String)keyword)) {
                this.search(customerId, sourceviewId, keyword);
                this.putSearchHistory(keyword);
            }
        }
        super.onSearch(event);
    }

    private void search(String customerId, String sourceviewId, String keyword) {
        if ("ocpos_brand_select".equals(sourceviewId)) {
            this.putLocalStorageForParent("keyword", keyword);
            ((ExtBillView)this.view).getParentForm().getDynamicView().refresh();
            ((ExtBillView)this.view).closeView();
        } else {
            OpenParam openParam = new OpenParam();
            openParam.addCustomParam("keyword", keyword);
            openParam.addCustomParam("customerid", customerId);
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setShowTitle(Boolean.TRUE);
            openParam.setViewId("ocpos_brand_select");
            openParam.addCustomParam("uuid", UUID.randomUUID().toString());
            ((ExtBillView)this.getView()).showView(openParam);
        }
    }

    private void putLocalStorageForParent(String key, String value) {
        AbstractExtFormPlugin parentForm = ((ExtBillView)this.view).getParentForm();
        if (StringUtil.isNotNull((String)value)) {
            parentForm.getDynamicView().putLocalStorage(key, value);
        } else {
            parentForm.getDynamicView().putLocalStorage(key, "empty");
        }
    }

    private void putSearchHistory(String keyword) {
        HashMap<String, String> searchhistory = new HashMap<String, String>(8);
        searchhistory.put("name", keyword);
        ((ExtBillView)this.view).putLocalStorage("searchhistory", searchhistory, true, 8);
    }
}

