/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.common.util.StringUtil;

public class OlsShowWindowPlugin
extends AbstractBasePlugIn {
    private static final String KEY_TBMAIN = "tbmain";
    private static final String KEY_SAVE = "bar_save";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SUBMIT = "bar_submit";

    public void initialize() {
        super.initialize();
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("customerid");
        QFilter filter = new QFilter("isonlinestore", "=", (Object)"1");
        fieldEdit.setQFilter(filter);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("starttime", (Object)new Date());
        this.getModel().setValue("endtime", (Object)Date.from(LocalDate.now().atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant()));
        DynamicObject defaultCustomer = OlstoreConfigHelper.getDefaultOlsCustomer();
        if (defaultCustomer != null) {
            this.getModel().setValue("customerid", (Object)new Object[]{defaultCustomer.getString("owner.id")});
            this.getModel().setValue("orgid", (Object)new Object[]{defaultCustomer.getString("owner.saleorg.id")});
        }
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl(KEY_TBMAIN);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String key;
        super.beforeItemClick(e);
        switch (key = e.getItemKey()) {
            case "bar_save": 
            case "bar_submit": {
                String checkTimeMsg = this.checkTime();
                if (StringUtil.isNotNull((String)checkTimeMsg)) {
                    this.getView().showErrorNotification(checkTimeMsg);
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection entryCollection = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                if (entryCollection == null || entryCollection.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u6a71\u7a97\u4fe1\u606f\u3002", (String)"OlsShowWindowPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                for (DynamicObject row : entryCollection) {
                    DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
                    if (subentryentity == null || subentryentity.size() <= 0) continue;
                    for (DynamicObject subrow : subentryentity) {
                        if (subrow.getDynamicObject("itemclassid") != null || subrow.getDynamicObject("itemid") != null) continue;
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u548c\u5546\u54c1\u7f16\u7801\u81f3\u5c11\u9009\u62e9\u4e00\u9879\u3002", (String)"OlsShowWindowPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                }
                break;
            }
        }
    }

    private String checkTime() {
        List customerIds;
        Date startTime = (Date)this.getModel().getValue("starttime");
        Date endTime = (Date)this.getModel().getValue("endtime");
        if (startTime != null && endTime != null && startTime.compareTo(endTime) > 0) {
            return ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"OlsShowWindowPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]);
        }
        DynamicObjectCollection customers = (DynamicObjectCollection)this.getModel().getValue("customerid");
        if (customers == null || customers.size() == 0) {
            return "";
        }
        Object id = this.getModel().getValue("id");
        String customerNames = OlstoreConfigHelper.checkWindowSingle((Object)id, customerIds = customers.stream().map(r -> r.getLong("fbasedataid_id") + "").collect(Collectors.toList()), (Date)startTime, (Date)endTime);
        if (StringUtil.isNotNull((String)customerNames)) {
            return ResManager.loadKDString((String)"\u5df2\u9009\u95e8\u5e97\u5728\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u5b58\u5728\u5355\u636e\uff0c\u4fdd\u5b58\u5931\u8d25\uff01", (String)"OlsShowWindowPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "itemid": {
                DynamicObject itemId = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int rowid = e.getChangeSet()[0].getRowIndex();
                DynamicObject itemClass = (DynamicObject)this.getModel().getValue("itemclassid", rowid);
                if (itemId == null || itemClass == null) {
                    return;
                }
                List itemClassIds = OlstoreConfigHelper.getItemClassByItemId((long)itemId.getLong("id"));
                if (!itemClassIds.contains(itemClass.getString("id"))) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u5206\u7c7b\u5df2\u5b58\u5728\u8fd9\u4e2a\u5546\u54c1\uff01", (String)"OlsShowWindowPlugin", (String)"occ-ocpos-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("itemid", null, rowid);
                break;
            }
            case "itemclassid": {
                DynamicObject itemClass = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int rowid = e.getChangeSet()[0].getRowIndex();
                DynamicObject itemId = (DynamicObject)this.getModel().getValue("itemid", rowid);
                if (itemId == null || itemClass == null) {
                    return;
                }
                List itemClassIds = OlstoreConfigHelper.getItemClassByItemId((long)itemId.getLong("id"));
                if (!itemClassIds.contains(itemClass.getString("id"))) break;
                this.getModel().setValue("itemid", null, rowid);
                break;
            }
            case "customerid": {
                DynamicObjectCollection customers = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                if (customers != null && customers.size() > 0) {
                    List customerIds = customers.stream().map(r -> r.getLong("fbasedataid_id")).collect(Collectors.toList());
                    List bizGroupIds = OlstoreConfigHelper.getOlsCustomerBizGroup(customerIds);
                    this.getModel().setValue("orgid", (Object)bizGroupIds.toArray());
                    break;
                }
                this.getModel().setValue("orgid", null);
                break;
            }
        }
    }
}

