/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.business.handle.SetBranchRangeHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class OlslideShowEditPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"picture"});
        BasedataEdit f7 = (BasedataEdit)this.getControl("jumpobject");
        f7.addAfterF7SelectListener((AfterF7SelectListener)this);
        f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"picture", (CharSequence)source.getKey())) {
            this.showImageSelector();
        }
    }

    private void showImageSelector() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ocpos_selectpicture");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "picture"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)"picture", (CharSequence)closedCallBackEvent.getActionId())) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
            int row = grid.getEntryState().getFocusRow();
            String url = (String)closedCallBackEvent.getReturnData();
            this.getModel().setValue("picture", (Object)url, row);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        super.propertyChanged(e);
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length <= 0) {
            return;
        }
        IDataModel model = this.getView().getModel();
        switch (fieldName = e.getProperty().getName()) {
            case "orgrange": {
                DynamicObjectCollection customerGroup = (DynamicObjectCollection)model.getValue("channelgroup");
                if (customerGroup != null && customerGroup.size() > 0) {
                    this.getView().getModel().beginInit();
                    this.getView().getModel().setValue("channelgroup", null);
                    this.getView().updateView("channelgroup");
                    this.getView().getModel().endInit();
                }
                DynamicObjectCollection range = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                SetBranchRangeHelper.setBranchRange((IDataModel)model, (DynamicObjectCollection)range, (boolean)true, (String)"treeentryentity", (String)"org", (String)"branch");
                this.expand();
                break;
            }
            case "channelgroup": {
                DynamicObjectCollection orgRange = (DynamicObjectCollection)model.getValue("orgrange");
                if (orgRange != null && orgRange.size() > 0) {
                    this.getView().getModel().beginInit();
                    this.getView().getModel().setValue("orgrange", null);
                    this.getView().updateView("orgrange");
                    this.getView().getModel().endInit();
                }
                DynamicObjectCollection group = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                SetBranchRangeHelper.setBranchRange((IDataModel)model, (DynamicObjectCollection)group, (boolean)false, (String)"treeentryentity", (String)"org", (String)"branch");
                this.expand();
                break;
            }
        }
    }

    private void expand() {
        this.getView().updateView("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        grid.setCollapse(false);
        grid.selectRows(-1);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityName = e.getEntryProp().getName();
        if (CollectionUtils.isEmpty((Map)customParams)) {
            return;
        }
        int insertRow = e.getRowDataEntities()[0].getRowIndex();
        DynamicObjectCollection entryEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        switch (entityName) {
            case "entryentity": {
                if (insertRow == 0) {
                    this.getView().getModel().setValue("sort", (Object)1, insertRow);
                    break;
                }
                this.getView().getModel().setValue("sort", (Object)(((DynamicObject)entryEntity.get(insertRow - 1)).getInt("sort") + 1), insertRow);
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        BasedataEdit source = (BasedataEdit)e.getSource();
        String key = source.getKey();
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (key) {
            case "jumpobject": {
                String urlPrefix = "view:";
                StringBuilder url = new StringBuilder(urlPrefix);
                DynamicObject currentEntry = this.getModel().getEntryRowEntity("entryentity", row);
                long jumpObjectId = DynamicObjectUtil.getPkValue((DynamicObject)currentEntry, (String)"jumpobject");
                if (jumpObjectId == 0L) break;
                String jumpType = currentEntry.getString("jumptype");
                String urlSuffix = "";
                switch (jumpType) {
                    case "ocdbd_giftset": {
                        urlSuffix = "ocpos_gift_marketing_detail?giftId=";
                        break;
                    }
                    case "ocdbd_olinvitate": {
                        urlSuffix = "ocpos_latestnews_info?olinvitationid=";
                        break;
                    }
                    case "ocdbd_iteminfo": {
                        urlSuffix = "ocpos_itemdetails?itemid=";
                        break;
                    }
                    case "ocdbd_market_promote": {
                        urlSuffix = "ocpos_promotion_info?promotionid=";
                        break;
                    }
                }
                url.append(urlSuffix).append(jumpObjectId);
                if ("ocdbd_olinvitate".equals(jumpType)) {
                    url.append("&sourceviewid=ocpos_latestnews_list");
                }
                this.getModel().setValue("jumpurl", (Object)url, row);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit source = (BasedataEdit)e.getSource();
        String key = source.getKey();
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (key) {
            case "jumpobject": {
                DynamicObject currentEntry = this.getModel().getEntryRowEntity("entryentity", row);
                String jumpType = currentEntry.getString("jumptype");
                QFilter filter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
                filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
                switch (jumpType) {
                    case "ocdbd_giftset": {
                        filter.and("activestatus", "=", (Object)Character.valueOf('B'));
                        break;
                    }
                    case "ocdbd_olinvitate": {
                        filter.and("activitystatus", "=", (Object)Character.valueOf('1'));
                        break;
                    }
                    case "ocdbd_iteminfo": {
                        break;
                    }
                    case "ocdbd_market_promote": {
                        Date nowDate = TimeServiceHelper.now();
                        filter.and("starttime", "<=", (Object)nowDate);
                        filter.and("endtime", ">=", (Object)nowDate);
                        break;
                    }
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
        }
    }
}

