/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.pojo.dto.member.user.RegisterByWechatDTO;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.Form;
import kd.occ.ocepfp.common.entity.MainPortal;
import kd.occ.ocepfp.core.portal.AbstractPortalGateWay;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class OlstorePortalGateWay
extends AbstractPortalGateWay {
    private static final String portalnum = "store";
    protected static Log logger = LogFactory.getLog(OlstorePortalGateWay.class);

    public boolean checkRole(ExtWebContext extCtx, MainPortal portal) {
        return portalnum.equals(portal.getNumber());
    }

    public String getExtAppId(ExtWebContext extCtx) {
        DynamicObject config = OlstoreConfigHelper.getOlstoreConfig();
        if (config != null) {
            return config.getString("appid");
        }
        return super.getExtAppId(extCtx);
    }

    public String getExtAppSecret(ExtWebContext extCtx) {
        DynamicObject config = OlstoreConfigHelper.getOlstoreConfig();
        if (config != null) {
            return config.getString("appsecret");
        }
        return super.getExtAppSecret(extCtx);
    }

    public long getExtAppOrgId(ExtWebContext extCtx) {
        Long customerId;
        Form form = extCtx.getForm();
        logger.info("OlstorePortalGateWay getExtAppOrgId \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 form\uff1a" + JSON.toJSONString((Object)form));
        String eventparam = form.getString("eventparam");
        JSONObject eventParam = JSONObject.parseObject((String)eventparam);
        logger.info("OlstorePortalGateWay getExtAppOrgId \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 eventParam JSONObject\uff1a" + eventParam);
        JSONObject localStorage = eventParam.getJSONObject("LocalStorage");
        logger.info("OlstorePortalGateWay getExtAppOrgId \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 localStorage\uff1a" + localStorage);
        String paramId = localStorage.getString("paramid");
        JSONObject customParam = eventParam.getJSONObject("customparam");
        logger.info("OlstorePortalGateWay getExtAppOrgId \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 customParam\uff1a" + customParam);
        String guideId = customParam.getString("guideid");
        String storeId = customParam.getString("storeid");
        JSONObject storeInfo = localStorage.getJSONObject("storeinfo");
        if (StringUtils.isNotBlank((CharSequence)guideId) && StringUtils.isNotBlank((CharSequence)storeId)) {
            customerId = Long.parseLong(storeId);
        } else if (StringUtils.isNotBlank((CharSequence)paramId)) {
            JSONObject guideParam = OlstoreUtil.getGuideParamJSONObject((String)paramId);
            String store = guideParam.getString("storeid");
            customerId = Long.parseLong(store);
        } else if (storeInfo != null && !storeInfo.isEmpty()) {
            logger.info("OlstorePortalGateWay getExtAppOrgId \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 storeInfo\uff1a" + storeInfo);
            customerId = storeInfo.getLong("id");
        } else {
            DynamicObject olstoreCogInfo = OlstoreConfigHelper.getOlstoreConfig();
            if (olstoreCogInfo == null) {
                return super.getExtAppOrgId(extCtx);
            }
            DynamicObject customerInfo = DynamicObjectUtils.getDynamicObject((DynamicObject)olstoreCogInfo, (String)"storeid");
            customerId = DynamicObjectUtils.getPkValue((DynamicObject)customerInfo);
            if (customerId == 0L) {
                return super.getExtAppOrgId(extCtx);
            }
        }
        DynamicObject branch = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"ocdbd_channel", (String)"saleorg");
        DynamicObject saleOrginfo = DynamicObjectUtils.getDynamicObject((DynamicObject)branch, (String)"saleorg");
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrginfo);
        logger.info("OlstorePortalGateWay getExtAppOrgId \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 saleOrgId\uff1a" + saleOrgId);
        return saleOrgId;
    }

    public void beforeRegisterFirst(ExtWebContext extCtx, RegisterByWechatDTO dto) {
        Long customerId;
        String eventparam = extCtx.getForm().getString("eventparam");
        JSONObject eventParam = JSONObject.parseObject((String)eventparam);
        logger.info("OlstorePortalGateWay beforeRegisterFirst \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 eventParam JSONObject\uff1a" + eventParam);
        if (eventParam == null || eventParam.isEmpty()) {
            return;
        }
        JSONObject localStorage = eventParam.getJSONObject("LocalStorage");
        logger.info("OlstorePortalGateWay beforeRegisterFirst \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 localStorage\uff1a" + localStorage);
        String paramId = localStorage.getString("paramid");
        logger.info("OlstorePortalGateWay beforeRegisterFirst \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 paramId\uff1a" + paramId);
        JSONObject customParam = eventParam.getJSONObject("customparam");
        String guideId = customParam.getString("guideid");
        String storeId = customParam.getString("storeid");
        JSONObject storeInfo = localStorage.getJSONObject("storeinfo");
        long memberId = extCtx.getMemberId();
        if (StringUtils.isNotBlank((CharSequence)guideId) && StringUtils.isNotBlank((CharSequence)storeId)) {
            logger.info("\u8ba4\u7b79\u9080\u7ea6\u5206\u4eab \u66f4\u65b0\u6765\u6e90\u6e20\u9053id\u548c\u5f00\u53d1\u4eba\u53c2\u6570\uff1a" + memberId + "," + storeId + "," + guideId);
            customerId = Long.parseLong(storeId);
            dto.setDeveloperId(Long.valueOf(Long.parseLong(guideId)));
            this.addNewMember(memberId, storeId);
        } else if (StringUtils.isNotBlank((CharSequence)paramId)) {
            JSONObject guideParam = OlstoreUtil.getGuideParamJSONObject((String)paramId);
            String guide = guideParam.getString("guideid");
            String store = guideParam.getString("storeid");
            String sourceviewid = guideParam.getString("sourceviewid");
            customerId = Long.parseLong(store);
            if ("brokerview".equals(sourceviewid)) {
                dto.setAgentId(Long.valueOf(Long.parseLong(guide)));
            } else {
                dto.setDeveloperId(Long.valueOf(Long.parseLong(guide)));
            }
            this.addNewMember(memberId, store);
        } else if (storeInfo != null && !storeInfo.isEmpty()) {
            logger.info("OlstorePortalGateWay getExtAppOrgId \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 storeInfo\uff1a" + storeInfo);
            customerId = storeInfo.getLong("id");
        } else {
            DynamicObject olstoreCogInfo = OlstoreConfigHelper.getOlstoreConfig();
            if (olstoreCogInfo == null) {
                return;
            }
            DynamicObject customerInfo = DynamicObjectUtils.getDynamicObject((DynamicObject)olstoreCogInfo, (String)"storeid");
            customerId = DynamicObjectUtils.getPkValue((DynamicObject)customerInfo);
            if (customerId == 0L) {
                return;
            }
        }
        DynamicObject branch = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"ocdbd_channel", (String)"saleorg");
        DynamicObject saleOrginfo = DynamicObjectUtils.getDynamicObject((DynamicObject)branch, (String)"saleorg");
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrginfo);
        logger.info("OlstorePortalGateWay beforeRegisterFirst \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 saleOrgId\uff1a" + saleOrgId);
        dto.setOrgId(Long.valueOf(saleOrgId));
        dto.setChannelId(customerId);
        dto.setSrcAppName("\u7ebf\u4e0a\u95e8\u5e97");
        if (SystemParamUtil.getEnableCounselor((long)saleOrgId, (long)customerId)) {
            logger.info("OlstorePortalGateWay beforeRegisterFirst \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 customerId\uff1a" + customerId);
            JSONObject consultantResult = OlstoreMemberHelper.getChannelConsultant((Long)customerId);
            logger.info("OlstorePortalGateWay beforeRegisterFirst \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u56de\u8c03 consultantResult\uff1a" + consultantResult);
            if (consultantResult != null && consultantResult.getInteger("code") == 0) {
                JSONObject data = consultantResult.getJSONObject("data");
                Long consultantId = data.getLong("consultantId");
                dto.setConsultantId(consultantId);
            }
        }
        dto.setAssignReasonId(Long.valueOf(1114511053657709568L));
        logger.info("OlstorePortalGateWay beforeRegisterFirst \u7ebf\u4e0a\u95e8\u5e97\u6ce8\u518c\u524d\u66f4\u65b0dto\uff1a" + JSON.toJSONString((Object)dto));
    }

    private void addNewMember(Long memberId, String storeId) {
        DynamicObject olstoreShareClick = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_olstoreshareclick");
        olstoreShareClick.set("createtime", (Object)new Date());
        olstoreShareClick.set("memberid", (Object)memberId);
        olstoreShareClick.set("storeid", (Object)storeId);
        olstoreShareClick.set("isnewmember", (Object)"1");
        logger.info("\u5f00\u59cb\u4fdd\u5b58\u65b0\u589e\u4f1a\u5458");
        SaveServiceHelper.saveOperate((String)"ocpos_olstoreshareclick", (DynamicObject[])new DynamicObject[]{olstoreShareClick});
        logger.info("\u7ed3\u675f\u4fdd\u5b58\u65b0\u589e\u4f1a\u5458");
    }
}

