/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class OlstoreReceiveTicketDetailPlugin
extends ExtBillViewPlugin {
    private static Log logger = LogFactory.getLog(OlstoreReceiveTicketDetailPlugin.class);

    public DynamicObject onDataLoad(LoadDataEvent event) {
        DynamicObject receiveTicketDyn = super.onDataLoad(event);
        String sourceViewId = this.hideControlBySourceViewId(event);
        long schemeID = this.initShareUrl(event, sourceViewId);
        return this.doLoadData(receiveTicketDyn, schemeID, sourceViewId);
    }

    private DynamicObject doLoadData(DynamicObject receiveTicketDyn, long schemeID, String sourceViewId) {
        long vipID = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        JSONObject receiveTicketJsonRes = OlstoreTicketHelper.queryReceiveTicketDetail((long)schemeID, (long)vipID);
        if (receiveTicketJsonRes.getBoolean("success").booleanValue()) {
            String validperiodType;
            boolean isExceedVipGetMaxQty;
            JSONObject receiveTicketJson = (JSONObject)receiveTicketJsonRes.get((Object)"data");
            receiveTicketDyn.set("schemeid", (Object)receiveTicketJson.getLong("schemeID"));
            receiveTicketDyn.set("schemenumber", receiveTicketJson.get((Object)"schemeNumber"));
            receiveTicketDyn.set("tickettypeid", (Object)receiveTicketJson.getLong("ticketTypeID"));
            receiveTicketDyn.set("schemenumber", (Object)receiveTicketJson.getString("ticketTypeNumber"));
            receiveTicketDyn.set("ticketname", (Object)receiveTicketJson.getString("schemeName"));
            String ticketvalue = "";
            switch (receiveTicketJson.getString("usagemode")) {
                case "0": {
                    ticketvalue = receiveTicketJson.getBigDecimal("ticketValue").setScale(2).stripTrailingZeros().toPlainString();
                    ((ExtBillView)this.view).hide("labelnuq7g", false);
                    ((ExtBillView)this.view).hide("labeld4pas", true);
                    break;
                }
                case "1": {
                    ticketvalue = receiveTicketJson.getBigDecimal("discountrate").divide(new BigDecimal("10"), 2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                    ((ExtBillView)this.view).hide("labelnuq7g", true);
                    ((ExtBillView)this.view).hide("labeld4pas", false);
                    break;
                }
                case "2": {
                    ticketvalue = ResManager.loadKDString((String)"\u793c\u54c1\u5238", (String)"OlstoreReceiveTicketDetailPlugin_0", (String)"occ-ocpos-formplugin", (Object[])new Object[0]);
                    ((ExtBillView)this.view).hide("labelnuq7g", true);
                    ((ExtBillView)this.view).hide("labeld4pas", true);
                    break;
                }
                default: {
                    ticketvalue = receiveTicketJson.getBigDecimal("ticketValue").setScale(2).stripTrailingZeros().toPlainString();
                    ((ExtBillView)this.view).hide("labelnuq7g", false);
                    ((ExtBillView)this.view).hide("labeld4pas", true);
                }
            }
            receiveTicketDyn.set("ticketvalue", (Object)ticketvalue);
            receiveTicketDyn.set("viphasreceiveqty", (Object)receiveTicketJson.getInteger("vipHasReceiveQty"));
            receiveTicketDyn.set("vipgetmaxqty", (Object)receiveTicketJson.getInteger("vipGetMaxQty"));
            receiveTicketDyn.set("validitydays", (Object)receiveTicketJson.getInteger("validityDays"));
            receiveTicketDyn.set("condition", (Object)receiveTicketJson.getString("ticketApplyTerminal"));
            receiveTicketDyn.set("totalqty", (Object)receiveTicketJson.getInteger("totalQty"));
            receiveTicketDyn.set("hasdistributetotalqty", (Object)receiveTicketJson.getInteger("hasDistributeTotalQty"));
            receiveTicketDyn.set("startdate", (Object)receiveTicketJson.getString("startDate"));
            receiveTicketDyn.set("enddate", (Object)receiveTicketJson.getString("endDate"));
            receiveTicketDyn.set("validperiodtype", (Object)receiveTicketJson.getString("validPeriodType"));
            receiveTicketDyn.set("minconsume", (Object)receiveTicketJson.getBigDecimal("minConsumeAmount").setScale(2).stripTrailingZeros().toPlainString());
            receiveTicketDyn.set("minconsumeamount", (Object)("\u6ee1" + receiveTicketJson.getBigDecimal("minConsumeAmount").setScale(2).stripTrailingZeros().toPlainString() + "\u5143\u4f7f\u7528"));
            receiveTicketDyn.set("usagemode", (Object)receiveTicketJson.getString("usagemode"));
            long schemeId = receiveTicketJson.getLong("schemeID");
            Boolean isOutstandingTicket = OlstoreTicketHelper.isHasOutstandingTicket((long)schemeId, (long)vipID);
            if (!"guide_givegift".equals(sourceViewId)) {
                if (isOutstandingTicket.booleanValue()) {
                    ((ExtBillView)this.view).hide("receiveticket", true);
                    ((ExtBillView)this.view).hide("useticket", false);
                } else {
                    ((ExtBillView)this.view).hide("receiveticket", false);
                    ((ExtBillView)this.view).hide("useticket", true);
                }
            }
            boolean isExceedTotalQty = receiveTicketJson.getInteger("hasDistributeTotalQty") >= receiveTicketJson.getInteger("totalQty");
            boolean bl = isExceedVipGetMaxQty = receiveTicketJson.getInteger("vipHasReceiveQty") >= receiveTicketJson.getInteger("vipGetMaxQty");
            if (isExceedTotalQty || isExceedVipGetMaxQty) {
                ((ExtBillView)this.view).updateControlName("receiveticket", "\u5df2\u9886\u5b8c");
                ((ExtBillView)this.view).disable("receiveticket", true);
            }
            if ("B".equals(validperiodType = receiveTicketDyn.getString("validperiodtype"))) {
                ((ExtBillView)this.view).hide("flexpaneltetm3", true);
                ((ExtBillView)this.view).hide("flexpaneldate", false);
            } else {
                ((ExtBillView)this.view).hide("flexpaneltetm3", false);
                ((ExtBillView)this.view).hide("flexpaneldate", true);
            }
        }
        return receiveTicketDyn;
    }

    private String getSourceViewId(LoadDataEvent event) {
        String paramId;
        JSONObject paramInfo;
        String sourceViewId = event.getCustomParam().getString("sourceviewid");
        if (StringUtils.isEmpty((CharSequence)sourceViewId) && (paramInfo = OlstoreUtil.getGuideParamJSONObject((String)(paramId = event.getCustomParam().getString("paramid")))) != null) {
            sourceViewId = paramInfo.getString("sourceviewid");
        }
        return sourceViewId;
    }

    private long initShareUrl(LoadDataEvent event, String sourceViewId) {
        JSONObject paramInfo;
        String paramId;
        long schemeID = event.getCustomParam().getLong("billId");
        String nickName = event.getCustomParam().getString("nickName");
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        String storeId = "0";
        if ("guideview".equals(sourceViewId)) {
            paramId = event.getCustomParam().getString("paramid");
            paramInfo = OlstoreUtil.getGuideParamJSONObject((String)paramId);
            if (paramInfo != null) {
                schemeID = paramInfo.getLong("billId");
                nickName = paramInfo.getString("nickName");
                String billNo = paramInfo.getString("billno");
                String guideId = paramInfo.getString("guideid");
                storeId = paramInfo.getString("storeid");
                String sourceType = paramInfo.getString("sourcetype");
                String role = paramInfo.getString("role");
                logger.info("\u7f16\u53f7\uff1a" + billNo + "\u5bfc\u8d2d\u5458\uff1a" + guideId + "\u95e8\u5e97\uff1a" + storeId + "\u6765\u6e90\u7c7b\u578b\uff1a" + sourceType + "\u89d2\u8272\uff1a" + role + "\u4f1a\u5458\uff1a" + memberId);
                OlstoreUtil.regularMarketClick((String)billNo, (String)guideId, (String)String.valueOf(memberId), (String)storeId, (String)role, (String)sourceType);
            }
        } else if ("guide_givegift".equals(sourceViewId)) {
            String billNo = event.getCustomParam().getString("billno");
            String guideId = event.getCustomParam().getString("guideid");
            storeId = event.getCustomParam().getString("storeid");
            String sourceType = event.getCustomParam().getString("sourcetype");
            String role = event.getCustomParam().getString("role");
            logger.info("\u793c\u5238\u8d60\u9001\u7f16\u53f7\uff1a" + billNo + "\u5bfc\u8d2d\u5458\uff1a" + guideId + "\u95e8\u5e97\uff1a" + storeId + "\u6765\u6e90\u7c7b\u578b\uff1a" + sourceType + "\u89d2\u8272\uff1a" + role + "\u4f1a\u5458\uff1a" + memberId);
            OlstoreUtil.regularMarketClick((String)billNo, (String)guideId, (String)String.valueOf(memberId), (String)storeId, (String)role, (String)sourceType);
        } else if ("brokerview".equals(sourceViewId) && (paramInfo = OlstoreUtil.getGuideParamJSONObject((String)(paramId = event.getCustomParam().getString("paramid")))) != null) {
            storeId = paramInfo.getString("storeid");
            schemeID = paramInfo.getLong("billId");
            nickName = paramInfo.getString("nickName");
        }
        if (StringUtils.isNotBlank((CharSequence)event.getCustomParam().getString("storeid"))) {
            logger.info("\u5206\u4eab\u8fc7\u6765\u643a\u5e26\u7684\u95e8\u5e97id\u53c2\u6570\uff1a" + storeId);
            storeId = event.getCustomParam().getString("storeid");
        }
        logger.info("\u5bfc\u8d2d\u52a9\u624b\u8df3\u8fc7\u6765\u643a\u5e26\u7684\u95e8\u5e97id\u53c2\u6570\uff1a" + storeId);
        ((ExtBillView)this.view).putLocalStorage("branchId", storeId);
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo((long)Long.parseLong(storeId));
        if (storeInfo != null) {
            String storeName = storeInfo.getString("name");
            if (StringUtils.isNotBlank((CharSequence)storeId) && StringUtils.isNotBlank((CharSequence)storeName)) {
                JSONObject storeJson = new JSONObject();
                storeJson.put("id", (Object)storeId);
                storeJson.put("name", (Object)storeName);
                OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
            }
        }
        String title = ResManager.loadKDString((String)"\u7ed9\u4f60\u5206\u4eab\u4f18\u60e0\u597d\u5238\uff0c\u4e0d\u8981\u9519\u8fc7\u5566", (String)"OlstoreReceiveTicketDetailPlugin_0", (String)"occ-ocpos-formplugin", (Object[])new Object[0]);
        DynamicObject issueSchemeInfo = BusinessDataServiceHelper.loadSingle((Object)schemeID, (String)"ocdbd_issuescheme");
        DynamicObject ticketTypeInfo = DynamicObjectUtils.getDynamicObject((DynamicObject)issueSchemeInfo, (String)"tickettypeid");
        String ticketStyle = DynamicObjectUtils.getString((DynamicObject)ticketTypeInfo, (String)"ticketstyle");
        String pic = PictureUtil.getFileServerUrl() + ticketStyle;
        ((ExtBillView)this.view).initShareUrl("giftticket", this.getShareUrl(schemeID, storeId), nickName + title, pic);
        logger.info("OlstoreReceiveTicketDetailPlugin_onDataLoad_schemeId=" + schemeID);
        return schemeID;
    }

    private String getShareUrl(long schemeId, String storeId) {
        Map paramMap = OlstoreUtil.buildFromToViewMap((String)"giftticket", (String)"ocpos_receiveticket_detail");
        paramMap.put("billId", schemeId);
        paramMap.put("storeid", storeId);
        String url = OlstoreUtil.buildShareUrl((Map)paramMap);
        logger.info("OlstoreReceiveTicketDetailPlugin_getShareUrl_url=" + url);
        return url;
    }

    private String hideControlBySourceViewId(LoadDataEvent event) {
        String sourceViewId;
        switch (sourceViewId = this.getSourceViewId(event)) {
            case "guide_givegift": {
                ((ExtBillView)this.view).hide("receiveticket", true);
                ((ExtBillView)this.view).hide("giftticket", false);
                break;
            }
            case "giftticket": 
            case "guideview": 
            case "row_panel": 
            case "brokerview": {
                ((ExtBillView)this.view).hide("giftticket", true);
                break;
            }
        }
        logger.info("OlstoreReceiveTicketDetailPlugin_onDataLoad_sourceViewId=" + sourceViewId);
        return sourceViewId;
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        long vipID = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        switch (eventId) {
            case "receiveticket": {
                long branchId = OlstoreUtil.getStoreId((ClientEvent)event);
                logger.info("\u7f13\u5b58\u7684\u95e8\u5e97id\uff1a" + branchId);
                if (branchId == 0L) {
                    SimpleMap localStorage = event.getLocalStorage();
                    branchId = localStorage.getLong("branchId");
                    logger.info("\u5bfc\u8d2d\u52a9\u624b\u653e\u5165\u7f13\u5b58\u7684\u95e8\u5e97id\uff1a" + branchId);
                }
                if (branchId == 0L) {
                    DynamicObject defaultStore = OlstoreStoreInfoHelper.getDefaultStore();
                    branchId = defaultStore.getLong("id");
                    logger.info("\u793c\u5238\u9ed8\u8ba4\u95e8\u5e97id\uff1a" + branchId);
                }
                this.receiveTicket(vipID, branchId, event);
                break;
            }
            case "giftticket": {
                break;
            }
            case "useticket": {
                long schemeId = ((BillFormData)this.billData).getLong("schemeid");
                long ticketId = OlstoreTicketHelper.getTicketInfoIdByschemeId((long)schemeId, (long)vipID);
                OpenParam ticketItemSearchView = new OpenParam();
                ticketItemSearchView.setTarget(OpenParam.OpenTarget.NewWindow);
                ticketItemSearchView.setViewId("ocpos_ticketitem_search");
                ticketItemSearchView.setShowTitle(Boolean.TRUE);
                ticketItemSearchView.addCustomParam("ticketId", String.valueOf(ticketId));
                ((ExtBillView)this.getView()).showView(ticketItemSearchView);
                break;
            }
        }
        super.onClick(event);
    }

    private void receiveTicket(long vipID, long branchId, ClickEvent event) {
        DynamicObject receiveTicketDyn = ((BillFormData)this.getBillData()).getDataObject();
        long schemeID = receiveTicketDyn.getLong("schemeid");
        JSONObject jsonRes = OlstoreTicketHelper.receiveTicket((long)vipID, (long)schemeID, (long)branchId);
        if (jsonRes.getBoolean("success").booleanValue()) {
            boolean isExceedVipGetMaxQty = receiveTicketDyn.getInt("viphasreceiveqty") + 1 >= receiveTicketDyn.getInt("vipgetmaxqty");
            boolean isExceedTotalQty = receiveTicketDyn.getInt("hasdistributetotalqty") + 1 >= receiveTicketDyn.getInt("totalqty");
            ((BillFormData)this.billData).updateValue("viphasreceiveqty", (Object)(receiveTicketDyn.getInt("viphasreceiveqty") + 1));
            ((BillFormData)this.billData).updateValue("hasdistributetotalqty", (Object)(receiveTicketDyn.getInt("hasdistributetotalqty") + 1));
            if (isExceedVipGetMaxQty || isExceedTotalQty) {
                ((ExtBillView)this.view).updateControlName("receiveticket", "\u5df2\u9886\u5b8c");
                ((ExtBillView)this.view).disable("receiveticket", true);
            }
            long ticketId = OlstoreTicketHelper.getTicketInfoIdByschemeId((long)schemeID, (long)vipID);
            this.recordTicketNo(ticketId, event);
            ((ExtBillView)this.view).showMessage("\u9886\u53d6\u6210\u529f\u3002");
            ((ExtBillView)this.view).refresh();
        } else {
            ((ExtBillView)this.view).showMessage(jsonRes.getString("message"));
        }
    }

    private void recordTicketNo(Long ticketId, ClickEvent event) {
        String paramId;
        JSONObject paramInfo;
        String sourceViewId = event.getCustomParam().getString("sourceviewid");
        if (StringUtils.isEmpty((CharSequence)sourceViewId) && (paramInfo = OlstoreUtil.getGuideParamJSONObject((String)(paramId = event.getCustomParam().getString("paramid")))) != null) {
            sourceViewId = paramInfo.getString("sourceviewid");
        }
        logger.info("OlstoreReceiveTicketDetailPlugin:sourceViewId===>" + sourceViewId);
        if ("brokerview".equals(sourceViewId)) {
            DynamicObject ticket = BusinessDataServiceHelper.loadSingle((Object)ticketId, (String)"ocdbd_ticketinfo");
            String ticketNo = DynamicObjectUtils.getString((DynamicObject)ticket, (String)"number");
            String paramId2 = event.getCustomParam().getString("paramid");
            JSONObject paramInfo2 = OlstoreUtil.getGuideParamJSONObject((String)paramId2);
            if (paramInfo2 != null) {
                logger.info("OlstoreReceiveTicketDetailPlugin:sourceViewId===>" + paramInfo2);
                String billNo = paramInfo2.getString("billno");
                String guideId = paramInfo2.getString("guideid");
                String storeId = paramInfo2.getString("storeid");
                String sourceType = paramInfo2.getString("sourcetype");
                String role = paramInfo2.getString("role");
                OlstoreUtil.recordTicketNoApi((String)ticketNo, (String)billNo, (String)guideId, (String)storeId, (String)sourceType, (String)role);
            }
        }
    }
}

