/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class OlstoreReceiveTicketListPlugin
extends ExtListViewPlugin {
    public ListDataSet<?> onDataLoad(LoadDataEvent event) {
        boolean isExistList;
        long branchId;
        ListDataSet listDataSet = super.onDataLoad(event);
        long vipID = ((ExtListView)this.getView()).getExtCtx().getMemberId();
        DynamicObjectCollection receiveTicketList = this.getReceiveTicketList(vipID, branchId = OlstoreUtil.getStoreId((ClientEvent)event), event.getPage(), event.getPageSize());
        boolean bl = isExistList = receiveTicketList.size() > 0;
        if (isExistList) {
            block10: for (DynamicObject entryDyn : receiveTicketList) {
                String validperiodType;
                boolean isExceedVipGetMaxQty;
                int index = receiveTicketList.indexOf((Object)entryDyn);
                long schemeId = entryDyn.getLong("schemeid");
                Boolean isOutstandingTicket = OlstoreTicketHelper.isHasOutstandingTicket((long)schemeId, (long)vipID);
                if (isOutstandingTicket.booleanValue()) {
                    ((ExtListView)this.view).hide("receiveticket", true, index);
                    ((ExtListView)this.view).hide("useticket", false, index);
                } else {
                    ((ExtListView)this.view).hide("receiveticket", false, index);
                    ((ExtListView)this.view).hide("useticket", true, index);
                }
                boolean isExceedTotalQty = entryDyn.getInt("hasdistributetotalqty") >= entryDyn.getInt("totalqty");
                boolean bl2 = isExceedVipGetMaxQty = entryDyn.getInt("viphasreceiveqty") >= entryDyn.getInt("vipgetmaxqty");
                if (isExceedTotalQty || isExceedVipGetMaxQty) {
                    ((ExtListView)this.view).updateControlName("receiveticket", "\u5df2\u9886\u5b8c", index);
                    ((ExtListView)this.view).disable("receiveticket", true, index);
                }
                if ("B".equals(validperiodType = entryDyn.getString("validperiodtype"))) {
                    ((ExtListView)this.view).hide("flexpanelnay1t", true, index);
                    ((ExtListView)this.view).hide("flexpaneldate", false, index);
                } else {
                    ((ExtListView)this.view).hide("flexpanelnay1t", false, index);
                    ((ExtListView)this.view).hide("flexpaneldate", true, index);
                }
                switch (entryDyn.getString("usagemode")) {
                    case "0": {
                        ((ExtListView)this.view).hide("labeltgruk", false, index);
                        ((ExtListView)this.view).hide("labeld4pas", true, index);
                        continue block10;
                    }
                    case "1": {
                        ((ExtListView)this.view).hide("labeltgruk", true, index);
                        ((ExtListView)this.view).hide("labeld4pas", false, index);
                        continue block10;
                    }
                    case "2": {
                        ((ExtListView)this.view).hide("labeltgruk", true, index);
                        ((ExtListView)this.view).hide("labeld4pas", true, index);
                        continue block10;
                    }
                }
                ((ExtListView)this.view).hide("labeltgruk", false, index);
                ((ExtListView)this.view).hide("labeld4pas", true, index);
            }
            listDataSet.setRows((Object)receiveTicketList);
        }
        ((ExtListView)this.view).hide("receiveticket_list", !isExistList);
        ((ExtListView)this.view).hide("order_none_panel", isExistList);
        return listDataSet;
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        DynamicObject entryRowData = ((ListFormData)this.getBillData()).getEntryRowData("receiveticket_list", event.getCurrentRow());
        switch (eventId) {
            case "receiveticket": {
                this.receiveTicket(event);
                break;
            }
            case "row_panel": {
                OpenParam receiveTicketDetailView = OlstoreUtil.createOpenParam((String)"row_panel", (String)"ocpos_receiveticket_detail");
                receiveTicketDetailView.addCustomParam("billId", String.valueOf(entryRowData.get("id")));
                ((ExtListView)this.getView()).showView(receiveTicketDetailView);
                break;
            }
            case "useticket": {
                long schemeId = (Long)entryRowData.getPkValue();
                long ticketId = OlstoreTicketHelper.getTicketInfoIdByschemeId((long)schemeId, (long)((ExtListView)this.getView()).getExtCtx().getMemberId());
                OpenParam ticketItemSearchView = new OpenParam();
                ticketItemSearchView.setTarget(OpenParam.OpenTarget.NewWindow);
                ticketItemSearchView.setViewId("ocpos_ticketitem_search");
                ticketItemSearchView.setShowTitle(Boolean.TRUE);
                ticketItemSearchView.addCustomParam("ticketId", String.valueOf(ticketId));
                ((ExtListView)this.getView()).showView(ticketItemSearchView);
                break;
            }
        }
        super.onClick(event);
    }

    private DynamicObjectCollection getReceiveTicketList(long vipID, long branchId, int pageIndex, int pageSize) {
        DynamicObjectCollection entryDynList = new DynamicObjectCollection();
        JSONObject jsonRes = OlstoreTicketHelper.queryReceiveTicketList((long)vipID, (long)branchId, (int)pageIndex, (int)pageSize);
        if (jsonRes.getBoolean("success").booleanValue()) {
            JSONArray ticketJsonArr = jsonRes.getJSONArray("data");
            for (Object obj : ticketJsonArr) {
                JSONObject jsonTicket = (JSONObject)obj;
                String startDate = jsonTicket.getString("startDate");
                String endDate = jsonTicket.getString("endDate");
                if (StringUtils.isNotEmpty((CharSequence)startDate) && StringUtils.isNotEmpty((CharSequence)endDate)) {
                    Date startdate = DateUtil.getDateFormat((String)startDate);
                    Date enddate = DateUtil.getDateFormat((String)endDate);
                    Date nowDate = TimeServiceHelper.now();
                    if (nowDate.getTime() < startdate.getTime() || nowDate.getTime() > enddate.getTime()) continue;
                }
                DynamicObject entryDyn = ((ListFormData)this.getBillData()).createNewEntryDynamicObject("receiveticket_list");
                entryDyn.set("id", (Object)jsonTicket.getLong("schemeID"));
                entryDyn.set("schemeid", (Object)jsonTicket.getLong("schemeID"));
                entryDyn.set("schemenumber", jsonTicket.get((Object)"schemeNumber"));
                entryDyn.set("tickettypeid", (Object)jsonTicket.getLong("ticketTypeID"));
                entryDyn.set("tickettypenumber", (Object)jsonTicket.getString("ticketTypeNumber"));
                entryDyn.set("ticketname", (Object)jsonTicket.getString("schemeName"));
                String ticketvalue = "";
                switch (jsonTicket.getString("usagemode")) {
                    case "0": {
                        ticketvalue = jsonTicket.getBigDecimal("ticketValue").setScale(2).stripTrailingZeros().toPlainString();
                        break;
                    }
                    case "1": {
                        ticketvalue = jsonTicket.getBigDecimal("discountrate").divide(new BigDecimal("10"), 2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                        break;
                    }
                    case "2": {
                        ticketvalue = ResManager.loadKDString((String)"\u793c\u54c1\u5238", (String)"OlstoreReceiveTicketListPlugin_0", (String)"occ-ocpos-formplugin", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        ticketvalue = jsonTicket.getBigDecimal("ticketValue").setScale(2).stripTrailingZeros().toPlainString();
                    }
                }
                entryDyn.set("ticketvalue", (Object)ticketvalue);
                entryDyn.set("viphasreceiveqty", (Object)jsonTicket.getInteger("vipHasReceiveQty"));
                entryDyn.set("vipgetmaxqty", (Object)jsonTicket.getInteger("vipGetMaxQty"));
                entryDyn.set("validitydays", (Object)jsonTicket.getInteger("validityDays"));
                entryDyn.set("totalqty", (Object)jsonTicket.getInteger("totalQty"));
                entryDyn.set("hasdistributetotalqty", (Object)jsonTicket.getInteger("hasDistributeTotalQty"));
                entryDyn.set("startdate", (Object)startDate);
                entryDyn.set("enddate", (Object)endDate);
                entryDyn.set("validperiodtype", (Object)jsonTicket.getString("validPeriodType"));
                entryDyn.set("minconsumeamount", (Object)("\u6ee1" + jsonTicket.getBigDecimal("minConsumeAmount").setScale(2).stripTrailingZeros().toPlainString() + "\u5143\u4f7f\u7528"));
                entryDyn.set("usagemode", (Object)jsonTicket.getString("usagemode"));
                entryDynList.add((Object)entryDyn);
            }
        }
        return entryDynList;
    }

    private void receiveTicket(ClickEvent event) {
        long branchId;
        long schemeID;
        int index = event.getCurrentRow().getRow();
        DynamicObject currRowDyn = ((ListFormData)this.getBillData()).getEntryRowData("receiveticket_list", event.getCurrentRow());
        long vipID = ((ExtListView)this.getView()).getExtCtx().getMemberId();
        JSONObject jsonRes = OlstoreTicketHelper.receiveTicket((long)vipID, (long)(schemeID = ((Long)currRowDyn.getPkValue()).longValue()), (long)(branchId = OlstoreUtil.getStoreId((ClientEvent)event)));
        if (jsonRes.getBoolean("success").booleanValue()) {
            boolean isExceedVipGetMaxQty = currRowDyn.getInt("viphasreceiveqty") + 1 >= currRowDyn.getInt("vipgetmaxqty");
            boolean isExceedTotalQty = currRowDyn.getInt("hasdistributetotalqty") + 1 >= currRowDyn.getInt("totalqty");
            ((ListFormData)this.billData).updateEntryValue("viphasreceiveqty", index, (Object)(currRowDyn.getInt("viphasreceiveqty") + 1));
            ((ListFormData)this.billData).updateEntryValue("hasdistributetotalqty", index, (Object)(currRowDyn.getInt("hasdistributetotalqty") + 1));
            if (isExceedVipGetMaxQty || isExceedTotalQty) {
                ((ExtListView)this.view).updateControlName("receiveticket", "\u5df2\u9886\u5b8c", index);
                ((ExtListView)this.view).disable("receiveticket", true, index);
            }
            ((ExtListView)this.view).showMessage("\u9886\u53d6\u6210\u529f\u3002");
            ((ExtListView)this.view).refresh();
        } else {
            ((ExtListView)this.view).showMessage(jsonRes.getString("message"));
        }
    }
}

