/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.GoHistoryEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import kd.occ.ocpos.common.enums.CloseStatusEnum;
import kd.occ.ocpos.common.enums.InvoiceStatusEnum;
import kd.occ.ocpos.common.enums.OrderStatusEnum;
import kd.occ.ocpos.common.util.StringUtil;

public class OrderListMobPlugin
extends ExtListViewPlugin {
    private static final String orderentrys = "orderList";
    private static final String cid_searcharea = "searcharea";
    private static final String cid_searchstatus = "searchstatus";
    private static final String cancel = "cancel";

    public ListDataSet<DynamicObjectCollection> onDataLoad(LoadDataEvent event) {
        boolean isHaveData;
        ListDataSet listDataSet = super.onDataLoad(event);
        String searcharea = null;
        if (event.getFilterParam() != null && event.getFilterParam().containsKey(cid_searcharea)) {
            searcharea = event.getFilterParam().get(cid_searcharea).toString();
        }
        String searchStatus = this.getSearchStatus(event);
        ((ExtListView)this.view).setActiveByValue(cid_searchstatus, searchStatus);
        DynamicObjectCollection orderList = this.getOrderList(event.getPage(), event.getPageSize(), searcharea, searchStatus);
        boolean bl = isHaveData = orderList.size() > 0;
        if (isHaveData) {
            listDataSet.setRows((Object)orderList);
        }
        ((ExtListView)this.view).hide("orderlist", !isHaveData);
        ((ExtListView)this.view).hide("order_none_panel", isHaveData);
        return listDataSet;
    }

    private String getSearchStatus(LoadDataEvent event) {
        String searchStatus = ((ExtListView)this.view).getViewId().equals("ocpos_postsalelist") ? "F" : "E";
        String status = event.getCustomParam().getString("status");
        if (StringUtil.isNotNull((String)status)) {
            searchStatus = status;
            event.getCustomParam().remove((Object)"status");
        }
        if (event.getFilterParam() != null && event.getFilterParam().containsKey(cid_searchstatus)) {
            List searchStatusList = (List)event.getFilterParam().get(cid_searchstatus);
            searchStatus = StringUtil.joinList((String)",", (List)searchStatusList);
        }
        return searchStatus;
    }

    private DynamicObjectCollection getOrderList(int page, int pageSize, String searcharea, String searchStatus) {
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        long memberId = ((ExtListView)this.getView()).getExtCtx().getMemberId();
        this.checkLogin(memberId);
        Map<String, Object> dataMap = this.buildOrderListParam(memberId, searchStatus, searcharea, page, pageSize);
        DynamicObject[] orderList = SaleOrderDBHelper.querySaleOrderList(dataMap);
        if (orderList == null || orderList.length == 0) {
            return new DynamicObjectCollection();
        }
        for (int i = 0; i < orderList.length; ++i) {
            boolean isClose;
            DynamicObject orderInfo = orderList[i];
            DynamicObjectCollection itemList = orderInfo.getDynamicObjectCollection("goodsentryentity");
            if (itemList == null || itemList.size() == 0) continue;
            String billno = orderInfo.getString("billno");
            BigDecimal totalQty = BigDecimal.ZERO;
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal mustretQty = BigDecimal.ZERO;
            boolean bl = isClose = CloseStatusEnum.CLOSE.getValue().equals(orderInfo.getString("closestatus")) && ((ExtListView)this.view).getViewId().equals("ocpos_orderlistm");
            if (OrderStatusEnum.CANCELED.getValue().equals(orderInfo.getString("orderstatus")) && ((ExtListView)this.view).getViewId().equals("ocpos_postsalelist")) {
                orderInfo.set("orderstatus", (Object)OrderStatusEnum.RESCINDED.getValue());
            }
            String storeName = orderInfo.getString("salebranchid.name");
            ArrayList<Long> itemIdList = new ArrayList<Long>(10);
            for (DynamicObject item : itemList) {
                totalQty = totalQty.add(item.getBigDecimal("saleqty"));
                totalAmount = totalAmount.add(item.getBigDecimal("saleqty").multiply(item.getBigDecimal("balamount")));
                mustretQty = mustretQty.add(item.getBigDecimal("mustretqty"));
                itemIdList.add(item.getLong("goodsid_id"));
            }
            boolean isPostsale = ((ExtListView)this.view).getViewId().equals("ocpos_postsalelist");
            if (isPostsale) {
                this.hiddenShowRefundButton(orderInfo, isClose, itemIdList, null);
            } else {
                Date receiveDate = ((DynamicObject)((DynamicObject)itemList.get(0)).getDynamicObjectCollection("salesorderdelivery").get(0)).getDate("receivedate");
                this.hiddenShowRefundButton(orderInfo, isClose, itemIdList, receiveDate);
            }
            this.hiddenShowInvoiceButton(orderInfo, mustretQty);
            for (DynamicObject item : itemList) {
                DynamicObjectCollection salesorderdelivery = item.getDynamicObjectCollection("salesorderdelivery");
                DynamicObject delivery = (DynamicObject)salesorderdelivery.get(0);
                DynamicObject entryData = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(orderentrys);
                entryData.set("id", (Object)orderInfo.getString("id"));
                entryData.set("itemname", (Object)item.getString("goodsid.name"));
                entryData.set("thumbnail", (Object)item.getString("goodsid.thumbnail"));
                entryData.set("qty", (Object)item.getBigDecimal("saleqty").abs().stripTrailingZeros().toPlainString());
                entryData.set("price", (Object)item.getBigDecimal("balamount").divide(item.getBigDecimal("saleqty")).abs().stripTrailingZeros().toPlainString());
                entryData.set("billno", (Object)billno);
                entryData.set("storename", (Object)storeName);
                entryData.set("orderstatusname", (Object)OrderStatusEnum.getName((String)orderInfo.getString("orderstatus")));
                entryData.set("salestatus", (Object)orderInfo.getString("salestatus"));
                entryData.set("orderstatus", (Object)orderInfo.getString("orderstatus"));
                entryData.set("itemid", (Object)item.getLong("goodsid_id"));
                entryData.set("billid", (Object)orderInfo.getString("id"));
                entryData.set("totalqty", (Object)totalQty.abs());
                entryData.set("totalamount", (Object)orderInfo.getBigDecimal("sumbalamount").abs());
                if (delivery.getDynamicObject("deliverystatus") != null && !((ExtListView)this.view).getViewId().equals("ocpos_postsalelist")) {
                    entryData.set("itemstatus", (Object)delivery.getDynamicObject("deliverystatus").getString("name"));
                }
                if (!((ExtListView)this.view).getViewId().equals("ocpos_postsalelist")) {
                    entryData.set("invoicestatus", (Object)orderInfo.getString("invoicestatus"));
                }
                if (isPostsale) {
                    String srcBillBizType = orderInfo.getString("srcbillbiztype");
                    if ("H".equals(srcBillBizType)) {
                        entryData.set("returntype", (Object)"\u6362\u8d27");
                    } else {
                        entryData.set("returntype", (Object)"\u9000\u8d27");
                    }
                }
                entryList.add((Object)entryData);
            }
        }
        return entryList;
    }

    private void hiddenShowInvoiceButton(DynamicObject orderInfo, BigDecimal mustretQty) {
        String billno = orderInfo.getString("billno");
        ((ExtListView)this.view).hideGroupFooter(billno, "checkinvoice", true);
        if (!((ExtListView)this.view).getViewId().equals("ocpos_postsalelist")) {
            String invoiceStatus = orderInfo.getString("invoicestatus");
            if (InvoiceStatusEnum.APPLY_INVOICE.getValue().equals(invoiceStatus) || InvoiceStatusEnum.FIN_INVOICE.getValue().equals(invoiceStatus)) {
                ((ExtListView)this.view).hideGroupFooter(billno, "checkinvoice", false);
            } else {
                ((ExtListView)this.view).hideGroupFooter(billno, "checkinvoice", true);
            }
        }
        if (mustretQty.compareTo(BigDecimal.ZERO) == 0) {
            ((ExtListView)this.view).hideGroupFooter(billno, "refund", true);
            ((ExtListView)this.view).hideGroupFooter(billno, "applyinvoice", true);
            ((ExtListView)this.view).hideGroupFooter(billno, "electwarranty", true);
            ((ExtListView)this.view).hideGroupFooter(billno, "checkinvoice", true);
        }
    }

    private Map<String, Object> buildOrderListParam(long memberId, String searchStatus, String searcharea, int page, int pageSize) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("member", memberId);
        dataMap.put("orderStatus", searchStatus);
        if (StringUtil.isNotNull((String)searcharea)) {
            dataMap.put("goodsName", searcharea);
        }
        dataMap.put("startTime", LocalDate.now().minusYears(1L).format(DateTimeFormatter.ISO_LOCAL_DATE));
        dataMap.put("endTime", LocalDate.now().plusDays(1L).format(DateTimeFormatter.ISO_LOCAL_DATE));
        dataMap.put("pageSize", pageSize);
        dataMap.put("pageIndex", page - 1);
        return dataMap;
    }

    private void checkLogin(long memberId) {
        if (memberId == 0L && ((ExtListView)this.view).getExtCtx().isFromMiniProgram()) {
            OpenParam openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setViewId("ocpos_mpgrant");
            ((ExtListView)this.getView()).showView(openParam);
        }
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "refund": {
                this.goPage(event, "ocpos_refundreturn_apply", null);
                break;
            }
            case "namepanel": 
            case "pay": 
            case "thumbnail": {
                if (((ExtListView)this.view).getViewId().equals("ocpos_postsalelist")) {
                    this.goPage(event, "ocpos_refundreturn_detail", "ocpos_orderlistm");
                    break;
                }
                this.goPage(event, "ocpos_orderdetail", "ocpos_orderlistm");
                break;
            }
            case "cancel": {
                this.goPage(event, "ocpos_orderdetail", cancel);
                break;
            }
            case "electwarranty": {
                this.goPage(event, "ocpos_electwarranty_list", "ocpos_orderlistm");
                break;
            }
            case "applyinvoice": {
                this.goPage(event, "ocpos_invoice_apply", "ocpos_orderlistm");
                break;
            }
            case "checkinvoice": {
                DynamicObject entryRowData = ((ListFormData)this.getBillData()).getEntryRowData(orderentrys, event.getCurrentRow());
                String invoicestatus = entryRowData.getString("invoicestatus");
                if ("C".equals(invoicestatus)) {
                    this.goPage(event, "ocpos_invoice_detail", "ocpos_orderlistm");
                    break;
                }
                this.goPage(event, "ocpos_invoice_applying", "ocpos_orderlistm");
                break;
            }
        }
        super.onClick(event);
    }

    private void goPage(ClickEvent event, String pageViewId, String sourceViewId) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.addCustomParam("sourceviewid", sourceViewId);
        DynamicObject entryRowData = ((ListFormData)this.getBillData()).getEntryRowData(orderentrys, event.getCurrentRow());
        String billId = entryRowData.getString("id");
        openParam.addCustomParam("billId", billId);
        openParam.setViewId(pageViewId);
        ((ExtListView)this.getView()).showView(openParam);
    }

    private void hiddenShowRefundButton(DynamicObject orderInfo, boolean isClose, List<Long> itemIdList, Date receiveDate) {
        boolean hidden = orderInfo.getString("orderstatus").equals(OrderStatusEnum.TO_BE_PAID.getValue());
        String billno = orderInfo.getString("billno");
        boolean isPostsale = ((ExtListView)this.view).getViewId().equals("ocpos_postsalelist");
        boolean isCancel = orderInfo.getString("orderstatus").equals(OrderStatusEnum.CANCELED.getValue());
        boolean isCompleted = orderInfo.getString("orderstatus").equals(OrderStatusEnum.COMPLETED.getValue());
        if (isPostsale || isCancel || isClose) {
            ((ExtListView)this.view).hideGroupFooter(billno, "refund", true);
            ((ExtListView)this.view).hideGroupFooter(billno, "applyinvoice", true);
            ((ExtListView)this.view).hideGroupFooter(billno, "electwarranty", true);
            ((ExtListView)this.view).hideGroupFooter(billno, cancel, true);
            ((ExtListView)this.view).hideGroupFooter(billno, "pay", true);
        } else if (hidden) {
            ((ExtListView)this.view).hideGroupFooter(billno, "refund", true);
            ((ExtListView)this.view).hideGroupFooter(billno, "applyinvoice", true);
            ((ExtListView)this.view).hideGroupFooter(billno, "electwarranty", true);
            ((ExtListView)this.view).hideGroupFooter(billno, cancel, false);
            ((ExtListView)this.view).hideGroupFooter(billno, "pay", false);
        } else {
            ((ExtListView)this.view).hideGroupFooter(billno, "refund", false);
            ((ExtListView)this.view).hideGroupFooter(billno, "applyinvoice", false);
            ((ExtListView)this.view).hideGroupFooter(billno, "electwarranty", false);
            ((ExtListView)this.view).hideGroupFooter(billno, cancel, true);
            ((ExtListView)this.view).hideGroupFooter(billno, "pay", true);
        }
        if (!((ExtListView)this.view).getViewId().equals("ocpos_postsalelist")) {
            String invoiceStatus = orderInfo.getString("invoicestatus");
            if (!InvoiceStatusEnum.NO_APPLY_INVOICE.getValue().equals(invoiceStatus)) {
                ((ExtListView)this.view).hideGroupFooter(billno, "applyinvoice", true);
            }
        }
    }

    public void onGoHistory(GoHistoryEvent event) {
        OpenParam openParam = new OpenParam();
        openParam.setViewId("ocpos_userinfom");
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        ((ExtListView)this.view).showView(openParam);
    }
}

