/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.control.controls.Option;
import kd.occ.ocepfp.core.form.control.controls.Select;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SearchEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.common.util.JsonUtil;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;

public class PosBrandSelectPlugin
extends ExtBillViewPlugin {
    private static final int MIN_CLICK_DELAY_TIME = 2000;
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ocpos-olstore-cache");
    private static final String itemListCacheKey = "initview_itemList";
    private static final String itementrys = "goodslist";
    private static final Log log = LogFactory.getLog(PosBrandSelectPlugin.class);

    public DynamicObject onDataLoad(LoadDataEvent event) {
        return super.onDataLoad(event);
    }

    public void afterBindData(LoadDataEvent event) {
        JSONArray itemList;
        String filterInfo;
        long start = System.currentTimeMillis();
        int page = event.getPage();
        int pageSize = event.getPageSize();
        String keywordFromStorage = "";
        String maxprice = "";
        String minprice = "";
        String filter_brand = "";
        String filter_label = "";
        String filter_class = "";
        DynamicObject olstoreConfig = OlstoreConfigHelper.getOlstoreConfig();
        if (olstoreConfig.getBoolean("issearch")) {
            ((ExtBillView)this.view).hide("querysearchpanel", false);
        } else {
            ((ExtBillView)this.view).hide("querysearchpanel", true);
        }
        String queryId = event.getCustomParam().getString("queryId");
        String uuid = event.getCustomParam().getString("uuid");
        JSONObject storeJson = OlstoreUtil.getCurrentStore((ClientEvent)event);
        String customerId = storeJson.getString("id");
        if (StringUtil.isNotNull((String)customerId)) {
            ((BillFormData)this.billData).updateValue("customerid", (Object)customerId);
        }
        String type = event.getCustomParam().getString("type");
        ((BillFormData)this.billData).updateValue("type", (Object)type);
        String keywordFromParam = event.getCustomParam().getString("keyword");
        String itemListStr = (String)CACHE.get(itemListCacheKey + uuid);
        String l1 = event.getCustomParam().getString("l1");
        String l2 = event.getCustomParam().getString("l2");
        String l3 = event.getCustomParam().getString("l3");
        Boolean isFilter = Boolean.FALSE;
        if (event.getLocalStorage().containsKey((Object)"filterinfo") && StringUtil.isNotNull((String)(filterInfo = event.getLocalStorage().getString("filterinfo"))) && !"{}".equals(filterInfo)) {
            isFilter = Boolean.TRUE;
            JSONObject filterJson = (JSONObject)JsonUtil.fromJson((String)filterInfo, JSONObject.class);
            maxprice = filterJson.getString("maxprice");
            minprice = filterJson.getString("minprice");
            filter_brand = filterJson.getString("filter_brand");
            filter_label = filterJson.getString("filter_label");
            filter_class = filterJson.getString("filter_class");
        }
        if (StringUtil.isNotNull((String)filter_brand)) {
            ((BillFormData)this.billData).updateValue("brandlist", (Object)filter_brand);
        } else if ("brand".equals(type) && StringUtil.isNotNull((String)l3)) {
            ((BillFormData)this.billData).updateValue("brandlist", (Object)filter_brand);
        }
        log.info("\u5546\u57ce\u8017\u65f6\u7edf\u8ba13 this.afterBindData consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        if (StringUtil.isNotNull((String)keywordFromParam)) {
            start = System.currentTimeMillis();
            String[] classArr = StringUtil.isNotNull((String)filter_class) ? this.string2StringArr(filter_class) : null;
            itemList = StringUtil.isNotNull((String)itemListStr) ? JSONArray.parseArray((String)itemListStr) : OlstoreItemHelper.getItemList((String)customerId, (String)keywordFromParam, (String[])classArr, (String)"", (String)String.valueOf(page), (String)String.valueOf(pageSize), (String)OlstoreUtil.buildItemParamAppendStr(), this.toList(filter_brand), this.toList(filter_label), (String)minprice, (String)maxprice);
            log.info("\u5546\u57ce\u8017\u65f6\u7edf\u8ba14 this.afterBindData consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            this.showItemList(itemList);
            ((BillFormData)this.billData).updateValue("maxprice", (Object)maxprice);
            ((BillFormData)this.billData).updateValue("minprice", (Object)minprice);
            ((BillFormData)this.billData).updateValue("search", (Object)keywordFromParam);
            ((BillFormData)this.billData).updateValue("keyword", (Object)keywordFromParam);
            ((BillFormData)this.billData).updateValue("brand", (Object)filter_brand);
            ((BillFormData)this.billData).updateValue("label", (Object)filter_label);
            ((BillFormData)this.billData).updateValue("class", (Object)filter_class);
        } else if (isFilter.booleanValue()) {
            start = System.currentTimeMillis();
            String classQuery = StringUtil.isNotNull((String)filter_class) ? l1 : filter_class;
            String[] classArr = StringUtil.isNotNull((String)classQuery) ? this.string2StringArr(filter_class) : null;
            itemList = StringUtil.isNotNull((String)itemListStr) ? JSONArray.parseArray((String)itemListStr) : OlstoreItemHelper.getItemList((String)customerId, (String)keywordFromStorage, (String[])classArr, (String)"", (String)String.valueOf(page), (String)String.valueOf(pageSize), (String)OlstoreUtil.buildItemParamAppendStr(), this.toList(filter_brand), this.toList(filter_label), (String)minprice, (String)maxprice);
            log.info("\u5546\u57ce\u8017\u65f6\u7edf\u8ba15 this.afterBindData consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            this.showItemList(itemList);
            ((BillFormData)this.billData).updateValue("keyword", (Object)keywordFromStorage);
            ((BillFormData)this.billData).updateValue("maxprice", (Object)maxprice);
            ((BillFormData)this.billData).updateValue("minprice", (Object)minprice);
            ((BillFormData)this.billData).updateValue("brand", (Object)filter_brand);
            ((BillFormData)this.billData).updateValue("label", (Object)filter_label);
            ((BillFormData)this.billData).updateValue("class", (Object)filter_class);
        } else {
            if (StringUtil.isNotNull((String)l3) && StringUtil.isNotNull((String)l2)) {
                if ("brand".equals(type)) {
                    ((BillFormData)this.billData).updateValue("brand", (Object)l3);
                    ((BillFormData)this.billData).updateValue("class", (Object)l1);
                } else if ("label".equals(type)) {
                    ((BillFormData)this.billData).updateValue("label", (Object)l3);
                    ((BillFormData)this.billData).updateValue("class", (Object)l1);
                } else if ("class".equals(type)) {
                    ((BillFormData)this.billData).updateValue("class", (Object)l3);
                }
            } else if (StringUtil.isNotNull((String)l2)) {
                ((BillFormData)this.billData).updateValue("class", (Object)l1);
            }
            start = System.currentTimeMillis();
            this.queryItemList(customerId, event.getPage(), event.getPageSize(), keywordFromParam, type, queryId, l1, itemListStr);
            log.info("\u5546\u57ce\u8017\u65f6\u7edf\u8ba16 this.afterBindData consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        }
        this.clearLocalStorage();
        CACHE.remove(itemListCacheKey + uuid);
        super.afterBindData(event);
    }

    public boolean initView(InitViewEvent initViewEvent) {
        JSONObject storeJson = OlstoreUtil.getCurrentStore((ClientEvent)initViewEvent);
        String customerId = storeJson != null ? storeJson.getString("id") : initViewEvent.getCustomParam().getString("customerid");
        String type = initViewEvent.getCustomParam().getString("type");
        String keyword = initViewEvent.getCustomParam().getString("keyword");
        String uuid = initViewEvent.getCustomParam().getString("uuid");
        String l1 = initViewEvent.getCustomParam().getString("l1");
        String l2 = initViewEvent.getCustomParam().getString("l2");
        String l3 = initViewEvent.getCustomParam().getString("l3");
        log.info("\u5546\u54c1\u641c\u7d22\u5217\u8868\uff0cinitView\uff1acustomerId\uff1a" + customerId + ",keyword:" + keyword + ":l1" + l1);
        Select brandlist = (Select)((ExtBillView)this.getView()).getControl("brandlist");
        if (StringUtil.isNotNull((String)keyword)) {
            JSONArray itemList = OlstoreItemHelper.getItemList((String)customerId, (String)keyword, null, (String)"", null, null, null, null, null, null, null);
            if (itemList != null && itemList.size() > 0) {
                Option option;
                CACHE.put(itemListCacheKey + uuid, (Object)JSONObject.toJSONString((Object)itemList), 60);
                List itemLists = itemList.toJavaList(JSONObject.class);
                List itemBrandList = itemLists.stream().filter(obj -> StringUtil.isNotNull((String)obj.getString("itembrands.id"))).collect(Collectors.toList());
                List itemBrandListDis = itemBrandList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<JSONObject>(Comparator.comparing(r -> r.getLong("itembrands.id")))), ArrayList::new));
                if (itemBrandListDis != null && itemBrandListDis.size() > 0) {
                    for (JSONObject brand : itemBrandListDis) {
                        option = new Option();
                        option.setId(brand.getString("itembrands.id"));
                        option.setValue((Object)brand.getString("itembrands.id"));
                        option.setName(brand.getString("itembrands.name"));
                        brandlist.addChild((Object)option);
                    }
                }
                if (itemLists != null && itemBrandList != null && itemLists.size() != itemBrandList.size() || itemBrandList == null) {
                    option = new Option();
                    option.setId("0");
                    option.setValue((Object)"0");
                    option.setName("\u5176\u4ed6");
                    brandlist.addChild((Object)option);
                }
            }
        } else if (StringUtil.isNotNull((String)l1)) {
            ArrayList<String> brandList = new ArrayList<String>(1);
            ArrayList<String> labelList = new ArrayList<String>(1);
            if ("class".equals(type)) {
                l1 = StringUtil.isNotNull((String)l2) && StringUtil.isNotNull((String)l3) ? l3 : l2;
            } else if ("brand".equals(type)) {
                if (StringUtil.isNotNull((String)l3)) {
                    brandList = new ArrayList(1);
                    brandList.add(l3);
                }
            } else if (StringUtil.isNotNull((String)l3)) {
                labelList = new ArrayList(1);
                labelList.add(l3);
            }
            JSONArray itemList = OlstoreItemHelper.getItemList((String)customerId, null, (String[])new String[]{l1}, (String)"", null, null, null, brandList, labelList, null, null);
            if (itemList != null && itemList.size() > 0) {
                Option option;
                CACHE.put(itemListCacheKey + uuid, (Object)JSONObject.toJSONString((Object)itemList), 60);
                List itemLists = itemList.toJavaList(JSONObject.class);
                List itemBrandList = itemLists.stream().filter(obj -> StringUtil.isNotNull((String)obj.getString("itembrands.id"))).collect(Collectors.toList());
                List itemBrandListDis = itemBrandList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<JSONObject>(Comparator.comparing(r -> r.getLong("itembrands.id")))), ArrayList::new));
                if (itemBrandListDis != null && itemBrandListDis.size() > 0) {
                    for (JSONObject brand : itemBrandListDis) {
                        option = new Option();
                        option.setId(brand.getString("itembrands.id"));
                        option.setValue((Object)brand.getString("itembrands.id"));
                        option.setName(brand.getString("itembrands.name"));
                        brandlist.addChild((Object)option);
                    }
                }
                if (itemLists != null && itemBrandList != null && itemLists.size() != itemBrandList.size() || itemBrandList == null) {
                    option = new Option();
                    option.setId("0");
                    option.setValue((Object)"0");
                    option.setName("\u5176\u4ed6");
                    brandlist.addChild((Object)option);
                }
            }
        }
        return true;
    }

    public void onSearch(SearchEvent event) {
        String searchStatus;
        super.onSearch(event);
        JSONObject storeJson = OlstoreUtil.getCurrentStore((ClientEvent)event);
        String customerId = storeJson != null ? storeJson.getString("id") : event.getCustomParam().getString("customerid");
        if (StringUtils.isEmpty((String)customerId)) {
            customerId = ((BillFormData)this.billData).getString("customerid");
        }
        if ("A".equals(searchStatus = (String)((ArrayList)((Map)event.getEventParam().get((Object)"filter")).get("searchstatus")).get(0))) {
            this.orderByPrice(event, customerId);
        } else if ("C".equals(searchStatus)) {
            this.showFilterPage(event, customerId);
        } else {
            this.filterByBrand(searchStatus, event, customerId);
        }
    }

    private void updateItemList(JSONArray itemList) {
        int i;
        DynamicObjectCollection goodslist = (DynamicObjectCollection)((BillFormData)this.billData).get(itementrys);
        int size = goodslist.size();
        if (size > 0) {
            for (i = size - 1; i >= 0; --i) {
                ((BillFormData)this.billData).delEntryRow(itementrys, i);
            }
        }
        if (itemList != null) {
            for (i = 0; i < itemList.size(); ++i) {
                JSONObject item = itemList.getJSONObject(i);
                DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
                dataObject.set("id", (Object)item.getString("itemid"));
                dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + item.get((Object)"thumbnail")));
                dataObject.set("itemname", item.get((Object)"itemname"));
                dataObject.set("spuid", item.get((Object)"spuid"));
                dataObject.set("auxptyid", item.get((Object)"auxptyid"));
                dataObject.set("minmemberprice", (Object)item.getBigDecimal("memberprice"));
                dataObject.set("shorttitle", (Object)item.getString("shorttitle"));
                dataObject.set("barcodeid", (Object)item.getString("barcodeid"));
                ((BillFormData)this.billData).addEntryRow(itementrys, dataObject);
            }
        }
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "itempanel": {
                DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_itemdetails");
                openParam.addCustomParam("itemid", String.valueOf(entryRowData.get("id")));
                openParam.addCustomParam("spuid", String.valueOf(entryRowData.get("spuid")));
                openParam.addCustomParam("auxptyid", String.valueOf(entryRowData.get("auxptyid")));
                openParam.addCustomParam("barcodeid", String.valueOf(entryRowData.get("barcodeid")));
                openParam.addCustomParam("sourceviewid", "ocpos_brand_select");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "search_icon": 
            case "searcharea": 
            case "searchpanel": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_search");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    private void queryItemList(String customerId, int page, int pageSize, String keyword, String type, String queryId, String l1, String itemListStr) {
        String appendStr = OlstoreUtil.buildItemParamAppendStr();
        long start = System.currentTimeMillis();
        JSONArray itemList = null;
        if (StringUtil.isNotNull((String)itemListStr)) {
            itemList = JSONArray.parseArray((String)itemListStr);
        }
        if ("class".equals(type)) {
            start = System.currentTimeMillis();
            String[] queryIds = new String[]{queryId};
            if (!StringUtil.isNotNull((String)itemListStr)) {
                itemList = OlstoreItemHelper.getItemList((String)customerId, (String)keyword, (String[])queryIds, (String)"", (String)String.valueOf(page), (String)String.valueOf(pageSize), (String)appendStr, null, null, null, null);
            }
            log.info("\u5546\u57ce\u8017\u65f6\u7edf\u8ba17 this.afterBindData consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            ((BillFormData)this.billData).updateValue("class", (Object)queryId);
            ((BillFormData)this.billData).updateValue("brand", (Object)"");
            ((BillFormData)this.billData).updateValue("label", (Object)"");
        } else if ("brand".equals(type)) {
            start = System.currentTimeMillis();
            String[] l1class = new String[]{l1};
            if (!StringUtil.isNotNull((String)itemListStr)) {
                itemList = OlstoreItemHelper.getItemList((String)customerId, (String)keyword, (String[])l1class, (String)"", (String)String.valueOf(page), (String)String.valueOf(pageSize), (String)appendStr, this.toList(queryId), null, null, null);
            }
            log.info("\u5546\u57ce\u8017\u65f6\u7edf\u8ba18 this.afterBindData consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            ((BillFormData)this.billData).updateValue("brand", (Object)queryId);
            ((BillFormData)this.billData).updateValue("label", (Object)"");
            ((BillFormData)this.billData).updateValue("class", (Object)"");
            ((BillFormData)this.billData).updateValue("keyword", (Object)"");
        } else if ("label".equals(type)) {
            start = System.currentTimeMillis();
            String[] l1class = new String[]{l1};
            if (!StringUtil.isNotNull((String)itemListStr)) {
                itemList = OlstoreItemHelper.getItemList((String)customerId, (String)keyword, (String[])l1class, (String)"", (String)String.valueOf(page), (String)String.valueOf(pageSize), (String)appendStr, null, this.toList(queryId), null, null);
            }
            log.info("\u5546\u57ce\u8017\u65f6\u7edf\u8ba19 this.afterBindData consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            ((BillFormData)this.billData).updateValue("label", (Object)queryId);
            ((BillFormData)this.billData).updateValue("brand", (Object)"");
            ((BillFormData)this.billData).updateValue("class", (Object)"");
            ((BillFormData)this.billData).updateValue("keyword", (Object)"");
        }
        start = System.currentTimeMillis();
        this.showItemList(itemList);
        log.info("\u5546\u57ce\u8017\u65f6\u7edf\u8ba110 this.afterBindData consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
    }

    private void filterByBrand(String brand, SearchEvent event, String customerId) {
        String l1 = event.getCustomParam().getString("l1");
        String keyword = ((BillFormData)this.billData).getString("keyword");
        String maxprice = ((BillFormData)this.billData).getString("maxprice");
        String minprice = ((BillFormData)this.billData).getString("minprice");
        String classId = ((BillFormData)this.billData).getString("class");
        String label = ((BillFormData)this.billData).getString("label");
        String classQuery = StringUtil.isNotNull((String)classId) ? classId : l1;
        String[] classArr = StringUtil.isNotNull((String)classQuery) ? this.string2StringArr(classId) : null;
        JSONArray itemList = OlstoreItemHelper.getItemList((String)customerId, (String)keyword, (String[])classArr, (String)"", (String)"1", (String)"200", (String)OlstoreUtil.buildItemParamAppendStr(), this.toList(brand), this.toList(label), (String)maxprice, (String)minprice);
        ((BillFormData)this.billData).updateValue("brand", (Object)brand);
        ((BillFormData)this.billData).updateValue("brandlist", (Object)brand);
        this.showItemList(itemList);
    }

    private void showFilterPage(SearchEvent event, String customerId) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.Pop);
        openParam.setPostion(OpenParam.OpenPosition.Right);
        openParam.setViewId("ocpos_select_list");
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setWidth("300");
        openParam.addCustomParam("uuid", UUID.randomUUID().toString());
        openParam.addCustomParam("keyword", event.getCustomParam().getString("keyword"));
        openParam.addCustomParam("l1", event.getCustomParam().getString("l1"));
        openParam.addCustomParam("l2", event.getCustomParam().getString("l2"));
        openParam.addCustomParam("l3", event.getCustomParam().getString("l3"));
        openParam.addCustomParam("customerid", customerId);
        openParam.addCustomParam("type", ((BillFormData)this.billData).getString("type"));
        openParam.addCustomParam("brand", ((BillFormData)this.billData).getString("brand"));
        openParam.addCustomParam("class", ((BillFormData)this.billData).getString("class"));
        openParam.addCustomParam("label", ((BillFormData)this.billData).getString("label"));
        openParam.addCustomParam("maxprice", ((BillFormData)this.billData).getString("maxprice"));
        openParam.addCustomParam("minprice", ((BillFormData)this.billData).getString("minprice"));
        ((ExtBillView)this.getView()).showView(openParam);
    }

    private void orderByPrice(SearchEvent event, String customerId) {
        if (StringUtil.isNotNull((String)customerId)) {
            ((BillFormData)this.billData).updateValue("customerid", (Object)customerId);
        } else {
            customerId = ((BillFormData)this.billData).getString("customerid");
        }
        String keyword = ((BillFormData)this.billData).getString("keyword");
        String maxprice = ((BillFormData)this.billData).getString("maxprice");
        String minprice = ((BillFormData)this.billData).getString("minprice");
        String brand = ((BillFormData)this.billData).getString("brand");
        String classId = ((BillFormData)this.billData).getString("class");
        String label = ((BillFormData)this.billData).getString("label");
        String[] classArr = this.string2StringArr(classId);
        String isReverse = ((BillFormData)this.billData).getString("isreverse");
        if ("1".equals(isReverse)) {
            ((BillFormData)this.billData).updateValue("isreverse", (Object)"0");
            JSONArray itemList = OlstoreItemHelper.getItemList((String)customerId, (String)keyword, (String[])classArr, (String)"asc", (String)"1", (String)"200", (String)OlstoreUtil.buildItemParamAppendStr(), this.toList(brand), this.toList(label), (String)minprice, (String)maxprice);
            this.showItemList(itemList);
        } else if ("0".equals(isReverse)) {
            ((BillFormData)this.billData).updateValue("isreverse", (Object)"1");
            JSONArray itemList = OlstoreItemHelper.getItemList((String)customerId, (String)keyword, (String[])classArr, (String)"desc", (String)"1", (String)"200", (String)OlstoreUtil.buildItemParamAppendStr(), this.toList(brand), this.toList(label), (String)minprice, (String)maxprice);
            this.showItemList(itemList);
        }
    }

    private List<String> toList(String field) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (StringUtil.isNotNull((String)field)) {
            String[] splits;
            for (String split : splits = field.split(",")) {
                if (!StringUtil.isNotNull((String)split)) continue;
                resultList.add(split);
            }
        }
        return resultList;
    }

    private String[] string2StringArr(String field) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (StringUtil.isNotNull((String)field)) {
            String[] splits;
            for (String split : splits = field.split(",")) {
                if (!StringUtil.isNotNull((String)split)) continue;
                resultList.add(split);
            }
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    private void clearLocalStorage() {
        JSONObject filterJson = new JSONObject();
        ((ExtBillView)this.view).putLocalStoragePrivate("filterinfo", (Object)filterJson.toJSONString(), true, 99, true);
    }

    private void showItemList(JSONArray itemList) {
        if (null == itemList) {
            return;
        }
        int size = itemList.size();
        if (size > 0) {
            ((ExtBillView)this.view).hide("itemlist_panel", false);
            ((ExtBillView)this.view).hide("service_none_panel", true);
            this.updateItemList(itemList);
        } else {
            ((ExtBillView)this.view).hide("itemlist_panel", true);
            ((ExtBillView)this.view).hide("service_none_panel", false);
        }
    }

    private JSONArray jsonArraySort(JSONArray jsonArray, String isReverse) {
        ArrayList tempList = new ArrayList();
        tempList.addAll(jsonArray);
        if ("1".equals(isReverse)) {
            Collections.sort(tempList, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    BigDecimal b;
                    BigDecimal a = ((JSONObject)o1).getBigDecimal("minmemberprice");
                    if (a.compareTo(b = ((JSONObject)o2).getBigDecimal("minmemberprice")) > 0) {
                        return 1;
                    }
                    if (a.compareTo(b) == 0) {
                        return 0;
                    }
                    return -1;
                }
            });
        } else if ("0".equals(isReverse)) {
            Collections.sort(tempList, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    BigDecimal b;
                    BigDecimal a = ((JSONObject)o1).getBigDecimal("minmemberprice");
                    if (a.compareTo(b = ((JSONObject)o2).getBigDecimal("minmemberprice")) < 0) {
                        return 1;
                    }
                    if (a.compareTo(b) == 0) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
        JSONArray tempJSONArray = new JSONArray();
        tempJSONArray.addAll(tempList);
        return tempJSONArray;
    }
}

