/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.enums.ticket.TicketUsageModeEnum;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryAddressByIdDTO;
import kd.occ.ocbase.common.pojo.vo.member.user.QueryUserByIdVO;
import kd.occ.ocbase.common.util.ButtonFastClickUtil;
import kd.occ.ocbase.common.util.CalendarUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.event.SelectDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.service.admindivision.AdminDivisionHelper;
import kd.occ.ocpos.business.olstore.OlstoreCartHelper;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.business.olstore.OlstorePromotionTransferHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.business.promotion.OlstorePromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.common.consts.OlstoreDefaultValue;
import kd.occ.ocpos.common.entity.request.CxPromotionRequestEntity;
import kd.occ.ocpos.common.entity.request.CxPromotionResultEntity;
import kd.occ.ocpos.common.entity.request.PromoteRuleResultEntity;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class PosConfirmOrderPlugin
extends ExtBillViewPlugin {
    private static final String KEY_ISONLINESTORE = "isonlinestore";
    private static final String itementrys = "goodslist";
    private static final String pgiftpanel = "pgiftpanel";
    private static final String pgiftname = "pgiftname";
    private static final String selectgift = "selectgift";
    private static Log logger = LogFactory.getLog(PosConfirmOrderPlugin.class);
    private static final String cid_carttype = "carttype";
    private static final String cid_picktypetab = "picktypetab";
    private static final String cid_malldistribution = "malldistributionpanel";
    private static final String cid_storepickup = "storepickuppanel";
    private static final int MIN_CLICK_DELAY_TIME = 2000;

    public void afterDataLoad(LoadDataEvent event) {
        long start = System.currentTimeMillis();
        this.bindStoreAndShipping(event);
        logger.info("\u8ba2\u5355\u786e\u8ba4\u8017\u65f6\u7edf\u8ba1  1\u3001\u7ed1\u5b9a\u95e8\u5e97\u548c\u81ea\u63d0\u4fe1\u606f-bindStoreAndShipping consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        start = System.currentTimeMillis();
        this.bindItem(event);
        logger.info("\u8ba2\u5355\u786e\u8ba4\u8017\u65f6\u7edf\u8ba1  2\u3001\u7ed1\u5b9a\u8981\u8d2d\u4e70\u7684\u5546\u54c1-bindItem consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        start = System.currentTimeMillis();
        this.bindPromotion(event);
        logger.info("\u8ba2\u5355\u786e\u8ba4\u8017\u65f6\u7edf\u8ba1  3\u3001\u7ed1\u5b9a\u4fc3\u9500\u65b9\u6848-bindPromotion consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
    }

    private void bindStoreAndShipping(LoadDataEvent event) {
        JSONObject deliveryAddress = null;
        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
        String customerName = currentStore.getString("name");
        String storeName = event.getCustomParam().getString("storename");
        if (StringUtils.isNotBlank((CharSequence)storeName)) {
            Date pickUpTime = event.getCustomParam().getDate("pickuptime");
            ((BillFormData)this.getBillData()).updateValue("deliverytime", (Object)pickUpTime);
        } else {
            ((BillFormData)this.getBillData()).updateValue("deliverytime", (Object)CalendarUtil.getNowTime());
        }
        long customerId = currentStore.getLong("id") == 0L ? Long.parseLong(event.getCustomParam().getString("customerId")) : currentStore.getLong("id");
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo((long)customerId);
        String address = storeInfo.getString("address");
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        JSONObject resultJson = OlstoreMemberHelper.getMemberInfoById((long)memberId);
        if (resultJson != null && resultJson.getInteger("code") == 0) {
            JSONObject jsonData = resultJson.getJSONObject("data");
            QueryUserByIdVO vo = (QueryUserByIdVO)JSONObject.toJavaObject((JSON)jsonData, QueryUserByIdVO.class);
            ((BillFormData)this.getBillData()).updateValue("deliveryman", (Object)(vo.getName() + "," + vo.getMobile()));
        }
        ((BillFormData)this.getBillData()).updateValue("customerid", (Object)customerId);
        ((BillFormData)this.getBillData()).updateValue("orgid", (Object)storeInfo.getLong("saleorg"));
        ((BillFormData)this.getBillData()).updateValue("storename", (Object)customerName);
        ((BillFormData)this.getBillData()).updateValue("deliveryaddress", (Object)(StringUtil.isNotNull((String)address) ? address : customerName));
        ((BillFormData)this.getBillData()).updateValue("isselfpickup", (Object)"0");
        ((BillFormData)this.getBillData()).updateValue("isgift", (Object)0);
        String addressId = event.getCustomParam().getString("addressid");
        if (StringUtils.isNotBlank((CharSequence)addressId)) {
            QueryAddressByIdDTO dto = new QueryAddressByIdDTO();
            dto.setUserId(Long.valueOf(memberId));
            dto.setAddressId(Long.valueOf(Long.parseLong(addressId)));
            JSONObject deliveryAddressResult = OlstoreMemberHelper.getDeliveryAddressByIdDTO((QueryAddressByIdDTO)dto);
            if (deliveryAddressResult != null && deliveryAddressResult.getInteger("code") == 0) {
                deliveryAddress = deliveryAddressResult.getJSONObject("data");
            }
        }
        String sourceviewId = event.getCustomParam().getString("sourceviewid");
        String cartType = event.getCustomParam().getString(cid_carttype);
        if (sourceviewId.equals("ocpos_cartlistm") && cartType.equals("A")) {
            ((ExtBillView)this.view).hide(cid_picktypetab, true);
        }
        if (deliveryAddress != null) {
            ((ExtBillView)this.view).hide(cid_malldistribution, false);
            ((ExtBillView)this.view).hide(cid_storepickup, true);
            ((ExtBillView)this.view).hide("deliverswitchpanel", false, true, -1);
            ((BillFormData)this.getBillData()).updateValue("isselfpickup", (Object)"0");
            ((ExtBillView)this.view).setActiveByValue(cid_picktypetab, "malldistribution");
            String districtName = AdminDivisionHelper.getDivisionName((long)deliveryAddress.getLong("districtId"));
            ((BillFormData)this.getBillData()).updateValue("address", (Object)(districtName + deliveryAddress.getString("detailedAddress")));
            ((BillFormData)this.getBillData()).updateValue("linkman", (Object)deliveryAddress.getString("contact"));
            ((BillFormData)this.getBillData()).updateValue("linkphone", (Object)deliveryAddress.getString("phone"));
            ((BillFormData)this.getBillData()).updateValue("districtid", (Object)deliveryAddress.getLong("districtId"));
            ((ExtBillView)this.view).hide("addshippingpanel", true);
            ((ExtBillView)this.view).hide("distributionpanel", false);
        } else if (sourceviewId.equals("ocpos_itemdetails") && StringUtils.isBlank((CharSequence)storeName)) {
            ((ExtBillView)this.view).setActiveByValue(cid_picktypetab, "malldistribution");
            ((ExtBillView)this.view).hide(cid_malldistribution, false);
            ((ExtBillView)this.view).hide(cid_storepickup, true);
            ((ExtBillView)this.view).hide("addshippingpanel", false);
            ((ExtBillView)this.view).hide("distributionpanel", true);
        } else {
            ((ExtBillView)this.view).hide(cid_malldistribution, true);
            ((ExtBillView)this.view).hide(cid_storepickup, false);
            ((ExtBillView)this.view).hide("deliverswitchpanel", true, true, -1);
            ((BillFormData)this.getBillData()).updateValue("isselfpickup", (Object)"1");
            ((ExtBillView)this.view).setActiveByValue(cid_picktypetab, "selfpick");
        }
    }

    protected void bindItem(LoadDataEvent event) {
        String ticketId = event.getCustomParam().getString("ticketid");
        ((BillFormData)this.getBillData()).updateValue("ticketid", (Object)ticketId);
        String sourceviewId = event.getCustomParam().getString("sourceviewid");
        ((BillFormData)this.getBillData()).updateValue("sourceviewid", (Object)sourceviewId);
        long customerId = ((BillFormData)this.getBillData()).getLong("customerid");
        HashMap<String, BigDecimal> itemMap = new HashMap<String, BigDecimal>(10);
        JSONObject jsonObject = sourceviewId != null && sourceviewId.equals("ocpos_itemdetails") ? this.bindItemFromItemDetails(event, itemMap) : this.bindItemFromCart(event, customerId, itemMap);
        BigDecimal disCountPrice = BigDecimal.ZERO;
        BigDecimal totalMemberPrice = jsonObject.getBigDecimal("totalMemberPrice");
        ((BillFormData)this.getBillData()).updateValue("totalretailprice", (Object)totalMemberPrice);
        if (StringUtils.isNotBlank((CharSequence)ticketId)) {
            DynamicObject ticketInfo = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(ticketId), (String)"ocdbd_ticketinfo");
            BigDecimal minconsumeamount = ticketInfo.getBigDecimal("tickettypeid.minconsumeamount");
            if (TicketUsageModeEnum.CASH.getName().equals(ticketInfo.getString("tickettypeid.usagemode"))) {
                ((BillFormData)this.billData).updateValue("ticketcontent", (Object)("\u6ee1" + minconsumeamount.setScale(2, 4).toPlainString() + "\u51cf" + ticketInfo.getBigDecimal("tickettypeid.ticketvalue").setScale(2, 4).toPlainString()));
            } else {
                ((BillFormData)this.billData).updateValue("ticketcontent", (Object)"\u793c\u54c1\u5238");
            }
            if (totalMemberPrice.compareTo(minconsumeamount) < 0) {
                ((ExtBillView)this.view).showMessage("\u8be5\u4f18\u60e0\u5238\u9700\u6ee1" + minconsumeamount.setScale(2, 4).toPlainString() + "\u5143\u4f7f\u7528");
            } else if (TicketUsageModeEnum.CASH.getName().equals(ticketInfo.getString("tickettypeid.usagemode"))) {
                BigDecimal ticketvalue = ticketInfo.getBigDecimal("tickettypeid.ticketvalue");
                if ((totalMemberPrice = totalMemberPrice.subtract(ticketvalue)).compareTo(BigDecimal.ZERO) < 0) {
                    disCountPrice = ((BillFormData)this.getBillData()).getBigDecimal("totalretailprice");
                    totalMemberPrice = BigDecimal.ZERO;
                } else {
                    disCountPrice = ticketvalue;
                }
            } else if (TicketUsageModeEnum.ITEM_CONVERT.getName().equals(ticketInfo.getString("tickettypeid.usagemode"))) {
                DynamicObject ticketType = ticketInfo.getDynamicObject("tickettypeid");
                BigDecimal maxItemPrice = BigDecimal.ZERO;
                if (ticketType != null) {
                    boolean isAllGoods = DynamicObjectUtil.getBoolean((DynamicObject)ticketType, (String)"isallgoods");
                    maxItemPrice = isAllGoods ? this.getMaxValue(itemMap) : this.getMaxItemPrice(ticketType, itemMap);
                }
                totalMemberPrice = totalMemberPrice.subtract(maxItemPrice);
                disCountPrice = maxItemPrice;
            }
            ((ExtBillView)this.view).hide("ticketid", true);
            ((ExtBillView)this.view).hide("ticketcontent", false);
        } else {
            ((ExtBillView)this.view).hide("ticketid", false);
            ((ExtBillView)this.view).hide("ticketcontent", true);
        }
        ((BillFormData)this.getBillData()).updateValue("totalmemberprice", (Object)totalMemberPrice);
        ((BillFormData)this.getBillData()).updateValue("discountprice", (Object)disCountPrice);
        ((ExtBillView)this.view).updateFrontF7("ticketid", "0", "", "", (Object)"\u4e0d\u4f7f\u7528\u4f18\u60e0\u5238");
    }

    private BigDecimal getMaxItemPrice(DynamicObject ticketType, Map<String, BigDecimal> itemMap) {
        DynamicObjectCollection goodsList = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)ticketType, (String)"tictgoodsentry");
        HashSet goodsIdList = OlstoreItemHelper.getItemListByTicketType((DynamicObject)ticketType);
        Map<String, BigDecimal> filterMap = itemMap.entrySet().stream().filter(r -> goodsIdList.contains(Long.parseLong((String)r.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return this.getMaxValue(filterMap);
    }

    private void bindPromotion(LoadDataEvent event) {
        long storeId = OlstoreUtil.getStoreId((ClientEvent)event);
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        DynamicObjectCollection itemList = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
        StringBuilder promotionStr = new StringBuilder();
        for (int index = 0; index < itemList.size(); ++index) {
            CxPromotionRequestEntity requestEntity = OlstorePromotionTransferHelper.buildPromotionParam((DynamicObjectCollection)itemList, (int)index, (long)storeId, (long)memberId);
            long start = System.currentTimeMillis();
            List cxPromotionResultEntities = OlstorePromotionHelper.matchPromotion((CxPromotionRequestEntity)requestEntity);
            logger.info("\u8ba2\u5355\u786e\u8ba4\u8017\u65f6\u7edf\u8ba1 \u4fc3\u9500\u65b9\u6848\u67e5\u8be2-OlstorePromotionHelper.matchPromotion consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            int i = 1;
            boolean isPromotionGift = false;
            for (CxPromotionResultEntity entity : cxPromotionResultEntities) {
                if (!entity.getItemList().contains(((DynamicObject)itemList.get(index)).getString("itemid"))) continue;
                if (PromotionEnum.onlineGiftPromotion().contains(entity.getTypeName())) {
                    if (isPromotionGift) continue;
                    ((ExtBillView)this.view).hide(pgiftpanel + i, false, index);
                    ((ExtBillView)this.view).hide(selectgift + i, false, index);
                    ((BillFormData)this.billData).updateValue(pgiftname + i, index, (Object)entity.getName());
                    isPromotionGift = true;
                    ++i;
                    continue;
                }
                ((ExtBillView)this.view).hide(pgiftpanel + i, false, index);
                ((ExtBillView)this.view).hide(selectgift + i, true, index);
                ((BillFormData)this.billData).updateValue(pgiftname + i, index, (Object)entity.getName());
                ++i;
            }
            String promotion = OlstorePromotionTransferHelper.queryPromotion((DynamicObjectCollection)itemList, (int)index, (long)storeId, (long)memberId, (boolean)false);
            promotionStr.append(promotion).append('\n');
        }
        ((BillFormData)this.billData).updateValue("promotion", (Object)promotionStr.toString());
    }

    private void createOrder(Map<String, Object> orderParam) {
        this.buildOrderBaseInfo(orderParam);
        long start = System.currentTimeMillis();
        String stockMessage = this.buildStock(orderParam);
        logger.info("\u8ba2\u5355\u786e\u8ba4\u8017\u65f6\u7edf\u8ba1  3\u3001\u6784\u5efa\u5e93\u5b58\u4fe1\u606f\u53c2\u6570-buildStock consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        if (StringUtils.isNotBlank((CharSequence)stockMessage)) {
            ((ExtBillView)this.view).showMessage(stockMessage);
            return;
        }
        start = System.currentTimeMillis();
        this.buildPromotiom(orderParam);
        logger.info("\u8ba2\u5355\u786e\u8ba4\u8017\u65f6\u7edf\u8ba1  4\u3001\u6784\u5efa\u4fc3\u9500\u53c2\u6570-buildPromotiom consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        this.buildCalulateTicketDiscount(orderParam);
        logger.info("\u7ebf\u4e0a\u95e8\u5e97\u4e0b\u5355\u53c2\u6570orderParam\uff1a" + orderParam);
        start = System.currentTimeMillis();
        Map orderResult = SaleOrderDBHelper.addSaleOrder(orderParam);
        logger.info("\u8ba2\u5355\u786e\u8ba4\u8017\u65f6\u7edf\u8ba1 \u521b\u5efa\u8ba2\u5355SaleOrderDBHelper.addSaleOrder consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        logger.info("\u7ebf\u4e0a\u95e8\u5e97\u4e0b\u5355\u7ed3\u679cresult\uff1a" + orderResult);
        if (orderResult != null && !orderResult.isEmpty() && ((Boolean)orderResult.get("success")).booleanValue()) {
            DynamicObject saleOrder = (DynamicObject)orderResult.get("billId");
            if (saleOrder != null) {
                this.showOrderDetail(saleOrder);
                this.deleteCartItem();
            } else {
                ((ExtBillView)this.view).showMessage("\u521b\u5efa\u8ba2\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + orderResult.get("error"));
            }
        } else {
            ((ExtBillView)this.view).showMessage("\u521b\u5efa\u8ba2\u5355\u5f02\u5e38\u3002");
        }
    }

    private String buildStock(Map<String, Object> orderParam) {
        boolean isSelfPickup;
        long branchId = ((BillFormData)this.getBillData()).getLong("customerid");
        long saleOrgId = ((BillFormData)this.getBillData()).getLong("orgid");
        String ticketId = ((BillFormData)this.getBillData()).getString("ticketid.id");
        long saleOrderDefInvTypeId = SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)branchId);
        DynamicObject wareHouse = OlstoreInventoryHelper.getIdsFromOcocicWareHouse((long)branchId);
        List itemList = (List)orderParam.get("itemList");
        boolean bl = isSelfPickup = !((BillFormData)this.getBillData()).getString("isselfpickup").equals("0");
        if (isSelfPickup) {
            if (wareHouse == null) {
                return "\u5f53\u524d\u95e8\u5e97\u672a\u914d\u7f6e\u6e20\u9053\u4ed3\u5e93\u5bf9\u5e94\u7684\u9ed8\u8ba4\u53d1\u8d27\u4ed3\u5e93\uff0c\u65e0\u6cd5\u67e5\u8be2\u5e93\u5b58";
            }
            long erpStockOrgid = wareHouse.getLong("erpstockorgid.id");
            long erpWarehouseId = wareHouse.getLong("erpwarehouseid.id");
            for (Map itemParam : itemList) {
                itemParam.put("invtypeid", saleOrderDefInvTypeId);
                itemParam.put("stockOrgId", erpStockOrgid);
                itemParam.put("warehouseId", erpWarehouseId);
            }
        } else {
            Long inventoryTypeByTicket;
            long districtId = OlstoreStoreInfoHelper.getNewListrictId((long)((BillFormData)this.getBillData()).getLong("districtid"));
            long invTypeId = StringUtils.isNotBlank((CharSequence)ticketId) ? ((inventoryTypeByTicket = OlstoreTicketHelper.getInventoryTypeByTicket((long)Long.parseLong(ticketId))) != null && inventoryTypeByTicket > 0L ? inventoryTypeByTicket : SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)branchId)) : SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)branchId);
            for (Map itemParam : itemList) {
                List dataList;
                Date deliveryTime = (Date)itemParam.get("deliverdeliverytime");
                BigDecimal qty = (BigDecimal)itemParam.get("qty");
                JSONObject itemInfo = this.MapToJSONObject(itemParam);
                Map deliveryParams = OlstoreInventoryHelper.getDeliveryParams((JSONObject)itemInfo, (long)saleOrgId, (long)branchId, (long)districtId, (BigDecimal)qty, (Date)deliveryTime, (long)invTypeId);
                logger.info("\u8ba2\u5355\u786e\u8ba4\u5e93\u5b58\u67e5\u8be2\u53c2\u6570 param \uff1a" + deliveryParams);
                long start = System.currentTimeMillis();
                Map deliveryResult = SaleOrderDeliveryInfoHelper.getDeliveryInfo((Map)deliveryParams, (boolean)false);
                logger.info("\u8ba2\u5355\u786e\u8ba4\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c result \uff1a" + deliveryResult);
                logger.info("\u8ba2\u5355\u786e\u8ba4\u8017\u65f6\u7edf\u8ba1 \u6784\u5efa\u5e93\u5b58\u4fe1\u606f\u53c2\u6570-SaleOrderDeliveryInfoHelper.getDeliveryInfo " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
                if (CollectionUtils.isEmpty((Map)deliveryResult)) {
                    return "\u5e93\u5b58\u67e5\u8be2\u5f02\u5e38";
                }
                boolean isSuccess = CommonUtil.formatObjectToBoolean(deliveryResult.get("isSuccess"));
                if (!isSuccess) {
                    String errorMsg = CommonUtil.formatStringToEmpty(deliveryResult.get("errorMsg"));
                    return errorMsg;
                }
                Map deliveryData = (Map)deliveryResult.get("deliveryData");
                Object returnData = deliveryData.get("data");
                if (returnData == null) continue;
                if (returnData instanceof JSONObject) {
                    JSONObject data = (JSONObject)returnData;
                    itemParam.put("isnegativesell", deliveryData.get("isnegativesell"));
                    itemParam.put("oversalepolicyid", deliveryData.get("oversalepolicyid"));
                    itemParam.put("oversalepolicyentryid", deliveryData.get("oversalepolicyentryid"));
                    itemParam.put("distributionModeId", data.get((Object)"distributionModeId"));
                    itemParam.put("invtypeid", data.getLongValue("invtypeid"));
                    itemParam.put("stockOrgId", data.getLongValue("stockorgid"));
                    itemParam.put("warehouseId", data.getLongValue("stockid"));
                    continue;
                }
                if (!(returnData instanceof List) || CollectionUtils.isEmpty((Collection)(dataList = (List)returnData))) continue;
                itemParam.put("isnegativesell", deliveryData.get("isnegativesell"));
                itemParam.put("distributionModeId", ((JSONObject)dataList.get(0)).getLongValue("distributionmodeid"));
                itemParam.put("stockOrgId", ((JSONObject)dataList.get(0)).getLongValue("stockorgid"));
                itemParam.put("warehouseId", ((JSONObject)dataList.get(0)).getLongValue("warehouseid"));
                itemParam.put("invtypeid", ((JSONObject)dataList.get(0)).getLongValue("invtypeid"));
            }
        }
        return null;
    }

    private JSONObject MapToJSONObject(Map<String, Object> itemParam) {
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("itemid", itemParam.get("goodsid"));
        jsonParam.put("materielid", itemParam.get("materielid"));
        jsonParam.put("baseunitid", itemParam.get("baseunit"));
        jsonParam.put("unitid", itemParam.get("unit"));
        jsonParam.put("auxptyid", itemParam.get("auxattrid"));
        return jsonParam;
    }

    private void buildOrderBaseInfo(Map<String, Object> orderParam) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        orderParam.put("member", memberId);
        orderParam.put("salebranchid", ((BillFormData)this.getBillData()).getLong("customerid"));
        boolean isDelivery = ((BillFormData)this.getBillData()).getString("isselfpickup").equals("0");
        if (isDelivery) {
            orderParam.put("districtid", OlstoreStoreInfoHelper.getNewListrictId((long)((BillFormData)this.getBillData()).getLong("districtid")));
        } else {
            orderParam.put("districtid", ((BillFormData)this.getBillData()).getLong("districtid"));
        }
        orderParam.put("saler", ((BillFormData)this.getBillData()).getLong("guideid"));
        orderParam.put("orgid", ((BillFormData)this.getBillData()).getLong("orgid"));
        orderParam.put("ordersource", ((BillFormData)this.getBillData()).getString("isonlinepurchase"));
    }

    private void buildItemListOrder(Map<String, Object> orderParam) {
        DynamicObjectCollection selectEntrys = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
        HashSet<Long> itemIds = new HashSet<Long>(0);
        for (DynamicObject selectEntry : selectEntrys) {
            long itemId = selectEntry.getLong("itemid");
            itemIds.add(itemId);
        }
        Long start = System.currentTimeMillis();
        String selectFields = "id,operationmodel,enableserial,material.taxrate,itemclassentity.goodsclasssid";
        QFilter filters = new QFilter("id", "in", itemIds);
        DynamicObjectCollection itemInfos = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFields, (QFilter[])filters.toArray());
        logger.info("\u7ebf\u4e0a\u95e8\u5e97\u4e0b\u5355\u8017\u65f6\u7edf\u8ba11  " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        HashMap<Long, DynamicObject> itemInfoMap = new HashMap<Long, DynamicObject>(itemInfos.size());
        for (DynamicObject itemInfo : itemInfos) {
            itemInfoMap.put(DynamicObjectUtils.getPkValue((DynamicObject)itemInfo), itemInfo);
        }
        ArrayList<HashMap<String, Object>> itemList = new ArrayList<HashMap<String, Object>>();
        long customerId = ((BillFormData)this.getBillData()).getLong("customerid");
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumbalAmount = BigDecimal.ZERO;
        if (selectEntrys != null && selectEntrys.size() > 0) {
            for (DynamicObject item : selectEntrys) {
                String string = item.getString("itemid");
                DynamicObject goodsInfo = (DynamicObject)itemInfoMap.get(Long.parseLong(string));
                Boolean isItemGift = item.getBoolean("isitemgift");
                if (isItemGift.booleanValue()) continue;
                HashMap<String, Object> itemParam = new HashMap<String, Object>(5);
                BigDecimal qty = item.getBigDecimal("qty");
                long unitId = item.getLong("unitid");
                String auxattrId = item.getString("auxptyid");
                String materielId = item.getString("materielid");
                String baseunitId = item.getString("baseunitid");
                Boolean isPresent = item.getBoolean("ispresent");
                itemParam.put("ispresent", isPresent);
                start = System.currentTimeMillis();
                JSONObject itemInfo = this.getItemInfo(string, auxattrId, customerId);
                logger.info("\u7ebf\u4e0a\u95e8\u5e97\u4e0b\u5355\u8017\u65f6\u7edf\u8ba12  " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
                if (itemInfo == null) continue;
                if (!isPresent.booleanValue()) {
                    BigDecimal memberprice = itemInfo.getBigDecimal("memberprice");
                    BigDecimal retailprice = itemInfo.getBigDecimal("memberprice");
                    itemParam.put("retailprice", retailprice);
                    itemParam.put("discountprice", memberprice);
                    sumAmount = sumAmount.add(retailprice.multiply(qty));
                    sumbalAmount = sumbalAmount.add(memberprice.multiply(qty));
                } else {
                    itemParam.put("retailprice", BigDecimal.ZERO);
                    itemParam.put("discountprice", BigDecimal.ZERO);
                }
                boolean isSelfPickup = !((BillFormData)this.getBillData()).getString("isselfpickup").equals("0");
                String barcodeId = itemInfo.getString("barcodeid");
                itemParam.put("qty", qty);
                itemParam.put("materielid", materielId);
                itemParam.put("baseunit", baseunitId);
                itemParam.put("goodsid", string);
                itemParam.put("unit", unitId);
                itemParam.put("auxattrid", auxattrId);
                itemParam.put("isselfpickup", isSelfPickup);
                itemParam.put("ispresent", isPresent);
                itemParam.put("barcode", barcodeId);
                itemParam.put("brand", itemInfo.getString("itembrands"));
                itemParam.put("operationmodel", DynamicObjectUtils.getString((DynamicObject)goodsInfo, (String)"operationmodel"));
                itemParam.put("delivergoodsclass", DynamicObjectUtils.getString((DynamicObject)goodsInfo, (String)"itemclassentity.goodsclasssid"));
                itemParam.put("goodsinfo", goodsInfo);
                if (isSelfPickup) {
                    this.buildShipping(itemParam);
                } else {
                    this.buildReceiveAddress(itemParam, item);
                }
                itemList.add(itemParam);
            }
            HashMap itemGiftMap = new HashMap(0);
            for (DynamicObject dynamicObject : selectEntrys) {
                String itemId = dynamicObject.getString("itemid");
                DynamicObject goodsInfo = (DynamicObject)itemInfoMap.get(Long.parseLong(itemId));
                Boolean isItemGift = dynamicObject.getBoolean("isitemgift");
                if (!isItemGift.booleanValue()) continue;
                String preItemId = dynamicObject.getString("preitemid");
                List list = itemGiftMap.containsKey(preItemId) ? (List)itemGiftMap.get(preItemId) : new ArrayList();
                HashMap<String, Object> giftParam = new HashMap<String, Object>();
                giftParam.put("itemid", itemId);
                giftParam.put("materielid", dynamicObject.getString("materielid"));
                giftParam.put("itemname", dynamicObject.getString("itemname"));
                giftParam.put("qty", dynamicObject.getBigDecimal("qty"));
                giftParam.put("promotionid", dynamicObject.getString("promotionid"));
                giftParam.put("promotionname", dynamicObject.getString("promotionname"));
                giftParam.put("typeid", dynamicObject.getString("typeid"));
                giftParam.put("typename", dynamicObject.getString("typename"));
                giftParam.put("priority", dynamicObject.getString("priority"));
                giftParam.put("itemgroup", dynamicObject.getString("itemgroup"));
                giftParam.put("actname", dynamicObject.getString("actname"));
                giftParam.put("barcode", dynamicObject.getString("barcode"));
                giftParam.put("unitid", dynamicObject.getString("unitid"));
                giftParam.put("inventorytype", dynamicObject.getString("inventorytype"));
                giftParam.put("promotionbillno", dynamicObject.getString("promotionbillno"));
                giftParam.put("goodsinfo", goodsInfo);
                list.add(giftParam);
                itemGiftMap.put(preItemId, list);
            }
            for (Map map : itemList) {
                List list = (List)itemGiftMap.get(map.get("goodsid"));
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                map.put("giftList", list);
            }
        }
        BigDecimal discountCount = sumAmount.subtract(sumbalAmount).compareTo(BigDecimal.ZERO) > 0 ? sumAmount.subtract(sumbalAmount) : BigDecimal.ZERO;
        orderParam.put("sumamount", sumAmount);
        orderParam.put("sumbalamount", sumbalAmount);
        orderParam.put("sumdiscount", discountCount);
        orderParam.put("itemList", itemList);
    }

    private void buildPromotiom(Map<String, Object> orderParam) {
        DynamicObjectCollection itemList = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
        long customerId = (Long)orderParam.get("salebranchid");
        long memberId = (Long)orderParam.get("member");
        HashMap promotionMap = new HashMap(0);
        for (int index = 0; index < itemList.size(); ++index) {
            CxPromotionRequestEntity cxPromotionRequestEntity = OlstorePromotionTransferHelper.buildPromotionParam((DynamicObjectCollection)itemList, (int)index, (long)customerId, (long)memberId);
            List cxPromotionResultEntities = OlstorePromotionHelper.matchPromotion((CxPromotionRequestEntity)cxPromotionRequestEntity);
            for (CxPromotionResultEntity promotionResultEntity : cxPromotionResultEntities) {
                HashMap<String, Object> promotion = new HashMap<String, Object>(0);
                promotion.put("itemidlist", promotionResultEntity.getItemList());
                promotion.put("priority", promotionResultEntity.getPriority());
                promotion.put("promotionid", promotionResultEntity.getId());
                promotion.put("promoteruleid", ((PromoteRuleResultEntity)promotionResultEntity.getPromoteRuleList().get(0)).getPromoteRuleId());
                promotionMap.put(promotionResultEntity.getId(), promotion);
            }
        }
        List promotionList = promotionMap.entrySet().stream().map(e -> (Map)e.getValue()).collect(Collectors.toList());
        orderParam.put("promoteList", promotionList);
    }

    private void buildCalulateTicketDiscount(Map<String, Object> orderParam) {
        QFilter qFilter;
        DynamicObject ticketInfo;
        String ticketnumber = ((BillFormData)this.billData).getString("ticketnumber");
        if (StringUtil.isNotNull((String)ticketnumber) && (ticketInfo = this.getTicketInfo(qFilter = new QFilter("number", "=", (Object)ticketnumber))) != null) {
            orderParam.put("ticketnumber", ticketInfo.getLong("id"));
        }
    }

    private DynamicObject getTicketInfo(QFilter filter) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdbd_ticketinfo");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_ticketinfo", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
    }

    private void deleteCartItem() {
        String[] split;
        ArrayList<String> lstCartId;
        String cartIds = ((BillFormData)this.getBillData()).getString("cartids");
        if (StringUtils.isNotBlank((CharSequence)cartIds) && (lstCartId = new ArrayList<String>(Arrays.asList(split = cartIds.split(",")))).size() > 0) {
            OlstoreCartHelper.deleteCartById(lstCartId);
        }
    }

    private JSONObject bindItemFromItemDetails(LoadDataEvent event, Map<String, BigDecimal> itemMap) {
        BigDecimal totalMemberPrice = BigDecimal.ZERO;
        String itemId = event.getCustomParam().getString("itemid");
        String spuId = event.getCustomParam().getString("spuid");
        String auxptyId = event.getCustomParam().getString("auxptyid");
        BigDecimal qty = event.getCustomParam().getBigDecimal("qty");
        String guideid = event.getCustomParam().getString("guideid");
        ((BillFormData)this.getBillData()).updateValue("guideid", (Object)guideid);
        ((BillFormData)this.getBillData()).updateValue("isonlinepurchase", (Object)"E");
        String appendStr = OlstoreUtil.buildItemParamAppendStr();
        JSONObject itemDetailResult = OlstoreItemHelper.getItemDetail((String)((BillFormData)this.getBillData()).getString("customerid"), (String)spuId, (String)itemId, (String)appendStr);
        if ("0000".equals(itemDetailResult.get((Object)"code").toString()) && itemDetailResult.getJSONArray("data").size() > 0) {
            JSONArray dataList = itemDetailResult.getJSONArray("data");
            List products = JSONObject.parseArray((String)dataList.toJSONString(), JSONObject.class);
            JSONObject product = products.size() > 1 ? (JSONObject)products.stream().filter(p -> p.getString("itemid").equals(itemId) && p.getString("auxptyid").equals(auxptyId)).findFirst().orElse(null) : (JSONObject)products.get(0);
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            if (product != null) {
                Long unitId = product.getLong("unitid");
                BigDecimal memberprice = product.getBigDecimal("memberprice");
                BigDecimal retailprice = product.getBigDecimal("memberprice");
                dataObject.set("itemid", (Object)itemId);
                dataObject.set("goodsid", (Object)itemId);
                dataObject.set("brand", (Object)product.getLong("itembrands"));
                dataObject.set("goodsclass", (Object)PosItemUtil.queryItemClass((Object)itemId));
                dataObject.set("spuid", (Object)spuId);
                dataObject.set("itemname", (Object)product.getString("itemname"));
                dataObject.set("qty", (Object)qty);
                dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + product.getString("thumbnail")));
                dataObject.set("unitid", (Object)unitId);
                dataObject.set("baseunitid", (Object)product.getString("baseunitid"));
                dataObject.set("auxptyid", (Object)product.getLong("auxptyid"));
                dataObject.set("barcode", (Object)product.getLong("barcodeid"));
                dataObject.set("materielid", (Object)product.getLong("materielid"));
                dataObject.set("memberprice", (Object)memberprice);
                dataObject.set("retailprice", (Object)retailprice);
                itemMap.put(itemId, memberprice);
                totalMemberPrice = memberprice.multiply(qty);
                String storeName = event.getCustomParam().getString("storename");
                if (StringUtils.isBlank((CharSequence)storeName)) {
                    Date deliverytime = event.getCustomParam().getDate("deliverytime");
                    dataObject.set("deliverdeliverytime", (Object)deliverytime);
                } else {
                    dataObject.set("deliverdeliverytime", (Object)CalendarUtil.getNextDayTime());
                }
                dataObject.set("deliverinstalltime", (Object)CalendarUtil.getNextDayTime());
                ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
            }
        }
        JSONObject result = new JSONObject();
        result.put("totalMemberPrice", (Object)totalMemberPrice);
        return result;
    }

    private JSONObject bindItemFromCart(LoadDataEvent event, long customerId, Map<String, BigDecimal> itemMap) {
        BigDecimal totalMemberPrice = BigDecimal.ZERO;
        String cartIds = event.getCustomParam().getString("cartIds");
        ((BillFormData)this.getBillData()).updateValue("cartids", (Object)cartIds);
        String[] split = cartIds.split(",");
        ArrayList<String> cartIdList = new ArrayList<String>(Arrays.asList(split));
        DynamicObjectCollection olstoreCartList = OlstoreCartHelper.getOlstoreCartList(cartIdList);
        for (DynamicObject item : olstoreCartList) {
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            String itemId = item.getString("itemid");
            String auxptyId = item.getString("auxptyid.id");
            long unitId = item.getLong("unitid.id");
            long barcodeId = item.getLong("barcodeid.id");
            BigDecimal qty = item.getBigDecimal("qty");
            JSONObject itemInfo = this.getItemInfo(itemId, auxptyId, customerId);
            ((BillFormData)this.getBillData()).updateValue("isonlinepurchase", (Object)(item.getBoolean("isonlinepurchase") ? "D" : "E"));
            if (itemInfo == null) continue;
            BigDecimal memberprice = itemInfo.getBigDecimal("memberprice");
            BigDecimal retailprice = itemInfo.getBigDecimal("memberprice");
            dataObject.set("itemname", (Object)item.getString("itemid.name"));
            dataObject.set("itemid", (Object)itemId);
            dataObject.set("goodsid", (Object)itemId);
            dataObject.set("brand", (Object)itemInfo.getLong("itembrands"));
            dataObject.set("goodsclass", (Object)PosItemUtil.queryItemClass((Object)itemId));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + item.getString("itemid.thumbnail")));
            dataObject.set("qty", (Object)item.getBigDecimal("qty"));
            dataObject.set("unitid", (Object)unitId);
            dataObject.set("baseunitid", (Object)itemInfo.getString("baseunitid"));
            dataObject.set("barcode", (Object)barcodeId);
            dataObject.set("auxptyid", (Object)item.getLong("auxptyid.id"));
            dataObject.set("materielid", (Object)itemInfo.getLong("materielid"));
            dataObject.set("memberprice", (Object)memberprice);
            dataObject.set("retailprice", (Object)retailprice);
            dataObject.set("deliverdeliverytime", (Object)CalendarUtil.getNextDayTime());
            dataObject.set("deliverinstalltime", (Object)CalendarUtil.getNextDayTime());
            itemMap.put(itemId, memberprice);
            totalMemberPrice = totalMemberPrice.add(memberprice.multiply(qty));
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
        }
        JSONObject result = new JSONObject();
        result.put("totalMemberPrice", (Object)totalMemberPrice);
        return result;
    }

    private JSONObject getItemInfo(String itemId, String auxptyId, long customerId) {
        String appendStr = OlstoreUtil.buildItemParamAppendStr();
        JSONObject returnData = OlstoreItemHelper.getItemDetail((String)String.valueOf(customerId), (String)"0", (String)itemId, (String)appendStr);
        if ("0000".equals(returnData.get((Object)"code").toString()) && returnData.getJSONArray("data").size() > 0) {
            JSONArray products = returnData.getJSONArray("data");
            if (products.size() == 1) {
                return products.getJSONObject(0);
            }
            if (products.size() > 1) {
                List list = JSONObject.parseArray((String)products.toJSONString(), JSONObject.class);
                return list.stream().filter(p -> p.getString("itemid").equals(itemId) && p.getString("auxptyid").equals(auxptyId)).findFirst().orElse(null);
            }
        }
        return null;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "thumbnail": {
                this.goItemDetailPage(event);
                break;
            }
            case "picktypetab": {
                String pickTypeTab = event.getBillData().getString(cid_picktypetab);
                if ("malldistribution".equals(pickTypeTab)) {
                    this.setTimeCurrentTime();
                    ((ExtBillView)this.view).hide(cid_malldistribution, false);
                    ((ExtBillView)this.view).hide(cid_storepickup, true);
                    ((ExtBillView)this.view).hide("deliverswitchpanel", false, true, -1);
                    ((BillFormData)this.getBillData()).updateValue("isselfpickup", (Object)"0");
                    ((ExtBillView)this.view).setActiveByValue(cid_picktypetab, "malldistribution");
                    break;
                }
                this.setTimeCurrentTime();
                ((ExtBillView)this.view).hide(cid_malldistribution, true);
                ((ExtBillView)this.view).hide(cid_storepickup, false);
                ((ExtBillView)this.view).hide("deliverswitchpanel", true, true, -1);
                ((BillFormData)this.getBillData()).updateValue("isselfpickup", (Object)"1");
                ((ExtBillView)this.view).setActiveByValue(cid_picktypetab, "selfpick");
                break;
            }
            case "createorderbtn": {
                if (ButtonFastClickUtil.isFastClickByTime((long)2000L)) break;
                int isgift = ((BillFormData)this.getBillData()).getInt("isgift");
                String ticketId = ((BillFormData)this.billData).getString("ticketid.id");
                if (isgift == 0 && this.openGiftItem(event)) {
                    OpenParam openParam = new OpenParam();
                    openParam.setTarget(OpenParam.OpenTarget.Pop);
                    openParam.setShowTitle(Boolean.TRUE);
                    openParam.addCustomParam("ticketid", ticketId);
                    openParam.setViewId("ocpos_giftlist");
                    ((ExtBillView)this.getView()).showView(openParam);
                    return;
                }
                if (!this.compareTimeDiff()) break;
                HashMap<String, Object> orderParam = new HashMap<String, Object>();
                this.buildItemListOrder(orderParam);
                if (StringUtils.isNotBlank((CharSequence)ticketId)) {
                    Date dtNow = TimeServiceHelper.now();
                    DynamicObject ticketInfo = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(ticketId), (String)"ocdbd_ticketinfo");
                    Long tickettypeid = ticketInfo.getLong("tickettypeid.id");
                    DynamicObject ticketType = BusinessDataServiceHelper.loadSingle((Object)tickettypeid, (String)"ocdbd_ticketstype");
                    BigDecimal sumbalamount = (BigDecimal)orderParam.get("sumbalamount");
                    if (!ticketType.getBoolean(KEY_ISONLINESTORE)) {
                        ((ExtBillView)this.view).showMessage("\u8be5\u4f18\u60e0\u5238\u65e0\u6cd5\u5728\u7ebf\u4e0a\u4f7f\u7528");
                        return;
                    }
                    if (dtNow.compareTo(ticketInfo.getDate("starttime")) < 0 || dtNow.compareTo(ticketInfo.getDate("endtime")) > 0) {
                        ((ExtBillView)this.view).showMessage("\u8be5\u4f18\u60e0\u5238\u672a\u5728\u6709\u6548\u671f");
                        return;
                    }
                    if (sumbalamount.compareTo(ticketType.getBigDecimal("minconsumeamount")) < 0) {
                        ((ExtBillView)this.view).showMessage("\u8be5\u4f18\u60e0\u5238\u9700\u6ee1" + ticketType.getBigDecimal("minconsumeamount").setScale(2, 4).toPlainString() + "\u5143\u4f7f\u7528");
                        return;
                    }
                    if (!this.isTicketItem(ticketType).booleanValue() && !ticketType.getBoolean("isallgoods")) {
                        ((ExtBillView)this.view).showMessage("\u5f53\u524d\u5546\u54c1\u65e0\u6cd5\u4f7f\u7528\u8be5\u4f18\u60e0\u5238");
                        return;
                    }
                }
                this.createOrder(orderParam);
                break;
            }
            case "address": 
            case "addressid": 
            case "distributionpanel": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.Pop);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("addressid", ((BillFormData)this.billData).getString("addressid"));
                openParam.setViewId("ocpos_memberaddressm");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "selectgift1": 
            case "selectgift2": 
            case "selectgift3": 
            case "selectgift4": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.Pop);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("itemindex", (Object)event.getCurrentRow().getRow());
                openParam.addCustomParam("pgiftindex", eventId.split(selectgift)[1]);
                openParam.setViewId("ocpos_giftlist_promotion");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    private Boolean isTicketItem(DynamicObject ticketType) {
        DynamicObjectCollection selectEntrys = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
        HashSet itemListByTicketType = OlstoreItemHelper.getItemListByTicketType((DynamicObject)ticketType);
        for (DynamicObject select : selectEntrys) {
            if (!itemListByTicketType.contains(select.getLong("itemid"))) continue;
            return true;
        }
        return false;
    }

    private boolean openGiftItem(ClickEvent event) {
        Long ticketId = ((BillFormData)this.billData).getLong("ticketid.id");
        String ticketnumber = ((BillFormData)this.billData).getString("ticketid.number");
        if (ticketId == null || ticketId == 0L) {
            return false;
        }
        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
        Long customerId = currentStore.getLong("id");
        logger.info("\u5f39\u51fa\u8d60\u54c1\u5217\u8868  queryGiftListForTicket\u53c2\u6570\uff0cticketnumber:" + ticketnumber + ",ticketId:" + ticketId + ", customerId:" + customerId);
        DynamicObject ticketInfo = BusinessDataServiceHelper.loadSingle((Object)ticketId, (String)"ocdbd_ticketinfo");
        if (ticketInfo != null && TicketUsageModeEnum.CASH.getName().equals(ticketInfo.getString("tickettypeid.usagemode"))) {
            long olinvitateid = ticketInfo.getLong("olinvitateid.id");
            String tickettypeid = ticketInfo.getString("tickettypeid.id");
            return this.isGiftItemList(olinvitateid, tickettypeid, customerId);
        }
        return false;
    }

    private boolean isGiftItemList(Long olinvitateid, String tickettypeid, Long customerId) {
        QFilter filter = new QFilter("id", "=", (Object)olinvitateid);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdbd_olinvitate");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"ocdbd_olinvitate", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
        logger.info("\u5f39\u51fa\u8d60\u54c1\u5217\u8868  \u67e5\u8be2\u8ba4\u7b79\u9080\u7ea6\uff0colinvitateid:" + olinvitateid);
        if (dynamicObject == null) {
            return false;
        }
        logger.info("\u5f39\u51fa\u8d60\u54c1\u5217\u8868  \u6ca1\u6709\u8be5\u8ba4\u7b79\u9080\u7ea6\uff0colinvitateid:" + olinvitateid);
        DynamicObjectCollection tickettypetab = dynamicObject.getDynamicObjectCollection("tickettypeentry");
        for (DynamicObject tickettype : tickettypetab) {
            if (!tickettype.getString("tickettypeid.id").equals(tickettypeid)) continue;
            DynamicObjectCollection giftEntry = tickettype.getDynamicObjectCollection("selectgiftentryentity");
            for (DynamicObject gift : giftEntry) {
                DynamicObject item = gift.getDynamicObject("itemid");
                String itemId = item.getString("id");
                JSONObject giftItemInfo = this.getGiftItemInfo(itemId, customerId);
                if (giftItemInfo == null) continue;
                return true;
            }
        }
        logger.info("\u5f39\u51fa\u8d60\u54c1\u5217\u8868  \u6ca1\u6709\u53d1\u5e03\u7ecf\u8425\u76ee\u5f55\u5546\u54c1 olinvitateid:" + olinvitateid);
        return false;
    }

    private JSONObject getGiftItemInfo(String itemId, long customerId) {
        String appendStr = OlstoreUtil.buildItemParamAppendStr();
        JSONObject returnData = OlstoreItemHelper.getItemDetail((String)String.valueOf(customerId), (String)"0", (String)itemId, (String)appendStr);
        if ("0000".equals(returnData.get((Object)"code").toString()) && returnData.getJSONArray("data").size() > 0) {
            JSONArray products = returnData.getJSONArray("data");
            if (products.size() == 1) {
                return products.getJSONObject(0);
            }
            if (products.size() > 1) {
                List list = JSONObject.parseArray((String)products.toJSONString(), JSONObject.class);
                return list.stream().filter(p -> p.getString("itemid").equals(itemId)).findFirst().orElse(null);
            }
        }
        return null;
    }

    private void setTimeCurrentTime() {
        DynamicObjectCollection itemsInfo = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
        if (itemsInfo != null && itemsInfo.size() > 0) {
            for (int i = 0; i < itemsInfo.size(); ++i) {
                DynamicObject itemInfo = (DynamicObject)itemsInfo.get(i);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(TimeServiceHelper.now());
                calendar.add(5, 1);
                itemInfo.set("deliverdeliverytime", (Object)calendar.getTime().getTime());
                itemInfo.set("deliverinstalltime", (Object)calendar.getTime().getTime());
            }
        }
    }

    private boolean compareTimeDiff() {
        DynamicObjectCollection itemsInfo;
        boolean status = true;
        String isselfpickup = ((BillFormData)this.getBillData()).getString("isselfpickup");
        Date deliverytime = ((BillFormData)this.getBillData()).getDate("deliverytime");
        String address = ((BillFormData)this.getBillData()).getString("address");
        if (isselfpickup != null && !isselfpickup.equals("0")) {
            if (deliverytime == null) {
                ((ExtBillView)this.view).showMessage("\u8bf7\u9009\u62e9\u81ea\u63d0\u65f6\u95f4");
                return false;
            }
        } else if (!StringUtil.isNotNull((String)address)) {
            ((ExtBillView)this.view).showMessage("\u8bf7\u586b\u914d\u9001\u4fe1\u606f\u3002");
            return false;
        }
        if ((itemsInfo = ((BillFormData)this.getBillData()).getEntryRowData(itementrys)) != null && itemsInfo.size() > 0) {
            for (int i = 0; i < itemsInfo.size(); ++i) {
                DynamicObject itemInfo = (DynamicObject)itemsInfo.get(i);
                Date deliverDeliveryTime = itemInfo.getDate("deliverdeliverytime");
                Date deliverInstallTime = itemInfo.getDate("deliverinstalltime");
                if (deliverDeliveryTime == null || deliverInstallTime == null || deliverDeliveryTime.getTime() <= deliverInstallTime.getTime()) continue;
                ((ExtBillView)this.view).showMessage("\u7b2c" + (i + 1) + " \u884c\u5546\u54c1\uff0c\u5b89\u88c5\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u914d\u9001\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
                status = false;
                break;
            }
        }
        return status;
    }

    private void goItemDetailPage(ClickEvent event) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
        openParam.addCustomParam("itemid", String.valueOf(entryRowData.get("itemid")));
        openParam.addCustomParam("spuid", String.valueOf(entryRowData.get("spuid")));
        openParam.setViewId("ocpos_itemdetails");
        ((ExtBillView)this.getView()).showView(openParam);
    }

    protected void showOrderDetail(DynamicObject saleOrder) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.addCustomParam("billId", saleOrder.getString("id"));
        openParam.addCustomParam("ticketNumber", ((BillFormData)this.billData).getString("ticketnumber"));
        openParam.addCustomParam("isreservedoccupy", ((BillFormData)this.billData).getString("isreservedoccupy"));
        openParam.addCustomParam("sourceviewid", "ocpos_confirmorder");
        openParam.setEnabelHistory(false);
        openParam.setViewId("ocpos_orderdetail");
        ((ExtBillView)this.getView()).showView(openParam);
    }

    protected void onRowSelected(SelectAllEvent event) {
        DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId("ocpos_itemdetails");
        openParam.addCustomParam("itemid", String.valueOf(entryRowData.get("itemid")));
        openParam.addCustomParam("spuid", "0");
        ((ExtBillView)this.getView()).showView(openParam);
    }

    private void buildShipping(Map<String, Object> itemParam) {
        String deliveryman = ((BillFormData)this.getBillData()).getString("deliveryman");
        String deliveryaddress = ((BillFormData)this.getBillData()).getString("deliveryaddress");
        Date deliverytime = ((BillFormData)this.getBillData()).getDate("deliverytime");
        String[] split = deliveryman.split(",");
        itemParam.put("consignee", split[0]);
        itemParam.put("deliverphonenumber", split[1]);
        itemParam.put("fulladdress", deliveryaddress);
        itemParam.put("selfpickuptime", deliverytime);
    }

    private void buildReceiveAddress(Map<String, Object> itemParam, DynamicObject item) {
        String address = ((BillFormData)this.getBillData()).getString("address");
        String linkman = ((BillFormData)this.getBillData()).getString("linkman");
        String linkphone = ((BillFormData)this.getBillData()).getString("linkphone");
        itemParam.put("fulladdress", address);
        itemParam.put("consignee", linkman);
        itemParam.put("deliverphonenumber", linkphone);
        itemParam.put("deliverdeliverytime", item.getDate("deliverdeliverytime"));
        itemParam.put("deliverinstalltime", item.getDate("deliverinstalltime"));
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "ticketid": {
                this.updatePriceByTicket(event);
                break;
            }
            case "deliverswitch": {
                ((ExtBillView)this.view).hide("deliver_panel", (Boolean)event.getValue() == false, event.getRow());
                break;
            }
        }
        super.onDataChange(event);
    }

    private void updatePriceByTicket(DataChangeEvent event) {
        HashMap<String, BigDecimal> itemMap;
        BigDecimal disCountPrice;
        BigDecimal totalMemberPrice;
        block11: {
            String customerId;
            block10: {
                JSONObject product;
                totalMemberPrice = BigDecimal.ZERO;
                disCountPrice = BigDecimal.ZERO;
                String sourceviewId = ((BillFormData)this.getBillData()).getString("sourceviewid");
                customerId = ((BillFormData)this.getBillData()).getString("customerid");
                if (((BillFormData)this.getBillData()).getInt("isgift") == 1) {
                    ((BillFormData)this.billData).updateValue("isgift", (Object)0);
                    this.deleteGiftItem();
                }
                itemMap = new HashMap<String, BigDecimal>(10);
                if (sourceviewId == null || !sourceviewId.equals("ocpos_itemdetails")) break block10;
                DynamicObject itemInfo = (DynamicObject)((BillFormData)this.getBillData()).getEntryRowData(itementrys).get(0);
                String itemId = itemInfo.getString("itemid");
                String auxptyId = itemInfo.getString("auxptyid");
                BigDecimal qty = itemInfo.getBigDecimal("qty");
                String appendStr = OlstoreUtil.buildItemParamAppendStr();
                JSONObject result = OlstoreItemHelper.getItemDetail((String)customerId, (String)"0", (String)itemId, (String)appendStr);
                if (!"0000".equals(result.get((Object)"code").toString()) || result.getJSONArray("data").size() <= 0) break block11;
                JSONArray dataList = result.getJSONArray("data");
                List products = JSONObject.parseArray((String)dataList.toJSONString(), JSONObject.class);
                JSONObject jSONObject = product = products.size() > 1 ? (JSONObject)products.stream().filter(p -> p.getString("itemid").equals(itemId) && p.getString("auxptyid").equals(auxptyId)).findFirst().orElse(null) : (JSONObject)products.get(0);
                if (product == null) break block11;
                BigDecimal memberprice = product.getBigDecimal("memberprice");
                itemMap.put(itemId, memberprice);
                totalMemberPrice = totalMemberPrice.add(memberprice.multiply(qty));
                break block11;
            }
            String cartIds = event.getCustomParam().getString("cartIds");
            String[] split = cartIds.split(",");
            ArrayList<String> cartIdList = new ArrayList<String>(Arrays.asList(split));
            DynamicObjectCollection olstoreCartList = OlstoreCartHelper.getOlstoreCartList(cartIdList);
            for (DynamicObject item : olstoreCartList) {
                String itemId = item.getString("itemid");
                String auxptyId = item.getString("auxptyid.id");
                BigDecimal qty = item.getBigDecimal("qty");
                JSONObject itemInfo = this.getItemInfo(itemId, auxptyId, Long.parseLong(customerId));
                if (itemInfo == null) continue;
                BigDecimal memberprice = itemInfo.getBigDecimal("memberprice");
                itemMap.put(itemId, memberprice);
                totalMemberPrice = totalMemberPrice.add(memberprice.multiply(qty));
            }
        }
        DynamicObject dynamicObject = (DynamicObject)event.getValue();
        if (dynamicObject != null) {
            DynamicObject ticketInfo = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"ocdbd_ticketinfo");
            if (TicketUsageModeEnum.CASH.getName().equals(ticketInfo.getString("tickettypeid.usagemode"))) {
                ((BillFormData)this.getBillData()).updateValue("totalmemberprice", (Object)totalMemberPrice);
                ((BillFormData)this.getBillData()).updateValue("totalretailprice", (Object)totalMemberPrice);
                BigDecimal ticketvalue = ticketInfo.getBigDecimal("ticketvalue");
                dynamicObject.set("ticketvalue", (Object)ticketInfo.getBigDecimal("ticketvalue").setScale(2, 4).toPlainString());
                totalMemberPrice = totalMemberPrice.subtract(ticketvalue);
                if (totalMemberPrice.compareTo(BigDecimal.ZERO) < 0) {
                    disCountPrice = ((BillFormData)this.getBillData()).getBigDecimal("totalretailprice");
                    totalMemberPrice = BigDecimal.ZERO;
                } else {
                    disCountPrice = ticketvalue;
                }
            } else if (TicketUsageModeEnum.ITEM_CONVERT.getName().equals(ticketInfo.getString("tickettypeid.usagemode"))) {
                DynamicObject ticketType = ticketInfo.getDynamicObject("tickettypeid");
                BigDecimal maxItemPrice = BigDecimal.ZERO;
                if (ticketType != null) {
                    boolean isAllGoods = DynamicObjectUtil.getBoolean((DynamicObject)ticketType, (String)"isallgoods");
                    maxItemPrice = isAllGoods ? this.getMaxValue(itemMap) : this.getMaxItemPrice(ticketType, itemMap);
                }
                ((ExtBillView)this.view).updateFrontF7("ticketid", dynamicObject.getString("id"), dynamicObject.getString("number"), "", (Object)"\u793c\u54c1\u5238");
                totalMemberPrice = totalMemberPrice.subtract(maxItemPrice);
                disCountPrice = maxItemPrice;
            }
            ((BillFormData)this.getBillData()).updateValue("discountprice", (Object)disCountPrice);
            ((BillFormData)this.getBillData()).updateValue("totalmemberprice", (Object)OlstoreUtil.getBigDecimal((BigDecimal)totalMemberPrice));
        } else {
            ((ExtBillView)this.view).updateFrontF7("ticketid", "0", "", "", (Object)"\u4e0d\u4f7f\u7528\u4f18\u60e0\u5238");
            ((BillFormData)this.getBillData()).updateValue("discountprice", (Object)OlstoreDefaultValue.DFV_BigDecimal_Zero);
            ((BillFormData)this.getBillData()).updateValue("totalmemberprice", (Object)OlstoreUtil.getBigDecimal((BigDecimal)totalMemberPrice));
        }
    }

    private BigDecimal getMaxValue(Map<String, BigDecimal> map) {
        if (map == null || map.size() == 0) {
            return BigDecimal.ZERO;
        }
        int length = map.size();
        Collection<BigDecimal> c = map.values();
        Object[] obj = c.toArray();
        Arrays.sort(obj);
        return (BigDecimal)obj[length - 1];
    }

    private void deleteGiftItem() {
        DynamicObjectCollection entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
        int giftIndex = Integer.MAX_VALUE;
        int size = entryRowData.size();
        for (int row = 0; row < size; ++row) {
            DynamicObject item = (DynamicObject)entryRowData.get(row);
            if (!item.getBoolean("ispresent")) continue;
            giftIndex = row;
            break;
        }
        while (giftIndex <= size - 1) {
            ((BillFormData)this.billData).delEntryRow(itementrys, giftIndex);
            size = ((BillFormData)this.getBillData()).getEntryRowData(itementrys).size();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void beforeQueryF7(SelectDataEvent event) {
        var3_3 = eventId = event.getId();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case 1937368359: {
                if (!var3_3.equals("ticketid")) break;
                var4_4 = 0;
            }
        }
        switch (var4_4) {
            case 0: {
                memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
                currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
                customerId = currentStore.getLong("id");
                totalMemberPrice = BigDecimal.ZERO;
                sourceviewId = ((BillFormData)this.getBillData()).getString("sourceviewid");
                if (((BillFormData)this.getBillData()).getInt("isgift") == 1) {
                    ((BillFormData)this.billData).updateValue("isgift", (Object)0);
                    this.deleteGiftItem();
                }
                if (sourceviewId == null || !sourceviewId.equals("ocpos_itemdetails")) ** GOTO lbl32
                itemInfo = (DynamicObject)((BillFormData)this.getBillData()).getEntryRowData("goodslist").get(0);
                itemId = itemInfo.getString("itemid");
                auxptyId = itemInfo.getString("auxptyid");
                qty = itemInfo.getBigDecimal("qty");
                appendStr = OlstoreUtil.buildItemParamAppendStr();
                result = OlstoreItemHelper.getItemDetail((String)String.valueOf(customerId), (String)"0", (String)itemId, (String)appendStr);
                if (!"0000".equals(result.get((Object)"code").toString()) || result.getJSONArray("data").size() <= 0) ** GOTO lbl45
                dataList = result.getJSONArray("data");
                products = JSONObject.parseArray((String)dataList.toJSONString(), JSONObject.class);
                v0 = product = products.size() > 1 ? (JSONObject)products.stream().filter((Predicate<JSONObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$beforeQueryF7$6(java.lang.String java.lang.String com.alibaba.fastjson.JSONObject ), (Lcom/alibaba/fastjson/JSONObject;)Z)((String)itemId, (String)auxptyId)).findFirst().orElse(null) : (JSONObject)products.get(0);
                if (product == null) ** GOTO lbl45
                memberprice = product.getBigDecimal("memberprice");
                totalMemberPrice = totalMemberPrice.add(memberprice.multiply(qty));
                ** GOTO lbl45
lbl32:
                // 1 sources

                cartIds = event.getCustomParam().getString("cartIds");
                split = cartIds.split(",");
                cartIdList = new ArrayList<String>(Arrays.asList(split));
                olstoreCartList = OlstoreCartHelper.getOlstoreCartList(cartIdList);
                for (DynamicObject item : olstoreCartList) {
                    itemId = item.getString("itemid");
                    auxptyId = item.getString("auxptyid.id");
                    qty = item.getBigDecimal("qty");
                    itemInfo = this.getItemInfo(itemId, auxptyId, customerId);
                    if (itemInfo == null) continue;
                    memberprice = itemInfo.getBigDecimal("memberprice");
                    totalMemberPrice = totalMemberPrice.add(memberprice.multiply(qty));
                }
lbl45:
                // 4 sources

                selectEntrys = ((BillFormData)this.getBillData()).getEntryRowData("goodslist");
                qFilter = new QFilter("ticketstatus", "=", (Object)"P");
                qFilter.and("status", "=", (Object)"C");
                qFilter.and("enable", "=", (Object)"1");
                qFilter.and("cancelstatus", "=", (Object)"A");
                dtNow = TimeServiceHelper.now();
                qFilter.and("starttime", "<", (Object)dtNow);
                qFilter.and("endtime", ">", (Object)dtNow);
                qFilter.and("tickettypeid.isonlinestore", "=", (Object)Boolean.TRUE);
                qFilter.and("tickettypeid.minconsumeamount", "<=", (Object)totalMemberPrice);
                qFilter.and("vipid", "=", (Object)memberId);
                PosConfirmOrderPlugin.logger.info("\u8ba2\u5355\u786e\u8ba4\u6d88\u8d39\u91d1\u989d\uff1a" + totalMemberPrice);
                ticketInfoList = OlstoreTicketHelper.getMemberTicketInfo((QFilter)qFilter, (List)selectEntrys, (long)customerId, (long)memberId, null);
                filter = new QFilter("id", "in", (Object)ticketInfoList.toArray());
                event.getQueryFilter().addQFilter(filter);
                break;
            }
        }
    }

    private static /* synthetic */ boolean lambda$beforeQueryF7$6(String itemId, String auxptyId, JSONObject p) {
        return p.getString("itemid").equals(itemId) && p.getString("auxptyid").equals(auxptyId);
    }
}

