/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.promotion.OlstorePromotionHelper;
import kd.occ.ocpos.common.entity.request.CxPromotionRequestEntity;
import kd.occ.ocpos.common.entity.request.CxPromotionResultEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.entity.request.PromoteRuleResultEntity;
import kd.occ.ocpos.common.util.CommonUtil;

public class PosDiscountDetailsPlugin
extends ExtListViewPlugin {
    public ListDataSet<?> onDataLoad(LoadDataEvent event) {
        ListDataSet listDataSet = super.onDataLoad(event);
        HashMap promoteMap = (HashMap)event.getCustomParam().get((Object)"promoteMap");
        String dbId = (String)promoteMap.get("orgId");
        String storeId = (String)promoteMap.get("storeId");
        String memberId = (String)promoteMap.get("memberId");
        String itemId = (String)promoteMap.get("itemId");
        String unitId = (String)promoteMap.get("unitId");
        String auxId = (String)promoteMap.get("auxId");
        DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)memberId, (String)"ocdbd_user");
        String billDate = CommonUtil.format((Date)TimeServiceHelper.now(), (String)TimeServiceHelper.getDateTimeFormatString());
        String memberlevelid = member.getDynamicObject("viplevelid") != null ? member.getDynamicObject("viplevelid").getString("id") : "";
        CxPromotionRequestEntity cxRequestEntity = new CxPromotionRequestEntity(dbId, storeId, memberId, memberlevelid, billDate, false);
        PosDiscountDetailsPlugin.buildMaterialEntry(cxRequestEntity, itemId, unitId, auxId);
        List promotionList = OlstorePromotionHelper.matchPromotion((CxPromotionRequestEntity)cxRequestEntity);
        DynamicObjectCollection promoteList = this.getPromoteList(promotionList);
        if (promoteList != null && promoteList.size() > 0) {
            listDataSet.setRows((Object)promoteList);
        }
        return listDataSet;
    }

    private DynamicObjectCollection getPromoteList(List<CxPromotionResultEntity> promotionList) {
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        for (CxPromotionResultEntity promote : promotionList) {
            StringBuilder msg = new StringBuilder();
            DynamicObject dataObject = ((ListFormData)this.getBillData()).createNewEntryDynamicObject("promote_list");
            String typeName = promote.getTypeName();
            String promoteType = this.promoteType(typeName);
            String firstName = promote.getName();
            dataObject.set("type", (Object)promoteType);
            dataObject.set("content", (Object)firstName);
            List promoteRuleList = promote.getPromoteRuleList();
            if (promoteRuleList.size() > 1) {
                for (int i = 1; i < promoteRuleList.size(); ++i) {
                    PromoteRuleResultEntity tempRuleResult = (PromoteRuleResultEntity)promoteRuleList.get(i);
                    String promoteRuleName = tempRuleResult.getPromoteRuleName();
                    msg.append(promoteRuleName);
                    msg.append('\n');
                }
            } else {
                ((ExtListView)this.view).hide("more_img", true);
            }
            dataObject.set("more_content", (Object)msg.toString());
            entryList.add((Object)dataObject);
        }
        return entryList;
    }

    private static void buildMaterialEntry(CxPromotionRequestEntity cxRequestEntity, String itemId, String unitId, String auxattrid) {
        ArrayList<MaterialEntryEntity> materialEntryEntityList = new ArrayList<MaterialEntryEntity>();
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"ocdbd_iteminfo");
        if (item == null) {
            return;
        }
        DynamicObject goodsBrand = DynamicObjectUtils.getDynamicObject((DynamicObject)item, (String)"itembrands");
        String brandId = goodsBrand != null ? goodsBrand.getString("id") : "";
        List classIds = ItemClassUtil.queryClassList((Object)itemId);
        MaterialEntryEntity entryEntity = new MaterialEntryEntity(0, item.getString("id"), item.getString("name"), unitId, auxattrid, null, null, brandId, classIds.stream().map(CommonUtil::formatStringToEmpty).collect(Collectors.toList()), null, null, false);
        materialEntryEntityList.add(entryEntity);
        cxRequestEntity.setMatchMaterial(entryEntity);
        cxRequestEntity.setMaterialEntries(materialEntryEntityList);
    }

    private String promoteType(String typeName) {
        String result = "";
        result = typeName.equals("PM-037") || typeName.equals("PM-025") ? "\u9001\u5238" : (typeName.equals("PM-023") || typeName.equals("PM-039") ? "\u8d60\u79ef\u5206" : "\u6d3b\u52a8");
        return result;
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        DynamicObject entryRowData = ((ListFormData)this.getBillData()).getEntryRowData("promote_list", event.getCurrentRow());
        String ishidden = entryRowData.getString("ishidden");
        if (eventId.equals("more_img")) {
            if (ishidden.equals("1")) {
                ((ExtListView)this.view).hide("more_content", false, event.getCurrentRow().getRow());
                ((ListFormData)this.billData).updateValue("ishidden", event.getCurrentRow().getRow(), (Object)"0");
                ((ListFormData)this.billData).updateValue("more_img", (Object)"/static/image/olstore/arrow_up.png");
            } else {
                ((ExtListView)this.view).hide("more_content", true, event.getCurrentRow().getRow());
                ((ListFormData)this.billData).updateValue("ishidden", event.getCurrentRow().getRow(), (Object)"1");
                ((ListFormData)this.billData).updateValue("more_img", (Object)"/static/image/olstore/arrow_down.png");
            }
        }
    }
}

