/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;

public class PosElectwarrantyListPlugin
extends ExtBillViewPlugin {
    private final Log logger = LogFactory.getLog(PosElectwarrantyListPlugin.class);
    private static final String itementrys = "goodslist";

    public void afterDataLoad(LoadDataEvent event) {
        Long billId = Long.parseLong(event.getCustomParam().getString("billId"));
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billId);
        ((BillFormData)this.billData).updateValue("orderno", (Object)orderInfo.getString("billno"));
        DynamicObjectCollection goodsentryentity = orderInfo.getDynamicObjectCollection("goodsentryentity");
        for (int i = 0; i < goodsentryentity.size(); ++i) {
            DynamicObject goodsEntry = (DynamicObject)goodsentryentity.get(i);
            DynamicObject goods = goodsEntry.getDynamicObject("goodsid");
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            dataObject.set("id", (Object)goodsEntry.getString("goodsid.id"));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + goods.getString("thumbnail")));
            dataObject.set("itemname", (Object)goods.getString("name"));
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
        }
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "thumbnail": {
                this.goPage(event, "ocpos_itemdetails");
                break;
            }
            case "electwarranty": {
                DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow().getRow());
                String billNo = ((BillFormData)this.getBillData()).getString("orderno");
                QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
                qFilter.and("goodsid", "=", (Object)entryRowData.getLong("id"));
                DynamicObject warranty = QueryServiceHelper.queryOne((String)"ocpos_electwarranty", (String)"id", (QFilter[])qFilter.toArray());
                if (warranty == null) {
                    ((ExtBillView)this.view).showMessage("\u8be5\u5546\u54c1\u6ca1\u6709\u7535\u5b50\u4fdd\u4fee\u5355");
                    return;
                }
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_warranty");
                openParam.addCustomParam("warranty_id", warranty.getString("id"));
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    private void goPage(ClickEvent event, String viewId) {
        DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow().getRow());
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId(viewId);
        openParam.addCustomParam("itemid", entryRowData.getString("id"));
        openParam.addCustomParam("thumbnail", entryRowData.get("thumbnail"));
        openParam.addCustomParam("itemname", entryRowData.getString("itemname"));
        openParam.addCustomParam("billId", ((BillFormData)this.getBillData()).getString("billid"));
        ((ExtBillView)this.getView()).showView(openParam);
    }
}

