/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.pojo.vo.member.user.AddressVO;
import kd.occ.ocbase.common.pojo.vo.member.user.QueryUserByIdVO;
import kd.occ.ocbase.common.util.ButtonFastClickUtil;
import kd.occ.ocepfp.common.constant.Enums;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class PosExchangeApplyPlugin
extends ExtBillViewPlugin {
    private static final String itementrys = "goodslist";
    protected static Log logger = LogFactory.getLog(PosExchangeApplyPlugin.class);
    private static final int MIN_CLICK_DELAY_TIME = 2000;

    public void afterDataLoad(LoadDataEvent event) {
        AddressVO defaultAddress;
        DynamicObject data = super.onDataLoad(event);
        boolean allToDelivery = true;
        Long billId = Long.parseLong(event.getCustomParam().getString("billId"));
        String selectItemList = event.getCustomParam().getString("selectitemList");
        List<String> selectItemIds = Arrays.asList(selectItemList.split(","));
        ((BillFormData)this.getBillData()).updateValue("billid", (Object)billId);
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billId);
        data.set("totalrealamount", (Object)orderInfo.getBigDecimal("totalrealamount"));
        DynamicObjectCollection goodsentryentity = orderInfo.getDynamicObjectCollection("goodsentryentity");
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        JSONObject resultJson = OlstoreMemberHelper.getMemberInfoById((long)memberId);
        if (resultJson != null && resultJson.getInteger("code") == 0) {
            JSONObject jsonData = resultJson.getJSONObject("data");
            QueryUserByIdVO vo = (QueryUserByIdVO)JSONObject.toJavaObject((JSON)jsonData, QueryUserByIdVO.class);
            ((BillFormData)this.getBillData()).updateValue("linkman", (Object)vo.getName());
            ((BillFormData)this.getBillData()).updateValue("linkphone", (Object)vo.getMobile());
        }
        if ((defaultAddress = this.queryDefaultAddress(memberId)) != null) {
            ((BillFormData)this.getBillData()).updateValue("address", (Object)defaultAddress.getDetailedAddress());
            ((BillFormData)this.getBillData()).updateValue("districtid", (Object)defaultAddress.getDistrictId());
            ((BillFormData)this.getBillData()).updateValue("addressid", (Object)defaultAddress.getId());
        }
        for (DynamicObject goodsEntry : goodsentryentity) {
            if (!selectItemIds.contains(String.valueOf(DynamicObjectUtil.getPkValue((DynamicObject)goodsEntry)))) continue;
            DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)1026065142993238016L, (String)"ococic_deliverstatus");
            DynamicObjectCollection salesorderdelivery = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
            DynamicObject delivery = (DynamicObject)salesorderdelivery.get(0);
            String deliverystatus = delivery.getDynamicObject("deliverystatus").getString("name");
            if (!deliveryStatus.getString("name").equals(deliverystatus)) {
                allToDelivery = false;
            }
            DynamicObject goods = goodsEntry.getDynamicObject("goodsid");
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            dataObject.set("id", (Object)DynamicObjectUtil.getPkValue((DynamicObject)goodsEntry));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + goods.getString("thumbnail")));
            dataObject.set("itemname", (Object)goods.getString("name"));
            dataObject.set("retailprice", (Object)goodsEntry.getBigDecimal("amount").stripTrailingZeros().toPlainString());
            dataObject.set("memberprice", (Object)goodsEntry.getBigDecimal("balamount").divide(goodsEntry.getBigDecimal("saleqty")).stripTrailingZeros().toPlainString());
            dataObject.set("applyqty", (Object)goodsEntry.getBigDecimal("saleqty").intValue());
            dataObject.set("mustretqty", (Object)goodsEntry.getBigDecimal("mustretqty").intValue());
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
        }
        if (allToDelivery) {
            ((BillFormData)this.billData).updateValue("returntype", (Object)"D");
            ((ExtBillView)this.view).setActiveByValue("returntype", "D");
            ((ExtBillView)this.view).hide("distributionpanel", true);
        }
    }

    protected AddressVO queryDefaultAddress(long memberId) {
        JSONObject jsonRes = OlstoreMemberHelper.queryDefaultAddressByUserId((long)memberId);
        if (((Boolean)jsonRes.get((Object)"success")).booleanValue()) {
            List addressList = (List)jsonRes.get((Object)"data");
            return (AddressVO)addressList.get(0);
        }
        return null;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "submit": {
                if (ButtonFastClickUtil.isFastClickByTime((long)2000L)) break;
                this.returnApply();
                break;
            }
            case "revoke": {
                this.goPage("ocpos_orderlistm", null);
                break;
            }
            case "distribution": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.Pop);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("addressid", ((BillFormData)this.billData).getString("addressid"));
                openParam.setViewId("ocpos_memberaddressm");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    private void returnApply() {
        long billid = ((BillFormData)this.getBillData()).getLong("billid");
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billid);
        JSONObject param = new JSONObject();
        DynamicObjectCollection goodsentryentity = orderInfo.getDynamicObjectCollection("goodsentryentity");
        ArrayList lstData = new ArrayList();
        DynamicObjectCollection entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
        for (DynamicObject viewItem : entryRowData) {
            for (DynamicObject item : goodsentryentity) {
                Object saleqty;
                if (!viewItem.getString("id").equals(String.valueOf(item.getPkValue()))) continue;
                DynamicObjectCollection salesorderdelivery = item.getDynamicObjectCollection("salesorderdelivery");
                BigDecimal applyqty = viewItem.getBigDecimal("applyqty");
                if (applyqty.compareTo((BigDecimal)(saleqty = item.getBigDecimal("saleqty"))) > 0) {
                    ((ExtBillView)this.view).showMessage("\u7533\u8bf7\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b9e\u9645\u8d2d\u4e70\u6570\u91cf\u3002\u5546\u54c1\u540d\u79f0\uff1a" + viewItem.getString("itemname") + "\u7684\u5b9e\u9645\u8d2d\u4e70\u6570\u91cf\uff1a" + ((BigDecimal)saleqty).intValue());
                    return;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("entryid", item.getPkValue());
                map.put("subentryid", ((DynamicObject)salesorderdelivery.get(0)).getPkValue());
                map.put("changeqty", applyqty.negate());
                lstData.add(map);
            }
        }
        Object reason = ((BillFormData)this.getBillData()).get("reason.id");
        String remark = ((BillFormData)this.billData).getString("remark");
        if (StringUtil.isNull((Object)reason)) {
            ((ExtBillView)this.view).showMessage("\u8bf7\u9009\u62e9\u9000\u8d27\u539f\u56e0\u3002");
            return;
        }
        if (StringUtil.isNull((String)remark)) {
            ((ExtBillView)this.view).showMessage("\u8bf7\u63cf\u8ff0\u7533\u8bf7\u552e\u540e\u670d\u52a1\u7684\u5177\u4f53\u539f\u56e0\u3002");
            return;
        }
        String returnType = ((BillFormData)this.getBillData()).getString("returntype");
        String districtid = ((BillFormData)this.getBillData()).getString("districtid");
        String address = ((BillFormData)this.getBillData()).getString("address");
        String linkphone = ((BillFormData)this.getBillData()).getString("linkphone");
        switch (returnType) {
            case "A": {
                Date selfpickuptime = ((BillFormData)this.getBillData()).getDate("pickuptime");
                if (selfpickuptime == null) {
                    ((ExtBillView)this.view).showMessage("\u8bf7\u9009\u62e9\u53d6\u4ef6\u65f6\u95f4\u3002");
                    return;
                }
                param.put("isselfpickup", (Object)Boolean.TRUE);
                param.put("selfpickuptime", (Object)selfpickuptime);
                break;
            }
            case "B": {
                String expressno = ((BillFormData)this.getBillData()).getString("expressno");
                String expresscomp = ((BillFormData)this.getBillData()).getString("expresscomp.id");
                if (StringUtil.isNull((String)expressno)) {
                    ((ExtBillView)this.view).showMessage("\u8bf7\u586b\u5199\u7269\u6d41\u5355\u53f7\u3002");
                    return;
                }
                if (StringUtil.isNull((String)expresscomp)) {
                    ((ExtBillView)this.view).showMessage("\u8bf7\u9009\u62e9\u7269\u6d41\u516c\u53f8\u3002");
                    return;
                }
                param.put("isselfpickup", (Object)Boolean.FALSE);
                param.put("expressno", (Object)expressno);
                param.put("expresscomp", (Object)expresscomp);
                break;
            }
            case "C": {
                break;
            }
            case "D": {
                break;
            }
        }
        param.put("returntype", (Object)((BillFormData)this.billData).getString("returntype"));
        param.put("address", (Object)address);
        param.put("districtid", (Object)districtid);
        param.put("deliverphonenumber", (Object)linkphone);
        param.put("returnreason", reason);
        param.put("ordersource", (Object)"E");
        param.put("comment", (Object)remark);
        logger.info("\u6362\u8d27\u9000\u6b3e\u53c2\u6570param\uff1a" + JSON.toJSONString((Object)param));
        JSONObject orderResult = SaleOrderDBHelper.addSaleChange((DynamicObject)orderInfo, (JSONObject)param, (boolean)true, lstData);
        if (orderResult != null) {
            if (orderResult.get("billId") != null) {
                logger.info("\u9000\u8d27\u9000\u6b3e\u6210\u529f\uff0c\u6b63\u5728\u8df3\u5230\u9000\u6b3e\u8be6\u60c5\u9875\u9762\uff0c\u9000\u6b3ebillId\uff1a" + orderResult.get("billId"));
                this.goPage("ocpos_postsale_success", String.valueOf(orderResult.get("billId")));
            } else {
                ((ExtBillView)this.view).showMessage((String)orderResult.get("error"));
            }
        }
    }

    private void goPage(String viewId, String billId) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId(viewId);
        openParam.addCustomParam("sourceviewid", "ocpos_exchange_apply");
        openParam.addCustomParam("billId", billId);
        openParam.addCustomParam("returntype", ((BillFormData)this.billData).getString("returntype"));
        openParam.addCustomParam("address", ((BillFormData)this.billData).getString("address"));
        openParam.addCustomParam("pickuptime", (Object)((BillFormData)this.getBillData()).getDate("pickuptime"));
        openParam.addCustomParam("linkphone", ((BillFormData)this.getBillData()).getString("linkphone"));
        openParam.addCustomParam("linkman", ((BillFormData)this.getBillData()).getString("linkman"));
        openParam.addCustomParam("expressno", ((BillFormData)this.getBillData()).getString("expressno"));
        openParam.addCustomParam("expresscomp", ((BillFormData)this.getBillData()).getString("expresscomp.name"));
        ((ExtBillView)this.getView()).showView(openParam);
    }

    protected void onDataChange(DataChangeEvent event) {
        String returnType = event.getBillData().getString("returntype");
        if (StringUtil.isNotNull((String)returnType)) {
            switch (returnType) {
                case "A": {
                    ((ExtBillView)this.view).hide("expresspanel", true);
                    ((ExtBillView)this.view).hide("distributionpanel", false);
                    ((ExtBillView)this.view).hide("pickuptime", false);
                    break;
                }
                case "B": {
                    ((ExtBillView)this.view).hide("expresspanel", false);
                    ((ExtBillView)this.view).hide("distributionpanel", false);
                    ((ExtBillView)this.view).hide("pickuptime", true);
                    break;
                }
                case "C": 
                case "D": {
                    ((ExtBillView)this.view).hide("distributionpanel", true);
                    break;
                }
            }
        } else {
            String id;
            switch (id = event.getId()) {
                case "applyqty": {
                    DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow().getRow());
                    if (entryRowData == null) break;
                    int mustretqty = entryRowData.getInt("mustretqty");
                    Integer qty = (Integer)event.getValue();
                    if (qty <= mustretqty) break;
                    ((BillFormData)this.getBillData()).updateValue("applyqty", event.getCurrentRow().getRow(), (Object)mustretqty);
                    break;
                }
            }
        }
        super.onDataChange(event);
    }

    protected void beforeQueryF7(SelectDataEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "reason": {
                event.getQueryFilter().addFilter("group", Enums.SqlCompareOperator.equal, (Object)1062223569272256512L);
                break;
            }
        }
        super.beforeQueryF7(event);
    }
}

