/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.AbstractFormData;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.formplugin.olstore.PosConfirmOrderPlugin;

public class PosGiftListPlugin
extends ExtBillViewPlugin {
    private static final String itementrys = "goodslist";
    private static Log logger = LogFactory.getLog(PosConfirmOrderPlugin.class);

    public void afterDataLoad(LoadDataEvent event) {
        String ticketId = event.getCustomParam().getString("ticketid");
        String itemIndex = event.getCustomParam().getString("itemindex");
        ((BillFormData)this.billData).updateValue("ticketid", (Object)ticketId);
        ((BillFormData)this.billData).updateValue("itemindex", (Object)itemIndex);
        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
        Long customerId = currentStore.getLong("id");
        this.getTicketItemList(customerId, ticketId);
        ((ExtBillView)this.view).hide("searchhistory", true);
    }

    private JSONObject getGiftItemInfo(String itemId, long customerId) {
        String appendStr = OlstoreUtil.buildItemParamAppendStr();
        JSONObject returnData = OlstoreItemHelper.getItemDetail((String)String.valueOf(customerId), (String)"0", (String)itemId, (String)appendStr);
        if ("0000".equals(returnData.get((Object)"code").toString()) && returnData.getJSONArray("data").size() > 0) {
            JSONArray products = returnData.getJSONArray("data");
            if (products.size() == 1) {
                return products.getJSONObject(0);
            }
            if (products.size() > 1) {
                List list = JSONObject.parseArray((String)products.toJSONString(), JSONObject.class);
                return list.stream().filter(p -> p.getString("itemid").equals(itemId)).findFirst().orElse(null);
            }
        }
        return null;
    }

    private void getTicketItemList(Long customerId, String ticketId) {
        logger.info("\u8d60\u54c1\u5217\u8868  queryGiftListForTicket\u53c2\u6570\uff0cticketId:" + ticketId + ", customerId:" + customerId);
        DynamicObject ticketInfo = this.getTicketInfo(Long.parseLong(ticketId));
        long olinvitateid = ticketInfo.getLong("olinvitateid.id");
        String tickettypeid = ticketInfo.getString("tickettypeid.id");
        DynamicObject dynamicObject = this.getGiftItemList(olinvitateid);
        DynamicObjectCollection tickettypetab = dynamicObject.getDynamicObjectCollection("tickettypeentry");
        DynamicObjectCollection giftEntry = new DynamicObjectCollection();
        for (DynamicObject tickettype : tickettypetab) {
            if (!tickettype.getString("tickettypeid.id").equals(tickettypeid)) continue;
            giftEntry = tickettype.getDynamicObjectCollection("selectgiftentryentity");
            break;
        }
        int giftradiogroup = dynamicObject.getInt("giftradiogroup");
        BigDecimal gifttotal = dynamicObject.getBigDecimal("gifttotal");
        int i = 0;
        for (DynamicObject gift : giftEntry) {
            DynamicObject item = gift.getDynamicObject("itemid");
            String itemid = item.getString("id");
            JSONObject itemInfo = this.getGiftItemInfo(itemid, customerId);
            logger.info("\u5f39\u51fa\u8d60\u54c1\u5217\u8868  \u5546\u54c1\u8be6\u60c5 itemInfo:" + JSONObject.toJSONString((Object)itemInfo));
            if (itemInfo == null) continue;
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            dataObject.set("itemid", (Object)itemid);
            dataObject.set("spuid", (Object)itemInfo.getString("spuid"));
            dataObject.set("itemname", (Object)itemInfo.getString("itemname"));
            dataObject.set("qty", (Object)itemInfo.getBigDecimal("qty"));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + itemInfo.getString("thumbnail")));
            dataObject.set("unitid", (Object)itemInfo.getString("unitid"));
            dataObject.set("baseunitid", (Object)itemInfo.getString("baseunitid"));
            dataObject.set("auxattrid", (Object)itemInfo.getString("auxptyid"));
            dataObject.set("barcode", (Object)itemInfo.getString("barcodeid"));
            dataObject.set("materielid", (Object)itemInfo.getString("materielid"));
            if (giftradiogroup == 1) {
                dataObject.set("qty", (Object)gift.getString("giveqty"));
                ((ExtBillView)this.view).disable("qty", true, i++);
            }
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
        }
        if (giftradiogroup == 1) {
            ((BillFormData)this.billData).updateValue("message", (Object)"\u8bf7\u4efb\u9009\u4e00\u79cd\u8d60\u54c1");
            ((ExtBillView)this.view).setMultiple(itementrys, false);
        } else {
            ((BillFormData)this.billData).updateValue("message", (Object)("\u4e00\u5171\u53ef\u9009" + gifttotal + "\u4ef6\u8d60\u54c1"));
            ((ExtBillView)this.view).setMultiple(itementrys, true);
        }
    }

    private DynamicObject getTicketInfo(Long ticketId) {
        QFilter filter = new QFilter("id", "=", (Object)ticketId);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdbd_ticketinfo");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_ticketinfo", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
    }

    private DynamicObject getGiftItemList(Long olinvitateid) {
        QFilter filter = new QFilter("id", "=", (Object)olinvitateid);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdbd_olinvitate");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_olinvitate", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "confirm": {
                String ticketId = event.getCustomParam().getString("ticketid");
                ((BillFormData)this.billData).updateValue("ticketid", (Object)ticketId);
                List selectionRowIds = event.getSelectionRowIds();
                if (selectionRowIds == null || selectionRowIds.size() == 0) {
                    ((ExtBillView)this.view).showMessage("\u8bf7\u52fe\u9009\u5546\u54c1\u8bb0\u5f55");
                    return;
                }
                AbstractExtFormPlugin parentForm = ((ExtBillView)this.view).getParentForm();
                ExtDynamicView parentView = parentForm.getDynamicView();
                AbstractFormData abstractFormData = (AbstractFormData)parentForm.getBillData();
                DynamicObjectCollection entryRowData = abstractFormData.getEntryRowData(itementrys);
                int size = entryRowData.size();
                BigDecimal totalQty = BigDecimal.ZERO;
                Iterator iterator = selectionRowIds.iterator();
                while (iterator.hasNext()) {
                    int row = (Integer)iterator.next();
                    DynamicObject item = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, row);
                    totalQty = totalQty.add(item.getBigDecimal("qty"));
                }
                DynamicObject ticketInfo = this.getTicketInfo(Long.parseLong(ticketId));
                long olinvitateid = ticketInfo.getLong("olinvitateid.id");
                DynamicObject dynamicObject = this.getGiftItemList(olinvitateid);
                int giftradiogroup = dynamicObject.getInt("giftradiogroup");
                BigDecimal gifttotal = dynamicObject.getBigDecimal("gifttotal");
                if (totalQty.compareTo(BigDecimal.ZERO) == 0) {
                    ((ExtBillView)this.view).showMessage("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u8d60\u54c1");
                    return;
                }
                if (giftradiogroup == 0 && totalQty.compareTo(gifttotal) > 0) {
                    ((ExtBillView)this.view).showMessage("\u8d60\u54c1\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7" + gifttotal);
                    return;
                }
                Iterator iterator2 = selectionRowIds.iterator();
                while (iterator2.hasNext()) {
                    int row = (Integer)iterator2.next();
                    DynamicObject item = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, row);
                    if (item.getBigDecimal("qty").compareTo(BigDecimal.ZERO) <= 0) continue;
                    DynamicObject dataObject = abstractFormData.createNewEntryDynamicObject(itementrys);
                    dataObject.set("itemid", (Object)item.getString("itemid"));
                    dataObject.set("spuid", (Object)item.getString("spuid"));
                    dataObject.set("itemname", (Object)item.getString("itemname"));
                    dataObject.set("qty", (Object)item.getBigDecimal("qty"));
                    dataObject.set("thumbnail", (Object)item.getString("thumbnail"));
                    dataObject.set("unitid", (Object)item.getString("unitid"));
                    dataObject.set("baseunitid", (Object)item.getString("baseunitid"));
                    dataObject.set("auxptyid", (Object)item.getString("auxattrid"));
                    dataObject.set("barcode", (Object)item.getString("barcode"));
                    dataObject.set("materielid", (Object)item.getString("materielid"));
                    dataObject.set("deliverdeliverytime", (Object)new Date());
                    dataObject.set("deliverinstalltime", (Object)new Date());
                    dataObject.set("ispresent", (Object)Boolean.TRUE);
                    abstractFormData.addEntryRow(itementrys, dataObject);
                    abstractFormData.updateValue("isgift", (Object)1);
                    parentView.hide("gift", false, size++);
                    abstractFormData.updateFormData();
                }
                ((ExtBillView)this.view).closeView();
                break;
            }
        }
        super.onClick(event);
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "qty": {
                int rowId = event.getRow();
                ((ExtBillView)this.view).setRowSelection(itementrys, rowId, true);
                break;
            }
        }
        super.onDataChange(event);
    }
}

