/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocepfp.common.entity.SelectedRow;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.AbstractFormData;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocpos.business.olstore.OlstorePromotionTransferHelper;
import kd.occ.ocpos.business.promotion.OlstorePromotionHelper;
import kd.occ.ocpos.common.entity.request.CxPromotionRequestEntity;
import kd.occ.ocpos.common.entity.request.CxPromotionResultEntity;
import kd.occ.ocpos.common.entity.request.PromoteRuleGiftResultEntity;
import kd.occ.ocpos.common.entity.request.PromoteRuleGroupResultEntity;
import kd.occ.ocpos.common.entity.request.PromoteRuleResultEntity;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.formplugin.olstore.PosConfirmOrderPlugin;

public class PosGiftListPromotionPlugin
extends ExtBillViewPlugin {
    private static final String itementrys = "goodslist";
    private static Log logger = LogFactory.getLog(PosConfirmOrderPlugin.class);

    public void afterDataLoad(LoadDataEvent event) {
        String itemIndex = event.getCustomParam().getString("itemindex");
        ((BillFormData)this.billData).updateValue("itemindex", (Object)itemIndex);
        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
        Long customerId = currentStore.getLong("id");
        this.getPromotionItemList(customerId, Integer.parseInt(itemIndex));
        ((ExtBillView)this.view).hide("searchhistory", true);
    }

    private void getPromotionItemList(Long customerId, int itemIndex) {
        long memberId = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        AbstractExtFormPlugin parentForm = ((ExtBillView)this.view).getParentForm();
        AbstractFormData abstractFormData = (AbstractFormData)parentForm.getBillData();
        DynamicObjectCollection itemList = abstractFormData.getEntryRowData(itementrys);
        DynamicObject item = (DynamicObject)itemList.get(itemIndex);
        CxPromotionRequestEntity cxPromotionRequestEntity = OlstorePromotionTransferHelper.buildPromotionParam((DynamicObjectCollection)itemList, (int)itemIndex, (long)customerId, (long)memberId);
        List cxPromotionResultEntities = OlstorePromotionHelper.matchPromotion((CxPromotionRequestEntity)cxPromotionRequestEntity);
        CxPromotionResultEntity promotionResultEntity = null;
        for (CxPromotionResultEntity entity : cxPromotionResultEntities) {
            if (!entity.getItemList().contains(((DynamicObject)itemList.get(itemIndex)).getString("itemid")) || !PromotionEnum.onlineGiftPromotion().contains(entity.getTypeName())) continue;
            promotionResultEntity = entity;
            break;
        }
        if (promotionResultEntity == null) {
            return;
        }
        List groupList = ((PromoteRuleResultEntity)promotionResultEntity.getPromoteRuleList().get(0)).getGroupList();
        ((BillFormData)this.billData).updateValue("pname", (Object)promotionResultEntity.getName());
        ((BillFormData)this.billData).updateValue("groupnum", (Object)groupList.size());
        for (int i = 0; i < groupList.size(); ++i) {
            PromoteRuleGroupResultEntity promoteRuleGroupResultEntity = (PromoteRuleGroupResultEntity)groupList.get(i);
            List giftList = promoteRuleGroupResultEntity.getGiftList();
            for (PromoteRuleGiftResultEntity giftItem : giftList) {
                DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys + i);
                dataObject.set("promotionid" + i, (Object)promotionResultEntity.getId());
                dataObject.set("promotionname" + i, (Object)promotionResultEntity.getName());
                dataObject.set("typeid" + i, (Object)promotionResultEntity.getTypeId());
                dataObject.set("typename" + i, (Object)promotionResultEntity.getTypeName());
                dataObject.set("priority" + i, (Object)promotionResultEntity.getPriority());
                dataObject.set("actname" + i, (Object)promotionResultEntity.getActName());
                dataObject.set("itemgroup" + i, (Object)((PromoteRuleResultEntity)promotionResultEntity.getPromoteRuleList().get(0)).getItemGroup());
                dataObject.set("promotionbillno" + i, (Object)promotionResultEntity.getBillNo());
                dataObject.set("preitemid" + i, (Object)item.getString("itemid"));
                dataObject.set("itemid" + i, (Object)giftItem.getGiftId());
                dataObject.set("itemname" + i, (Object)giftItem.getGiftName());
                dataObject.set("barcode" + i, (Object)giftItem.getBarCode());
                dataObject.set("inventorytype" + i, (Object)giftItem.getInventoryType());
                dataObject.set("unitid" + i, (Object)giftItem.getUnit());
                dataObject.set("qty" + i, (Object)promoteRuleGroupResultEntity.getPickQty());
                QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(giftItem.getGiftId()));
                DynamicObject itemInfo = QueryServiceHelper.queryOne((String)"ocdbd_iteminfo", (String)"thumbnail", (QFilter[])filter.toArray());
                dataObject.set("thumbnail" + i, (Object)(PictureUtil.getFileServerUrl() + itemInfo.getString("thumbnail")));
                ((BillFormData)this.getBillData()).addEntryRow(itementrys + i, dataObject);
            }
        }
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "confirm": {
                int itemIndex = ((BillFormData)this.billData).getInt("itemindex");
                int groupnum = ((BillFormData)this.billData).getInt("groupnum");
                for (int i = 0; i < groupnum; ++i) {
                    List selections = event.getSelections(itementrys + i);
                    if (!CollectionUtils.isEmpty((Collection)selections)) continue;
                    ((ExtBillView)this.view).showMessage("\u8bf7\u9009\u62e9\u8d60\u54c1");
                    return;
                }
                AbstractExtFormPlugin parentForm = ((ExtBillView)this.view).getParentForm();
                ExtDynamicView parentView = parentForm.getDynamicView();
                AbstractFormData abstractFormData = (AbstractFormData)parentForm.getBillData();
                DynamicObjectCollection entryRowData = abstractFormData.getEntryRowData(itementrys);
                int size = entryRowData.size();
                if (abstractFormData.getInt("isgift") == itemIndex + 1 || size != itemIndex + 1 && abstractFormData.getEntryRowData(itementrys, itemIndex + 1).getBoolean("isitemgift")) {
                    ArrayList<Integer> delList = new ArrayList<Integer>(10);
                    for (int i = 0; i < groupnum; ++i) {
                        DynamicObject parentItem = abstractFormData.getEntryRowData(itementrys, itemIndex + 1 + i);
                        if (!parentItem.getBoolean("isitemgift")) continue;
                        delList.add(itemIndex + 1 + i);
                    }
                    abstractFormData.delEntryRow(itementrys, delList);
                }
                for (int i = 0; i < groupnum; ++i) {
                    List selections = event.getSelections(itementrys + i);
                    SelectedRow row = (SelectedRow)selections.get(0);
                    DynamicObject item = ((BillFormData)this.getBillData()).getEntryRowData(itementrys + i, row);
                    DynamicObject dataObject = abstractFormData.createNewEntryDynamicObject(itementrys);
                    dataObject.set("itemid", (Object)item.getString("itemid" + i));
                    dataObject.set("itemname", (Object)item.getString("itemname" + i));
                    dataObject.set("qty", (Object)item.getBigDecimal("qty" + i));
                    dataObject.set("thumbnail", (Object)item.getString("thumbnail" + i));
                    dataObject.set("promotionid", (Object)item.getString("promotionid" + i));
                    dataObject.set("promotionname", (Object)item.getString("promotionname" + i));
                    dataObject.set("typeid", (Object)item.getString("typeid" + i));
                    dataObject.set("typename", (Object)item.getString("typename" + i));
                    dataObject.set("priority", (Object)item.getString("priority" + i));
                    dataObject.set("actname", (Object)item.getString("actname" + i));
                    dataObject.set("itemgroup", (Object)item.getString("itemgroup" + i));
                    dataObject.set("promotionbillno", (Object)item.getString("promotionbillno" + i));
                    dataObject.set("preitemid", (Object)item.getString("preitemid" + i));
                    dataObject.set("barcode", (Object)item.getString("barcode" + i));
                    dataObject.set("unitid", (Object)item.getString("unitid" + i));
                    dataObject.set("inventorytype", (Object)item.getString("inventorytype" + i));
                    dataObject.set("isitemgift", (Object)Boolean.TRUE);
                    abstractFormData.insertEntryRow(itementrys, dataObject, itemIndex + i + 1);
                    abstractFormData.updateValue("isgift", (Object)(itemIndex + 1));
                    parentView.hide("gift", false, itemIndex + i + 1);
                    parentView.hide("memberpricepanel", true, itemIndex + i + 1);
                    parentView.hide("deliver_panel", true, itemIndex + i + 1);
                    abstractFormData.updateFormData();
                }
                ((ExtBillView)this.view).closeView();
                break;
            }
        }
        super.onClick(event);
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "qty": {
                int rowId = event.getRow();
                ((ExtBillView)this.view).setRowSelection(itementrys, rowId, true);
                break;
            }
        }
        super.onDataChange(event);
    }
}

