/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.pojo.vo.member.user.QueryUserByIdVO;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocpos.business.olstore.OlsGiftRecBillHelper;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.business.olstore.PosGiftSetHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class PosGiftPromotionDetailPlugin
extends ExtBillViewPlugin {
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ocpos-olstore-cache");
    protected static Log logger = LogFactory.getLog(PosGiftPromotionDetailPlugin.class);

    public DynamicObject onDataLoad(LoadDataEvent event) {
        String paramId;
        JSONObject paramInfo;
        DynamicObject data = super.onDataLoad(event);
        long giftId = event.getCustomParam().getLong("giftId");
        long vipID = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        long storeId = OlstoreUtil.getStoreId((ClientEvent)event);
        if (giftId == 0L && (paramInfo = OlstoreUtil.getGuideParamJSONObject((String)(paramId = event.getCustomParam().getString("paramid")))) != null) {
            giftId = paramInfo.getLong("giftId");
            String billNo = paramInfo.getString("billno");
            String guideId = paramInfo.getString("guideid");
            String guidePhone = paramInfo.getString("guidephone");
            ((ExtBillView)this.view).putLocalStorage("guideid", guideId);
            ((ExtBillView)this.view).putLocalStorage("guidephone", guidePhone);
            storeId = paramInfo.getLong("storeid");
            DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo((long)storeId);
            if (storeInfo != null) {
                String storeName = storeInfo.getString("name");
                if (StringUtils.isNotBlank((Object)storeId) && StringUtils.isNotBlank((CharSequence)storeName)) {
                    JSONObject storeJson = new JSONObject();
                    storeJson.put("id", (Object)storeId);
                    storeJson.put("name", (Object)storeName);
                    OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
                }
            }
            String sourceType = paramInfo.getString("sourcetype");
            String role = paramInfo.getString("role");
            OlstoreUtil.regularMarketClick((String)billNo, (String)guideId, (String)String.valueOf(vipID), (String)String.valueOf(storeId), (String)role, (String)sourceType);
        }
        ((BillFormData)this.billData).updateValue("giftid", (Object)giftId);
        DynamicObject giftDetailInfo = PosGiftSetHelper.getGiftDetailByGiftId((long)giftId);
        if (giftDetailInfo != null) {
            data.set("giftsetid", (Object)giftDetailInfo.getLong("id"));
            data.set("storeid", (Object)storeId);
            data.set("activename", (Object)giftDetailInfo.getString("name"));
            data.set("giftpicwordinfo", (Object)giftDetailInfo.getString("description_tag"));
            int limitQty = giftDetailInfo.getInt("limitqty");
            data.set("limitqty", (Object)limitQty);
            String displayStyle = giftDetailInfo.getString("displaystyle");
            DynamicObjectCollection goodsList = giftDetailInfo.getDynamicObjectCollection("goodsentry");
            if (!CollectionUtils.isEmpty((Collection)goodsList)) {
                Collections.sort(goodsList, (o1, o2) -> {
                    int priority2;
                    int priority1 = o1.getInt("priority");
                    if (priority1 > (priority2 = o2.getInt("priority"))) {
                        return 1;
                    }
                    if (priority1 < priority2) {
                        return -1;
                    }
                    return 0;
                });
                boolean isEnable = giftDetailInfo.getBoolean("enable");
                String activeStatus = giftDetailInfo.getString("activestatus");
                for (int i = 0; i < goodsList.size(); ++i) {
                    boolean isExceedQty;
                    DynamicObject goodsinfo = (DynamicObject)goodsList.get(i);
                    DynamicObject goods = goodsinfo.getDynamicObject("goodsid");
                    long goodsId = goods.getLong("id");
                    DynamicObject giftObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject("giftlist");
                    giftObject.set("id", goodsinfo.getPkValue());
                    giftObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + goods.getString("thumbnail")));
                    giftObject.set("itemname", (Object)goods.getString("name"));
                    giftObject.set("itemid", (Object)goodsId);
                    giftObject.set("singgelimit", (Object)goodsinfo.getInt("singgelimit"));
                    BigDecimal singleQty = BigDecimal.valueOf(goodsinfo.getInt("singleqty"));
                    giftObject.set("singleqty", (Object)singleQty);
                    BigDecimal vipHasRecQty = OlsGiftRecBillHelper.queryGiftsNum((Long)storeId, (Long)giftId, (Long)goodsId, (long)vipID);
                    giftObject.set("viphasreceiveqty", (Object)vipHasRecQty.setScale(0));
                    Map queryAllGiftsNum = OlsGiftRecBillHelper.queryAllGiftsNum((Long)storeId, (Long)giftId, (Long)goodsId, (long)0L);
                    BigDecimal allGiftsNum = (BigDecimal)queryAllGiftsNum.get(goodsId);
                    boolean isExceedTotalQty = allGiftsNum.compareTo(singleQty) >= 0;
                    int vipHasRecNum = OlsGiftRecBillHelper.queryVipRecNum((long)giftId, (long)vipID);
                    boolean isExceedVipGetMaxQty = vipHasRecNum >= limitQty;
                    boolean bl = isExceedQty = isExceedTotalQty || isExceedVipGetMaxQty;
                    if (isExceedQty) {
                        ((ExtBillView)this.view).updateControlName("receive", "\u5df2\u9886\u5b8c", i);
                        ((ExtBillView)this.view).disable("receive", true, i);
                    }
                    ((BillFormData)this.getBillData()).addEntryRow("giftlist", giftObject);
                    if (!isEnable || "C".equals(activeStatus)) {
                        ((ExtBillView)this.view).updateControlName("receive", "\u6d3b\u52a8\u5df2\u8fc7\u671f", i);
                        ((ExtBillView)this.view).disable("receive", true, i);
                    }
                    if (isExceedQty || !"B".equals(displayStyle)) continue;
                    return data;
                }
            }
        }
        return data;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "receive": {
                long vipID = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
                String memberIdKey = "PosGiftPromotionDetailPlugin_receiveKey" + vipID;
                if (CACHE.contains(memberIdKey)) {
                    ((ExtBillView)this.view).showMessage("\u8bf7\u52ff\u9891\u7e41\u91cd\u590d\u70b9\u51fb\u3002", MessageBoxType.Toast);
                    return;
                }
                CACHE.put(memberIdKey, (Object)memberIdKey, 2);
                Long giftId = ((BillFormData)this.billData).getLong("giftid");
                long storeId = OlstoreUtil.getStoreId((ClientEvent)event);
                int limitQty = ((BillFormData)this.getBillData()).getInt("limitqty");
                int vipHasRecNum = OlsGiftRecBillHelper.queryVipRecNum((long)giftId, (long)vipID);
                boolean isExceedVipGetMaxQty = vipHasRecNum >= limitQty;
                DynamicObject goodsinfo = ((BillFormData)this.getBillData()).getEntryRowData("giftlist", event.getCurrentRow().getRow());
                long goodsId = goodsinfo.getLong("itemid");
                BigDecimal singleQty = BigDecimal.valueOf(goodsinfo.getInt("singleqty"));
                Map queryAllGiftsNum = OlsGiftRecBillHelper.queryAllGiftsNum((Long)storeId, (Long)giftId, (Long)goodsId, (long)0L);
                BigDecimal allGiftsNum = (BigDecimal)queryAllGiftsNum.get(goodsId);
                boolean isExceedTotalQty = allGiftsNum.compareTo(singleQty) >= 0;
                logger.info("\u793c\u54c1\u8425\u9500\u6d3b\u52a8\u70b9\u51fb\u9886\u53d6\uff1avipID:" + vipID + ",limitQty\uff1a" + limitQty + ",vipHasRecNum:" + vipHasRecNum + ",singleQty:" + singleQty + ",allGiftsNum:" + allGiftsNum);
                if (isExceedTotalQty || isExceedVipGetMaxQty) {
                    ((ExtBillView)this.view).showMessage("\u9886\u53d6\u6570\u91cf\u8d85\u51fa\u9650\u5236\uff01", MessageBoxType.Toast);
                    ((ExtBillView)this.view).updateControlName("receive", "\u5df2\u9886\u5b8c", event.getCurrentRow().getRow());
                    ((ExtBillView)this.view).disable("receive", true, event.getCurrentRow().getRow());
                    return;
                }
                this.createGiftRecBill(event, singleQty);
                break;
            }
        }
        super.onClick(event);
    }

    private void createGiftRecBill(ClickEvent event, BigDecimal singleQty) {
        long memberId = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData("giftlist", event.getCurrentRow().getRow());
        long itemId = entryRowData.getLong("itemid");
        long storeId = ((BillFormData)this.getBillData()).getLong("storeid");
        long orgId = OlstoreInventoryHelper.getSaleOrgIdByChannelId((long)storeId);
        int singgelimit = entryRowData.getInt("singgelimit");
        String telephone = "";
        JSONObject resultJson = OlstoreMemberHelper.getMemberInfoById((long)memberId);
        if (resultJson != null && resultJson.getInteger("code") == 0) {
            QueryUserByIdVO vo = (QueryUserByIdVO)JSON.parseObject((String)resultJson.getJSONObject("data").toString(), QueryUserByIdVO.class);
            telephone = vo.getMobile();
        }
        HashMap<String, Object> giftParams = new HashMap<String, Object>();
        long giftSetId = ((BillFormData)this.billData).getLong("giftsetid");
        giftParams.put("memberid", memberId);
        giftParams.put("storeid", storeId);
        giftParams.put("orgid", orgId);
        giftParams.put("telephone", telephone);
        giftParams.put("activityname", giftSetId);
        giftParams.put("singleQty", singleQty);
        ArrayList giftsList = new ArrayList();
        HashMap<String, Object> goodsParams = new HashMap<String, Object>();
        goodsParams.put("item", itemId);
        goodsParams.put("receivenum", singgelimit);
        SimpleMap localStorage = event.getLocalStorage();
        String guider = localStorage.getString("guideid");
        long guiderId = StringUtils.isEmpty((CharSequence)guider) ? 0L : Long.parseLong(guider);
        giftParams.put("guiderId", guiderId);
        goodsParams.put("guider", guiderId);
        goodsParams.put("guidephone", localStorage.getString("guidephone"));
        giftsList.add(goodsParams);
        giftParams.put("giftsList", giftsList);
        JSONObject result = OlsGiftRecBillHelper.createGiftRecBill(giftParams);
        logger.info("\u793c\u54c1\u8425\u9500\u6d3b\u52a8\u70b9\u51fb\u9886\u53d6\u7ed3\u679c\uff1a vipID:" + memberId + ",result:" + result.getString("message"));
        OlsGiftRecBillHelper.saveRecGiftsNum((Long)storeId, (Long)giftSetId, (Long)itemId);
        Boolean isSuccess = result.getBoolean("success");
        String code = result.getString("code");
        if (isSuccess.booleanValue()) {
            ((ExtBillView)this.view).showMessage("\u9886\u53d6\u6210\u529f\u3002");
            ((ExtBillView)this.view).refresh();
        } else if (!isSuccess.booleanValue() && "102".equals(code)) {
            ((ExtBillView)this.view).showMessage("\u9886\u53d6\u6570\u91cf\u8d85\u51fa\u9650\u5236\uff01", MessageBoxType.Toast);
            ((ExtBillView)this.view).updateControlName("receive", "\u5df2\u9886\u5b8c", event.getCurrentRow().getRow());
            ((ExtBillView)this.view).disable("receive", true, event.getCurrentRow().getRow());
        } else {
            ((ExtBillView)this.view).showMessage("\u9886\u53d6\u5931\u8d25");
        }
    }
}

