/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocepfp.common.entity.ImgObject;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.LocationEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocpos.business.olstore.OlstoreCartHelper;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.common.enums.RecomItemTypeEnum;
import kd.occ.ocpos.common.util.DistanceUitl;
import kd.occ.ocpos.common.util.OlstoreUtil;
import org.apache.commons.lang.StringUtils;

public class PosIndexPlugin
extends ExtBillViewPlugin {
    private static final String itemlist = "windowlist";
    private static final String cid_storename = "storename";
    private static final int window_item_num = 4;
    protected static Log logger = LogFactory.getLog(PosIndexPlugin.class);
    private static String joinShareUrl = "";
    private static final double NEAR_STORE_DISTANCE = 5000.0;

    public void afterBindData(LoadDataEvent event) {
        long customerId = 0L;
        String customerName = "";
        DynamicObject defaultStore = OlstoreStoreInfoHelper.getDefaultStore();
        JSONObject storeJson = OlstoreUtil.getCurrentStore((ClientEvent)event);
        if (storeJson != null) {
            customerId = storeJson.getLong("id");
            customerName = storeJson.getString("name");
        } else {
            storeJson = new JSONObject();
            storeJson.put("id", (Object)defaultStore.getLong("id"));
            storeJson.put("name", (Object)defaultStore.getString("name"));
            OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
            customerId = storeJson.getLong("id");
            customerName = storeJson.getString("name");
        }
        ((BillFormData)this.billData).updateValue("customerid", (Object)customerId);
        ((ExtBillView)this.view).updateFrontValue(cid_storename, (Object)customerName);
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        if (memberId > 0L) {
            this.initItemRecom(customerId);
        } else {
            ((ExtBillView)this.view).hide("recompanel", true);
        }
        DynamicObject olstoreConfig = OlstoreConfigHelper.getOlstoreConfig();
        if (olstoreConfig.getBoolean("issearch")) {
            ((ExtBillView)this.view).hide("searchpanel", false);
        } else {
            ((ExtBillView)this.view).hide("searchpanel", true);
        }
        this.initScrollImage(customerId);
        this.initItemWindow(customerId);
        boolean isHasScene = event.getEventParam().containsKey((Object)"customparam");
        if (isHasScene) {
            Object scene;
            Map customparam = (Map)event.getEventParam().get((Object)"customparam");
            String isShareStorage = event.getLocalStorage().getString("isshare_storage");
            if (kd.bos.orm.util.StringUtils.isEmpty((Object)isShareStorage) && (scene = customparam.get("scene")) != null) {
                logger.info("PosIndexLogger_scene:" + scene);
                OpenParam op = new OpenParam();
                op.setViewId("ocpos_itemdetails");
                op.addCustomParam("itemid", String.valueOf(scene));
                op.addCustomParam("from_item_share", "1");
                op.setTarget(OpenParam.OpenTarget.NewWindow);
                ((ExtBillView)this.getView()).showView(op);
                event.getCustomParam().clear();
            }
        }
        super.afterBindData(event);
    }

    private void initItemRecom(long customerId) {
        JSONObject result = OlstoreConfigHelper.getItemRecomList((long)customerId, (String)RecomItemTypeEnum.RECOMITEM_INDEX.getValue());
        if (result != null) {
            JSONArray itemRecomList = result.getJSONArray("itemRecomList");
            if (itemRecomList != null && itemRecomList.size() > 0) {
                ((BillFormData)this.billData).updateValue("recompanelname", (Object)result.getString("operatingsubject"));
                for (int i = 0; i < itemRecomList.size(); ++i) {
                    JSONObject itemRecom = itemRecomList.getJSONObject(i);
                    DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject("recomitemlist");
                    dataObject.set("recomitemid", (Object)itemRecom.getLong("itemid"));
                    dataObject.set("recomauxptyid", (Object)itemRecom.getLong("auxptyid"));
                    dataObject.set("recomspuid", (Object)itemRecom.getLong("spuid"));
                    dataObject.set("recomunitid", (Object)itemRecom.getLong("unitid"));
                    dataObject.set("recombarcodeid", (Object)itemRecom.getLong("barcodeid"));
                    dataObject.set("recomitemname", (Object)itemRecom.getString("itemname"));
                    dataObject.set("recomitemthumbnail", (Object)PictureUtil.getServerPictureUrl((String)itemRecom.getString("thumbnail")));
                    dataObject.set("recomitemprice", (Object)itemRecom.getBigDecimal("minmemberprice"));
                    ((BillFormData)this.getBillData()).addEntryRow("recomitemlist", dataObject);
                }
                ((ExtBillView)this.view).hide("recompanel", false);
            } else {
                ((ExtBillView)this.view).hide("recompanel", true);
            }
        } else {
            ((ExtBillView)this.view).hide("recompanel", true);
        }
    }

    private void addCart(DynamicObject data) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        long customerId = ((BillFormData)this.billData).getLong("customerid");
        long itemId = data.getLong("recomitemid");
        long auxptyId = data.getLong("recomauxptyid");
        long unitId = data.getLong("recomunitid");
        long barcodeId = data.getLong("recombarcodeid");
        BigDecimal qty = BigDecimal.ONE;
        int preCartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        OlstoreCartHelper.addCart((long)customerId, (long)memberId, (long)itemId, (long)unitId, (long)auxptyId, (long)barcodeId, (BigDecimal)qty, (int)0);
        int cartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        if (preCartSumCount != cartSumCount) {
            ((BillFormData)this.billData).updateValue("cartcount", (Object)cartSumCount);
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", MessageBoxType.Toast);
        } else {
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u3002", MessageBoxType.Toast);
        }
    }

    private int getCartSumCount() {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        return OlstoreCartHelper.getOlstoreCartCount((long)((BillFormData)this.billData).getLong("customerid"), (long)memberId, (long)((BillFormData)this.billData).getLong("itemid"), (long)((BillFormData)this.billData).getLong("auxptyid"), (int)0).intValue();
    }

    private void initItemWindow(long customerId) {
        Map itemWindowMap = OlstoreConfigHelper.getOlsWindowList((long)customerId, (int)0, (int)5);
        if (itemWindowMap == null || itemWindowMap.size() == 0) {
            return;
        }
        AtomicInteger autoIndex = new AtomicInteger(1);
        for (Map.Entry entryset : itemWindowMap.entrySet()) {
            int size;
            String key = (String)entryset.getKey();
            List values = (List)entryset.getValue();
            if (values == null || values.size() <= 0) continue;
            int index = autoIndex.getAndIncrement();
            if (index > 5) break;
            ((BillFormData)this.getBillData()).updateValue("windowname" + index, (Object)key.split("_")[1]);
            ((BillFormData)this.getBillData()).updateValue("windowkey" + index, (Object)key);
            if (values.size() > 4) {
                size = 4;
                ((ExtBillView)this.view).hide("more" + index, false);
            } else {
                size = values.size();
                ((ExtBillView)this.view).hide("more" + index, true);
            }
            for (int i = 0; i < size; ++i) {
                JSONObject itemInfo = (JSONObject)values.get(i);
                DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itemlist + index);
                dataObject.set("id", (Object)itemInfo.getLong("itemid"));
                dataObject.set("itemid_" + index, (Object)itemInfo.getLong("itemid"));
                dataObject.set("thumbnail_" + index, (Object)PictureUtil.getServerPictureUrl((String)itemInfo.getString("thumbnail")));
                dataObject.set("itemname_" + index, (Object)itemInfo.getString("itemname"));
                dataObject.set("barcodeid_" + index, (Object)itemInfo.getString("barcodeid"));
                dataObject.set("taxprice_" + index, (Object)itemInfo.getBigDecimal("memberprice"));
                ((BillFormData)this.getBillData()).addEntryRow(itemlist + index, dataObject);
            }
            ((ExtBillView)this.view).hide("window" + index, false);
        }
    }

    private void initScrollImage(long customerId) {
        DynamicObject[] data = OlstoreConfigHelper.getOlsScrollImage((long)customerId);
        if (data == null || data.length == 0) {
            return;
        }
        DynamicObject scrollImageInfo = data[0];
        DynamicObjectCollection scrollImageList = scrollImageInfo.getDynamicObjectCollection("entryentity");
        Collections.sort(scrollImageList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return Integer.compare(o1.getInt("sort"), o2.getInt("sort"));
            }
        });
        ArrayList<ImgObject> scrollImgList = new ArrayList<ImgObject>(scrollImageList.size());
        AtomicInteger index = new AtomicInteger();
        for (DynamicObject imageInfo : scrollImageList) {
            int rowid = index.getAndIncrement();
            ImgObject i = new ImgObject();
            i.setId("scrollimage" + rowid);
            i.setSrc(PictureUtil.getServerPictureUrl((String)imageInfo.getString("picture")));
            boolean allowShowUrl = this.isAllowShowUrl(imageInfo, customerId);
            if (allowShowUrl && StringUtils.isNotBlank((String)imageInfo.getString("jumpurl"))) {
                i.setHref(imageInfo.getString("jumpurl"));
            }
            scrollImgList.add(i);
        }
        ((BillFormData)this.billData).updateValue("scrollImg", scrollImgList);
    }

    public boolean isAllowShowUrl(DynamicObject imageInfo, long customerId) {
        boolean result = true;
        String jumpUrl = imageInfo.getString("jumpurl");
        if (!jumpUrl.contains("view:")) {
            return false;
        }
        if (jumpUrl.contains("?")) {
            String[] split = jumpUrl.split("\\?");
            JSONObject jsonObject = OlstoreUtil.transUrltoJSONObject((String)split[1]);
            String jumpType = imageInfo.getString("jumptype");
            QFilter listFilter = this.getListFilter();
            switch (jumpType) {
                case "ocdbd_market_promote": {
                    Long promotionId = jsonObject.getLong("promotionid");
                    listFilter.and("id", "=", (Object)promotionId);
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"ocdbd_market_promote", (String)"id", (QFilter[])new QFilter[]{listFilter});
                    if (collection != null && collection.size() != 0) break;
                    result = false;
                    break;
                }
                case "ocdbd_olinvitate": {
                    Long olinvitationId = jsonObject.getLong("olinvitationid");
                    listFilter.and("id", "=", (Object)olinvitationId);
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"ocdbd_olinvitate", (String)"id", (QFilter[])new QFilter[]{listFilter});
                    if (collection != null && collection.size() != 0) break;
                    result = false;
                    break;
                }
                case "ocdbd_giftset": {
                    Long giftId = jsonObject.getLong("giftId");
                    QFilter giftFilter = this.getGiftFilter();
                    giftFilter.and("id", "=", (Object)giftId);
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"ocdbd_giftset", (String)"id", (QFilter[])new QFilter[]{giftFilter});
                    if (collection != null && collection.size() != 0) break;
                    result = false;
                    break;
                }
                case "ocdbd_iteminfo": {
                    JSONArray data;
                    JSONObject returnData = OlstoreItemHelper.getItemDetail((String)String.valueOf(customerId), (String)"0", (String)jsonObject.getString("itemid"), (String)OlstoreUtil.buildItemParamAppendStr());
                    if ("0000".equals(returnData.get((Object)"code").toString()) && ((data = returnData.getJSONArray("data")) == null || data.size() == 0)) {
                        result = false;
                    }
                    if (result) break;
                    break;
                }
            }
        }
        return result;
    }

    protected QFilter getListFilter() {
        Date currentTime = TimeServiceHelper.now();
        QFilter filter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("starttime", "<", (Object)currentTime);
        filter.and("endtime", ">", (Object)currentTime);
        return filter;
    }

    protected QFilter getGiftFilter() {
        Date currentTime = TimeServiceHelper.now();
        QFilter filter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("startdate", "<", (Object)currentTime);
        filter.and("enddate", ">", (Object)currentTime);
        return filter;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "store_icon": 
            case "storename": 
            case "store_change": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_selectstore");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "search_icon": 
            case "searcharea": 
            case "searchpanel": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_search");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "more1": 
            case "more2": 
            case "more3": 
            case "more4": 
            case "more5": {
                this.goWindowItemList(eventId);
                break;
            }
            case "recomitemthumbnail": 
            case "recomitemname": {
                DynamicObject data = ((BillFormData)this.getBillData()).getEntryRowData("recomitemlist", event.getCurrentRow());
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_itemdetails");
                openParam.addCustomParam("itemid", data.getString("recomitemid"));
                openParam.addCustomParam("auxptyid", data.getString("recomauxptyid"));
                openParam.addCustomParam("spuid", data.getString("recomspuid"));
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "addcart": {
                DynamicObject data = ((BillFormData)this.getBillData()).getEntryRowData("recomitemlist", event.getCurrentRow());
                this.addCart(data);
                break;
            }
            case "getcoupons": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_receiveticket_list");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    private void goWindowItemList(String eventId) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        String[] index = eventId.split("more");
        String windowname = ((BillFormData)this.getBillData()).getString("windowkey" + index[1]);
        openParam.addCustomParam("windowname", windowname);
        openParam.setViewId("ocpos_windowitemlist");
        ((ExtBillView)this.getView()).showView(openParam);
    }

    protected void onRowSelected(SelectAllEvent event) {
        String eventId = event.getId();
        if (eventId != null && eventId.contains(itemlist)) {
            int entryIndex = Integer.parseInt(eventId.replace(itemlist, ""));
            DynamicObject data = ((BillFormData)this.getBillData()).getEntryRowData(eventId, event.getCurrentRow(eventId).getRow());
            OpenParam openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setViewId("ocpos_itemdetails");
            openParam.addCustomParam("itemid", data.getString("itemid_" + entryIndex));
            openParam.addCustomParam("barcodeid", data.getString("barcodeid_" + entryIndex));
            openParam.addCustomParam("sourceviewid", "ocpos_index");
            ((ExtBillView)this.getView()).showView(openParam);
        }
        super.onRowSelected(event);
    }

    public void onLocation(LocationEvent event) {
        if (event.isAllow()) {
            DynamicObject olstoreCogInfo;
            BigDecimal distancestore;
            double nearStoreDistance;
            double distance;
            BigDecimal latitude = new BigDecimal(String.valueOf(event.getLatitude()));
            BigDecimal longitude = new BigDecimal(String.valueOf(event.getLongitude()));
            ((ExtBillView)this.view).putLocalStorage("latitude", String.valueOf(event.getLatitude()));
            ((ExtBillView)this.view).putLocalStorage("longitude", String.valueOf(event.getLongitude()));
            logger.info("\u9996\u9875\u63d2\u4ef6-\u83b7\u53d6\u672c\u5730\u7f13\u5b58\u6240\u6709\u6570\u636e\uff1a" + event.getLatitude() + "," + event.getLongitude());
            DynamicObject nearStore = OlstoreStoreInfoHelper.getNearestStore((BigDecimal)longitude, (BigDecimal)latitude);
            if (nearStore != null && (distance = DistanceUitl.GetDistance((BigDecimal)nearStore.getBigDecimal("latitude"), (BigDecimal)nearStore.getBigDecimal("longitude"), (BigDecimal)latitude, (BigDecimal)longitude)) <= (nearStoreDistance = (distancestore = (olstoreCogInfo = OlstoreConfigHelper.getOlstoreConfig()).getBigDecimal("distancestore")).multiply(new BigDecimal("1000")).doubleValue())) {
                JSONObject storeJson = new JSONObject();
                storeJson.put("id", (Object)nearStore.getLong("id"));
                storeJson.put("name", (Object)nearStore.getString("name"));
                OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
            }
        } else {
            SimpleMap localStorage = event.getLocalStorage();
            if (!"0".equals(localStorage.getString("istriggeronLocation"))) {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_authorized_location");
                ((ExtBillView)this.getView()).showView(openParam);
            }
        }
        super.onLocation(event);
    }

    public String initPageTitle(InitViewEvent initViewEvent) {
        DynamicObject olstoreCogInfo = OlstoreConfigHelper.getOlstoreConfig();
        if (olstoreCogInfo != null) {
            return olstoreCogInfo.getString("name");
        }
        return super.initPageTitle(initViewEvent);
    }
}

