/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.common.util.EmailUtils;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SelectedRow;
import kd.occ.ocepfp.core.form.control.controls.Option;
import kd.occ.ocepfp.core.form.control.controls.Select;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import kd.occ.ocpos.common.enums.InvoiceTypeEnum;
import org.apache.commons.lang.StringUtils;

public class PosInvoiceApplyPlugin
extends ExtBillViewPlugin {
    protected static Log logger = LogFactory.getLog(PosInvoiceApplyPlugin.class);
    public static final String COMPANY_NAME = "companyname";

    public void afterDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        Long billId = Long.parseLong(event.getCustomParam().getString("billId"));
        data.set("billId", (Object)billId);
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billId);
        BigDecimal sumbalamount = orderInfo.getBigDecimal("sumbalamount");
        DynamicObjectCollection itemList = orderInfo.getDynamicObjectCollection("goodsentryentity");
        data.set("billId", (Object)billId);
        data.set("sumbalamount", (Object)sumbalamount);
        data.set("thumbnail", (Object)((DynamicObject)itemList.get(0)).getString("goodsid.thumbnail"));
        data.set("orderno", orderInfo.get("billno"));
    }

    public boolean initView(InitViewEvent initViewEvent) {
        Select invoiceTypeList = (Select)((ExtBillView)this.getView()).getControl("invoicetype");
        for (InvoiceTypeEnum invoiceType : InvoiceTypeEnum.values()) {
            Option option = new Option();
            option.setId(invoiceType.getValue());
            option.setValue((Object)invoiceType.getValue());
            option.setName(invoiceType.getName());
            invoiceTypeList.addChild((Object)option);
        }
        return true;
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "openquotype": {
                String openquotype = event.getBillData().getString("openquotype");
                if (openquotype.equals("A")) {
                    ((ExtBillView)this.view).hide("personalpanel", false);
                    ((ExtBillView)this.view).hide("companypanel", true);
                    break;
                }
                ((ExtBillView)this.view).hide("personalpanel", true);
                ((ExtBillView)this.view).hide("companypanel", false);
                break;
            }
        }
        super.onDataChange(event);
    }

    protected void onClick(ClickEvent event) {
        switch (event.getId().toLowerCase()) {
            case "submit": {
                String billId = ((BillFormData)this.billData).getString("billId");
                String invoicetype = ((BillFormData)this.billData).getString("invoicetype");
                String openquoType = ((BillFormData)this.billData).getString("openquotype");
                String name = ((BillFormData)this.billData).getString("name");
                String phonenumber = ((BillFormData)this.billData).getString("phonenumber");
                String email = ((BillFormData)this.billData).getString("email");
                String enterprisename = ((BillFormData)this.billData).getString(COMPANY_NAME);
                String taxnumber = ((BillFormData)this.billData).getString("taxnumber");
                String enterpriseaddr = ((BillFormData)this.billData).getString("enterpriseaddr");
                String enterprisetel = ((BillFormData)this.billData).getString("enterprisetel");
                String bank = ((BillFormData)this.billData).getString("bank");
                String bankaccount = ((BillFormData)this.billData).getString("bankaccount");
                String enterprisephone = ((BillFormData)this.billData).getString("enterprisephone");
                String enterpriseemail = ((BillFormData)this.billData).getString("enterpriseemail");
                Pattern pattern = Pattern.compile("^1[3|4|5|7|8][0-9]\\d{4,8}$");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_invoice_confirm");
                openParam.addCustomParam("invoicetype", invoicetype);
                openParam.addCustomParam("openquotype", openquoType);
                if (openquoType.equals("A")) {
                    if (StringUtils.isEmpty((String)name)) {
                        ((ExtBillView)this.view).showMessage("\u8bf7\u586b\u5199\u9700\u8981\u5f00\u5177\u53d1\u7968\u7684\u59d3\u540d");
                        return;
                    }
                    if (StringUtils.isEmpty((String)phonenumber)) {
                        ((ExtBillView)this.view).showMessage("\u8bf7\u8f93\u5165\u5f00\u5177\u53d1\u7968\u4eba\u7684\u624b\u673a\u53f7\u7801");
                        return;
                    }
                    if (!pattern.matcher(phonenumber).matches()) {
                        ((ExtBillView)this.view).showMessage("\u5f00\u5177\u53d1\u7968\u4eba\u7684\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002");
                        return;
                    }
                    if (StringUtils.isEmpty((String)email)) {
                        ((ExtBillView)this.view).showMessage("\u8bf7\u8f93\u5165\u5f00\u5177\u53d1\u7968\u4eba\u7684\u90ae\u7bb1\u5730\u5740");
                        return;
                    }
                    if (!EmailUtils.isValidEmail((String)email)) {
                        ((ExtBillView)this.view).showMessage("\u5f00\u5177\u53d1\u7968\u4eba\u7684\u90ae\u7bb1\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002");
                        return;
                    }
                    openParam.addCustomParam("name", name);
                    openParam.addCustomParam("phonenumber", phonenumber);
                    openParam.addCustomParam("email", email);
                } else {
                    if (StringUtils.isEmpty((String)enterprisename)) {
                        ((ExtBillView)this.view).showMessage("\u8bf7\u586b\u5199\u9700\u8981\u5f00\u5177\u53d1\u7968\u7684\u4f01\u4e1a\u540d\u79f0");
                        return;
                    }
                    if (StringUtils.isEmpty((String)taxnumber)) {
                        ((ExtBillView)this.view).showMessage("\u8bf7\u586b\u5199\u9700\u8981\u5f00\u5177\u53d1\u7968\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
                        return;
                    }
                    if (StringUtils.isEmpty((String)enterprisetel)) {
                        ((ExtBillView)this.view).showMessage("\u8bf7\u8f93\u5165\u624b\u673a\u53f7\u7801");
                        return;
                    }
                    if (!pattern.matcher(enterprisetel).matches()) {
                        ((ExtBillView)this.view).showMessage("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002");
                        return;
                    }
                    if (StringUtils.isEmpty((String)enterpriseemail)) {
                        ((ExtBillView)this.view).showMessage("\u8bf7\u8f93\u5165\u4f01\u4e1a\u90ae\u7bb1");
                        return;
                    }
                    if (!EmailUtils.isValidEmail((String)enterpriseemail)) {
                        ((ExtBillView)this.view).showMessage("\u4f01\u4e1a\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002");
                        return;
                    }
                    openParam.addCustomParam("enterprisename", enterprisename);
                    openParam.addCustomParam("taxnumber", taxnumber);
                    openParam.addCustomParam("enterpriseaddr", enterpriseaddr);
                    openParam.addCustomParam("enterprisetel", enterprisetel);
                    openParam.addCustomParam("bank", bank);
                    openParam.addCustomParam("bankaccount", bankaccount);
                    openParam.addCustomParam("enterprisephone", enterprisephone);
                    openParam.addCustomParam("enterpriseemail", enterpriseemail);
                }
                openParam.addCustomParam("billId", billId);
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    protected void beforeQueryF7(SelectDataEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "enterprisename": {
                String newValue = event.getQueryText() == null ? "" : event.getQueryText();
                logger.info("\u5f00\u7968\u7533\u8bf7\u516c\u53f8\u62ac\u5934\u641c\u7d22\uff0cnewValue\uff1a" + newValue);
                JSONArray jsonArray = (JSONArray)DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"TitleServiceImpl", (String)"queryTitle", (Object[])new Object[]{newValue});
                logger.info("\u5f00\u7968\u7533\u8bf7\u516c\u53f8\u62ac\u5934\u641c\u7d22\u7ed3\u679c\uff0cresult\uff1a" + jsonArray);
                if (jsonArray != null && jsonArray.size() > 0) {
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        jsonObject.put("number", jsonObject.get((Object)"taxNo"));
                        jsonObject.put("id", (Object)(jsonObject.get((Object)"taxNo") + "_" + jsonObject.get((Object)"name")));
                    }
                    logger.info("\u5f00\u7968\u7533\u8bf7\u516c\u53f8\u62ac\u5934\u641c\u7d22\u7ed3\u679c\uff0cresult\uff1a" + jsonArray);
                    ListDataSet dataList = new ListDataSet();
                    dataList.setRows((Object)jsonArray);
                    dataList.setPage(0);
                    dataList.setPageSize(30);
                    dataList.setRecordCount(5);
                    ((ExtBillView)this.view).dropSelectData(eventId, (Object)dataList);
                }
                event.setPreventDefault(true);
                break;
            }
        }
    }

    protected void beforeF7HanderData(DataChangeEvent event, List<SelectedRow> selectRows) {
        super.beforeF7HanderData(event, selectRows);
        String pkValue = (String)selectRows.get(0).getPkValue();
        if (StringUtils.isNotBlank((String)pkValue)) {
            String[] s = pkValue.split("_");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)s[0]);
            jsonObject.put("name", (Object)s[1]);
            ((BillFormData)this.billData).updateValue("enterprisename", (Object)jsonObject);
            ((BillFormData)this.billData).updateValue("taxnumber", (Object)s[0]);
            ((BillFormData)this.billData).updateValue(COMPANY_NAME, (Object)s[1]);
            ((BillFormData)this.getBillData()).getFormModifiedManager().setHeadModified();
        }
        event.setPreventDefault(true);
    }
}

