/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.entity.ImgObject;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import kd.occ.ocpos.common.enums.InvoiceTypeEnum;
import kd.occ.ocpos.common.enums.OpenQuoTypeEnum;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;

public class PosInvoiceDetailPlugin
extends ExtBillViewPlugin {
    protected static Log logger = LogFactory.getLog(PosInvoiceDetailPlugin.class);

    public void afterDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        Long billId = Long.parseLong(event.getCustomParam().getString("billId"));
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billId);
        Map invoiceInfo = SaleOrderDBHelper.queryInvoiceInfo((DynamicObject)orderInfo);
        BigDecimal sumbalamount = (BigDecimal)invoiceInfo.get("entryinvoiceamount");
        sumbalamount = sumbalamount.setScale(2);
        String openquoType = (String)invoiceInfo.get("entryinvoicetype");
        String invoiceType = orderInfo.getString("invoicetype");
        String taxNumber = (String)invoiceInfo.get("entrycompanytaxno");
        String invoiceTitle = (String)invoiceInfo.get("entryinvoicetitle");
        Date invoiceDateTime = (Date)invoiceInfo.get("entryinvoicedatetime");
        if ("A".equals(openquoType)) {
            ((ExtBillView)this.view).hide("taxnumber", true);
        } else {
            data.set("taxnumber", (Object)taxNumber);
            ((ExtBillView)this.view).hide("taxnumber", false);
        }
        data.set("invoicetitle", (Object)invoiceTitle);
        data.set("invoicetype", (Object)InvoiceTypeEnum.getName((String)invoiceType));
        data.set("openquotype", (Object)OpenQuoTypeEnum.getName((String)openquoType));
        data.set("billid", (Object)billId);
        data.set("sumbalamount", (Object)sumbalamount);
        data.set("invoiceamount", (Object)sumbalamount);
        data.set("goodsprice", (Object)sumbalamount);
        data.set("invoicedatetime", (Object)invoiceDateTime);
        data.set("billno", (Object)orderInfo.getString("billno"));
        data.set("createtime", (Object)orderInfo.getDate("createtime"));
        data.set("applydatetime", (Object)orderInfo.getDate("invoiceapplytime"));
        List<ImgObject> imgObjects = this.getImgObjects(invoiceInfo);
        ((BillFormData)this.billData).updateImgGroup("invoicepdfurl", imgObjects);
        data.set("pdfnumber", (Object)imgObjects.size());
        DynamicObjectCollection itemList = orderInfo.getDynamicObjectCollection("goodsentryentity");
        List goodsImgs = OlstoreUtil.getGoodsImgs((DynamicObjectCollection)itemList);
        ((BillFormData)this.billData).updateImgGroup("thumbnail", goodsImgs);
        data.set("goodsqty", (Object)itemList.size());
    }

    private List<ImgObject> getImgObjects(Map<String, Object> invoiceInfo) {
        ArrayList<ImgObject> imgObjects = new ArrayList<ImgObject>();
        String invoicePdfUrl = (String)invoiceInfo.get("entryinvoicepdfurl");
        if (StringUtil.isNotNull((String)invoicePdfUrl)) {
            ImgObject img = new ImgObject();
            img.setSrc("invoicePdfUrl");
            imgObjects.add(img);
        }
        return imgObjects;
    }
}

