/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.ButtonFastClickUtil;
import kd.occ.ocbase.common.util.CalendarUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocepfp.common.entity.CallBackArgu;
import kd.occ.ocepfp.common.entity.ImgObject;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.CustomEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.MessageCallBackEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.service.admindivision.AdminDivisionHelper;
import kd.occ.ocpos.business.olstore.OlsActivityCfyHelper;
import kd.occ.ocpos.business.olstore.OlstoreCartHelper;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.business.promotion.OlstorePromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.common.entity.request.CxPromotionRequestEntity;
import kd.occ.ocpos.common.entity.request.CxPromotionResultEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.enums.RecomItemTypeEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class PosItemDetailsMobileBillPlugin
extends ExtBillViewPlugin {
    private static final String ADMINDIVISION = "bd_admindivision";
    public static final int PICTURE_NUM = 10;
    private static final int MIN_CLICK_DELAY_TIME = 2000;
    private static Log logger = LogFactory.getLog(PosItemDetailsMobileBillPlugin.class);
    private static final String modellist = "modellist";
    private static final String modelpanel = "modelpanel";
    private static final String detailpanel = "detailpanel";
    private static final String loginpanel = "loginpanel";

    public void afterDataLoad(LoadDataEvent event) {
        JSONArray products;
        Long customerId;
        String sourceviewId;
        String auxptyId;
        String barcodeId;
        String spuId;
        String itemId;
        long startTime = System.currentTimeMillis();
        logger.info("PosItemDetailsMobileBillPlugin_afterDataLoad_Sourceviewid=" + JSON.toJSONString((Object)((ExtBillView)this.view).getExtCtx().getForm()));
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        boolean isFromItemShare = event.getCustomParam().containsKey((Object)"from_item_share");
        String ticketId = event.getCustomParam().getString("ticketid");
        ((BillFormData)this.billData).updateValue("ticketid", (Object)ticketId);
        if (isFromItemShare) {
            ((ExtBillView)this.view).putLocalStorage("isshare_storage", "1");
        }
        String paramId = StringUtils.isNotBlank((CharSequence)event.getCustomParam().getString("paramid")) ? event.getCustomParam().getString("paramid") : event.getCustomParam().getString("id");
        logger.info("PosItemDetailsMobileBillPlugin afterDataLoad \u5bfc\u8d2d\u52a9\u624b\u53c2\u6570paramId\uff1a" + paramId);
        if (StringUtils.isNotBlank((CharSequence)paramId)) {
            JSONObject guideParam = OlstoreUtil.getGuideParamJSONObject((String)paramId);
            itemId = guideParam.getString("itemid");
            spuId = guideParam.getString("spuid");
            barcodeId = "";
            auxptyId = guideParam.getString("auxptyid");
            sourceviewId = guideParam.getString("sourceviewid");
            String guideId = guideParam.getString("guideid");
            String billno = guideParam.getString("billno");
            String role = guideParam.getString("role");
            customerId = guideParam.getLong("storeid");
            String storeName = guideParam.getString("storename");
            if (customerId != null && StringUtils.isNotBlank((CharSequence)storeName)) {
                JSONObject storeJson = new JSONObject();
                storeJson.put("id", (Object)customerId);
                storeJson.put("name", (Object)storeName);
                OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
            }
            String sourcetype = guideParam.getString("sourcetype");
            logger.info("PosItemDetailsMobileBillPlugin afterDataLoad \u5bfc\u8d2d\u52a9\u624b\u53c2\u6570\uff1a" + guideParam + "\u4f1a\u5458\u4fe1\u606f:" + memberId);
            if (memberId != 0L && ((ExtBillView)this.view).getExtCtx().isFromMiniProgram()) {
                OlstoreUtil.regularMarketClick((String)billno, (String)guideId, (String)String.valueOf(memberId), (String)String.valueOf(customerId), (String)role, (String)sourcetype);
            }
            this.updateCurStore(customerId, storeName, guideId);
        } else {
            itemId = event.getCustomParam().getString("itemid");
            barcodeId = event.getCustomParam().getString("barcodeid");
            spuId = event.getCustomParam().getString("spuid") == null ? "0" : event.getCustomParam().getString("spuid");
            auxptyId = event.getCustomParam().getString("auxptyid") == null ? "0" : event.getCustomParam().getString("auxptyid");
            sourceviewId = event.getCustomParam().getString("sourceviewid");
            JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
            if (currentStore != null) {
                customerId = currentStore.getLong("id");
            } else {
                DynamicObject defaultStore = OlstoreStoreInfoHelper.getDefaultStore();
                customerId = defaultStore.getLong("id");
            }
        }
        if (memberId == 0L) {
            ((ExtBillView)this.view).hide("noinventorypanel", true);
            ((ExtBillView)this.view).disable("addcart", false);
            ((ExtBillView)this.view).disable("quickorder", false);
            ((ExtBillView)this.view).hide(loginpanel, false);
            ((ExtBillView)this.view).hide("recompanel", true);
        } else {
            ((ExtBillView)this.view).hide(loginpanel, true);
            this.initItemRecom(customerId);
        }
        long start = System.currentTimeMillis();
        logger.info("\u5546\u54c1\u8be6\u60c5\u8017\u65f6\u7edf\u8ba1  this.getCurDistrictId consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        if (!StringUtils.isNotBlank((CharSequence)spuId) || spuId.length() == 1) {
            JSONObject itemInfo1 = StringUtils.isNotBlank((CharSequence)barcodeId) ? (JSONObject)JSONObject.parseArray((String)OlstoreItemHelper.getItemDetail((String)String.valueOf(customerId), (String)spuId, (String)itemId, (String)OlstoreUtil.buildItemParamAppendStr()).getJSONArray("data").toJSONString(), JSONObject.class).stream().filter(p -> p.getString("itemid").equals(itemId) && p.getString("barcodeid").equals(barcodeId)).findFirst().orElse(null) : (JSONObject)JSONObject.parseArray((String)OlstoreItemHelper.getItemDetail((String)String.valueOf(customerId), (String)spuId, (String)itemId, (String)OlstoreUtil.buildItemParamAppendStr()).getJSONArray("data").toJSONString(), JSONObject.class).stream().filter(p -> p.getString("itemid").equals(itemId)).findFirst().orElse(null);
            if (itemInfo1 != null) {
                spuId = itemInfo1.getString("spuid");
            } else {
                ((ExtBillView)this.view).showMessage("\u5546\u54c1\u4e0d\u5b58\u5728\u3002");
                return;
            }
        }
        start = System.currentTimeMillis();
        HashSet<Long> hashSet = new HashSet<Long>();
        JSONObject returnData = OlstoreItemHelper.getItemDetail((String)String.valueOf(customerId), (String)spuId, (String)itemId, (String)OlstoreUtil.buildItemParamAppendStr());
        if (returnData == null) {
            ((ExtBillView)this.view).showMessage("\u5546\u54c1\u4e0d\u5b58\u5728\u3002");
            return;
        }
        if (returnData != null && "0000".equals(returnData.get((Object)"code").toString()) && returnData.getJSONArray("data").size() > 0) {
            products = returnData.getJSONArray("data");
            for (int i = 0; i < products.size(); ++i) {
                hashSet.add(products.getJSONObject(i).getLong("itemid") + products.getJSONObject(i).getLong("barcodeid"));
            }
        }
        logger.info("\u5546\u54c1\u8be6\u60c5\u8017\u65f6\u7edf\u8ba1  OlstoreItemHelper.getItemDetail consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        logger.info("\u5546\u54c1\u8be6\u60c5\u8fd4\u56de\u7ed3\u679c\uff1a " + returnData);
        if (returnData != null && "0000".equals(returnData.get((Object)"code").toString()) && returnData.getJSONArray("data").size() > 0) {
            products = returnData.getJSONArray("data");
            int productCount = hashSet.size();
            ((ExtBillView)this.view).hide("auxpty_flexpanel", false);
            if (products != null && products.size() > 0) {
                List list = JSONObject.parseArray((String)products.toJSONString(), JSONObject.class);
                JSONObject itemInfo = productCount > 1 ? (StringUtils.isNotBlank((CharSequence)barcodeId) ? (JSONObject)list.stream().filter(p -> p.getString("itemid").equals(itemId) && p.getString("barcodeid").equals(barcodeId)).findFirst().orElse(null) : (JSONObject)list.stream().filter(p -> p.getString("itemid").equals(itemId) && p.getString("auxptyid").equals(auxptyId)).findFirst().orElse(null)) : (JSONObject)list.get(0);
                this.changeDeliveryModeByItem(Long.parseLong(itemId), customerId, event);
                String innerAuxptyId = itemInfo.getString("auxptyid");
                long unitId = itemInfo.getLong("unitid");
                this.updateSelectSpec(spuId, itemId, innerAuxptyId, unitId, BigDecimal.ONE);
                this.updateAttributeAndDetail(itemId);
                this.updateItemData(itemInfo, productCount, innerAuxptyId, itemId, spuId);
                ((BillFormData)this.billData).updateValue("memberid", (Object)memberId);
                ((BillFormData)this.billData).updateValue("customerid", (Object)customerId);
                PageCache pageCache = new PageCache(((ExtBillView)this.view).getPageId());
                pageCache.put("itemInfo", itemInfo.toJSONString());
                ((ExtBillView)this.view).addCustomEvent(new CustomEvent("asynInventory"));
            } else {
                ((ExtBillView)this.view).showMessage("\u5546\u54c1\u4e0d\u5b58\u5728\u3002");
            }
        } else {
            ((ExtBillView)this.view).showMessage("\u5546\u54c1\u4e0d\u5b58\u5728\u3002");
        }
        logger.info("\u5546\u54c1\u8be6\u60c5\u8017\u65f6\u7edf\u8ba1-\u603b\u8017\u65f6  consumes " + (System.currentTimeMillis() - startTime) + " \u6beb\u79d2\u3002");
    }

    private void changeDeliveryModeByItem(Long itemId, Long customerId, LoadDataEvent event) {
        QFilter contentFilter = new QFilter("id", "=", (Object)itemId);
        DynamicObject item = QueryServiceHelper.queryOne((String)"ocdbd_iteminfo", (String)"isdelivery", (QFilter[])contentFilter.toArray());
        if (item != null && item.getBoolean("isdelivery")) {
            long curDistrictId = this.getCurDistrictId(event, customerId);
            ((BillFormData)this.billData).updateValue("districtid", (Object)curDistrictId);
        } else {
            DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo((long)customerId);
            ((ExtBillView)this.view).hide("deliverytime", true);
            ((ExtBillView)this.view).hide("pickuptime", false);
            ((ExtBillView)this.view).hide("address", true);
            ((ExtBillView)this.view).hide("storename", false);
            ((BillFormData)this.billData).updateValue("pickuptime", (Object)CalendarUtil.getNowTime());
            ((BillFormData)this.billData).updateValue("storename", (Object)storeInfo.getString("name"));
        }
    }

    private void initItemRecom(long customerId) {
        JSONObject result = OlstoreConfigHelper.getItemRecomList((long)customerId, (String)RecomItemTypeEnum.RECOMITEM_ITEMDETAIL.getValue());
        if (result != null) {
            JSONArray itemRecomList = result.getJSONArray("itemRecomList");
            if (itemRecomList != null && itemRecomList.size() > 0) {
                ((BillFormData)this.billData).updateValue("recompanelname", (Object)result.getString("operatingsubject"));
                for (int i = 0; i < itemRecomList.size(); ++i) {
                    JSONObject itemRecom = itemRecomList.getJSONObject(i);
                    DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject("recomitemlist");
                    dataObject.set("recomitemid", (Object)itemRecom.getLong("itemid"));
                    dataObject.set("recomauxptyid", (Object)itemRecom.getLong("auxptyid"));
                    dataObject.set("recomspuid", (Object)itemRecom.getLong("spuid"));
                    dataObject.set("recomunitid", (Object)itemRecom.getLong("unitid"));
                    dataObject.set("recombarcodeid", (Object)itemRecom.getLong("barcodeid"));
                    dataObject.set("recomitemname", (Object)itemRecom.getString("itemname"));
                    dataObject.set("recomitemthumbnail", (Object)PictureUtil.getServerPictureUrl((String)itemRecom.getString("thumbnail")));
                    dataObject.set("recomitemprice", (Object)itemRecom.getBigDecimal("minmemberprice"));
                    ((BillFormData)this.getBillData()).addEntryRow("recomitemlist", dataObject);
                }
                ((ExtBillView)this.view).hide("recompanel", false);
            } else {
                ((ExtBillView)this.view).hide("recompanel", true);
            }
        } else {
            ((ExtBillView)this.view).hide("recompanel", true);
        }
    }

    private void updateAttributeAndDetail(String itemId) {
        DynamicObject itemInfo = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"ocdbd_iteminfo");
        String description = itemInfo.getString("description_tag");
        DynamicObjectCollection itemModelList = itemInfo.getDynamicObjectCollection("itemmodelentry");
        if (itemModelList != null && itemModelList.size() > 0) {
            for (DynamicObject itemModel : itemModelList) {
                DynamicObject model = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(modellist);
                model.set("modelkey", (Object)itemModel.getString("modelkey"));
                model.set("modelvalue", (Object)itemModel.getString("modelvalue"));
                ((BillFormData)this.getBillData()).addEntryRow(modellist, model);
            }
            ((ExtBillView)this.view).hide(modelpanel, false);
        } else {
            ((ExtBillView)this.view).hide(modelpanel, true);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            ((ExtBillView)this.view).hide(detailpanel, false);
            ((BillFormData)this.billData).updateValue("description", (Object)itemInfo.getString("description_tag"));
        } else {
            ((ExtBillView)this.view).hide(detailpanel, true);
        }
    }

    protected void onCustomEvent(CustomEvent event) {
        Long inventoryTypeByTicket;
        long startTime = System.currentTimeMillis();
        PageCache pageCache = ((ExtBillView)this.view).getPageCache();
        long customerId = ((BillFormData)this.billData).getLong("customerid");
        long unitId = ((BillFormData)this.billData).getLong("unitid");
        long memberId = ((BillFormData)this.billData).getLong("memberid");
        String storename = ((BillFormData)this.billData).getString("storename");
        String itemId = ((BillFormData)this.billData).getString("itemid");
        String innerAuxptyId = ((BillFormData)this.billData).getString("auxptyid");
        String ticketId = ((BillFormData)this.billData).getString("ticketid");
        JSONObject itemInfo = JSONObject.parseObject((String)pageCache.get("itemInfo"));
        DynamicObject branchDyn = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"ocdbd_channel", (String)"saleorg");
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branchDyn, (String)"saleorg");
        long invTypeId = StringUtils.isNotBlank((CharSequence)ticketId) ? ((inventoryTypeByTicket = OlstoreTicketHelper.getInventoryTypeByTicket((long)Long.parseLong(ticketId))) != null && inventoryTypeByTicket > 0L ? inventoryTypeByTicket : SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)customerId)) : SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)customerId);
        long start = System.currentTimeMillis();
        if (StringUtil.isNotNull((String)storename)) {
            this.checkPickUp(itemInfo, customerId, saleOrgId, invTypeId);
        } else {
            long curDistrictId = ((BillFormData)this.billData).getLong("districtid");
            curDistrictId = OlstoreStoreInfoHelper.getNewListrictId((long)curDistrictId);
            this.checkInventory(itemInfo, saleOrgId, customerId, curDistrictId, invTypeId);
        }
        logger.info("\u5546\u54c1\u8be6\u60c5\u8017\u65f6\u7edf\u8ba1  this.inventoryCheckInItemDetail consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        if (memberId != 0L) {
            start = System.currentTimeMillis();
            this.loadDiscount(memberId, customerId, itemId, unitId, innerAuxptyId);
            logger.info("\u5546\u54c1\u8be6\u60c5\u8017\u65f6\u7edf\u8ba1  this.loadDiscount consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        }
        logger.info("\u5546\u54c1\u8be6\u60c5\u8017\u65f6\u7edf\u8ba1-\u5f02\u6b65\u603b\u8017\u65f6 this.loadDiscount consumes " + (System.currentTimeMillis() - startTime) + " \u6beb\u79d2\u3002");
        if (StringUtils.isNotBlank((CharSequence)ticketId)) {
            ((ExtBillView)this.view).disable("addcart", true);
        } else {
            ((ExtBillView)this.view).disable("addcart", false);
        }
        super.onCustomEvent(event);
    }

    private void checkPickUp(JSONObject itemInfo, long customerId, long saleOrgId, long invTypeId) {
        DynamicObject wareHouse = OlstoreInventoryHelper.getIdsFromOcocicWareHouse((long)customerId);
        if (wareHouse == null) {
            ((ExtBillView)this.view).showMessage("\u5f53\u524d\u95e8\u5e97\u672a\u914d\u7f6e\u6e20\u9053\u4ed3\u5e93\u5bf9\u5e94\u7684\u9ed8\u8ba4\u53d1\u8d27\u4ed3\u5e93\uff0c\u65e0\u6cd5\u67e5\u8be2\u5e93\u5b58");
            return;
        }
        long erpStockOrgid = wareHouse.getLong("erpstockorgid.id");
        long erpWarehouseId = wareHouse.getLong("erpwarehouseid.id");
        List inventoryParam = OlstoreInventoryHelper.buildInventoryParam((JSONObject)itemInfo, (long)saleOrgId, (long)customerId, (long)erpStockOrgid, (long)erpWarehouseId, (long)invTypeId, (BigDecimal)BigDecimal.ONE);
        logger.info("\u626b\u7801\u8d2d\u5e93\u5b58\u67e5\u8be2\u53c2\u6570 param \uff1a" + inventoryParam);
        List inventoryResult = SaleOrderDeliveryInfoHelper.getInventoryInfo((List)inventoryParam);
        logger.info("\u626b\u7801\u8d2d\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c result \uff1a" + inventoryResult);
        ((ExtBillView)this.view).updateFrontValue("noinventorypanel", (Object)"\u8be5\u5546\u54c1\u5728\u5f53\u524d\u95e8\u5e97\u6682\u65e0\u5e93\u5b58");
        if (CollectionUtils.isEmpty((Collection)inventoryResult)) {
            ((ExtBillView)this.view).hide("noinventorypanel", false);
            ((ExtBillView)this.view).disable("addcart", true);
            ((ExtBillView)this.view).disable("quickorder", true);
            ((BillFormData)this.billData).updateValue("isinventory", (Object)Boolean.FALSE);
        } else {
            JSONObject inventoryItem = (JSONObject)inventoryResult.get(0);
            String invStatus = inventoryItem.getString("invstatus");
            if (!StringUtils.equals((CharSequence)invStatus, (CharSequence)"1")) {
                ((ExtBillView)this.view).hide("noinventorypanel", false);
                ((ExtBillView)this.view).disable("addcart", true);
                ((ExtBillView)this.view).disable("quickorder", true);
                ((BillFormData)this.billData).updateValue("isinventory", (Object)Boolean.FALSE);
            } else {
                ((ExtBillView)this.view).hide("noinventorypanel", true);
                ((ExtBillView)this.view).disable("addcart", false);
                ((ExtBillView)this.view).disable("quickorder", false);
                ((BillFormData)this.billData).updateValue("isinventory", (Object)Boolean.TRUE);
            }
        }
    }

    private void checkInventory(JSONObject itemInfo, long saleOrgId, long customerId, long curDistrictId, long invTypeId) {
        Map deliveryParams = OlstoreInventoryHelper.getDeliveryParams((JSONObject)itemInfo, (long)saleOrgId, (long)customerId, (long)curDistrictId, (BigDecimal)BigDecimal.ONE, (Date)CalendarUtil.getNextDayTime(), (long)invTypeId);
        Boolean enableSerial = OlstoreInventoryHelper.getEnableSerial((long)itemInfo.getLong("materielid"));
        ((BillFormData)this.billData).updateValue("enableserial", (Object)enableSerial);
        logger.info("\u5546\u54c1\u8be6\u60c5\u5e93\u5b58\u67e5\u8be2\u53c2\u6570 param \uff1a" + deliveryParams);
        Map deliveryResult = SaleOrderDeliveryInfoHelper.getDeliveryInfo((Map)deliveryParams, (boolean)false);
        logger.info("\u5546\u54c1\u8be6\u60c5\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c result \uff1a" + deliveryResult);
        this.updateDeliveryShow(deliveryResult);
    }

    private void checkInventory() {
        Map<String, Object> deliveryParams = this.getDeliveryParams();
        logger.info("\u5546\u54c1\u8be6\u60c5\u5e93\u5b58\u67e5\u8be2\u53c2\u6570 param \uff1a" + deliveryParams);
        Map deliveryResult = SaleOrderDeliveryInfoHelper.getDeliveryInfo(deliveryParams, (boolean)false);
        logger.info("\u5546\u54c1\u8be6\u60c5\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c result \uff1a" + deliveryResult);
        this.updateDeliveryShow(deliveryResult);
    }

    private void updateDeliveryShow(Map<String, Object> deliveryResult) {
        if (CollectionUtils.isEmpty(deliveryResult)) {
            ((ExtBillView)this.view).hide("noinventorypanel", false);
            ((ExtBillView)this.view).disable("addcart", true);
            ((ExtBillView)this.view).disable("quickorder", true);
            ((BillFormData)this.billData).updateValue("isinventory", (Object)Boolean.FALSE);
        } else {
            boolean isSuccess = CommonUtil.formatObjectToBoolean((Object)deliveryResult.get("isSuccess"));
            if (!isSuccess) {
                ((ExtBillView)this.view).hide("noinventorypanel", false);
                ((ExtBillView)this.view).disable("addcart", true);
                ((ExtBillView)this.view).disable("quickorder", true);
                ((BillFormData)this.billData).updateValue("isinventory", (Object)Boolean.FALSE);
            } else {
                ((ExtBillView)this.view).hide("noinventorypanel", true);
                ((ExtBillView)this.view).disable("addcart", false);
                ((ExtBillView)this.view).disable("quickorder", false);
                ((BillFormData)this.billData).updateValue("isinventory", (Object)Boolean.TRUE);
            }
        }
    }

    private Map<String, Object> getDeliveryParams() {
        long itemId = ((BillFormData)this.billData).getLong("itemid");
        long auxptyId = ((BillFormData)this.billData).getLong("auxptyid");
        long unitId = ((BillFormData)this.billData).getLong("unitid");
        long baseunitId = ((BillFormData)this.billData).getLong("baseunitid");
        long materielId = ((BillFormData)this.billData).getLong("materialid");
        Long branchId = ((BillFormData)this.billData).getLong("customerid");
        Date deliveryTime = ((BillFormData)this.billData).getDate("deliverytime");
        long districtId = ((BillFormData)this.billData).getLong("districtid");
        districtId = OlstoreStoreInfoHelper.getNewListrictId((long)districtId);
        DynamicObject branchDyn = BusinessDataServiceHelper.loadSingle((Object)branchId, (String)"ocdbd_channel", (String)"saleorg");
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branchDyn, (String)"saleorg");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("index", 0);
        params.put("saleOrgId", saleOrgId);
        params.put("saleChannelID", branchId);
        params.put("itemId", itemId);
        params.put("adminDivisionId", districtId);
        params.put("materialId", materielId);
        params.put("baseUnitID", baseunitId);
        params.put("baseUnitQty", new BigDecimal(1));
        params.put("unitId", unitId);
        params.put("unitQty", new BigDecimal(1));
        params.put("deliveryDate", deliveryTime);
        params.put("auxPtyID", auxptyId);
        params.put("bizdate", new Date());
        params.put("invtypeid", SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)branchId));
        return params;
    }

    private void updateItemData(JSONObject itemInfo, int productCount, String innerAuxptyId, String itemId, String spuId) {
        List<ImgObject> imgObjects = this.getImgObjects(itemInfo);
        long unitId = itemInfo.getLong("unitid");
        long baseunitId = itemInfo.getLong("baseunitid");
        long materielId = itemInfo.getLong("materielid");
        long customerId = ((BillFormData)this.billData).getLong("customerid");
        ((BillFormData)this.billData).updateValue("productcount", (Object)productCount);
        ((BillFormData)this.billData).updateImgGroup("itemimgs", imgObjects);
        ((BillFormData)this.billData).updateValue("auxptyid", (Object)innerAuxptyId);
        ((BillFormData)this.billData).updateValue("itemid", (Object)itemId);
        ((BillFormData)this.billData).updateValue("unitid", (Object)unitId);
        ((BillFormData)this.billData).updateValue("baseunitid", (Object)baseunitId);
        ((BillFormData)this.billData).updateValue("shorttitle", (Object)itemInfo.getString("shorttitle"));
        ((BillFormData)this.billData).updateValue("materialid", (Object)materielId);
        ((BillFormData)this.billData).updateValue("memberprice", (Object)itemInfo.getBigDecimal("memberprice"));
        ((BillFormData)this.billData).updateValue("retailprice", (Object)itemInfo.getBigDecimal("retailprice"));
        ((BillFormData)this.billData).updateValue("itemname", (Object)itemInfo.getString("itemname"));
        ((BillFormData)this.billData).updateValue("cartcount", (Object)this.getCartSumCount());
        ((BillFormData)this.billData).updateValue("barcodeid", (Object)itemInfo.getLong("barcodeid"));
        ((BillFormData)this.billData).updateValue("spuid", (Object)spuId);
        ((BillFormData)this.billData).updateValue("thumbnail", (Object)itemInfo.getString("thumbnail"));
        String activityPic = OlsActivityCfyHelper.getActivityPic((Long)customerId, (Long)Long.parseLong(itemId));
        if (StringUtil.isNotNull((String)activityPic)) {
            ((ExtBillView)this.view).hide("bottomimg", false);
            ((BillFormData)this.billData).updateValue("bottomimg", (Object)(PictureUtil.getFileServerUrl() + activityPic));
        } else {
            ((ExtBillView)this.view).hide("bottomimg", true);
        }
    }

    private long getCurDistrictId(LoadDataEvent event, Long customerId) {
        ((BillFormData)this.billData).updateValue("customerid", (Object)customerId);
        long districtId = 0L;
        ((ExtBillView)this.view).hide("deliverytime", false);
        ((ExtBillView)this.view).hide("pickuptime", true);
        ((ExtBillView)this.view).hide("address", false);
        ((ExtBillView)this.view).hide("storename", true);
        JSONObject currentAddress = OlstoreUtil.getCurrentAddress((ClientEvent)event);
        if (currentAddress != null) {
            ((BillFormData)this.billData).updateValue("districtid", (Object)currentAddress.getString("districtid"));
            ((BillFormData)this.billData).updateValue("address", (Object)currentAddress.getString("address"));
            ((BillFormData)this.billData).updateValue("addressid", (Object)currentAddress.getString("addressid"));
            districtId = Long.parseLong(currentAddress.getString("districtid"));
        } else {
            String addressId;
            String address;
            JSONObject addressObject = OlstoreMemberHelper.queryDefaultDeliveryAddress((long)((ExtBillView)this.view).getExtCtx().getMemberId());
            if (addressObject != null) {
                districtId = OlstoreStoreInfoHelper.getNewListrictId((long)addressObject.getLong("districtId"));
                String districtName = AdminDivisionHelper.getDivisionName((long)districtId);
                address = districtName + addressObject.getString("detailedAddress");
                addressId = addressObject.getString("id");
            } else {
                SimpleMap localStorage = event.getLocalStorage();
                String latitude = localStorage.getString("latitude");
                String longitude = localStorage.getString("longitude");
                logger.info("\u5546\u54c1\u8be6\u60c5\u63d2\u4ef6-\u83b7\u53d6\u672c\u5730\u7f13\u5b58\u6240\u6709\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)localStorage));
                JSONObject division = OlstoreInventoryHelper.getDivisionIdByLatLng((String)latitude, (String)longitude);
                districtId = division.getLong("districtId");
                ((BillFormData)this.billData).updateValue("districtid", (Object)districtId);
                address = division.getString("address");
                addressId = null;
            }
            ((BillFormData)this.billData).updateValue("districtid", (Object)districtId);
            ((BillFormData)this.billData).updateValue("address", (Object)address);
            ((BillFormData)this.billData).updateValue("addressid", (Object)addressId);
            JSONObject addressJson = new JSONObject();
            addressJson.put("districtid", (Object)String.valueOf(districtId));
            addressJson.put("address", (Object)address);
            addressJson.put("addressid", (Object)addressId);
            OlstoreUtil.setCurrentAddress((ExtDynamicView)((ExtDynamicView)this.view), (String)addressJson.toJSONString());
        }
        ((BillFormData)this.billData).updateValue("deliverytime", (Object)CalendarUtil.getNextDayTime());
        return districtId;
    }

    private void updateCurStore(Long customerId, String storeName, String guideId) {
        logger.info("PosItemDetailsMobileBillPlugin afterDataLoad storeId\uff1a" + customerId);
        JSONObject storeJson = new JSONObject();
        storeJson.put("id", (Object)customerId);
        storeJson.put("name", (Object)storeName);
        logger.info("\u8bbe\u7f6e\u5f53\u524d\u95e8\u5e97\u4e3a\u5bfc\u8d2d\u5458\u95e8\u5e97 id:" + customerId + ",name:" + storeName);
        OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
        ((BillFormData)this.billData).updateValue("guideid", (Object)guideId);
    }

    private void updateSelectSpec(String spuId, String itemId, String auxptyId, long unitId, BigDecimal qty) {
        String mapName;
        if (spuId.length() > 1) {
            DynamicObject spuMapName = OlstoreItemHelper.getSpuMapName((long)Long.parseLong(itemId), (long)Long.parseLong(auxptyId));
            mapName = spuMapName.getString("entryentity_specmap.spumapname");
        } else {
            String auxptyName = ((BillFormData)this.billData).getAuxpty(Long.parseLong(auxptyId), false).getAuxptyName();
            mapName = auxptyName.replace(':', '\uff1a');
        }
        ((BillFormData)this.billData).updateValue("qty", (Object)qty);
        String unit = BusinessDataServiceHelper.loadSingle((Object)unitId, (String)"bd_measureunits").getString("name");
        mapName = StringUtils.isNotBlank((CharSequence)mapName) ? mapName + "\uff0c" + qty.intValue() + unit : qty.intValue() + unit;
        ((BillFormData)this.billData).updateValue("selectspec", (Object)mapName);
    }

    private List<ImgObject> getImgObjects(JSONObject itemInfo) {
        ArrayList<ImgObject> imgObjects = new ArrayList<ImgObject>();
        for (int i = 1; i < 10; ++i) {
            String picture = "";
            if (itemInfo != null) {
                picture = itemInfo.getString("picture" + i);
            }
            if (!StringUtil.isNotNull((String)picture)) continue;
            ImgObject img = new ImgObject();
            img.setSrc(PictureUtil.getFileServerUrl() + picture);
            imgObjects.add(img);
        }
        if (imgObjects.size() == 0) {
            String thumbnail = "";
            if (itemInfo != null) {
                thumbnail = itemInfo.getString("thumbnail");
            }
            if (thumbnail != null) {
                ImgObject img = new ImgObject();
                img.setSrc(PictureUtil.getFileServerUrl() + thumbnail);
                imgObjects.add(img);
            }
        }
        return imgObjects;
    }

    private void goPage(String pagename) {
        OpenParam openParam = new OpenParam();
        openParam.setViewId(pagename);
        openParam.addCustomParam("itemid", ((BillFormData)this.billData).getString("itemid"));
        openParam.addCustomParam("customerid", ((BillFormData)this.billData).getString("customerid"));
        openParam.addCustomParam("spuid", ((BillFormData)this.billData).getString("spuid"));
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        ((ExtBillView)this.view).showView(openParam);
    }

    private Map<String, Object> getParam(String pkValue) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("itemid", ((BillFormData)this.billData).getString("itemid"));
        param.put("materielid", ((BillFormData)this.billData).getString("materialid"));
        param.put("spuid", ((BillFormData)this.billData).getString("spuid"));
        param.put("auxptyid", ((BillFormData)this.billData).getString("auxptyid"));
        param.put("spumapids", ((BillFormData)this.getBillData()).getString("spumapids"));
        param.put("qty", ((BillFormData)this.getBillData()).getBigDecimal("qty"));
        param.put("productcount", ((BillFormData)this.getBillData()).getInt("productcount"));
        param.put("storename", ((BillFormData)this.getBillData()).getString("storename"));
        param.put("ticketid", ((BillFormData)this.getBillData()).getString("ticketid"));
        param.put("btnname", pkValue);
        param.put("updateControlId", "auxptyid");
        param.put("isinventory", ((BillFormData)this.billData).getBoolean("isinventory"));
        param.put("districtid", ((BillFormData)this.billData).getString("districtid"));
        return param;
    }

    private Map<String, String> getPromoteParam(Long memberId, Long customerId) {
        String billDate = CommonUtil.format((Date)TimeServiceHelper.now(), (String)TimeServiceHelper.getDateTimeFormatString());
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo((long)customerId);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("storeId", String.valueOf(customerId));
        param.put("memberId", String.valueOf(memberId));
        param.put("itemId", ((BillFormData)this.billData).getString("itemid"));
        param.put("orgId", storeInfo.getString("saleorg"));
        param.put("billDate", billDate);
        param.put("unitId", ((BillFormData)this.billData).getString("unitid"));
        param.put("auxId", ((BillFormData)this.billData).getString("auxptyid"));
        return param;
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        Long customerId = OlstoreUtil.getCurrentStore((ClientEvent)event).getLong("id");
        OpenParam openParam = new OpenParam();
        long itemId = ((BillFormData)this.getBillData()).getLong("itemid");
        long barcodeId = ((BillFormData)this.billData).getLong("barcodeid");
        if (memberId == 0L && ((ExtBillView)this.view).getExtCtx().isFromMiniProgram()) {
            CallBackArgu loginCallBack = new CallBackArgu();
            loginCallBack.setActionKey("login");
            ((ExtBillView)this.view).showMessage("\u6b64\u64cd\u4f5c\u9700\u8981\u767b\u5f55\uff0c\u662f\u5426\u524d\u5f80\u767b\u5f55\uff1f", MessageBoxType.YesNO, loginCallBack);
        } else {
            int productCount = ((BillFormData)this.getBillData()).getInt("productcount");
            switch (eventId) {
                case "cartlist": {
                    this.goPage("ocpos_cartlistm");
                    break;
                }
                case "addcart": {
                    if (ButtonFastClickUtil.isFastClickByTime((long)2000L)) {
                        return;
                    }
                    if (productCount > 1) {
                        Map<String, Object> param = this.getParam(eventId);
                        ((ExtBillView)this.view).showAuxptyView(event.getId(), "ocpos_selectspec", param);
                        break;
                    }
                    boolean olstoreSale = OlstoreItemHelper.isOlstoreSale((Long)customerId, (Long)barcodeId, (Long)itemId);
                    if (olstoreSale) {
                        this.addCart(memberId);
                        break;
                    }
                    ((ExtBillView)this.view).showMessage("\u8be5\u5546\u54c1\u672a\u4e0a\u67b6\uff0c\u8bf7\u5230\u7ebf\u4e0b\u95e8\u5e97\u5b8c\u6210\u8d2d\u4e70\u3002", MessageBoxType.Toast);
                    break;
                }
                case "quickorder": {
                    if (productCount > 1) {
                        Map<String, Object> param = this.getParam(eventId);
                        ((ExtBillView)this.view).showAuxptyView(event.getId(), "ocpos_selectspec", param);
                        break;
                    }
                    boolean olstoreSale = OlstoreItemHelper.isOlstoreSale((Long)customerId, (Long)barcodeId, (Long)itemId);
                    if (olstoreSale) {
                        this.quickOrder();
                        break;
                    }
                    ((ExtBillView)this.view).showMessage("\u8be5\u5546\u54c1\u672a\u4e0a\u67b6\uff0c\u8bf7\u5230\u7ebf\u4e0b\u95e8\u5e97\u5b8c\u6210\u8d2d\u4e70\u3002", MessageBoxType.Toast);
                    break;
                }
                case "selectspec": {
                    Map<String, Object> param = this.getParam(eventId);
                    ((ExtBillView)this.view).showAuxptyView(event.getId(), "ocpos_selectspec", param);
                    break;
                }
                case "address": {
                    this.selectAddress();
                    break;
                }
                case "sharebutton": {
                    this.goToSharePage();
                    event.getCustomParam().clear();
                    break;
                }
                case "discount_flexpanel": {
                    Map<String, String> promoteMap = this.getPromoteParam(memberId, customerId);
                    openParam.setTarget(OpenParam.OpenTarget.Pop);
                    openParam.setViewId("ocpos_itemdiscounts");
                    openParam.setShowTitle(Boolean.FALSE);
                    openParam.addCustomParam("promoteMap", promoteMap);
                    ((ExtBillView)this.getView()).showView(openParam);
                    break;
                }
                case "recomitemthumbnail": 
                case "recomitemname": {
                    DynamicObject data = ((BillFormData)this.getBillData()).getEntryRowData("recomitemlist", event.getCurrentRow());
                    openParam = new OpenParam();
                    openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                    openParam.setViewId("ocpos_itemdetails");
                    openParam.addCustomParam("itemid", data.getString("recomitemid"));
                    openParam.addCustomParam("auxptyid", data.getString("recomauxptyid"));
                    openParam.addCustomParam("spuid", data.getString("recomspuid"));
                    ((ExtBillView)this.getView()).showView(openParam);
                    break;
                }
                case "addrecomcart": {
                    DynamicObject data = ((BillFormData)this.getBillData()).getEntryRowData("recomitemlist", event.getCurrentRow());
                    this.addCart(data);
                    break;
                }
            }
            super.onClick(event);
        }
    }

    private void goToSharePage() {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.Pop);
        openParam.setPostion(OpenParam.OpenPosition.Custom);
        openParam.setShowTitle(Boolean.FALSE);
        openParam.setViewId("ocpos_itemdetailsshare");
        openParam.addCustomParam("spuid", ((BillFormData)this.getBillData()).getString("spuid"));
        openParam.addCustomParam("itemid", ((BillFormData)this.getBillData()).getString("itemid"));
        openParam.addCustomParam("auxptyid", ((BillFormData)this.getBillData()).getString("auxptyid"));
        openParam.addCustomParam("itemname", ((BillFormData)this.getBillData()).getString("itemname"));
        openParam.addCustomParam("thumbnail", ((BillFormData)this.getBillData()).getString("thumbnail"));
        openParam.addCustomParam("memberprice", ((BillFormData)this.getBillData()).getBigDecimal("memberprice").stripTrailingZeros().toPlainString());
        openParam.addCustomParam("retailprice", ((BillFormData)this.getBillData()).getBigDecimal("retailprice").stripTrailingZeros().toPlainString());
        ((ExtBillView)this.getView()).showView(openParam);
    }

    public void onMessageCallBack(MessageCallBackEvent event) {
        String actionKey;
        Map messageBackMap = (Map)event.getEventParam().get((Object)"messageback");
        int result = messageBackMap.getOrDefault("result", 0);
        switch (actionKey = event.getActionKey()) {
            case "login": {
                if (result != 1) break;
                this.goPage("ocpos_mpgrant");
                break;
            }
            case "address": {
                if (result != 1) break;
                this.goPage("ocpos_deliveryaddresseditm");
                break;
            }
        }
        super.onMessageCallBack(event);
    }

    private void selectAddress() {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.Pop);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.addCustomParam("addressid", ((BillFormData)this.billData).getString("addressid"));
        openParam.setViewId("ocpos_memberaddressm");
        ((ExtBillView)this.getView()).showView(openParam);
    }

    private void quickOrder() {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.addCustomParam("itemid", ((BillFormData)this.billData).getString("itemid"));
        openParam.addCustomParam("spuid", ((BillFormData)this.billData).getString("spuid"));
        openParam.addCustomParam("guideid", ((BillFormData)this.billData).getString("guideid"));
        openParam.addCustomParam("qty", (Object)((BillFormData)this.billData).getBigDecimal("qty"));
        openParam.addCustomParam("customerId", ((BillFormData)this.billData).getString("customerid"));
        openParam.addCustomParam("sourceviewid", "ocpos_itemdetails");
        openParam.addCustomParam("addressid", ((BillFormData)this.billData).getString("addressid"));
        openParam.addCustomParam("deliverytime", (Object)((BillFormData)this.billData).getDate("deliverytime"));
        openParam.addCustomParam("storename", ((BillFormData)this.billData).getString("storename"));
        openParam.addCustomParam("pickuptime", (Object)((BillFormData)this.billData).getDate("pickuptime"));
        openParam.addCustomParam("ticketid", ((BillFormData)this.billData).getString("ticketid"));
        openParam.setViewId("ocpos_confirmorder");
        ((ExtBillView)this.getView()).showView(openParam);
    }

    private void addCart(long memberId) {
        long customerId = ((BillFormData)this.billData).getLong("customerid");
        long itemId = ((BillFormData)this.billData).getLong("itemid");
        long auxptyId = ((BillFormData)this.billData).getLong("auxptyid");
        long unitId = ((BillFormData)this.billData).getLong("unitid");
        long barcodeId = ((BillFormData)this.billData).getLong("barcodeid");
        BigDecimal qty = ((BillFormData)this.billData).getBigDecimal("qty");
        int preCartSumCount = this.getCartSumCount();
        OlstoreCartHelper.addCart((long)customerId, (long)memberId, (long)itemId, (long)unitId, (long)auxptyId, (long)barcodeId, (BigDecimal)qty, (int)0);
        int cartSumCount = this.getCartSumCount();
        if (preCartSumCount != cartSumCount) {
            ((BillFormData)this.billData).updateValue("cartcount", (Object)cartSumCount);
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", MessageBoxType.Toast);
        } else {
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u3002", MessageBoxType.Toast);
        }
    }

    private void addCart(DynamicObject data) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        long customerId = ((BillFormData)this.billData).getLong("customerid");
        long itemId = data.getLong("recomitemid");
        long auxptyId = data.getLong("recomauxptyid");
        long unitId = data.getLong("recomunitid");
        long barcodeId = data.getLong("recombarcodeid");
        BigDecimal qty = BigDecimal.ONE;
        int preCartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        OlstoreCartHelper.addCart((long)customerId, (long)memberId, (long)itemId, (long)unitId, (long)auxptyId, (long)barcodeId, (BigDecimal)qty, (int)0);
        int cartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        if (preCartSumCount != cartSumCount) {
            ((BillFormData)this.billData).updateValue("cartcount", (Object)cartSumCount);
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", MessageBoxType.Toast);
        } else {
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u3002", MessageBoxType.Toast);
        }
    }

    private int getCartSumCount() {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        return OlstoreCartHelper.getOlstoreCartCount((long)((BillFormData)this.billData).getLong("customerid"), (long)memberId, (long)((BillFormData)this.billData).getLong("itemid"), (long)((BillFormData)this.billData).getLong("auxptyid"), (int)0).intValue();
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "districtid": 
            case "address": {
                this.checkInventory();
                JSONObject addressJson = new JSONObject();
                addressJson.put("districtid", (Object)((BillFormData)this.billData).getString("districtid"));
                addressJson.put("address", (Object)((BillFormData)this.billData).getString("address"));
                addressJson.put("addressid", (Object)((BillFormData)this.billData).getString("addressid"));
                OlstoreUtil.setCurrentAddress((ExtDynamicView)((ExtDynamicView)this.view), (String)addressJson.toJSONString());
                break;
            }
            case "isinventory": {
                Boolean isInventory = ((BillFormData)this.billData).getBoolean("isinventory");
                if (isInventory.booleanValue()) {
                    ((ExtBillView)this.view).hide("noinventorypanel", true);
                    ((ExtBillView)this.view).disable("addcart", false);
                    ((ExtBillView)this.view).disable("quickorder", false);
                    break;
                }
                ((ExtBillView)this.view).hide("noinventorypanel", false);
                ((ExtBillView)this.view).disable("addcart", true);
                ((ExtBillView)this.view).disable("quickorder", true);
                break;
            }
        }
        super.onDataChange(event);
    }

    public void loadDiscount(long memberId, long customerId, String itemId, long unit, String innerAuxptyId) {
        int promoteNum = this.setProtomeInfo(memberId, customerId, itemId, unit, innerAuxptyId);
        if (promoteNum < 1) {
            ((ExtBillView)this.view).hide("discount_flexpanel", true);
            ((ExtBillView)this.view).hide("pomote_panel", true);
        } else {
            ((ExtBillView)this.view).hide("discount_flexpanel", false);
            ((ExtBillView)this.view).hide("pomote_panel", false);
        }
    }

    public int setProtomeInfo(long memberID, long customerId, String itemId, long unit, String innerAuxptyId) {
        int pomoteNum = 0;
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo((long)customerId);
        if (storeInfo != null) {
            String dbId = storeInfo.getString("saleorg");
            String storeId = String.valueOf(customerId);
            String memberId = String.valueOf(memberID);
            String unitId = String.valueOf(unit);
            String billDate = CommonUtil.format((Date)TimeServiceHelper.now(), (String)TimeServiceHelper.getDateTimeFormatString());
            long start = System.currentTimeMillis();
            DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)memberId, (String)"ocdbd_user");
            String memberlevelid = member.getDynamicObject("viplevelid") != null ? member.getDynamicObject("viplevelid").getString("id") : "";
            logger.info("\u5546\u54c1\u8be6\u60c5\u8017\u65f6\u7edf\u8ba1 \u4f1a\u5458\u67e5\u8be2\u63a5\u53e3  member  " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            CxPromotionRequestEntity cxRequestEntity = new CxPromotionRequestEntity(dbId, storeId, memberId, memberlevelid, billDate, false);
            PosItemDetailsMobileBillPlugin.buildMaterialEntry(cxRequestEntity, itemId, unitId, innerAuxptyId);
            start = System.currentTimeMillis();
            List promotionList = OlstorePromotionHelper.matchPromotion((CxPromotionRequestEntity)cxRequestEntity);
            logger.info("\u5546\u54c1\u8be6\u60c5\u8017\u65f6\u7edf\u8ba1 \u4fc3\u9500\u5339\u914d\u63a5\u53e3  OlstorePromotionHelper.matchPromotion  " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            pomoteNum = promotionList.size();
            if (pomoteNum > 0) {
                StringBuilder msg = new StringBuilder();
                for (CxPromotionResultEntity promotionInfo : promotionList) {
                    String promotionName = promotionInfo.getName();
                    msg.append(promotionName);
                    msg.append('\n');
                }
                ((BillFormData)this.billData).updateValue("pomote", (Object)msg.toString());
            }
        }
        return pomoteNum;
    }

    private static void buildMaterialEntry(CxPromotionRequestEntity cxRequestEntity, String itemId, String unitId, String auxattrid) {
        ArrayList<MaterialEntryEntity> materialEntryEntityList = new ArrayList<MaterialEntryEntity>();
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"ocdbd_iteminfo");
        if (item == null) {
            return;
        }
        DynamicObject goodsBrand = DynamicObjectUtils.getDynamicObject((DynamicObject)item, (String)"itembrands");
        String brandId = goodsBrand != null ? goodsBrand.getString("id") : "";
        List classIds = ItemClassUtil.queryClassList((Object)itemId);
        MaterialEntryEntity entryEntity = new MaterialEntryEntity(0, item.getString("id"), item.getString("name"), unitId, auxattrid, null, null, brandId, classIds.stream().map(CommonUtil::formatStringToEmpty).collect(Collectors.toList()), null, null, false);
        materialEntryEntityList.add(entryEntity);
        cxRequestEntity.setMatchMaterial(entryEntity);
        cxRequestEntity.setMaterialEntries(materialEntryEntityList);
    }
}

