/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;

public class PosItemListPlugin
extends ExtListViewPlugin {
    private static final String itementrys = "goodslist";

    public ListDataSet<DynamicObjectCollection> onDataLoad(LoadDataEvent event) {
        ListDataSet listDataSet = super.onDataLoad(event);
        String keyword = event.getFilterParam() != null && event.getFilterParam().containsKey("search") ? event.getFilterParam().get("search").toString() : event.getEventParam().getString("search");
        if (StringUtil.isNotNull((String)keyword)) {
            JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
            String customerId = currentStore.getString("id");
            String sourceviewId = event.getCustomParam().getString("sourceviewid");
            this.putSearchHistory(keyword);
            this.search(customerId, sourceviewId, keyword);
        }
        return listDataSet;
    }

    private void search(String customerId, String sourceviewId, String keyword) {
        if ("ocpos_brand_select".equals(sourceviewId)) {
            this.putLocalStorageForParent("keyword", keyword);
            ((ExtListView)this.view).getParentForm().getDynamicView().refresh();
            ((ExtListView)this.view).closeView();
        } else {
            OpenParam openParam = new OpenParam();
            openParam.addCustomParam("keyword", keyword);
            openParam.addCustomParam("customerid", customerId);
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setShowTitle(Boolean.TRUE);
            openParam.setViewId("ocpos_brand_select");
            openParam.addCustomParam("uuid", UUID.randomUUID().toString());
            ((ExtListView)this.getView()).showView(openParam);
        }
    }

    private void putLocalStorageForParent(String key, String value) {
        AbstractExtFormPlugin parentForm = ((ExtListView)this.view).getParentForm();
        if (StringUtil.isNotNull((String)value)) {
            parentForm.getDynamicView().putLocalStorage(key, value);
        } else {
            parentForm.getDynamicView().putLocalStorage(key, "empty");
        }
    }

    private void putSearchHistory(String keyword) {
        HashMap<String, String> searchhistory = new HashMap<String, String>(8);
        searchhistory.put("name", keyword);
        ((ExtListView)this.view).putLocalStorage("searchhistory", searchhistory, true, 8);
    }
}

