/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.OlinvitationHelper;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocpos.common.util.OlstoreUtil;
import org.apache.commons.lang.StringUtils;

public class PosLatestNewsListPlugin
extends ExtBillViewPlugin {
    private static final String cid_olinvitationlist = "olinvitationlist";
    private static final String cid_olinvitationpic = "olinvitationpic";
    private static final String cid_olinvitationname = "olinvitationname";
    private static final String cid_starttime = "starttime";
    private static final String cid_endtime = "endtime";
    private static Log logger = LogFactory.getLog(PosLatestNewsListPlugin.class);

    public void afterDataLoad(LoadDataEvent event) {
        long currentStoreId = OlstoreUtil.getStoreId((ClientEvent)event);
        String storeId = event.getCustomParam().getString("storeid");
        String storeName = event.getCustomParam().getString("storename");
        String memberId = event.getCustomParam().getString("memberid");
        String guideId = event.getCustomParam().getString("guideid");
        ((BillFormData)this.billData).updateValue("memberid", (Object)memberId);
        ((BillFormData)this.billData).updateValue("guideid", (Object)guideId);
        logger.info("\u4ee3\u8ba4\u7b79storeId\uff1a" + storeId + ",storeName\uff1a " + storeName + ",memberId\uff1a" + memberId + ",guideId\uff1a" + guideId);
        Boolean isAgencyInvitate = Boolean.FALSE;
        if (StringUtils.isNotBlank((String)storeId) && StringUtils.isNotBlank((String)storeName)) {
            isAgencyInvitate = Boolean.TRUE;
            currentStoreId = Long.parseLong(storeId);
            this.setCurrentStore(currentStoreId, storeName);
        }
        this.getOlinvitationList(currentStoreId, isAgencyInvitate);
    }

    private void setCurrentStore(Long storeId, String storeName) {
        JSONObject storeJson = new JSONObject();
        storeJson.put("id", (Object)storeId);
        storeJson.put("name", (Object)storeName);
        OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
    }

    private void getOlinvitationList(long storeId, Boolean isAgencyInvitate) {
        DynamicObjectCollection olinvitationList = OlinvitationHelper.getOlinvitationByStoreId((long)storeId, (Boolean)isAgencyInvitate);
        if (olinvitationList != null && olinvitationList.size() > 0) {
            AtomicInteger index = new AtomicInteger(0);
            for (DynamicObject olinvitation : olinvitationList) {
                int rowid = index.getAndIncrement();
                DynamicObject entryData = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(cid_olinvitationlist);
                entryData.set("id", (Object)olinvitation.getLong("id"));
                if (olinvitation.getLong("id") == storeId) {
                    ((ExtBillView)this.view).setRowSelection(cid_olinvitationlist, rowid, true, false);
                }
                entryData.set(cid_olinvitationpic, (Object)olinvitation.getString("subjectpic"));
                entryData.set(cid_olinvitationname, (Object)olinvitation.getString("name"));
                entryData.set(cid_starttime, (Object)DateUtils.formatDate((Date)olinvitation.getDate(cid_starttime), (Object[])new Object[]{"yyyy.MM.dd"}));
                entryData.set(cid_endtime, (Object)DateUtils.formatDate((Date)olinvitation.getDate(cid_endtime), (Object[])new Object[]{"yyyy.MM.dd"}));
                ((BillFormData)this.getBillData()).addEntryRow(cid_olinvitationlist, entryData);
                long memberId = ((BillFormData)this.billData).getLong("memberid");
                if (memberId == 0L) {
                    memberId = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
                }
                QFilter publishFilter = new QFilter("olinvitateid.id", "=", (Object)olinvitation.getLong("id"));
                publishFilter.and("entryentity.ticketid.vipid", "=", (Object)memberId);
                DynamicObjectCollection publishDynArr = QueryServiceHelper.query((String)"ocgcm_ticketspublish", (String)"id,billstatus,billno,entryentity.ticketid.id,entryentity.ticketid.ticketstatus", (QFilter[])publishFilter.toArray());
                if (publishDynArr != null && publishDynArr.size() > 0) {
                    if (((DynamicObject)publishDynArr.get(0)).getString("billstatus").equals("B")) {
                        ((ExtBillView)this.view).hide("ispick", true, rowid);
                        continue;
                    }
                    ((ExtBillView)this.view).hide("ispick", false, rowid);
                    continue;
                }
                ((ExtBillView)this.view).hide("ispick", true, rowid);
            }
            ((ExtBillView)this.view).hide("news_none_panel", true);
            ((ExtBillView)this.view).hide(cid_olinvitationlist, false);
        } else {
            ((ExtBillView)this.view).hide("news_none_panel", false);
            ((ExtBillView)this.view).hide(cid_olinvitationlist, true);
        }
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        long memberId = ((BillFormData)this.billData).getLong("memberid");
        if (memberId == 0L) {
            memberId = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        }
        List selectRows = event.getSelections(cid_olinvitationlist);
        DynamicObjectCollection selectEntrys = ((BillFormData)this.getBillData()).getEntryRowData(cid_olinvitationlist, selectRows);
        switch (eventId) {
            case "olinvitationpanel": {
                if (selectEntrys == null || selectEntrys.size() <= 0) break;
                OpenParam openParam = new OpenParam();
                Long olinvitationId = ((DynamicObject)selectEntrys.get(0)).getLong("id");
                QFilter publishFilter = new QFilter("olinvitateid.id", "=", (Object)olinvitationId);
                publishFilter.and("entryentity.ticketid.vipid", "=", (Object)memberId);
                logger.info("\u8ba4\u7b79\u9080\u7ea6\u53c2\u4e0e\u6b21\u6570 \u53c2\u6570\uff1aolinvitationId\uff1a" + olinvitationId + ",memberId:" + memberId);
                DynamicObjectCollection publishDynArr = QueryServiceHelper.query((String)"ocgcm_ticketspublish", (String)"id,billstatus,billno,entryentity.ticketid.id,entryentity.ticketid.ticketstatus", (QFilter[])publishFilter.toArray());
                logger.info("\u8ba4\u7b79\u9080\u7ea6\u53c2\u4e0e\u6b21\u6570 \u7ed3\u679c\uff1a" + publishDynArr);
                if (publishDynArr != null && publishDynArr.size() > 0) {
                    if (((DynamicObject)publishDynArr.get(0)).getString("billstatus").equals("B")) {
                        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                        openParam.setShowTitle(Boolean.TRUE);
                        openParam.setViewId("ocpos_ticketorder_info");
                        openParam.addCustomParam("billId", ((DynamicObject)publishDynArr.get(0)).getString("id"));
                        openParam.setEnabelHistory(false);
                        ((ExtBillView)this.view).showView(openParam);
                        break;
                    }
                    logger.info("\u8ba4\u7b79\u9080\u7ea6\u53c2\u4e0e\u6b21\u6570 \u7ed3\u679c\u6b21\u6570\uff1a" + publishDynArr.size());
                    ((ExtBillView)this.view).showMessage("\u5f53\u524d\u6d3b\u52a8\u53ea\u53ef\u53c2\u4e0e1\u6b21\uff0c\u60a8\u5df2\u7528\u5b8c\u53c2\u4e0e\u6b21\u6570");
                    return;
                }
                openParam.addCustomParam("olinvitationid", String.valueOf(olinvitationId));
                openParam.addCustomParam("memberid", ((BillFormData)this.billData).getString("memberid"));
                openParam.addCustomParam("guideid", ((BillFormData)this.billData).getString("guideid"));
                openParam.addCustomParam("sourceviewid", "ocpos_latestnews_list");
                openParam.setViewId("ocpos_latestnews_info");
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                ((ExtBillView)this.view).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }
}

