/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.LevelMenuEntity;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.CollectionUtil;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.LevelClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocpos.business.olstore.OlsPersonalizedHelper;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;

public class PosMallMobileBillPlugin
extends ExtBillViewPlugin {
    private static final String cid_storename = "storename";
    private static final String ocpos_menu = "ocpos_menu";
    private static final String all_index = "all_index";
    private static final Log log = LogFactory.getLog(PosMallMobileBillPlugin.class);

    public void afterBindData(LoadDataEvent event) {
        DynamicObject olstoreConfig;
        JSONObject currentStore = this.getCurrentStore(event);
        Long customerId = currentStore.getLong("id");
        String customerName = currentStore.getString("name");
        if (StringUtil.isNotNull((String)customerName) && customerId > 0L) {
            ((BillFormData)this.getBillData()).updateValue("customerid", (Object)customerId);
            ((ExtBillView)this.view).updateFrontValue(cid_storename, (Object)customerName);
            long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
            ((BillFormData)this.billData).updateValue("switch", (Object)event.getLocalStorage().getBoolean("isSelfPickup" + memberId + customerId, Boolean.TRUE));
            List<LevelMenuEntity> menus = this.getItemClasses(customerId);
            ExtDynamicObject data = new ExtDynamicObject();
            data.put(ocpos_menu, menus);
            data.put(all_index, (Object)Boolean.TRUE);
            ((ExtBillView)this.getView()).bindData((Object)data);
            event.setPreventDefault(true);
        }
        if ((olstoreConfig = OlstoreConfigHelper.getOlstoreConfig()).getBoolean("issearch")) {
            ((ExtBillView)this.view).hide("searchpanel", false);
        } else {
            ((ExtBillView)this.view).hide("searchpanel", true);
        }
        super.afterBindData(event);
    }

    private JSONObject getCurrentStore(LoadDataEvent event) {
        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
        if (currentStore != null) {
            return currentStore;
        }
        DynamicObject defaultStore = OlstoreStoreInfoHelper.getDefaultStore();
        JSONObject storeJson = new JSONObject();
        storeJson.put("id", (Object)defaultStore.getLong("id"));
        storeJson.put("name", (Object)defaultStore.getString("name"));
        OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
        return storeJson;
    }

    private List<LevelMenuEntity> getItemClasses(Long customerId) {
        DynamicObjectCollection classstandardApply = OlstoreItemHelper.getClassstandardApply();
        ArrayList<LevelMenuEntity> allItemClasses = new ArrayList<LevelMenuEntity>();
        DynamicObject dynamicObject = (DynamicObject)classstandardApply.get(0);
        if (dynamicObject == null) {
            return null;
        }
        Long classStanderedId = dynamicObject.getLong("classstandardid.id");
        DynamicObject branchDyn = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"ocdbd_channel", (String)"saleorg");
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branchDyn, (String)"saleorg");
        log.info("\u5546\u57ce\u63a5\u53e3\u8fd4\u56de\u7ed3\u679cclassStanderedId\uff1a", (Object)classStanderedId);
        List malllList = OlsPersonalizedHelper.getHomeMallData((Long)classStanderedId, (Long)customerId);
        log.info("\u5546\u57ce\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a", (Object)malllList);
        this.sort(malllList, 1);
        if (malllList != null && malllList.size() > 0) {
            for (Map mallItem : malllList) {
                DynamicObject firstItemClass = (DynamicObject)mallItem.get("firstitemclassid");
                LevelMenuEntity levelMenuEntity1 = new LevelMenuEntity();
                levelMenuEntity1.setId(firstItemClass.getString("id"));
                levelMenuEntity1.setKey(firstItemClass.getString("number"));
                levelMenuEntity1.setName(firstItemClass.getString("name"));
                levelMenuEntity1.setLevel("1");
                List secondMalllList = (List)mallItem.get("secondentryentity");
                this.sort(secondMalllList, 2);
                if (secondMalllList != null && secondMalllList.size() > 0) {
                    ArrayList<LevelMenuEntity> secondClassList = new ArrayList<LevelMenuEntity>(10);
                    for (int i = 0; i < secondMalllList.size(); ++i) {
                        Map secondMallItem = (Map)secondMalllList.get(i);
                        LevelMenuEntity levelMenuEntity2 = new LevelMenuEntity();
                        DynamicObject secondItemClass = (DynamicObject)secondMallItem.get("seconditemclassid");
                        if (secondItemClass != null) {
                            levelMenuEntity2.setId(secondItemClass.getString("id"));
                        } else {
                            levelMenuEntity2.setId(this.getLevelId(secondMallItem));
                        }
                        levelMenuEntity2.setName(String.valueOf(secondMallItem.get("titlename")));
                        levelMenuEntity2.setLevel("2");
                        levelMenuEntity2.setParent(firstItemClass.getString("id"));
                        List thirdMalllList = (List)secondMallItem.get("thirdentryentity");
                        this.sort(thirdMalllList, 3);
                        if (thirdMalllList != null && thirdMalllList.size() > 0) {
                            ArrayList<LevelMenuEntity> thirdClassList = new ArrayList<LevelMenuEntity>(10);
                            for (Map thirdMallItem : thirdMalllList) {
                                LevelMenuEntity levelMenuEntity3 = new LevelMenuEntity();
                                DynamicObject thirdItem = null;
                                if (thirdMallItem.get("itembrandid") != null) {
                                    thirdItem = (DynamicObject)thirdMallItem.get("itembrandid");
                                    levelMenuEntity3.setKey("brand");
                                }
                                if (thirdMallItem.get("itemlableid") != null) {
                                    thirdItem = (DynamicObject)thirdMallItem.get("itemlableid");
                                    levelMenuEntity3.setKey("lable");
                                }
                                if (thirdMallItem.get("thirditemclassid") != null) {
                                    thirdItem = (DynamicObject)thirdMallItem.get("thirditemclassid");
                                    levelMenuEntity3.setKey("itemclass");
                                }
                                if (thirdItem == null) continue;
                                levelMenuEntity3.setId(thirdItem.getString("id"));
                                levelMenuEntity3.setName(thirdItem.getString("name"));
                                levelMenuEntity3.setLevel("3");
                                levelMenuEntity3.setIcon(PictureUtil.getFileServerUrl() + thirdMallItem.get("picture"));
                                levelMenuEntity3.setParent(levelMenuEntity2.getId());
                                thirdClassList.add(levelMenuEntity3);
                            }
                            levelMenuEntity2.setChildren(thirdClassList);
                        }
                        secondClassList.add(levelMenuEntity2);
                    }
                    levelMenuEntity1.setChildren(secondClassList);
                }
                allItemClasses.add(levelMenuEntity1);
            }
        }
        return allItemClasses;
    }

    private void sort(List<Map<String, Object>> malllList, final int level) {
        if (CollectionUtil.isNotNull(malllList)) {
            Collections.sort(malllList, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    int i1 = 0;
                    int i2 = 0;
                    if (level == 1) {
                        i1 = (Integer)o1.get("sort");
                        i2 = (Integer)o2.get("sort");
                    } else if (level == 2) {
                        i1 = (Integer)o1.get("subsort");
                        i2 = (Integer)o2.get("subsort");
                    } else if (level == 3) {
                        i1 = (Integer)o1.get("thirdsort");
                        i2 = (Integer)o2.get("thirdsort");
                    }
                    return i1 - i2;
                }
            });
        }
    }

    public void onLevelClick(LevelClickEvent event) {
        long startTime = System.currentTimeMillis();
        String l1 = event.getL1();
        String l2 = event.getL2();
        String l3 = event.getL3();
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId("ocpos_brand_select");
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setTitle("\u5546\u57ce");
        openParam.setAsync(true);
        openParam.addCustomParam("uuid", UUID.randomUUID().toString());
        openParam.addCustomParam("customerid", ((BillFormData)this.getBillData()).getString("customerid"));
        openParam.addCustomParam("sourceviewid", ((ExtBillView)this.view).getViewId());
        openParam.addCustomParam("l1", l1);
        openParam.addCustomParam("l2", l2);
        openParam.addCustomParam("l3", l3);
        if ("1".equals(l2)) {
            openParam.addCustomParam("type", "brand");
        } else if ("2".equals(l2)) {
            openParam.addCustomParam("type", "label");
        } else {
            openParam.addCustomParam("type", "class");
        }
        if (StringUtil.isNotNull((String)l3) && StringUtil.isNotNull((String)l2)) {
            openParam.addCustomParam("queryId", l3);
            long start = System.currentTimeMillis();
            ((ExtBillView)this.getView()).showView(openParam);
            log.info("\u5546\u57ce\u70b9\u51fb\u8017\u65f61 this.getView().showView(openParam) consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002" + openParam);
        } else if (StringUtil.isNotNull((String)l2)) {
            if ("1".equals(l2) || "2".equals(l2)) {
                openParam.addCustomParam("queryId", l1);
            } else {
                openParam.addCustomParam("queryId", l2);
            }
            long start = System.currentTimeMillis();
            ((ExtBillView)this.getView()).showView(openParam);
            log.info("\u5546\u57ce\u70b9\u51fb\u8017\u65f62 this.getView().showView(openParam) consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002" + openParam);
        }
        log.info("\u5546\u57ce\u8017\u65f6\u7edf\u8ba11 this.onLevelClick consumes " + (System.currentTimeMillis() - startTime) + " \u6beb\u79d2\u3002" + openParam);
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "storename": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.addCustomParam("sourceviewid", ((ExtBillView)this.view).getViewId());
                openParam.setViewId("ocpos_selectstore");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "search_icon": 
            case "searcharea": 
            case "searchpanel": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_search");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    public void onSearch(LoadDataEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "searcharea": {
                String searcharea = event.getFilterParam().get("searcharea").toString();
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_itemlist");
                openParam.addCustomParam("searcharea", searcharea);
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "storename": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_selectstore");
                openParam.addCustomParam("sourceviewid", "ocpos_mall");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId = event.getId();
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        String customerId = ((BillFormData)this.getBillData()).getString("customerid");
        switch (eventId) {
            case "switch": {
                Boolean isSelfPickup = ((BillFormData)this.getBillData()).getBoolean("switch");
                ((ExtBillView)this.view).putLocalStoragePrivate("isSelfPickup" + memberId + customerId, (Object)isSelfPickup, true, 99, true);
                if (isSelfPickup.booleanValue()) break;
                if (memberId == 0L && ((ExtBillView)this.view).getExtCtx().isFromMiniProgram()) {
                    OpenParam openParam = new OpenParam();
                    openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                    openParam.setViewId("ocpos_mpgrant");
                    ((ExtBillView)this.getView()).showView(openParam);
                    break;
                }
                JSONObject addressObject = this.queryDeliveryAddress();
                if (addressObject != null) break;
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.addCustomParam("sourceviewid", ((ExtBillView)this.view).getViewId());
                openParam.setViewId("ocpos_deliveryaddresseditm");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onDataChange(event);
    }

    private void checkLogin(long memberId) {
        if (memberId == 0L && ((ExtBillView)this.view).getExtCtx().isFromMiniProgram()) {
            OpenParam openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setViewId("ocpos_mpgrant");
            ((ExtBillView)this.getView()).showView(openParam);
        }
    }

    public JSONObject queryDeliveryAddress() {
        JSONArray dataList;
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        JSONObject deliveryAddressResult = OlstoreMemberHelper.getDeliveryAddressList((long)memberId);
        if (deliveryAddressResult != null && deliveryAddressResult.getInteger("code") == 0 && (dataList = deliveryAddressResult.getJSONArray("data")) != null && dataList.size() > 0) {
            return (JSONObject)dataList.toJavaList(JSONObject.class).get(0);
        }
        return null;
    }

    private String getLevelId(Map secondMallItem) {
        String result = null;
        if (((Boolean)secondMallItem.get("isitembrand")).booleanValue()) {
            result = "1";
        } else if (((Boolean)secondMallItem.get("isitemlable")).booleanValue()) {
            result = "2";
        }
        return result;
    }
}

