/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.payhelper.FinPayTradeHelper;
import kd.occ.ocbase.business.payhelper.PayTradeHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.enums.ticket.TicketUsageModeEnum;
import kd.occ.ocbase.common.pay.config.CheckOutCounterInfo;
import kd.occ.ocbase.common.pay.config.MiniPayResult;
import kd.occ.ocbase.common.pay.config.TradeStatus;
import kd.occ.ocbase.common.pay.finpay.util.ResponseEnum;
import kd.occ.ocbase.common.util.ButtonFastClickUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdbd.business.helper.ticket.TicketPayHelper;
import kd.occ.ocepfp.common.entity.CallBackArgu;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.CountTimeoutEvent;
import kd.occ.ocepfp.core.form.event.CustomEvent;
import kd.occ.ocepfp.core.form.event.GoHistoryEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.MessageCallBackEvent;
import kd.occ.ocepfp.core.form.event.PayBackEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.business.pay.PosPayLogHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderCheckHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.enums.CloseStatusEnum;
import kd.occ.ocpos.common.enums.OrderStatusEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.QRCodeUtil;
import kd.occ.ocpos.common.vo.OlStoreInventoryVO;

public class PosOrderDetailPlugin
extends ExtBillViewPlugin {
    private final Log logger = LogFactory.getLog(PosOrderDetailPlugin.class);
    private static final String itementrys = "goodslist";
    private static final String cid_longitude = "longitude";
    private static final String cid_latitude = "latitude";
    private static final String cancel = "cancel";
    private static final int MIN_CLICK_DELAY_TIME = 2000;

    public void afterDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        Long billId = Long.parseLong(event.getCustomParam().getString("billId"));
        String sourceViewId = event.getCustomParam().getString("sourceviewid");
        BigDecimal saleQty = BigDecimal.ZERO;
        BigDecimal mustretQty = BigDecimal.ZERO;
        ((BillFormData)this.getBillData()).updateValue("billid", (Object)billId);
        ((BillFormData)this.getBillData()).updateValue("sourceviewid", (Object)sourceViewId);
        String isreservedoccupy = event.getCustomParam().getString("isreservedoccupy");
        ((BillFormData)this.getBillData()).updateValue("isreservedoccupy", (Object)isreservedoccupy);
        if (cancel.equals(sourceViewId)) {
            ((ExtBillView)this.view).showMessage("\u786e\u5b9a\u8981\u53d6\u6d88\u8ba2\u5355\u5417\uff1f", MessageBoxType.YesNO, new CallBackArgu());
        }
        long start = System.currentTimeMillis();
        String selectFields = "id,billno,sumbalamount,receivableamount,totalrealamount,endpayamount,creditamount,payticketinfo.id as ticketid,payticketinfo.tickettypeid as tickettypeid,payticketinfo.tickettypeid.usagemode as usagemode,payticketinfo.ticketvalue as ticketvalue,goodsentryentity.id as goodsentryid,goodsentryentity.saleqty as saleqty,goodsentryentity.goodsid as goodsid,goodsentryentity.goodsid.name as goodsname,goodsentryentity.discountprice as discountprice,goodsentryentity.ispresent as ispresent,goodsentryentity.goodsid.thumbnail as thumbnail,salebranchid.name as channelname,salebranchid.phone as channelphone,salebranchid.address as channeladdress,salebranchid.longitude as longitude,salebranchid.latitude as latitude,salebranchid.beginstoreworktime as beginstoreworktime,goodsentryentity.mustretqty as mustretqty,salebranchid.endstoreworktime as endstoreworktime,goodsentryentity.salesorderdelivery.id as deliveryid,goodsentryentity.salesorderdelivery.consignee as consignee,goodsentryentity.salesorderdelivery.deliverphonenumber as deliverphonenumber,goodsentryentity.salesorderdelivery.fulladdress as fulladdress,goodsentryentity.salesorderdelivery.selfpickuptime as selfpickuptime,goodsentryentity.salesorderdelivery.isselfpickup as isselfpickup,goodsentryentity.salesorderdelivery.receivedate as receivedate,closestatus,orderstatus,createtime,payticketinfo.number as ticketno,finentity.paytime as paytime";
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        DataSet dsOrderBill = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocpos_saleorder", (String)selectFields, (QFilter[])qFilter.toArray(), (String)"");
        if (dsOrderBill == null) {
            return;
        }
        DataSet dsOrderCopy = dsOrderBill.copy();
        Row firstOrderRow = dsOrderBill.next();
        this.logger.info("\u8ba2\u5355\u8be6\u60c5\u8017\u65f6\u7edf\u8ba1 \u8ba2\u5355\u67e5\u8be2SaleOrderDBHelper.querySaleOrderInfo  " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        boolean isselfpickup = firstOrderRow.getBoolean("isselfpickup");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String billNo = CommonUtil.formatStringToEmpty((Object)firstOrderRow.get("billno"));
        data.set("orderno", (Object)billNo);
        data.set("ordernocopy", (Object)billNo);
        BigDecimal sumBalAmount = CommonUtil.formatObjectToDecimal((Object)firstOrderRow.get("sumbalamount"));
        String orderStatus = CommonUtil.formatStringToEmpty((Object)firstOrderRow.get("orderstatus"));
        boolean isClose = CloseStatusEnum.CLOSE.getValue().equals(CommonUtil.formatStringToEmpty((Object)firstOrderRow.get("closestatus")));
        if (isClose) {
            orderStatus = OrderStatusEnum.CLOSED.getValue();
        }
        BigDecimal totalRealAmount = CommonUtil.formatObjectToDecimal((Object)firstOrderRow.get("totalrealamount"));
        BigDecimal endPayAmount = CommonUtil.formatObjectToDecimal((Object)firstOrderRow.get("endpayamount"));
        BigDecimal receivableAmount = CommonUtil.formatObjectToDecimal((Object)firstOrderRow.get("receivableamount"));
        BigDecimal creditAmount = CommonUtil.formatObjectToDecimal((Object)firstOrderRow.get("creditamount"));
        DataSet dsGoodsEntry = dsOrderCopy.select("goodsentryid,goodsid,goodsname,discountprice,saleqty,mustretqty,ispresent,thumbnail,deliveryid").groupBy(new String[]{"goodsentryid", "goodsid", "goodsname", "discountprice", "saleqty", "mustretqty", "ispresent", "thumbnail"}).max("deliveryid").finish();
        DataSet goodsRows = dsGoodsEntry.copy();
        long ticketId = CommonUtil.formatObejctToLong((Object)firstOrderRow.get("ticketid"));
        if (ticketId > 0L) {
            long ticketTypeId = CommonUtil.formatObejctToLong((Object)firstOrderRow.get("tickettypeid"));
            String usageMode = CommonUtil.formatStringToEmpty((Object)firstOrderRow.get("usagemode"));
            if (StringUtils.isEmpty((CharSequence)usageMode)) {
                ((ExtBillView)this.view).showMessage("\u793c\u5238\u65e0\u6548\u3002");
                String ticketNo = CommonUtil.formatStringToEmpty((Object)firstOrderRow.get("ticketno"));
                this.logger.info("\u8ba2\u5355\u8be6\u60c5 usageMode\u4e3a\u7a7a\uff0c number\uff1a" + ticketNo);
                return;
            }
            BigDecimal ticketValue = CommonUtil.formatObjectToDecimal((Object)firstOrderRow.get("ticketvalue"));
            BigDecimal realAmount = this.calulateTicketDiscount(usageMode, sumBalAmount, ticketValue, ticketTypeId, goodsRows);
            BigDecimal needToPay = realAmount.subtract(totalRealAmount.add(creditAmount));
            if (needToPay.compareTo(BigDecimal.ZERO) < 0) {
                needToPay = BigDecimal.ZERO;
            }
            data.set("sumamount", (Object)sumBalAmount);
            data.set("sumdiscount", (Object)sumBalAmount.subtract(realAmount).stripTrailingZeros().toPlainString());
            data.set("sumbalamount", (Object)needToPay);
            data.set("needtopay", (Object)needToPay);
        } else {
            BigDecimal needToPay = receivableAmount.subtract(totalRealAmount.add(creditAmount));
            if (needToPay.compareTo(BigDecimal.ZERO) < 0) {
                needToPay = BigDecimal.ZERO;
            }
            data.set("sumdiscount", (Object)BigDecimal.ZERO);
            data.set("sumbalamount", (Object)needToPay);
            data.set("needtopay", (Object)needToPay);
            data.set("sumamount", (Object)sumBalAmount);
        }
        ((BillFormData)this.getBillData()).updateValue(cid_longitude, firstOrderRow.get(cid_longitude));
        ((BillFormData)this.getBillData()).updateValue(cid_latitude, firstOrderRow.get(cid_latitude));
        this.logger.info("PosOrderDetailPlugin afterDataLoad \u9700\u8981\u652f\u4ed8\u7684\u91d1\u989d,sumbalamount:" + sumBalAmount);
        data.set("createtime", (Object)df.format(firstOrderRow.getDate("createtime")));
        ArrayList<Long> itemIdList = new ArrayList<Long>(0);
        Date receiveDate = firstOrderRow.getDate("receivedate");
        int i = 0;
        for (Row goodsEntry : dsGoodsEntry) {
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            itemIdList.add(goodsEntry.getLong("goodsid"));
            dataObject.set("id", (Object)goodsEntry.getString("goodsentryid"));
            dataObject.set("itemid", (Object)goodsEntry.getString("goodsid"));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + goodsEntry.getString("thumbnail")));
            dataObject.set("itemname", (Object)goodsEntry.getString("goodsname"));
            if (goodsEntry.getBoolean("ispresent").booleanValue()) {
                ((ExtBillView)this.view).hide("gift", false, i);
                dataObject.set("taxprice", (Object)BigDecimal.ZERO);
            } else {
                ((ExtBillView)this.view).hide("gift", true, i);
                dataObject.set("taxprice", (Object)goodsEntry.getBigDecimal("discountprice").stripTrailingZeros().toPlainString());
            }
            dataObject.set("deliveryid", (Object)goodsEntry.getLong("deliveryid"));
            dataObject.set("qty", goodsEntry.get("saleqty"));
            this.logger.info("\u8ba2\u5355\u8be6\u60c5-\u5546\u54c1\u53ef\u9000\u6570\u91cf-\u6570\u91cf\uff1amustretQty\uff1a", (Object)goodsEntry.getBigDecimal("mustretqty"));
            mustretQty = mustretQty.add(goodsEntry.getBigDecimal("mustretqty"));
            saleQty = saleQty.add(goodsEntry.getBigDecimal("saleqty"));
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
            ++i;
        }
        if (isselfpickup) {
            ((BillFormData)this.billData).updateValue("pickuptime", (Object)firstOrderRow.getString("selfpickuptime"));
            ((BillFormData)this.billData).updateValue("pickupstore", (Object)firstOrderRow.getString("channelname"));
            ((BillFormData)this.billData).updateValue("storephone", (Object)firstOrderRow.getString("channelphone"));
            ((BillFormData)this.billData).updateValue("address", (Object)firstOrderRow.getString("channeladdress"));
            ((BillFormData)this.billData).updateValue("deliverytype", (Object)"\u95e8\u5e97\u81ea\u63d0");
            this.hiddenPanelBaseString(firstOrderRow.getString("channeladdress"), "addresspanel");
            this.hiddenPanelBaseString(firstOrderRow.getString("channelphone"), "storephonepanel");
            this.hiddenPanelBaseString(firstOrderRow.getString("beginstoreworktime"), "storeworktimepanel");
            ((BillFormData)this.billData).updateValue("storeworktime", (Object)this.getStoreOpenTime(firstOrderRow.getLong("beginstoreworktime"), firstOrderRow.getLong("endstoreworktime")));
            ((ExtBillView)this.view).hide("ordertrackingpanel", true);
            ((ExtBillView)this.view).hide("pickupstorepanel", false);
            ((ExtBillView)this.view).hide("deliverypanel", true);
        } else {
            ((BillFormData)this.billData).updateValue("ordertrackingstatus", (Object)("\u5f53\u524d\u8ba2\u5355" + orderStatus + "\uff0c\u70b9\u51fb\u67e5\u770b\u66f4\u591a"));
            ((ExtBillView)this.view).hide("ordertrackingpanel", false);
            ((ExtBillView)this.view).hide("deliverypanel", false);
            ((ExtBillView)this.view).hide("pickupstorepanel", true);
            ((ExtBillView)this.view).hide("location", true);
            ((BillFormData)this.billData).updateValue("address", (Object)firstOrderRow.getString("fulladdress"));
            ((BillFormData)this.billData).updateValue("deliverytype", (Object)"\u5546\u5bb6\u914d\u9001");
        }
        ((ExtBillView)this.view).updateFrontValue("phone", (Object)firstOrderRow.getString("deliverphonenumber"));
        ((BillFormData)this.billData).updateValue("storename", (Object)firstOrderRow.getString("channelname"));
        ((BillFormData)this.billData).updateValue("consignee", (Object)firstOrderRow.getString("consignee"));
        this.logger.info("\u8ba2\u5355\u8be6\u60c5-\u5546\u54c1\u53ef\u9000\u6570\u91cf-\u603b\u6570\u91cf\uff1amustretQty\uff1a", (Object)mustretQty);
        if (mustretQty.compareTo(BigDecimal.ZERO) == 0) {
            orderStatus = OrderStatusEnum.CLOSED.getValue();
        }
        this.updateOrderStatusPanel(firstOrderRow, orderStatus, data, itemIdList, receiveDate, isselfpickup, sourceViewId);
        DecimalFormat deFormat = new DecimalFormat("#.00");
        ((BillFormData)this.billData).updateValue("saleqty", (Object)deFormat.format(saleQty.doubleValue()));
        String msg = "\u8ba2\u5355\u8be6\u60c5\u6570\u636e\u7ed1\u5b9a\u8017\u65f6\u7edf\u8ba1 afterDataLoad " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002";
        this.logger.info(msg);
    }

    private String getStoreOpenTime(long startTime, long endTime) {
        String result = startTime > 0L ? DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.ofSecondOfDay(startTime)) : "00:00:00";
        result = result + " - ";
        result = result + (endTime > 0L && endTime <= 86399L ? DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.ofSecondOfDay(endTime)) : "23:59:59");
        return result;
    }

    private void hiddenPanelBaseString(String name, String panelName) {
        if (StringUtil.isNotNull((String)name)) {
            ((ExtBillView)this.view).hide(panelName, false);
        } else {
            ((ExtBillView)this.view).hide(panelName, true);
        }
    }

    private void hiddenShowButton(DynamicObject orderInfo, DynamicObject goodsEntry, int i) {
        this.logger.info("\u5546\u54c1\u660e\u7ec6\u5173\u95ed\u72b6\u6001\uff1aitemname: " + goodsEntry.getString("goodsid.name") + ", rowclosestatus:" + goodsEntry.getString("rowclosestatus"));
    }

    private BigDecimal calulateTicketDiscount(String usageMode, BigDecimal sumbalamount, BigDecimal ticketValue, Long ticketTypeId, Object billData) {
        if (TicketUsageModeEnum.CASH.getName().equals(usageMode)) {
            if ((sumbalamount = sumbalamount.subtract(ticketValue)).compareTo(BigDecimal.ZERO) < 0) {
                sumbalamount = BigDecimal.ZERO;
            }
        } else if (TicketUsageModeEnum.ITEM_CONVERT.getName().equals(usageMode)) {
            HashMap<String, BigDecimal> itemMap = new HashMap<String, BigDecimal>(10);
            if (billData instanceof DataSet) {
                DataSet dsGoodsEntry = (DataSet)billData;
                for (Object goodsEntry : dsGoodsEntry) {
                    itemMap.put(goodsEntry.getString("goodsid"), goodsEntry.getBigDecimal("discountprice"));
                }
            } else {
                DynamicObject orderInfo = (DynamicObject)billData;
                DynamicObjectCollection dsGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)orderInfo, (String)"goodsentryentity");
                if (dsGoodsEntry != null && dsGoodsEntry.size() > 0) {
                    for (DynamicObject goodsEntry : dsGoodsEntry) {
                        itemMap.put(CommonUtil.formatStringToEmpty((Object)DynamicObjectUtils.getPkValue((DynamicObject)goodsEntry, (String)"goodsid")), goodsEntry.getBigDecimal("discountprice"));
                        this.logger.info("PosOrderDetailPlugin payMoney ,\u5546\u54c1Id:" + CommonUtil.formatStringToEmpty((Object)DynamicObjectUtils.getPkValue((DynamicObject)goodsEntry, (String)"goodsid")));
                    }
                }
            }
            DynamicObject ticketType = BusinessDataServiceHelper.loadSingle((Object)ticketTypeId, (String)"ocdbd_ticketstype");
            BigDecimal maxItemPrice = BigDecimal.ZERO;
            if (ticketType != null) {
                boolean isAllGoods = DynamicObjectUtil.getBoolean((DynamicObject)ticketType, (String)"isallgoods");
                if (isAllGoods) {
                    maxItemPrice = this.getMaxValue(itemMap);
                } else {
                    HashSet goodsIdList = OlstoreItemHelper.getItemListByTicketType((DynamicObject)ticketType);
                    Map<String, BigDecimal> filterMap = itemMap.entrySet().stream().filter(r -> goodsIdList.contains(Long.parseLong((String)r.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    maxItemPrice = this.getMaxValue(filterMap);
                }
            }
            if ((sumbalamount = sumbalamount.subtract(maxItemPrice)).compareTo(BigDecimal.ZERO) < 0) {
                sumbalamount = BigDecimal.ZERO;
            }
        }
        return sumbalamount;
    }

    private BigDecimal getMaxValue(Map<String, BigDecimal> map) {
        if (map == null || map.size() == 0) {
            return BigDecimal.ZERO;
        }
        int length = map.size();
        Collection<BigDecimal> c = map.values();
        Object[] obj = c.toArray();
        Arrays.sort(obj);
        return (BigDecimal)obj[length - 1];
    }

    private void goPage(ClickEvent event, String pageViewId, String sourceViewId) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId(pageViewId);
        openParam.addCustomParam("sourceviewid", sourceViewId);
        openParam.addCustomParam("billId", ((BillFormData)this.getBillData()).getString("billid"));
        if (pageViewId.equals("ocpos_itemdetails")) {
            DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow().getRow());
            openParam.addCustomParam("itemid", String.valueOf(entryRowData.get("itemid")));
        }
        ((ExtBillView)this.getView()).showView(openParam);
    }

    private void updateCountDown(DynamicObject data, Date createTime, String sourceViewId) {
        long nowTime = new Date().getTime();
        long createOrderTime = createTime.getTime();
        DynamicObject config = OlstoreConfigHelper.getOlstoreConfig();
        long countDownTime = config.getInt("autocanceldate") * 60;
        long leftTime = countDownTime - (nowTime - createOrderTime) / 1000L;
        this.logger.info("updateCountDown\u5012\u8ba1\u65f6, sourceViewId:" + sourceViewId + ",nowTime:" + nowTime + ",createOrderTime:" + createOrderTime + ",leftTime:" + leftTime);
        if (sourceViewId != null && sourceViewId.equals("ocpos_confirmorder")) {
            ((ExtBillView)this.view).startCountDown("paycountdown", countDownTime);
        } else if (leftTime > 0L) {
            ((ExtBillView)this.view).startCountDown("paycountdown", leftTime);
        } else {
            long billId = ((BillFormData)this.getBillData()).getLong("billid");
            JSONObject result = SaleOrderDBHelper.cancelSaleOrder((long)billId);
            this.logger.info("\u8ba2\u5355\u8be6\u60c5\u8ba2\u5355\u53d6\u6d88\u7ed3\u679c\uff1a" + result);
            if (result.getBoolean("success").booleanValue()) {
                ((ExtBillView)this.view).refresh();
            }
        }
    }

    private void updateOrderStatusPanel(Row orderInfo, String orderStatus, DynamicObject data, List<Long> itemIdList, Date receiveDate, boolean isselfpickup, String sourceViewId) {
        String orderstatus = orderInfo.getString("orderstatus");
        data.set("orderstatus", (Object)OrderStatusEnum.getName((String)orderstatus));
        if (OrderStatusEnum.TO_BE_PAID.getValue().equals(orderstatus)) {
            this.updateCountDown(data, orderInfo.getDate("createTime"), sourceViewId);
            ((ExtBillView)this.view).updateFrontValue("sumpayable", (Object)"\u5e94\u4ed8\u91d1\u989d");
            ((ExtBillView)this.view).hide("topaypanel", false);
            ((BillFormData)this.billData).updateValue("orderstatuspic", (Object)"/static/image/olstore/topay.png");
            ((ExtBillView)this.view).hide("ordertrackingpanel", true);
        } else {
            ((ExtBillView)this.view).updateFrontValue("sumpayable", (Object)"\u5b9e\u4ed8\u91d1\u989d");
            this.showSwitch(data, orderInfo);
            ((ExtBillView)this.view).hide("topaypanel", true);
            this.logger.info("\u8ba2\u5355\u8be6\u60c5-\u8ba2\u5355\u72b6\u6001\uff1aorderstatus\uff1a", (Object)orderstatus);
            switch (orderstatus) {
                case "A": {
                    if (isselfpickup) {
                        data.set("orderstatus", (Object)"\u5f85\u81ea\u63d0");
                        String qrCodeimg = QRCodeUtil.generalQRCode((String)orderInfo.getString("billno"));
                        ((ExtBillView)this.view).hide("orderpicpanel", false);
                        ((BillFormData)this.getBillData()).updateValue("orderpic", (Object)(PictureUtil.getFileServerUrl() + qrCodeimg));
                        ((ExtBillView)this.view).hide("pickuptimepanel", false);
                        ((BillFormData)this.billData).updateValue("orderstatuspic", (Object)"/static/image/olstore/staytopick.png");
                        break;
                    }
                    ((BillFormData)this.billData).updateValue("orderstatuspic", (Object)"/static/image/olstore/todeliver.png");
                    break;
                }
                case "B": {
                    ((BillFormData)this.billData).updateValue("orderstatuspic", (Object)"/static/image/olstore/shipped.png");
                    break;
                }
                case "Q": {
                    ((ExtBillView)this.view).hide("paytimepanel", true);
                    ((ExtBillView)this.view).hide("ordertrackingpanel", true);
                    ((BillFormData)this.billData).updateValue("orderstatuspic", (Object)"/static/image/olstore/cancel.png");
                    break;
                }
                case "Z": {
                    ((BillFormData)this.billData).updateValue("orderstatuspic", (Object)"/static/image/olstore/initiating_service.png");
                    break;
                }
                case "D": {
                    if (isselfpickup) {
                        data.set("orderstatus", (Object)"\u5df2\u81ea\u63d0");
                        ((BillFormData)this.billData).updateValue("orderstatuspic", (Object)"/static/image/olstore/pickuped.png");
                        break;
                    }
                    ((BillFormData)this.billData).updateValue("orderstatuspic", (Object)"/static/image/olstore/finished.png");
                    break;
                }
            }
        }
        ((ExtBillView)this.view).hide("buttonpanel", false);
        if (orderInfo.getString("orderstatus").equals(OrderStatusEnum.CANCELED.getValue()) || orderInfo.getString("orderstatus").equals(OrderStatusEnum.CLOSED.getValue()) || orderInfo.getString("orderstatus").equals(OrderStatusEnum.TO_BE_PAID.getValue())) {
            ((ExtBillView)this.view).hide("buttonpanel", true);
            if (orderInfo.getString("orderstatus").equals(OrderStatusEnum.TO_BE_PAID.getValue())) {
                ((ExtBillView)this.view).hide("pay_btn", false);
            } else {
                ((ExtBillView)this.view).hide("pay_btn", true);
            }
            this.logger.info("\u8ba2\u5355\u8be6\u60c5-\u8ba2\u5355\u72b6\u6001\uff1a\u5f85\u652f\u4ed8\u3001\u5df2\u53d6\u6d88\u3001\u5df2\u5173\u95ed\uff08\u5df2\u53d1\u8d77\u552e\u540e\uff09");
        }
        ((ExtBillView)this.view).hide("comment", true);
    }

    private int differentDaysByMillisecond(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    private void showSwitch(DynamicObject data, Row orderInfo) {
        ((ExtBillView)this.view).hide("buttonpanel", true);
        ((ExtBillView)this.view).hide("paytimepanel", false);
        ((ExtBillView)this.view).hide("orderstatuspanel", false);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date payTime = orderInfo.getDate("paytime");
        if (payTime != null) {
            data.set("paytime", (Object)df.format(payTime));
        }
    }

    private boolean isNoComment(List<Long> itemIdList, String orderNo) {
        ArrayList<Long> commentItemList = new ArrayList<Long>(10);
        QFilter filter = new QFilter("itemid", "in", itemIdList);
        filter.and(new QFilter("billno", "=", (Object)orderNo));
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocpos_evaluatedata");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        DynamicObject[] commentList = BusinessDataServiceHelper.load((String)"ocpos_evaluatedata", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray(), (String)"starlevel desc, evaluatetime desc");
        for (DynamicObject comment : commentList) {
            commentItemList.add(comment.getLong("itemid.id"));
        }
        for (Long itemId : itemIdList) {
            boolean contains = commentItemList.contains(itemId);
            if (contains) continue;
            return true;
        }
        return false;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "namepanel": 
            case "thumbnail": {
                this.goPage(event, "ocpos_itemdetails", "ocpos_orderdetail");
                break;
            }
            case "cancel": {
                ((ExtBillView)this.view).showMessage("\u786e\u5b9a\u8981\u53d6\u6d88\u8ba2\u5355\u5417\uff1f", MessageBoxType.YesNO, new CallBackArgu());
                break;
            }
            case "pay": {
                if (ButtonFastClickUtil.isFastClickByTime((long)2000L)) break;
                this.payMoney();
                break;
            }
            case "comment": {
                this.goPage(event, "ocpos_comment_select_list", "ocpos_orderlistm");
                break;
            }
            case "refund": {
                this.goPage(event, "ocpos_refundreturn_apply", "ocpos_orderdetail");
                break;
            }
            case "ordertracking": {
                this.goPage(event, "ocpos_ordertracking", "ocpos_orderdetail");
                break;
            }
            case "applyinvoice": {
                this.goPage(event, "ocpos_invoice_apply", "ocpos_orderdetail");
                break;
            }
            case "ordertrackingpanel": {
                this.goPage(event, "ocpos_ordertracking_list", "ocpos_orderdetail");
                break;
            }
            case "electwarranty": {
                this.goPage(event, "ocpos_electwarranty_list", "ocpos_orderdetail");
                break;
            }
        }
        super.onClick(event);
    }

    public void onGoHistory(GoHistoryEvent event) {
        OpenParam openParam = new OpenParam();
        if (((BillFormData)this.getBillData()).getString("sourceviewid").equals("ocpos_orderlistm")) {
            openParam.setViewId("ocpos_orderlistm");
        } else if (((BillFormData)this.getBillData()).getString("sourceviewid").equals("ocpos_purchaseinfolistm")) {
            openParam.setViewId("ocpos_userinfom");
        } else {
            openParam.setViewId("ocpos_mall");
        }
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        ((ExtBillView)this.view).showView(openParam);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void payMoney() {
        BigDecimal realAmount;
        DynamicObject orderInfo;
        long billId;
        long start;
        block9: {
            start = System.currentTimeMillis();
            billId = ((BillFormData)this.getBillData()).getLong("billid");
            orderInfo = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_saleorder");
            String saleStatus = orderInfo.getString("salestatus");
            if (StringUtils.equals((CharSequence)saleStatus, (CharSequence)"S")) {
                ((ExtBillView)this.view).showMessage("\u5df2\u652f\u4ed8\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
                return;
            }
            DynamicObject ticketInfo = orderInfo.getDynamicObject("payticketinfo");
            BigDecimal sumbalamount = orderInfo.getBigDecimal("sumbalamount");
            boolean isAllowZeroSettle = SaleOrderCheckHelper.checkIsAllowZeroSettleOrder((DynamicObject)orderInfo);
            if (!isAllowZeroSettle) {
                ((ExtBillView)this.view).showMessage("\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u672a\u542f\u7528\u5141\u8bb8\u6574\u5355\u96f6\u91d1\u989d\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97");
                return;
            }
            boolean isAllowZeroSale = SaleOrderCheckHelper.checkIsAllowZeroSaleNoGift((DynamicObject)orderInfo);
            if (!isAllowZeroSale) {
                ((ExtBillView)this.view).showMessage("\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u672a\u542f\u7528\u975e\u8d60\u54c1\u5141\u8bb8\u96f6\u5355\u4ef7\u9500\u552e\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97");
                return;
            }
            if (ticketInfo != null) {
                DynamicObject ticketInfoObject = BusinessDataServiceHelper.loadSingle((Object)ticketInfo.getLong("id"), (String)"ocdbd_ticketinfo");
                boolean isTicketstatus = "P".equals(ticketInfoObject.getString("ticketstatus"));
                boolean isStatus = "C".equals(ticketInfoObject.getString("status"));
                boolean isEnable = "1".equals(ticketInfoObject.getString("enable"));
                boolean isCancelstatus = "A".equals(ticketInfoObject.getString("cancelstatus"));
                this.logger.info("\u8ba2\u5355\u793c\u5238\u652f\u4ed8\u72b6\u6001:" + isTicketstatus + "," + isStatus + "," + isEnable + "," + isCancelstatus);
                if (isTicketstatus && isStatus && isEnable && isCancelstatus) {
                    Long ticketTypeId = ticketInfo.getLong("tickettypeid.id");
                    BigDecimal ticketValue = ticketInfo.getBigDecimal("ticketvalue");
                    DynamicObject ticketType = BusinessDataServiceHelper.loadSingle((Object)ticketTypeId, (String)"ocdbd_ticketstype");
                    String usageMode = DynamicObjectUtil.getString((DynamicObject)ticketType, (String)"usagemode");
                    if (usageMode == null) {
                        ((ExtBillView)this.view).showMessage("\u793c\u5238\u65e0\u6548\u3002");
                        this.logger.info("\u8ba2\u5355\u8be6\u60c5 usageMode\u4e3a\u7a7a\uff0c number\uff1a" + ticketInfo.getString("number"));
                        return;
                    }
                    realAmount = this.calulateTicketDiscount(usageMode, sumbalamount, ticketValue, ticketTypeId, orderInfo);
                    break block9;
                } else {
                    ((ExtBillView)this.view).showMessage("\u8be5\u793c\u5238\u4e0d\u53ef\u7528\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97");
                    return;
                }
            }
            realAmount = sumbalamount;
        }
        this.logger.info("PosOrderDetailPlugin payMoney \u9700\u8981\u652f\u4ed8\u7684\u91d1\u989d,realAmount:" + realAmount);
        if (realAmount.compareTo(BigDecimal.ZERO) == 0) {
            this.ticketBalanceSettle(orderInfo);
        } else {
            this.wxBalanceSettle(orderInfo, billId, realAmount);
        }
        this.logger.info("\u8ba2\u5355\u8be6\u60c5\u8017\u65f6\u7edf\u8ba1 \u652f\u4ed8\u524d\u64cd\u4f5c payMoney   " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
    }

    private void ticketBalanceSettle(DynamicObject orderInfo) {
        this.openPaySuccessView();
        JSONObject jsonObject = SaleOrderHelper.ticketInfoPay((DynamicObject)orderInfo, (long)orderInfo.getLong("member.id"));
        this.logger.info("PosOrderDetailPlugin ticketBalanceSettle \u6838\u9500\u793c\u5238 \u7ed3\u679c\uff1a" + JSON.toJSONString((Object)jsonObject));
        PosPayLogHelper.savePayLog((String)orderInfo.getString("billno"), (String)JSON.toJSONString((Object)jsonObject), (int)1);
        if (jsonObject == null || jsonObject.get((Object)"code").equals("success")) {
            this.logger.info("PosOrderDetailPlugin ticketBalanceSettle \u6838\u9500\u793c\u5238\u6210\u529f");
            List<JSONObject> params = this.buildPaySuccessParam(orderInfo, null, null, null);
            SaleOrderHelper.afterPaySuccess((DynamicObject)orderInfo, params, (String)"1");
        } else {
            this.logger.info("PosOrderDetailPlugin ticketBalanceSettle \u6838\u9500\u793c\u5238\u5931\u8d25\uff0c" + jsonObject.getString("message"));
            ((ExtBillView)this.view).showMessage(jsonObject.getString("message"));
        }
    }

    private List<JSONObject> buildPaySuccessParam(DynamicObject orderInfo, BigDecimal totalrealamount, String outTradeNo, String TradeNo) {
        DynamicObject ticketInfo = orderInfo.getDynamicObject("payticketinfo");
        ArrayList<JSONObject> result = new ArrayList<JSONObject>(0);
        if (ticketInfo != null) {
            Long ticketTypeId = ticketInfo.getLong("tickettypeid.id");
            DynamicObject ticketType = BusinessDataServiceHelper.loadSingle((Object)ticketTypeId, (String)"ocdbd_ticketstype");
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"giftvoucherpay"), (String)"ocdbd_paymode");
            DynamicObject payWayType = BusinessDataServiceHelper.loadSingle((Object)960799969067988992L, (String)"ocdbd_paywaytype");
            JSONObject params = new JSONObject();
            params.put("amount", (Object)orderInfo.getBigDecimal("sumbalamount"));
            params.put("payWay", (Object)payWay);
            params.put("payWayType", (Object)payWayType);
            params.put("cardNo", (Object)ticketInfo.getString("number"));
            params.put("ticketInfoId", (Object)ticketInfo.getString("id"));
            params.put("ticketInfo", (Object)ticketInfo);
            params.put("ticketTypeId", (Object)ticketInfo.getString("tickettypeid.id"));
            params.put("ticketType", (Object)ticketType);
            result.add(params);
        }
        if (StringUtil.isNotNull((String)outTradeNo)) {
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"wechatpayment"), (String)"ocdbd_paymode");
            DynamicObject payWayType = BusinessDataServiceHelper.loadSingle((Object)960797054941170688L, (String)"ocdbd_paywaytype");
            JSONObject params = new JSONObject();
            params.put("amount", (Object)totalrealamount);
            params.put("payWay", (Object)payWay);
            params.put("payWayType", (Object)payWayType);
            params.put("orderNo", (Object)outTradeNo);
            params.put("bankExchangeNo", (Object)TradeNo);
            result.add(params);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void wxBalanceSettle(DynamicObject orderInfo, long billid, BigDecimal totalrealamount) {
        CheckOutCounterInfo checkOutCounterInfo = new CheckOutCounterInfo();
        String billNo = orderInfo.getString("billno");
        long storeId = orderInfo.getLong("salebranchid.id");
        long orgId = orderInfo.getLong("bizorgid.id");
        checkOutCounterInfo.setBillNo(billNo);
        DynamicObjectCollection goodsentryentity = orderInfo.getDynamicObjectCollection("goodsentryentity");
        if (goodsentryentity != null && goodsentryentity.size() > 0) {
            checkOutCounterInfo.setBody("\u8d2d\u4e70\u4e86" + ((DynamicObject)goodsentryentity.get(0)).getString("goodsid.name"));
        }
        checkOutCounterInfo.setOperaTime(new Date());
        checkOutCounterInfo.setSpbillCreateIp("127.0.0.1");
        checkOutCounterInfo.setStoreId(storeId);
        long memberId = orderInfo.getLong("member.id");
        DynamicObject olstoreCogInfo = OlstoreConfigHelper.getOlstoreConfig();
        String appId = olstoreCogInfo.getString("appid");
        JSONObject jsonObject = OlstoreMemberHelper.queryWechatUserById((String)appId, (long)memberId);
        if (jsonObject == null) {
            this.logger.info("wxBalanceSettle queryWechatUserById \u83b7\u53d6\u7ed3\u679c\u4e3anull");
            return;
        }
        if (jsonObject.getInteger("code") != 0) {
            this.logger.info("wxBalanceSettle queryWechatUserById result :" + jsonObject);
            ((ExtBillView)this.view).showMessage("\u652f\u4ed8\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u662f\uff1a" + jsonObject.getString("message"));
            return;
        }
        this.logger.info("wxBalanceSettle queryWechatUserById result :" + jsonObject.toJSONString());
        JSONObject data = jsonObject.getJSONObject("data");
        checkOutCounterInfo.setOpenId(data.getString("openId"));
        checkOutCounterInfo.setOperatorId(memberId);
        HashMap<String, String> map = new HashMap<String, String>(5);
        PageCache pageCache = new PageCache(((ExtBillView)this.view).getPageId());
        pageCache.put("billNo", billNo);
        pageCache.put("storeId", String.valueOf(storeId));
        pageCache.put("orgId", String.valueOf(orgId));
        pageCache.put("memberId", String.valueOf(memberId));
        pageCache.put("billid", String.valueOf(billid));
        pageCache.put("totalrealamount", totalrealamount.toString());
        long payWay = PayTradeHelper.getOlStorePayWay((long)storeId);
        pageCache.put("payWay", String.valueOf(payWay));
        if (PaymentModeEnum.getKey((String)"wechatpayment") == payWay) {
            MiniPayResult miniPayData = PayTradeHelper.getMiniPayData((CheckOutCounterInfo)checkOutCounterInfo, (BigDecimal)totalrealamount);
            this.logger.info("wxBalanceSettle getMiniPayData result :" + JSON.toJSONString((Object)miniPayData));
            if (!TradeStatus.SUCCESS.equals((Object)miniPayData.getTradeStatus())) {
                ((ExtBillView)this.view).showMessage("\u5fae\u4fe1\u652f\u4ed8\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u662f\uff1a" + miniPayData.getErrorMessage());
                return;
            }
            JSONObject payResponse = miniPayData.getPayResponse();
            String outTradeNo = payResponse.getString("out_trade_no");
            String tradeNo = payResponse.getString("trade_no");
            map.put("timeStamp", miniPayData.getTimeStamp());
            map.put("nonceStr", miniPayData.getNonceStr());
            map.put("package", miniPayData.getPackages());
            map.put("signType", miniPayData.getSignType());
            map.put("paySign", miniPayData.getPaySign());
            pageCache.put("outTradeNo", outTradeNo);
            pageCache.put("tradeNo", tradeNo);
            pageCache.put("payResponse", payResponse.toJSONString());
        } else {
            if (PaymentModeEnum.getKey((String)"kingdeefinancepay") != payWay) {
                ((ExtBillView)this.view).showMessage("\u7ebf\u4e0a\u652f\u4ed8\u5f53\u524d\u4ec5\u652f\u6301\u5fae\u4fe1\u652f\u4ed8\u6216\u91d1\u8776\u91d1\u878d\u652f\u4ed8\uff0c\u4e14\u9700\u52fe\u9009'\u9002\u7528\u7ebf\u4e0a\u652f\u4ed8'\uff0c\u8bf7\u524d\u5f80\u540e\u53f0\u914d\u7f6e\u3002");
                return;
            }
            MiniPayResult finPayData = FinPayTradeHelper.finPay((CheckOutCounterInfo)checkOutCounterInfo, (BigDecimal)totalrealamount);
            this.logger.info("KingDeePayBalanceSettle finPayData result :" + JSON.toJSONString((Object)finPayData));
            JSONObject finPay = finPayData.getPayResponse();
            this.logger.info("KingDeePayBalanceSettle finPay result :" + JSON.toJSONString((Object)finPay));
            if (!ResponseEnum.TRADE_SUCCESS.getCode().equals(finPay.getString("bizCode"))) {
                ((ExtBillView)this.view).showMessage("\u91d1\u8776\u91d1\u878d\u652f\u4ed8\u63a5\u53e3\u652f\u4ed8\u5931\u8d25\uff1a" + finPay.getString("bizMsg"));
                return;
            }
            map.put("timeStamp", finPay.getString("timeStamp"));
            map.put("nonceStr", finPay.getString("nonceStr"));
            map.put("package", finPay.getString("packages"));
            map.put("signType", finPay.getString("signType"));
            map.put("paySign", finPay.getString("paySign"));
            pageCache.put("outTradeNo", finPay.getString("bizNo"));
            pageCache.put("payResponse", finPay.toJSONString());
            pageCache.put("tradeNo", finPay.getString("tradeNO"));
        }
        this.logger.info("KingDeePayBalanceSettle prepay :" + JSON.toJSONString(map));
        List params = SaleOrderHelper.buildKDPaySuccessParam((DynamicObject)orderInfo, (BigDecimal)totalrealamount, (String)pageCache.get("outTradeNo"), (String)pageCache.get("tradeNo"));
        TicketPayHelper.afterPayTicketSuccess((DynamicObject)orderInfo, (List)params, (String)"1");
        ((ExtBillView)this.view).wxPay(map);
        ((ExtBillView)this.view).addCustomEvent(new CustomEvent("asynInventory"));
    }

    public void onPayBack(PayBackEvent event) {
        Object payStatus = ((Map)event.getEventParam().get((Object)"pay")).get("result");
        boolean isPaysuccess = (Boolean)payStatus;
        if (isPaysuccess) {
            OpenParam openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setShowTitle(Boolean.TRUE);
            openParam.addCustomParam("billId", ((BillFormData)this.billData).getString("billid"));
            openParam.setViewId("ocpos_paycomplete");
            openParam.setEnabelHistory(false);
            ((ExtBillView)this.view).showView(openParam);
        }
        super.onPayBack(event);
    }

    private void openPaySuccessView() {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId("ocpos_paycomplete");
        openParam.setEnabelHistory(false);
        openParam.addCustomParam("billId", ((BillFormData)this.getBillData()).getString("billid"));
        ((ExtBillView)this.getView()).showView(openParam);
    }

    public void onCountTimeout(CountTimeoutEvent event) {
        this.cancelOrder();
    }

    public void onMessageCallBack(MessageCallBackEvent event) {
        Map messageBackMap = (Map)event.getEventParam().get((Object)"messageback");
        int result = messageBackMap.getOrDefault("result", 0);
        if (result == 1) {
            this.cancelOrder();
        }
        super.onMessageCallBack(event);
    }

    private void cancelOrder() {
        long billId = ((BillFormData)this.getBillData()).getLong("billid");
        JSONObject result = SaleOrderDBHelper.cancelSaleOrder((long)billId);
        if (result.getBoolean("success").booleanValue()) {
            OpenParam openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setShowTitle(Boolean.TRUE);
            openParam.setEnabelHistory(false);
            openParam.setViewId("ocpos_orderdetail");
            openParam.addCustomParam("sourceviewid", "ocpos_orderdetail");
            openParam.addCustomParam("billId", String.valueOf(billId));
            ((ExtBillView)this.getView()).showView(openParam);
            DynamicObject saleOrderInfo = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_saleorder");
            DynamicObjectCollection goodsEntry = saleOrderInfo.getDynamicObjectCollection("goodsentryentity");
            boolean isHasReservedInventory = false;
            HashMap billIdMap = new HashMap(16);
            ArrayList<Long> billEntryIdList = new ArrayList<Long>();
            for (DynamicObject goods : goodsEntry) {
                if (goods.getBoolean("isnegativesell")) {
                    billEntryIdList.add(Long.valueOf(String.valueOf(goods.getPkValue())));
                    continue;
                }
                isHasReservedInventory = true;
            }
            if (billEntryIdList.size() > 0) {
                String billFormId = "ocpos_saleorder";
                billIdMap.put(billId, billEntryIdList);
                DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"OverSalePolicyService", (String)"releaseOverSalePolicy", (Object[])new Object[]{billFormId, billIdMap});
            }
            if (isHasReservedInventory) {
                this.releaseInventory(billId);
            }
        } else {
            ((ExtBillView)this.view).showMessage(result.getString("error"));
        }
    }

    private void releaseInventory(long billId) {
        ArrayList<OlStoreInventoryVO> inventoryVoList = new ArrayList<OlStoreInventoryVO>(1);
        OlStoreInventoryVO inventoryVO = new OlStoreInventoryVO();
        inventoryVO.setOperation("cancelorder");
        inventoryVO.setBillId(Long.valueOf(billId));
        inventoryVoList.add(inventoryVO);
        OlstoreInventoryHelper.executeInventoryStrategy(inventoryVoList);
    }
}

