/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SelectedRow;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.AbstractFormData;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocepfp.core.service.admindivision.AdminDivisionHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;

public class PosOrderMemberAddress
extends ExtListViewPlugin {
    private static final String cid_addresslist = "addresslist";

    public ListDataSet<DynamicObjectCollection> onDataLoad(LoadDataEvent event) {
        String addressId;
        ListDataSet listDataSet = super.onDataLoad(event);
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        DynamicObjectCollection pageData = this.getAddressList(memberId, addressId = event.getCustomParam().getString("addressid"));
        if (pageData != null && pageData.size() > 0) {
            listDataSet.setRows((Object)pageData);
        }
        return listDataSet;
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        List selectRows = event.getSelections(cid_addresslist);
        DynamicObjectCollection selectEntrys = ((ListFormData)this.getBillData()).getEntryRowData(cid_addresslist, selectRows);
        switch (eventId) {
            case "addresspanel": {
                if (selectEntrys == null || selectEntrys.size() <= 0) break;
                DynamicObject address = (DynamicObject)selectEntrys.get(0);
                this.updateParentBillData(address);
                break;
            }
            case "addbtn": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.Pop);
                openParam.addCustomParam("sourceviewid", ((ExtListView)this.view).getViewId());
                openParam.setViewId("ocpos_deliveryaddresseditm");
                ((ExtListView)this.getView()).showView(openParam);
                ((ExtListView)this.view).closeView();
                break;
            }
        }
        super.onClick(event);
    }

    private DynamicObjectCollection getAddressList(long memberId, String addressId) {
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        JSONObject deliveryAddressResult = OlstoreMemberHelper.getDeliveryAddressList((long)memberId);
        if (deliveryAddressResult == null || deliveryAddressResult.getInteger("code") != 0) {
            return entryList;
        }
        JSONArray dataList = deliveryAddressResult.getJSONArray("data");
        if (dataList != null && dataList.size() > 0) {
            List jsonList = dataList.toJavaList(JSONObject.class);
            AtomicInteger index = new AtomicInteger(0);
            for (JSONObject jsondata : jsonList) {
                DynamicObject entryData = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(cid_addresslist);
                int rowid = index.getAndIncrement();
                entryData.set("id", (Object)jsondata.getLong("id"));
                if (jsondata.getString("id").equals(addressId)) {
                    ((ExtListView)this.view).setRowSelection(cid_addresslist, rowid, true, false);
                }
                String districtName = AdminDivisionHelper.getDivisionName((long)jsondata.getLong("districtId"));
                entryData.set("address", (Object)(districtName + jsondata.getString("detailedAddress")));
                entryData.set("linkman", (Object)jsondata.getString("contact"));
                entryData.set("linkphone", (Object)jsondata.getString("phone"));
                entryData.set("districtid", (Object)jsondata.getLong("districtId"));
                entryList.add((Object)entryData);
            }
        }
        return entryList;
    }

    protected void onRowSelected(SelectAllEvent event) {
        List addresslist = event.getSelections(cid_addresslist);
        if (!CommonUtils.isNull((Object)addresslist)) {
            DynamicObject address = ((ListFormData)this.getBillData()).getEntryRowData(cid_addresslist, (SelectedRow)event.getSelections(cid_addresslist).get(0));
            this.updateParentBillData(address);
        }
    }

    private void updateParentBillData(DynamicObject address) {
        AbstractExtFormPlugin parentForm = ((ExtListView)this.view).getParentForm();
        AbstractFormData parentData = (AbstractFormData)parentForm.getBillData();
        this.updateAddress(parentData, address);
        ExtDynamicView parentView = parentForm.getDynamicView();
        parentView.hide("addshippingpanel", true);
        parentView.hide("distributionpanel", false);
        ((ExtListView)this.view).closeView();
    }

    private void updateAddress(AbstractFormData parentData, DynamicObject address) {
        parentData.updateValue("addressid", (Object)address.getString("id"));
        parentData.updateValue("address", (Object)address.getString("address"));
        parentData.updateValue("linkman", (Object)address.getString("linkman"));
        parentData.updateValue("linkphone", (Object)address.getString("linkphone"));
        parentData.updateValue("districtid", (Object)address.getString("districtid"), true);
        parentData.updateFormData();
    }
}

