/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;

public class PosOrderTrackingListPlugin
extends ExtBillViewPlugin {
    private final Log logger = LogFactory.getLog(PosOrderTrackingListPlugin.class);
    private static final String itementrys = "goodslist";

    public void afterDataLoad(LoadDataEvent event) {
        Long billId = Long.parseLong(event.getCustomParam().getString("billId"));
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billId);
        DynamicObjectCollection goodsentryentity = orderInfo.getDynamicObjectCollection("goodsentryentity");
        for (int i = 0; i < goodsentryentity.size(); ++i) {
            DynamicObject goodsEntry = (DynamicObject)goodsentryentity.get(i);
            DynamicObject goods = goodsEntry.getDynamicObject("goodsid");
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            this.logger.info("PosOrderTrackingListPlugin\u8ba2\u5355\u8ddf\u8e2a\uff1a" + goods.getString("id"));
            dataObject.set("id", (Object)goods.getString("id"));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + goods.getString("thumbnail")));
            dataObject.set("itemname", (Object)goods.getString("name"));
            DynamicObjectCollection salesorderdelivery = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
            DynamicObject delivery = (DynamicObject)salesorderdelivery.get(0);
            dataObject.set("deliverystatus", (Object)delivery.getString("deliverystatus.name"));
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
        }
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "thumbnail": {
                this.goPage(event, "ocpos_itemdetails");
                break;
            }
            case "ordertracking": {
                this.goPage(event, "ocpos_ordertracking");
                break;
            }
        }
        super.onClick(event);
    }

    private void goPage(ClickEvent event, String viewId) {
        DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow().getRow());
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId(viewId);
        openParam.addCustomParam("itemid", entryRowData.getString("id"));
        openParam.addCustomParam("thumbnail", entryRowData.get("thumbnail"));
        openParam.addCustomParam("itemname", entryRowData.getString("itemname"));
        openParam.addCustomParam("deliverystatus", entryRowData.getString("deliverystatus"));
        openParam.addCustomParam("billId", ((BillFormData)this.getBillData()).getString("billid"));
        ((ExtBillView)this.getView()).showView(openParam);
    }
}

