/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocdbd.common.mempoint.PointDetailVO;
import kd.occ.ocepfp.common.util.CollectionUtil;
import kd.occ.ocepfp.core.form.control.controls.SwitchTabBar;
import kd.occ.ocepfp.core.form.control.controls.SwitchTabBarItem;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;

public class PosPointListPlugin
extends ExtBillViewPlugin {
    protected static Log logger = LogFactory.getLog(PosPointListPlugin.class);
    private static final String pointentrys = "pointlist";
    private static final String pointtypelist = "pointtypelist";

    public void afterBindData(LoadDataEvent event) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        BigDecimal pointValue = OlstoreMemberHelper.getMemberPoint((String)String.valueOf(memberId), null);
        logger.info("\u79ef\u5206\u660e\u7ec6\u5217\u8868  \u4f1a\u5458memberId\uff1a" + memberId + ",\u79ef\u5206\u603b\u6570pointValue\uff1a" + pointValue);
        this.getPointList(memberId, null);
        ((BillFormData)this.billData).updateValue("pointnumber", (Object)pointValue);
        ((BillFormData)this.billData).updateValue(pointtypelist, (Object)"0");
        ((ExtBillView)this.view).setActiveByValue(pointtypelist, "0");
    }

    public boolean initView(InitViewEvent initViewEvent) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        DynamicObject[] pointTypes = this.queryPointType();
        SwitchTabBar pointTypeList = (SwitchTabBar)((ExtBillView)this.getView()).getControl(pointtypelist);
        SwitchTabBarItem switchTabBarItem = new SwitchTabBarItem();
        switchTabBarItem.setId("0");
        switchTabBarItem.setValue((Object)0);
        switchTabBarItem.setName("\u5168\u90e8");
        switchTabBarItem.setActive(true);
        pointTypeList.addChild((Object)switchTabBarItem);
        for (DynamicObject pointType : pointTypes) {
            Long id = pointType.getLong("id");
            String name = pointType.getString("name");
            BigDecimal pointValue = OlstoreMemberHelper.getMemberPoint((String)String.valueOf(memberId), (Long)id);
            logger.info("\u79ef\u5206\u660e\u7ec6\u5217\u8868  \u4f1a\u5458memberId\uff1a" + memberId + ",\u79ef\u5206\u7c7b\u578b\uff1a" + name + ",\u79ef\u5206\u603b\u6570pointValue\uff1a" + pointValue);
            SwitchTabBarItem switchTab = new SwitchTabBarItem();
            switchTab.setId(String.valueOf(id));
            switchTab.setValue((Object)String.valueOf(id));
            switchTab.setName(name + "\uff08" + pointValue + "\uff09");
            pointTypeList.addChild((Object)switchTab);
        }
        return false;
    }

    private String getPointName(PointDetailVO pointDetailVO) {
        StringBuilder sb = new StringBuilder();
        if (pointDetailVO.getChangeSign().equals("A")) {
            sb.append('+');
        } else {
            sb.append('-');
        }
        return sb.append(pointDetailVO.getQty()).toString();
    }

    private DynamicObject[] queryPointType() {
        QFilter filter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdbd_mpointtype");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        return BusinessDataServiceHelper.load((String)"ocdbd_mpointtype", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        switch (eventId) {
            case "pointtypelist": {
                String pointTypeId = event.getBillData().getString(pointtypelist);
                this.updatePointList(memberId, Long.parseLong(pointTypeId));
                ((ExtBillView)this.view).setActiveByValue(pointtypelist, pointTypeId);
                break;
            }
        }
        super.onClick(event);
    }

    private void updatePointList(Long memberId, Long pointTypeId) {
        DynamicObjectCollection entryRowData = ((BillFormData)this.billData).getEntryRowData(pointentrys);
        while (CollectionUtil.isNotNull((List)entryRowData)) {
            ((BillFormData)this.billData).delEntryRow(pointentrys, 0);
        }
        this.getPointList(memberId, pointTypeId);
    }

    private void getPointList(Long memberId, Long pointTypeId) {
        logger.info("\u79ef\u5206\u6d41\u6c34\u67e5\u8be2Page,\u53c2\u6570memberId\uff1a" + memberId + ",pointTypeId\uff1a" + pointTypeId);
        JSONObject result = OlstoreMemberHelper.queryPointList((long)memberId, (int)1, (int)1000, (Long)pointTypeId);
        logger.info("\u79ef\u5206\u6d41\u6c34\u67e5\u8be2Page,result" + JSONObject.toJSONString((Object)result));
        if (result == null) {
            ((ExtBillView)this.view).showMessage("\u79ef\u5206\u6d41\u6c34\u67e5\u8be2\u5f02\u5e38\uff1aresult is null");
        } else if (result.getInteger("code") == 0) {
            List pointDetailVOList = JSON.parseArray((String)result.getJSONArray("data").toJSONString(), PointDetailVO.class);
            for (PointDetailVO pointDetailVO : pointDetailVOList) {
                DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(pointentrys);
                dataObject.set("name", (Object)OlstoreMemberHelper.queryPointBizTypeNameById((long)pointDetailVO.getPointBizTypeId()));
                dataObject.set("billno", (Object)pointDetailVO.getBillNo());
                dataObject.set("point", (Object)this.getPointName(pointDetailVO));
                dataObject.set("transactiontime", (Object)pointDetailVO.getTransactionTime());
                ((BillFormData)this.getBillData()).addEntryRow(pointentrys, dataObject);
            }
            boolean isHaveData = pointDetailVOList.size() > 0;
            ((ExtBillView)this.view).hide(pointentrys, !isHaveData);
            ((ExtBillView)this.view).hide("nonepic", isHaveData);
            ((ExtBillView)this.view).hide("nonetip", isHaveData);
        } else {
            ((ExtBillView)this.view).showMessage(result.getString("message"));
        }
    }
}

