/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.business.promotion.PromotionHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class PosPromotionInfoPlugin
extends ExtBillViewPlugin {
    private static Log logger = LogFactory.getLog(PosPromotionInfoPlugin.class);
    private static final String cid_promotion_info = "promotioninfo";
    private static final String cid_promotionname = "promotionname";

    public DynamicObject onDataLoad(LoadDataEvent event) {
        String paramId;
        JSONObject paramInfo;
        DynamicObject data = super.onDataLoad(event);
        String storeId = null;
        String promotionId = event.getCustomParam().getString("promotionid");
        long memberId = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
        if (CommonUtils.isNull((Object)promotionId) && (paramInfo = OlstoreUtil.getGuideParamJSONObject((String)(paramId = event.getCustomParam().getString("paramid")))) != null) {
            promotionId = paramInfo.getString("promotionid");
            String billNo = paramInfo.getString("billno");
            String guideId = paramInfo.getString("guideid");
            storeId = paramInfo.getString("storeid");
            this.updateCurrentStore(storeId);
            String sourceType = paramInfo.getString("sourcetype");
            String role = paramInfo.getString("role");
            OlstoreUtil.regularMarketClick((String)billNo, (String)guideId, (String)String.valueOf(memberId), (String)storeId, (String)role, (String)sourceType);
        }
        if (StringUtils.isNotBlank((CharSequence)event.getCustomParam().getString("storeid"))) {
            String storeid = event.getCustomParam().getString("storeid");
            this.updateCurrentStore(storeid);
        }
        StringBuilder shareUrl = new StringBuilder("?viewId=ocpos_promotion_info&promotionid=").append(promotionId);
        if (StringUtils.isNotBlank(storeId)) {
            shareUrl.append("&storeid=").append(storeId);
        }
        logger.info("PosPromotionInfoPlugin_onDataLoad_shareUrl=" + shareUrl);
        DynamicObject promotion = PromotionHelper.getContentById((String)promotionId);
        String marketPromoteName = "";
        if (promotion != null) {
            data.set(cid_promotion_info, promotion.get("description_tag"));
            data.set(cid_promotionname, (Object)promotion.getString("name"));
            marketPromoteName = promotion.getString("name");
        }
        String subjectpic = DynamicObjectUtils.getString((DynamicObject)promotion, (String)"subjectpic");
        String pic = PictureUtil.getFileServerUrl() + subjectpic;
        ((ExtBillView)this.view).initShareUrl("sharebutton", shareUrl.toString(), marketPromoteName, pic);
        return data;
    }

    private void updateCurrentStore(String storeId) {
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo((long)Long.parseLong(storeId));
        if (storeInfo != null) {
            String storeName = storeInfo.getString("name");
            if (StringUtils.isNotBlank((CharSequence)storeId) && StringUtils.isNotBlank((CharSequence)storeName)) {
                JSONObject storeJson = new JSONObject();
                storeJson.put("id", (Object)storeId);
                storeJson.put("name", (Object)storeName);
                OlstoreUtil.setCurrentStore((ExtDynamicView)((ExtDynamicView)this.view), (String)storeJson.toJSONString());
            }
        }
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "preolinvitation": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_ticketorder_pay");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "share": {
                long vipID = ((ExtBillView)this.getView()).getExtCtx().getMemberId();
                if (vipID > 0L) break;
                ((ExtBillView)this.view).showMessage("\u6b64\u64cd\u4f5c\u9700\u8981\u767b\u5f55\uff0c\u662f\u5426\u524d\u5f80\u767b\u5f55\uff1f", MessageBoxType.YesNO, OlstoreUtil.createBtnCallBackArgu((String)"login", (String)"receiveticket"));
                break;
            }
        }
        super.onClick(event);
    }
}

