/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.text.SimpleDateFormat;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.promotion.PromotionHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class PosPromotionListPlugin
extends ExtListViewPlugin {
    private static final String cid_promotionlist = "promotionlist";
    private static final String cid_promotionpic = "promotionpic";
    private static final String cid_promotionname = "promotionname";
    private static final String cid_starttime = "promotionstarttime";
    private static final String cid_endtime = "promotionendtime";
    private static final String cid_promotionid = "promotionid";

    public ListDataSet<DynamicObjectCollection> onDataLoad(LoadDataEvent event) {
        ListDataSet listDataSet = super.onDataLoad(event);
        long currentStoreId = OlstoreUtil.getStoreId((ClientEvent)event);
        DynamicObjectCollection pageData = this.getPromotionList(currentStoreId);
        if (pageData != null && pageData.size() > 0) {
            listDataSet.setRows((Object)pageData);
            ((ExtListView)this.view).hide("promotionList_scroller", false);
            ((ExtListView)this.view).hide("promotion_none_panel", true);
        } else {
            ((ExtListView)this.view).hide("promotionList_scroller", true);
            ((ExtListView)this.view).hide("promotion_none_panel", false);
        }
        return listDataSet;
    }

    private DynamicObjectCollection getPromotionList(long storeId) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        DynamicObjectCollection promotionList = PromotionHelper.getAllPromotionList();
        if (promotionList != null && promotionList.size() > 0) {
            for (DynamicObject promotion : promotionList) {
                DynamicObject entryData = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(cid_promotionlist);
                entryData.set("id", promotion.get("id"));
                entryData.set(cid_promotionid, promotion.get("id"));
                entryData.set(cid_promotionpic, (Object)promotion.getString("subjectpic"));
                entryData.set(cid_promotionname, promotion.get("name"));
                entryData.set(cid_starttime, (Object)simpleDateFormat.format(promotion.getDate("starttime")));
                entryData.set(cid_endtime, (Object)simpleDateFormat.format(promotion.getDate("endtime")));
                entryList.add((Object)entryData);
            }
        }
        return entryList;
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        List selectRows = event.getSelections(cid_promotionlist);
        DynamicObjectCollection selectEntrys = ((ListFormData)this.getBillData()).getEntryRowData(cid_promotionlist, selectRows);
        switch (eventId) {
            case "promotionpanel": {
                if (selectEntrys == null || selectEntrys.size() <= 0) break;
                OpenParam openParam = new OpenParam();
                String promotionId = ((DynamicObject)selectEntrys.get(0)).getString(cid_promotionid);
                openParam.addCustomParam(cid_promotionid, promotionId);
                openParam.setViewId("ocpos_promotion_info");
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                ((ExtListView)this.view).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }
}

