/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.util.ButtonFastClickUtil;
import kd.occ.ocepfp.common.constant.Enums;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.BigDecimalUtil;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import org.apache.commons.lang.StringUtils;

public class PosRefundApplyPlugin
extends ExtBillViewPlugin {
    private static final String itementrys = "goodslist";
    protected static Log logger = LogFactory.getLog(PosRefundApplyPlugin.class);
    private static final int MIN_CLICK_DELAY_TIME = 2000;

    public void afterDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        Long billId = Long.parseLong(event.getCustomParam().getString("billId"));
        String itemId = event.getCustomParam().getString("itemId");
        logger.info("PosRefundApplyPlugin afterDataLoad billId:" + billId, (Object)("itemId:" + itemId));
        ((BillFormData)this.getBillData()).updateValue("billid", (Object)billId);
        ((BillFormData)this.getBillData()).updateValue("itemid", (Object)itemId);
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billId);
        data.set("totalrealamount", (Object)orderInfo.getBigDecimal("totalrealamount").stripTrailingZeros().toPlainString());
        DynamicObjectCollection goodsentryentity = orderInfo.getDynamicObjectCollection("goodsentryentity");
        if (StringUtils.isNotBlank((String)itemId)) {
            ((ExtBillView)this.view).hide("applyqtypanel", false);
        } else {
            ((ExtBillView)this.view).hide("applyqtypanel", true);
        }
        for (DynamicObject object : goodsentryentity) {
            DynamicObject goods = object.getDynamicObject("goodsid");
            if ((!StringUtils.isNotBlank((String)itemId) || !itemId.equals(object.getString("id"))) && StringUtils.isNotBlank((String)itemId)) continue;
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + goods.getString("thumbnail")));
            dataObject.set("itemname", (Object)goods.getString("name"));
            dataObject.set("retailprice", (Object)object.getBigDecimal("amount").stripTrailingZeros().toPlainString());
            dataObject.set("memberprice", (Object)object.getBigDecimal("balamount").divide(object.getBigDecimal("saleqty")).stripTrailingZeros().toPlainString());
            dataObject.set("qty", (Object)object.getBigDecimal("saleqty"));
            ((BillFormData)this.billData).updateValue("applyqty", object.get("saleqty"));
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
            if (!StringUtils.isNotBlank((String)itemId)) continue;
            data.set("totalrealamount", (Object)object.getBigDecimal("balamount").stripTrailingZeros().toPlainString());
        }
    }

    private DynamicObject getSaleQty() {
        long billId = ((BillFormData)this.getBillData()).getLong("billid");
        String itemId = ((BillFormData)this.getBillData()).getString("itemid");
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billId);
        DynamicObjectCollection goodsentryentity = orderInfo.getDynamicObjectCollection("goodsentryentity");
        for (DynamicObject object : goodsentryentity) {
            if ((!StringUtils.isNotBlank((String)itemId) || !itemId.equals(object.getString("id"))) && StringUtils.isNotBlank((String)itemId)) continue;
            return object;
        }
        return null;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "submit": {
                if (ButtonFastClickUtil.isFastClickByTime((long)2000L)) break;
                this.refundApply();
                break;
            }
            case "revoke": {
                this.goPage("ocpos_orderlistm", null, null);
                break;
            }
        }
        super.onClick(event);
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "applyqty": {
                DynamicObject object = this.getSaleQty();
                if (object == null) break;
                BigDecimal saleQty = object.getBigDecimal("saleqty");
                BigDecimal balamount = object.getBigDecimal("balamount");
                BigDecimal qty = BigDecimalUtil.toBigDecimal((Object)event.getValue());
                if (qty.compareTo(saleQty) > 0) {
                    ((BillFormData)this.getBillData()).updateValue("applyqty", (Object)saleQty);
                    break;
                }
                ((BillFormData)this.getBillData()).updateValue("totalrealamount", (Object)balamount.multiply(qty).stripTrailingZeros().toPlainString());
                break;
            }
        }
    }

    private void refundApply() {
        logger.info("\u5f00\u59cb\u8c03\u7528PosRefundApplyPlugin refundApply");
        long billid = ((BillFormData)this.getBillData()).getLong("billid");
        String itemId = ((BillFormData)this.getBillData()).getString("itemid");
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billid);
        DynamicObjectCollection goodsentryentity = orderInfo.getDynamicObjectCollection("goodsentryentity");
        JSONObject expressMap = new JSONObject();
        expressMap.put("returnreason", ((BillFormData)this.getBillData()).get("reason.id"));
        expressMap.put("comment", (Object)((BillFormData)this.billData).getString("remark"));
        expressMap.put("ordersource", (Object)"E");
        for (DynamicObject object : goodsentryentity) {
            if (StringUtils.isNotBlank((String)itemId) && itemId.equals(object.getString("id"))) {
                BigDecimal applyqty = ((BillFormData)this.billData).getBigDecimal("applyqty");
                BigDecimal saleqty = object.getBigDecimal("saleqty");
                BigDecimal balamount = object.getBigDecimal("balamount");
                BigDecimal totalrealamount = applyqty.multiply(balamount);
                BigDecimal receivableamount = ((BillFormData)this.getBillData()).getBigDecimal("totalrealamount");
                DynamicObjectCollection salesorderdelivery = object.getDynamicObjectCollection("salesorderdelivery");
                if (applyqty.compareTo(saleqty) > 0) {
                    ((ExtBillView)this.view).showMessage("\u7533\u8bf7\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b9e\u9645\u8d2d\u4e70\u6570\u91cf\u3002");
                    return;
                }
                if (receivableamount.compareTo(totalrealamount) > 0) {
                    ((ExtBillView)this.view).showMessage("\u90e8\u5206\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5b9e\u4ed8\u91d1\u989d\u3002");
                    return;
                }
                if (receivableamount.compareTo(BigDecimal.ZERO) == 0) {
                    ((ExtBillView)this.view).showMessage("\u90e8\u5206\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002");
                    return;
                }
                ArrayList lstData = new ArrayList();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("entryid", object.getPkValue());
                map.put("subentryid", ((DynamicObject)salesorderdelivery.get(0)).getPkValue());
                map.put("changeqty", applyqty.negate());
                lstData.add(map);
                long start = System.currentTimeMillis();
                JSONObject orderResult = SaleOrderDBHelper.addSaleReturn((DynamicObject)orderInfo, (JSONObject)expressMap, (boolean)false, lstData);
                logger.info("\u9000\u6b3e\u8017\u65f6\u7edf\u8ba1  \u90e8\u5206\u9000\u6b3e SaleOrderDBHelper.addSaleReturn " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
                if (orderResult != null) {
                    logger.info("\u521b\u5efa\u9500\u552e\u9000\u8d27\u7684\u8ba2\u5355\u7ed3\u679c\uff1a" + orderResult.get("success") + ", \u539f\u56e0\uff1a" + orderResult.get("error"));
                    if (orderResult.get("billId") != null) {
                        logger.info("\u9000\u6b3e\u6210\u529f\uff0c\u6b63\u5728\u8df3\u5230\u9000\u6b3e\u8be6\u60c5\u9875\u9762\uff0c\u9000\u6b3ebillId\uff1a" + orderResult.get("billId"));
                        this.goPage("ocpos_refundreturn_detail", String.valueOf(orderResult.get("billId")), itemId);
                    } else {
                        ((ExtBillView)this.view).showMessage((String)orderResult.get("error"));
                    }
                }
                return;
            }
            BigDecimal totalrealamount = orderInfo.getBigDecimal("totalrealamount");
            BigDecimal receivableamount = ((BillFormData)this.getBillData()).getBigDecimal("totalrealamount");
            if (receivableamount.compareTo(totalrealamount) > 0) {
                ((ExtBillView)this.view).showMessage("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5b9e\u4ed8\u91d1\u989d\u3002");
                return;
            }
            this.fullRefund(orderInfo, expressMap);
        }
    }

    private void fullRefund(DynamicObject orderInfo, JSONObject expressMap) {
        long start = System.currentTimeMillis();
        JSONObject orderResult = SaleOrderDBHelper.addSaleReturn((DynamicObject)orderInfo, (JSONObject)expressMap, (boolean)true, null);
        logger.info("\u9000\u6b3e\u8017\u65f6\u7edf\u8ba1  \u5168\u90e8\u9000\u6b3e SaleOrderDBHelper.addSaleReturn " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        if (orderResult != null) {
            logger.info("\u521b\u5efa\u9500\u552e\u9000\u8d27\u7684\u8ba2\u5355\u7ed3\u679c\uff1a" + orderResult.get("success") + ", \u539f\u56e0\uff1a" + orderResult.get("error"));
            if (orderResult.get("billId") != null) {
                logger.info("\u9000\u6b3e\u6210\u529f\uff0c\u6b63\u5728\u8df3\u5230\u9000\u6b3e\u8be6\u60c5\u9875\u9762\uff0c\u9000\u6b3ebillId\uff1a" + orderResult.get("billId"));
                this.goPage("ocpos_refundreturn_detail", String.valueOf(orderResult.get("billId")), null);
            } else {
                ((ExtBillView)this.view).showMessage((String)orderResult.get("error"));
            }
        }
    }

    private void goPage(String viewId, String billId, String itemId) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId(viewId);
        openParam.setEnabelHistory(false);
        openParam.addCustomParam("billId", billId);
        openParam.addCustomParam("itemId", itemId);
        ((ExtBillView)this.getView()).showView(openParam);
    }

    protected void beforeQueryF7(SelectDataEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "reason": {
                event.getQueryFilter().addFilter("group", Enums.SqlCompareOperator.equal, (Object)1062223569272256512L);
                break;
            }
        }
        super.beforeQueryF7(event);
    }
}

