/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SelectedRow;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import org.apache.commons.lang.StringUtils;

public class PosRefundReturnApplyPlugin
extends ExtBillViewPlugin {
    private static final String itementrys = "goodslist";
    private static Log logger = LogFactory.getLog(PosRefundReturnApplyPlugin.class);

    public void afterDataLoad(LoadDataEvent event) {
        Long billId = Long.parseLong(event.getCustomParam().getString("billId"));
        String itemId = event.getCustomParam().getString("itemId");
        logger.info("PosRefundReturnApplyPlugin afterDataLoad billId:" + billId, (Object)("itemId:" + itemId));
        ((BillFormData)this.getBillData()).updateValue("billid", (Object)billId);
        ((BillFormData)this.getBillData()).updateValue("itemid", (Object)itemId);
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billId);
        DynamicObjectCollection goodsentryentity = orderInfo.getDynamicObjectCollection("goodsentryentity");
        for (int index = 0; index < goodsentryentity.size(); ++index) {
            DynamicObject item = (DynamicObject)goodsentryentity.get(index);
            DynamicObject goods = item.getDynamicObject("goodsid");
            logger.info("PosRefundReturnApplyPlugin afterDataLoad \u9000\u6b3e\u7533\u8bf7 \u5546\u54c1\u8be6\u60c5\uff1a" + SerializationUtils.toJsonString((Object)goods));
            logger.info("PosRefundReturnApplyPlugin afterDataLoad \u9000\u6b3e\u7533\u8bf7 retailprice\uff1a" + item.getBigDecimal("amount"));
            logger.info("PosRefundReturnApplyPlugin afterDataLoad \u9000\u6b3e\u7533\u8bf7 memberprice\uff1a" + item.getBigDecimal("balamount"));
            BigDecimal mustretQty = item.getBigDecimal("mustretqty");
            if (mustretQty.compareTo(BigDecimal.ZERO) == 0) {
                ((ExtBillView)this.view).disableGridSelBox(itementrys, true, index);
                ((ExtBillView)this.view).hide("nostockpanel", false, index);
            } else {
                ((ExtBillView)this.view).hide("nostockpanel", true, index);
            }
            if ((!StringUtils.isNotBlank((String)itemId) || !itemId.equals(item.getString("id"))) && StringUtils.isNotBlank((String)itemId)) continue;
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + goods.getString("thumbnail")));
            dataObject.set("itemname", (Object)goods.getString("name"));
            dataObject.set("qty", item.get("saleqty"));
            dataObject.set("id", (Object)DynamicObjectUtil.getPkValue((DynamicObject)item));
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
        }
    }

    protected void onClick(ClickEvent event) {
        String eventId = event.getId();
        List selections = event.getSelections();
        if (selections == null || selections.size() == 0) {
            ((ExtBillView)this.view).showMessage("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5546\u54c1\u53d1\u8d77\u552e\u540e\u670d\u52a1");
            return;
        }
        ArrayList<Long> selectitemList = new ArrayList<Long>(16);
        for (SelectedRow row : selections) {
            selectitemList.add(Long.parseLong((String)row.getPkValue()));
        }
        long billId = ((BillFormData)this.getBillData()).getLong("billid");
        DynamicObject orderInfo = SaleOrderDBHelper.querySaleOrderInfo((long)billId);
        switch (eventId) {
            case "returngoods": {
                JSONObject checkRuleResult = SaleOrderDBHelper.checkReturnRule((DynamicObject)orderInfo, (boolean)false, selectitemList);
                if (checkRuleResult.getBoolean("success").booleanValue()) {
                    this.goPage("ocpos_return_apply", selectitemList);
                    break;
                }
                ((ExtBillView)this.view).showMessage(checkRuleResult.getString("error"));
                break;
            }
            case "changegoods": {
                JSONObject checkRuleResult = SaleOrderDBHelper.checkReturnRule((DynamicObject)orderInfo, (boolean)false, selectitemList);
                if (checkRuleResult.getBoolean("success").booleanValue()) {
                    this.goPage("ocpos_exchange_apply", selectitemList);
                    break;
                }
                ((ExtBillView)this.view).showMessage(checkRuleResult.getString("error"));
                break;
            }
        }
        super.onClick(event);
    }

    private void goPage(String viewId, List<Long> selectitemList) {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId(viewId);
        openParam.setEnabelHistory(false);
        openParam.addCustomParam("billId", ((BillFormData)this.getBillData()).getString("billid"));
        openParam.addCustomParam("selectitemList", StringUtils.join((Object[])selectitemList.toArray(), (String)","));
        ((ExtBillView)this.getView()).showView(openParam);
    }
}

