/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.GoHistoryEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import kd.occ.ocpos.common.enums.OrderStatusEnum;

public class PosRefundReturnDetaillPlugin
extends ExtBillViewPlugin {
    private static final String itementrys = "goodslist";
    protected static Log logger = LogFactory.getLog(PosRefundReturnDetaillPlugin.class);

    public void afterBindData(LoadDataEvent event) {
        String billId = event.getCustomParam().getString("billId");
        String serviceType = event.getCustomParam().getString("serviceType");
        ((BillFormData)this.billData).updateValue("servicetype", (Object)serviceType);
        String entityName = "ocpos_saleorder_return";
        if ("salechange".equals(serviceType)) {
            entityName = "ocpos_salechange";
        }
        DynamicObject orderInfo = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityName);
        logger.info("\u5f00\u59cbPosRefundReturnDetaillPlugin afterBindData\uff0c\u8fdb\u5165\u9000\u6b3e\u8be6\u60c5\u9875\u9762\uff0c\u9000\u6b3ebillId\uff1a" + billId);
        ((BillFormData)this.billData).updateValue("billid", (Object)billId);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ((ExtBillView)this.view).updateFrontValue("totalrealamount", (Object)orderInfo.getBigDecimal("receivableamount").abs());
        DynamicObjectCollection goodsentryentity = orderInfo.getDynamicObjectCollection("goodsentryentity");
        BigDecimal applyQty = BigDecimal.ZERO;
        for (DynamicObject object : goodsentryentity) {
            if ((!entityName.equals("ocpos_salechange") || object.getInt("saleoption") != 0) && entityName.equals("ocpos_salechange")) continue;
            DynamicObject goods = object.getDynamicObject("goodsid");
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            dataObject.set("id", (Object)goods.getString("id"));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + goods.getString("thumbnail")));
            dataObject.set("itemname", (Object)goods.getString("name"));
            dataObject.set("memberprice", (Object)object.getBigDecimal("balamount").abs().stripTrailingZeros().toPlainString());
            dataObject.set("applyqty", (Object)("\u7533\u8bf7\u6570\u91cf\uff1a" + Math.abs(object.getInt("saleqty"))));
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
            DynamicObjectCollection salesorderdelivery = object.getDynamicObjectCollection("salesorderdelivery");
            DynamicObject delivery = (DynamicObject)salesorderdelivery.get(0);
            if (delivery == null) continue;
            Boolean isselfpickup = delivery.getBoolean("isselfpickup");
            if (isselfpickup.booleanValue()) {
                ((ExtBillView)this.view).updateFrontValue("returntype", (Object)"\u4e0a\u95e8\u53d6\u4ef6");
            } else {
                ((ExtBillView)this.view).updateFrontValue("returntype", (Object)"\u5feb\u9012\u5bc4\u56de");
            }
            ((ExtBillView)this.view).updateFrontValue("reason", (Object)delivery.getString("returnreason.name"));
            ((ExtBillView)this.view).updateFrontValue("name", (Object)delivery.getString("consignee"));
            ((ExtBillView)this.view).updateFrontValue("phonenumber", (Object)delivery.getString("deliverphonenumber"));
            ((ExtBillView)this.view).updateFrontValue("address", (Object)delivery.getString("fulladdress"));
        }
        ((ExtBillView)this.view).updateFrontValue("applytime", (Object)df.format(orderInfo.getDate("createtime")));
        ((ExtBillView)this.view).updateFrontValue("orderno", (Object)orderInfo.getString("billno"));
        ((ExtBillView)this.view).updateFrontValue("servicetype", (Object)("salechange".equals(serviceType) ? "\u6362\u8d27" : "\u9000\u8d27"));
        ((BillFormData)this.billData).updateValue("servicemode", (Object)("salechange".equals(serviceType) ? "salechange" : "salereturn"));
        if (OrderStatusEnum.CANCELED.getValue().equals(orderInfo.getString("orderstatus"))) {
            ((ExtBillView)this.view).updateFrontValue("orderstatus", (Object)"\u5df2\u64a4\u9500\u7533\u8bf7");
        } else {
            ((ExtBillView)this.view).updateFrontValue("orderstatus", (Object)OrderStatusEnum.getName((String)orderInfo.getString("orderstatus")));
        }
        boolean allowSaleReturnUnSubmit = SaleOrderDBHelper.isAllowSaleReturnUnSubmit((DynamicObject)orderInfo);
        if ("salechange".equals(serviceType)) {
            allowSaleReturnUnSubmit = SaleOrderDBHelper.isAllowSaleChangeUnSubmit((DynamicObject)orderInfo);
        }
        if (allowSaleReturnUnSubmit) {
            ((ExtBillView)this.view).hide("revoke", false);
        } else {
            ((ExtBillView)this.view).hide("revoke", true);
        }
        ((ExtBillView)this.view).updateFrontValue("applyqty", (Object)applyQty.abs());
        logger.info("\u7ed3\u7b97PosRefundReturnDetaillPlugin afterBindData\uff0c\u8fdb\u5165\u9000\u6b3e\u8be6\u60c5\u9875\u9762\uff0c\u9000\u6b3ebillId\uff1a" + billId);
        super.afterBindData(event);
    }

    public void onGoHistory(GoHistoryEvent event) {
        OpenParam openParam = new OpenParam();
        openParam.setViewId("ocpos_postsalelist");
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        ((ExtBillView)this.view).showView(openParam);
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "revoke": {
                long billId = ((BillFormData)this.billData).getLong("billid");
                String serviceType = ((BillFormData)this.billData).getString("servicemode");
                JSONObject result = "salechange".equals(serviceType) ? SaleOrderDBHelper.unSubmitSaleChange((long)billId) : SaleOrderDBHelper.unSubmitSaleReturn((long)billId);
                if (result.getBoolean("success").booleanValue()) {
                    ((ExtBillView)this.view).hide("revoke", true);
                    ((ExtBillView)this.view).refresh();
                    break;
                }
                ((ExtBillView)this.view).showMessage(result.getString("error"));
                break;
            }
        }
        super.onClick(event);
    }
}

