/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.entity.CallBackArgu;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.MessageCallBackEvent;
import kd.occ.ocepfp.core.form.event.ScanCodeEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.business.olstore.OlstoreCartHelper;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class PosScanCodePlugin
extends ExtBillViewPlugin {
    private static Log logger = LogFactory.getLog(PosScanCodePlugin.class);

    public void onScanCode(ScanCodeEvent event) {
        logger.info("PosScanCodePlugin onScanCode\u6761\u5f62\u7801\uff1a" + event.getCode());
        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
        Long customerId = currentStore.getLong("id");
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        if (memberId == 0L) {
            CallBackArgu loginCallBack = new CallBackArgu();
            loginCallBack.setActionKey("login");
            ((ExtBillView)this.view).showMessage("\u8bf7\u5728\u767b\u5f55\u540e\u4f7f\u7528\u626b\u7801\u8d2d\u529f\u80fd", MessageBoxType.Confirm, loginCallBack);
            return;
        }
        String appendStr = OlstoreUtil.buildItemParamAppendStr();
        DynamicObject barcode = this.getBarcodeId(event.getCode());
        if (barcode == null) {
            ((ExtBillView)this.view).showMessage("\u8be5\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u672a\u4e0a\u67b6");
            return;
        }
        DynamicObject branchDyn = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"ocdbd_channel", (String)"saleorg");
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branchDyn, (String)"saleorg");
        long invTypeId = SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)customerId);
        JSONObject returnData = OlstoreItemHelper.queryItemDetailByBarcode((String)String.valueOf(customerId), (String)barcode.getString("id"), (String)appendStr);
        logger.info("PosScanCodePlugin onScanCode\u6839\u636e\u6761\u5f62\u7801\u67e5\u8be2\u5546\u54c1\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + returnData);
        if ("0000".equals(returnData.get((Object)"code").toString()) && returnData.getJSONArray("data").size() > 0) {
            JSONArray products = returnData.getJSONArray("data");
            if (products.size() > 0) {
                JSONObject itemInfo = products.getJSONObject(0);
                DynamicObject wareHouse = OlstoreInventoryHelper.getIdsFromOcocicWareHouse((long)customerId);
                if (wareHouse == null) {
                    ((ExtBillView)this.view).showMessage("\u5f53\u524d\u95e8\u5e97\u672a\u914d\u7f6e\u6e20\u9053\u4ed3\u5e93\u5bf9\u5e94\u7684\u9ed8\u8ba4\u53d1\u8d27\u4ed3\u5e93\uff0c\u65e0\u6cd5\u67e5\u8be2\u5e93\u5b58");
                    return;
                }
                long erpStockOrgid = wareHouse.getLong("erpstockorgid.id");
                long erpWarehouseId = wareHouse.getLong("erpwarehouseid.id");
                List inventoryParam = OlstoreInventoryHelper.buildInventoryParam((JSONObject)itemInfo, (long)saleOrgId, (long)customerId, (long)erpStockOrgid, (long)erpWarehouseId, (long)invTypeId, (BigDecimal)BigDecimal.ONE);
                logger.info("\u626b\u7801\u8d2d\u5e93\u5b58\u67e5\u8be2\u53c2\u6570 param \uff1a" + inventoryParam);
                List inventoryResult = SaleOrderDeliveryInfoHelper.getInventoryInfo((List)inventoryParam);
                logger.info("\u626b\u7801\u8d2d\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c result \uff1a" + inventoryResult);
                if (CollectionUtils.isEmpty((Collection)inventoryResult)) {
                    ((ExtBillView)this.getView()).showMessage("\u8be5\u5546\u54c1\u672a\u4e0a\u67b6");
                    return;
                }
                JSONObject inventoryItem = (JSONObject)inventoryResult.get(0);
                String invStatus = inventoryItem.getString("invstatus");
                if (!StringUtils.equals((CharSequence)invStatus, (CharSequence)"1")) {
                    ((ExtBillView)this.getView()).showMessage("\u8be5\u5546\u54c1\u672a\u4e0a\u67b6");
                    return;
                }
                this.addCart(itemInfo, customerId, memberId);
                ((ExtBillView)this.view).putLocalStorage("isonlinepurchase" + memberId + customerId, "1");
                this.goPage("ocpos_cartlistm");
            } else {
                ((ExtBillView)this.view).showMessage("\u8be5\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u672a\u4e0a\u67b6");
            }
        } else {
            ((ExtBillView)this.view).showMessage("\u8be5\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u672a\u4e0a\u67b6");
        }
        super.onScanCode(event);
    }

    private void goPage(String pageName) {
        OpenParam openParam = new OpenParam();
        openParam.setViewId(pageName);
        openParam.addCustomParam("isonlinepurchase", "1");
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        ((ExtBillView)this.view).showView(openParam);
    }

    public void onMessageCallBack(MessageCallBackEvent event) {
        String actionKey;
        switch (actionKey = event.getActionKey()) {
            case "login": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocpos_mpgrant");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onMessageCallBack(event);
    }

    private DynamicObject getBarcodeId(String barcode) {
        QFilter filter = new QFilter("barcode", "=", (Object)barcode);
        DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)"ocdbd_item_barcode", (String)"id", (QFilter[])filter.toArray());
        if (dataArray != null && dataArray.length > 0) {
            return dataArray[0];
        }
        return null;
    }

    private void addCart(JSONObject itemInfo, long customerId, long memberId) {
        long itemId = itemInfo.getLong("itemid");
        long auxptyId = itemInfo.getLong("auxptyid");
        long unitId = itemInfo.getLong("unitid");
        long barcodeId = itemInfo.getLong("barcodeid");
        int preCartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)1).intValue();
        OlstoreCartHelper.addCart((long)customerId, (long)memberId, (long)itemId, (long)unitId, (long)auxptyId, (long)barcodeId, (BigDecimal)BigDecimal.ONE, (int)1);
        int cartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)1).intValue();
        if (preCartSumCount != cartSumCount) {
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", MessageBoxType.Toast);
        } else {
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u3002", MessageBoxType.Toast);
        }
    }

    public void afterBindData(LoadDataEvent event) {
        DynamicObject olstoreConfig = OlstoreConfigHelper.getOlstoreConfig();
        if (olstoreConfig.getBoolean("isscan")) {
            ((ExtBillView)this.view).invokeGlobalAction("scan", "hidden", (Object)false);
        } else {
            ((ExtBillView)this.view).invokeGlobalAction("scan", "hidden", (Object)true);
        }
    }
}

