/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.entity.ImgObject;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.BigDecimalUtil;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.CloseEvent;
import kd.occ.ocepfp.core.form.event.CustomEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.GetEnableGroupEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.MessageCallBackEvent;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.AbstractFormData;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocpos.business.olstore.OlstoreCartHelper;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class PosSelectSpecPlugin
extends ExtBillViewPlugin {
    public static final int PICTURE_NUM = 10;
    private static Log logger = LogFactory.getLog(PosSelectSpecPlugin.class);
    private static final String modellist = "modellist";
    private static final String modelpanel = "modelpanel";
    private static final String detailpanel = "detailpanel";
    private static final String loginpanel = "loginpanel";

    public boolean initView(InitViewEvent initViewEvent) {
        return super.initView(initViewEvent);
    }

    public DynamicObject onDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        long customerId = OlstoreUtil.getCurrentStore((ClientEvent)event).getLong("id");
        long auxptyId = event.getCustomParam().getLong("auxptyid");
        long materielId = event.getCustomParam().getLong("materielid");
        long itemId = event.getCustomParam().getLong("itemid");
        long spuId = event.getCustomParam().getLong("spuid");
        String storeName = event.getCustomParam().getString("storename");
        String ticketId = event.getCustomParam().getString("ticketid");
        int productCount = event.getCustomParam().getInt("productcount");
        BigDecimal qty = event.getCustomParam().getBigDecimal("qty");
        Boolean isInventory = event.getCustomParam().getBoolean("isinventory");
        long districtId = event.getCustomParam().getLong("districtid");
        ((BillFormData)this.getBillData()).updateValue("materialid", (Object)materielId);
        ((BillFormData)this.getBillData()).updateValue("materialid", (Object)materielId);
        ((BillFormData)this.getBillData()).updateValue("customerid", (Object)customerId);
        ((BillFormData)this.getBillData()).updateValue("item", (Object)itemId);
        ((BillFormData)this.getBillData()).updateValue("ticketid", (Object)ticketId);
        ((BillFormData)this.getBillData()).updateValue("spu", (Object)spuId);
        ((BillFormData)this.getBillData()).updateValue("spuid", (Object)spuId);
        ((BillFormData)this.getBillData()).updateValue("districtid", (Object)districtId);
        ((BillFormData)this.getBillData()).updateValue("qty", (Object)qty);
        ((BillFormData)this.getBillData()).updateValue("productcount", (Object)productCount);
        ((BillFormData)this.getBillData()).updateValue("storename", (Object)storeName);
        ((BillFormData)this.getBillData()).updateValue("ordernumber", (Object)qty.intValue());
        ((BillFormData)this.billData).updateValue("cartcount", (Object)this.getCartSumCount());
        if (auxptyId > 0L) {
            ((BillFormData)this.getBillData()).updateValue("skutest", (Object)auxptyId);
            this.updateFlexGroup(materielId, auxptyId, isInventory, storeName, ticketId);
        } else {
            this.updateFlexGroup(itemId, auxptyId, isInventory, storeName, ticketId);
        }
        ((BillFormData)this.billData).updateValue("cartcount", (Object)this.getCartSumCount());
        return data;
    }

    protected void onClick(ClickEvent event) {
        String btn = event.getId().toLowerCase();
        long auxptyId = ((BillFormData)this.billData).getLong("auxptyid");
        long spuId = ((BillFormData)this.getBillData()).getLong("spuid");
        int productCount = ((BillFormData)this.getBillData()).getInt("productcount");
        long itemId = ((BillFormData)this.billData).getLong("itemid");
        long customerId = ((BillFormData)this.getBillData()).getLong("customerid");
        long barcodeId = ((BillFormData)this.billData).getLong("barcodeid");
        if (productCount > 1) {
            if (spuId > 0L) {
                ((BillFormData)this.billData).updateAuxpty(event.getParentAuxptyId(), "sputest", spuId);
            } else {
                if (auxptyId == 0L) {
                    ((ExtBillView)this.view).showMessage("\u8bf7\u9009\u62e9\u5546\u54c1\u89c4\u683c", MessageBoxType.Toast);
                    return;
                }
                ((BillFormData)this.billData).updateAuxpty(event.getParentAuxptyId(), "skutest", auxptyId);
            }
        }
        boolean olstoreSale = OlstoreItemHelper.isOlstoreSale((Long)customerId, (Long)barcodeId, (Long)itemId);
        switch (btn) {
            case "quickorder": {
                if (olstoreSale) {
                    this.quickOrder();
                    break;
                }
                ((ExtBillView)this.view).showMessage("\u8be5\u5546\u54c1\u672a\u4e0a\u67b6\uff0c\u8bf7\u5230\u7ebf\u4e0b\u95e8\u5e97\u5b8c\u6210\u8d2d\u4e70\u3002", MessageBoxType.Toast);
                break;
            }
            case "addcart": {
                if (olstoreSale) {
                    this.addCart();
                    break;
                }
                ((ExtBillView)this.view).showMessage("\u8be5\u5546\u54c1\u672a\u4e0a\u67b6\uff0c\u8bf7\u5230\u7ebf\u4e0b\u95e8\u5e97\u5b8c\u6210\u8d2d\u4e70\u3002", MessageBoxType.Toast);
                break;
            }
        }
    }

    public void onMessageCallBack(MessageCallBackEvent event) {
        String actionKey;
        Map messageBackMap = (Map)event.getEventParam().get((Object)"messageback");
        int result = messageBackMap.getOrDefault("result", 0);
        String btn = (String)messageBackMap.get("btn");
        switch (actionKey = event.getActionKey()) {
            case "preorder": {
                if (result == 1) {
                    if ("addcart".equals(btn)) {
                        this.addCartFromCallback();
                        break;
                    }
                    if (!"quickorder".equals(btn)) break;
                    this.quickOrderFromCallback();
                    break;
                }
                ((ExtBillView)this.view).showMessage("\u4e0d\u9884\u8ba2\uff0c\u6ca1\u6709\u5e93\u5b58");
                break;
            }
            case "login": {
                if (result != 1) break;
                this.goPage("ocpos_mpgrant");
                break;
            }
        }
    }

    private void goPage(String pagename) {
        OpenParam openParam = new OpenParam();
        openParam.setViewId(pagename);
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        ((ExtBillView)this.view).showView(openParam);
    }

    private void addCart() {
        long customerId = ((BillFormData)this.billData).getLong("customerid");
        long unitId = ((BillFormData)this.billData).getLong("unitid");
        long barcodeId = ((BillFormData)this.billData).getLong("barcodeid");
        long itemId = ((BillFormData)this.billData).getLong("itemid");
        long auxptyId = ((BillFormData)this.billData).getLong("auxptyid");
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        long spuId = ((BillFormData)this.getBillData()).getLong("spuid");
        BigDecimal qty = ((BillFormData)this.getBillData()).getBigDecimal("qty");
        int preCartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        OlstoreCartHelper.addCart((long)customerId, (long)memberId, (long)itemId, (long)unitId, (long)auxptyId, (long)barcodeId, (BigDecimal)qty, (int)0);
        int cartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        if (preCartSumCount != cartSumCount) {
            ((BillFormData)this.billData).updateValue("cartcount", (Object)cartSumCount);
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", MessageBoxType.Toast);
        } else {
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u3002", MessageBoxType.Toast);
        }
        this.updateParantData();
        ((ExtBillView)this.view).closeView();
    }

    private void quickOrder() {
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        AbstractExtFormPlugin parentForm = ((ExtBillView)this.view).getParentForm();
        AbstractFormData parentFormData = (AbstractFormData)parentForm.getBillData();
        openParam.addCustomParam("itemid", String.valueOf(((BillFormData)this.getBillData()).getBigDecimal("itemId")));
        openParam.addCustomParam("spuid", String.valueOf(((BillFormData)this.getBillData()).getBigDecimal("spuId")));
        openParam.addCustomParam("auxptyid", String.valueOf(((BillFormData)this.getBillData()).getBigDecimal("auxptyid")));
        openParam.addCustomParam("qty", (Object)((BillFormData)this.getBillData()).getBigDecimal("qty"));
        openParam.addCustomParam("addressid", parentFormData.getString("addressid"));
        openParam.addCustomParam("storename", parentFormData.getString("storename"));
        openParam.addCustomParam("pickuptime", (Object)parentFormData.getDate("pickuptime"));
        openParam.addCustomParam("deliverytime", (Object)parentFormData.getDate("deliverytime"));
        openParam.addCustomParam("ticketid", parentFormData.getString("ticketid"));
        openParam.addCustomParam("sourceviewid", "ocpos_itemdetails");
        openParam.setViewId("ocpos_confirmorder");
        ((ExtBillView)this.view).showView(openParam);
        this.updateParantData();
        ((ExtBillView)this.view).closeView();
    }

    private void addCartFromCallback() {
        long customerId = ((BillFormData)this.billData).getLong("customerid");
        long unitId = ((BillFormData)this.billData).getLong("unitid");
        long barcodeId = ((BillFormData)this.billData).getLong("barcodeid");
        long itemId = ((BillFormData)this.billData).getLong("itemid");
        long auxptyId = ((BillFormData)this.billData).getLong("auxptyid");
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        long spuId = ((BillFormData)this.getBillData()).getLong("spuid");
        BigDecimal qty = ((BillFormData)this.getBillData()).getBigDecimal("qty");
        int preCartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        OlstoreCartHelper.addCart((long)customerId, (long)memberId, (long)itemId, (long)unitId, (long)auxptyId, (long)barcodeId, (BigDecimal)qty, (int)0);
        int cartSumCount = OlstoreCartHelper.getOlstoreCartCount((long)customerId, (long)memberId, (long)itemId, (long)auxptyId, (int)0).intValue();
        this.updateParantData();
        ((ExtBillView)this.view).closeView();
        if (preCartSumCount != cartSumCount) {
            ((BillFormData)this.billData).updateValue("cartcount", (Object)cartSumCount);
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", MessageBoxType.Toast);
        } else {
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u3002", MessageBoxType.Toast);
        }
    }

    private void quickOrderFromCallback() {
        this.updateParantData();
        ((ExtBillView)this.view).closeView();
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.addCustomParam("itemid", String.valueOf(((BillFormData)this.getBillData()).getBigDecimal("itemId")));
        openParam.addCustomParam("spuid", String.valueOf(((BillFormData)this.getBillData()).getBigDecimal("spuId")));
        openParam.addCustomParam("auxptyid", String.valueOf(((BillFormData)this.getBillData()).getBigDecimal("auxptyid")));
        openParam.addCustomParam("qty", (Object)((BillFormData)this.getBillData()).getBigDecimal("qty"));
        openParam.addCustomParam("sourceviewid", "ocpos_itemdetails");
        openParam.setViewId("ocpos_confirmorder");
        ((ExtBillView)this.view).showView(openParam);
    }

    public void afterUpdateFlexGroup(GetEnableGroupEvent event, long basefieldId, long auxptyId) {
        this.updateFlexGroup(basefieldId, auxptyId, null, ((BillFormData)this.getBillData()).getString("storename"), ((BillFormData)this.getBillData()).getString("ticketid"));
        super.afterUpdateFlexGroup(event, basefieldId, auxptyId);
    }

    private void updateFlexGroup(long basefieldId, long auxptyId, Boolean isInventory, String storeName, String ticketId) {
        JSONObject product;
        logger.info("\u5546\u54c1\u89c4\u683c\u53d8\u5316updateFlexGroup\uff0c basefieldId\uff1a" + basefieldId + ", auxptyId:" + auxptyId + ",isInventory:" + isInventory);
        String spuId = ((BillFormData)this.getBillData()).getString("spuid");
        long customerId = ((BillFormData)this.getBillData()).getLong("customerid");
        if (spuId.length() > 1 || auxptyId == 0L) {
            product = this.getProductInfo(basefieldId, auxptyId);
            if (product != null) {
                ((BillFormData)this.getBillData()).updateValue("retailprice", (Object)product.getBigDecimal("retailprice"));
                ((BillFormData)this.getBillData()).updateValue("memberprice", (Object)product.getBigDecimal("memberprice"));
                ((BillFormData)this.getBillData()).updateValue("thumbnail", (Object)(PictureUtil.getFileServerUrl() + product.getString("thumbnail")));
                ((BillFormData)this.getBillData()).updateValue("unitid", (Object)product.getLong("unitid"));
                ((BillFormData)this.getBillData()).updateValue("barcodeid", (Object)product.getLong("barcodeid"));
                ((BillFormData)this.getBillData()).updateValue("itemid", (Object)product.getLong("itemid"));
                ((BillFormData)this.getBillData()).updateValue("materialid", (Object)product.getLong("materielid"));
                ((BillFormData)this.getBillData()).updateValue("auxptyid", (Object)product.getLong("auxptyid"));
                if (spuId.length() > 1) {
                    DynamicObject spuMapName = OlstoreItemHelper.getSpuMapName((long)basefieldId, (long)auxptyId);
                    String mapName = spuMapName.getString("entryentity_specmap.spumapname");
                    ((BillFormData)this.getBillData()).updateValue("spumapname", (Object)mapName);
                }
            }
        } else {
            DynamicObject item = ((BillFormData)this.getBillData()).getDynamicObject("item");
            long itemId = (Long)item.getPkValue();
            product = this.getProductInfo(itemId, auxptyId);
            if (product != null) {
                String auxptyName = ((BillFormData)this.billData).getAuxpty(auxptyId, false).getAuxptyName();
                ((BillFormData)this.getBillData()).updateValue("skutest", (Object)auxptyId);
                ((BillFormData)this.getBillData()).updateValue("retailprice", (Object)product.getBigDecimal("retailprice"));
                ((BillFormData)this.getBillData()).updateValue("memberprice", (Object)product.getBigDecimal("memberprice"));
                ((BillFormData)this.getBillData()).updateValue("thumbnail", (Object)(PictureUtil.getFileServerUrl() + product.getString("thumbnail")));
                ((BillFormData)this.getBillData()).updateValue("unitid", (Object)product.getLong("unitid"));
                ((BillFormData)this.getBillData()).updateValue("barcodeid", (Object)product.getLong("barcodeid"));
                ((BillFormData)this.getBillData()).updateValue("itemid", (Object)product.getLong("itemid"));
                ((BillFormData)this.getBillData()).updateValue("materialid", (Object)product.getLong("materielid"));
                ((BillFormData)this.getBillData()).updateValue("auxptyid", (Object)product.getLong("auxptyid"));
                ((BillFormData)this.getBillData()).updateValue("spumapname", (Object)auxptyName);
            } else {
                ((BillFormData)this.getBillData()).updateValue("spumapname", (Object)"\u8be5\u89c4\u683c\u5546\u54c1\u6682\u672a\u63d0\u4f9b");
            }
        }
        if (product == null) {
            ((ExtBillView)this.view).showMessage("\u8be5\u89c4\u683c\u5546\u54c1\u672a\u4e0a\u67b6\u3002");
            return;
        }
        if (isInventory == null || !isInventory.booleanValue()) {
            Long inventoryTypeByTicket;
            DynamicObject branchDyn = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"ocdbd_channel", (String)"saleorg");
            long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branchDyn, (String)"saleorg");
            long invTypeId = StringUtils.isNotBlank((CharSequence)ticketId) ? ((inventoryTypeByTicket = OlstoreTicketHelper.getInventoryTypeByTicket((long)Long.parseLong(ticketId))) != null && inventoryTypeByTicket > 0L ? inventoryTypeByTicket : SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)customerId)) : SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)customerId);
            if (StringUtils.isNotBlank((CharSequence)storeName)) {
                this.checkPickUp(product, saleOrgId, customerId, invTypeId);
            } else {
                long districtId = ((BillFormData)this.billData).getLong("districtid");
                this.checkInventory(product, saleOrgId, customerId, districtId, invTypeId);
            }
        } else {
            ((ExtBillView)this.view).hide("noinventorypanel", true);
            ((ExtBillView)this.view).disable("addcart", false);
            ((ExtBillView)this.view).disable("quickorder", false);
        }
        if (StringUtils.isNotBlank((CharSequence)ticketId)) {
            ((ExtBillView)this.view).disable("addcart", true);
        } else {
            ((ExtBillView)this.view).disable("addcart", false);
        }
    }

    private void checkPickUp(JSONObject itemInfo, long saleOrgId, long customerId, long invTypeId) {
        DynamicObject wareHouse = OlstoreInventoryHelper.getIdsFromOcocicWareHouse((long)customerId);
        if (wareHouse == null) {
            ((ExtBillView)this.view).showMessage("\u5f53\u524d\u95e8\u5e97\u672a\u914d\u7f6e\u6e20\u9053\u4ed3\u5e93\u5bf9\u5e94\u7684\u9ed8\u8ba4\u53d1\u8d27\u4ed3\u5e93\uff0c\u65e0\u6cd5\u67e5\u8be2\u5e93\u5b58");
            return;
        }
        long erpStockOrgid = wareHouse.getLong("erpstockorgid.id");
        long erpWarehouseId = wareHouse.getLong("erpwarehouseid.id");
        BigDecimal qty = ((BillFormData)this.getBillData()).getBigDecimal("qty");
        List inventoryParam = OlstoreInventoryHelper.buildInventoryParam((JSONObject)itemInfo, (long)saleOrgId, (long)customerId, (long)erpStockOrgid, (long)erpWarehouseId, (long)invTypeId, (BigDecimal)qty);
        logger.info("\u626b\u7801\u8d2d\u5e93\u5b58\u67e5\u8be2\u53c2\u6570 param \uff1a" + inventoryParam);
        List inventoryResult = SaleOrderDeliveryInfoHelper.getInventoryInfo((List)inventoryParam);
        logger.info("\u626b\u7801\u8d2d\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c result \uff1a" + inventoryResult);
        ((ExtBillView)this.view).updateFrontValue("noinventorypanel", (Object)"\u8be5\u5546\u54c1\u5728\u5f53\u524d\u95e8\u5e97\u6682\u65e0\u5e93\u5b58");
        AbstractExtFormPlugin parentForm = ((ExtBillView)this.view).getParentForm();
        AbstractFormData parentFormData = (AbstractFormData)parentForm.getBillData();
        if (CollectionUtils.isEmpty((Collection)inventoryResult)) {
            ((ExtBillView)this.view).hide("noinventorypanel", false);
            ((ExtBillView)this.view).disable("addcart", true);
            ((ExtBillView)this.view).disable("quickorder", true);
            ((BillFormData)this.getBillData()).updateValue("isinventory", (Object)Boolean.FALSE);
            parentFormData.updateValue("isinventory", (Object)Boolean.FALSE, true);
        } else {
            JSONObject inventoryItem = (JSONObject)inventoryResult.get(0);
            String invStatus = inventoryItem.getString("invstatus");
            if (!StringUtils.equals((CharSequence)invStatus, (CharSequence)"1")) {
                ((ExtBillView)this.view).hide("noinventorypanel", false);
                ((ExtBillView)this.view).disable("addcart", true);
                ((ExtBillView)this.view).disable("quickorder", true);
                ((BillFormData)this.getBillData()).updateValue("isinventory", (Object)Boolean.FALSE);
                parentFormData.updateValue("isinventory", (Object)Boolean.FALSE, true);
            } else {
                ((ExtBillView)this.view).hide("noinventorypanel", true);
                ((ExtBillView)this.view).disable("addcart", false);
                ((ExtBillView)this.view).disable("quickorder", false);
                ((BillFormData)this.getBillData()).updateValue("isinventory", (Object)Boolean.TRUE);
                parentFormData.updateValue("isinventory", (Object)Boolean.TRUE, true);
            }
        }
        parentFormData.updateFormData();
    }

    private void checkInventory(JSONObject itemInfo, long saleOrgId, long customerId, long districtId, long invTypeId) {
        AbstractExtFormPlugin parentForm = ((ExtBillView)this.view).getParentForm();
        AbstractFormData parentFormData = (AbstractFormData)parentForm.getBillData();
        Date deliveryTime = parentFormData.getDate("deliverytime");
        BigDecimal qty = ((BillFormData)this.getBillData()).getBigDecimal("qty");
        Map deliveryParams = OlstoreInventoryHelper.getDeliveryParams((JSONObject)itemInfo, (long)saleOrgId, (long)customerId, (long)districtId, (BigDecimal)qty, (Date)deliveryTime, (long)invTypeId);
        logger.info("\u5546\u54c1\u8be6\u60c5\u89c4\u683c\u5e93\u5b58\u67e5\u8be2\u53c2\u6570 param \uff1a" + deliveryParams);
        Map deliveryResult = SaleOrderDeliveryInfoHelper.getDeliveryInfo((Map)deliveryParams, (boolean)false);
        logger.info("\u5546\u54c1\u8be6\u60c5\u89c4\u683c\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c result \uff1a" + deliveryResult);
        this.updateDeliveryShow(deliveryResult);
    }

    private void updateDeliveryShow(Map<String, Object> deliveryResult) {
        AbstractExtFormPlugin parentForm = ((ExtBillView)this.view).getParentForm();
        AbstractFormData parentFormData = (AbstractFormData)parentForm.getBillData();
        if (CollectionUtils.isEmpty(deliveryResult)) {
            ((ExtBillView)this.view).hide("noinventorypanel", false);
            ((ExtBillView)this.view).disable("addcart", true);
            ((ExtBillView)this.view).disable("quickorder", true);
            ((BillFormData)this.getBillData()).updateValue("isinventory", (Object)Boolean.FALSE);
            parentFormData.updateValue("isinventory", (Object)Boolean.FALSE, true);
        } else {
            boolean isSuccess = CommonUtil.formatObjectToBoolean((Object)deliveryResult.get("isSuccess"));
            if (!isSuccess) {
                ((ExtBillView)this.view).hide("noinventorypanel", false);
                ((ExtBillView)this.view).disable("addcart", true);
                ((ExtBillView)this.view).disable("quickorder", true);
                ((BillFormData)this.getBillData()).updateValue("isinventory", (Object)Boolean.FALSE);
                parentFormData.updateValue("isinventory", (Object)Boolean.FALSE, true);
            } else {
                ((ExtBillView)this.view).hide("noinventorypanel", true);
                ((ExtBillView)this.view).disable("addcart", false);
                ((ExtBillView)this.view).disable("quickorder", false);
                ((BillFormData)this.getBillData()).updateValue("isinventory", (Object)Boolean.TRUE);
                parentFormData.updateValue("isinventory", (Object)Boolean.TRUE, true);
            }
        }
        parentFormData.updateFormData();
    }

    private JSONObject getProductInfo(long itemId, long auxptyId) {
        logger.info("\u5546\u54c1\u89c4\u683c\u53d8\u5316getProductInfo\uff0c itemId\uff1a" + itemId + ", auxptyId:" + auxptyId);
        String spuId = ((BillFormData)this.getBillData()).getString("spuid");
        Long customerId = ((BillFormData)this.getBillData()).getLong("customerid");
        String appendStr = OlstoreUtil.buildItemParamAppendStr();
        JSONObject returnData = OlstoreItemHelper.getItemDetail((String)String.valueOf(customerId), (String)spuId, (String)String.valueOf(itemId), (String)appendStr);
        logger.info("\u5546\u54c1\u89c4\u683c\u53d8\u5316getItemDetail\uff0c returnData\uff1a" + returnData);
        if ("0000".equals(returnData.get((Object)"code").toString())) {
            JSONArray products = returnData.getJSONArray("data");
            List list = JSONObject.parseArray((String)products.toJSONString(), JSONObject.class);
            if (list == null || list.size() == 0) {
                return null;
            }
            if (list.size() == 1) {
                return (JSONObject)list.get(0);
            }
            JSONObject product = list.stream().filter(p -> p.getLong("itemid").equals(itemId) && p.getLong("auxptyid").equals(auxptyId)).findFirst().orElse(null);
            logger.info("\u5546\u54c1\u89c4\u683c\u53d8\u5316getItemDetail\uff0c product\uff1a" + product);
            if (product == null) {
                return null;
            }
            product.put("memberprice", (Object)product.getBigDecimal("memberprice"));
            product.put("retailprice", (Object)product.getBigDecimal("retailprice"));
            return product;
        }
        return null;
    }

    private int getCartSumCount() {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        return OlstoreCartHelper.getOlstoreCartCount((long)((BillFormData)this.billData).getLong("customerid"), (long)memberId, (long)((BillFormData)this.billData).getLong("itemid"), (long)((BillFormData)this.billData).getLong("auxptyid"), (int)0).intValue();
    }

    public void afterClose(CloseEvent event) {
        this.updateParantData();
        super.afterClose(event);
    }

    private void updateParantData() {
        long spuId = ((BillFormData)this.getBillData()).getLong("spuid");
        long itemId = ((BillFormData)this.getBillData()).getLong("itemid");
        long auxptyId = ((BillFormData)this.getBillData()).getLong("auxptyid");
        JSONObject itemInfo = this.getProductInfo(itemId, auxptyId);
        AbstractExtFormPlugin parentForm = ((ExtBillView)this.view).getParentForm();
        AbstractFormData parentFormData = (AbstractFormData)parentForm.getBillData();
        if (itemInfo != null) {
            String thumbnail;
            ArrayList<ImgObject> imgObjects = new ArrayList<ImgObject>();
            for (int i = 1; i < 10; ++i) {
                String picture = itemInfo.getString("picture" + i);
                if (!StringUtil.isNotNull((String)picture)) continue;
                ImgObject img = new ImgObject();
                img.setSrc(PictureUtil.getFileServerUrl() + picture);
                imgObjects.add(img);
            }
            if (imgObjects.size() == 0 && (thumbnail = itemInfo.getString("thumbnail")) != null) {
                ImgObject img = new ImgObject();
                img.setSrc(PictureUtil.getFileServerUrl() + thumbnail);
                imgObjects.add(img);
            }
            parentFormData.updateImgGroup("itemimgs", imgObjects);
            parentFormData.updateValue("shorttitle", (Object)itemInfo.getString("shorttitle"));
            parentFormData.updateValue("itemid", (Object)itemId);
            parentFormData.updateValue("itemname", (Object)itemInfo.getString("itemname"));
            if (spuId > 0L) {
                parentFormData.updateValue("spuid", itemInfo.get((Object)"spuid"));
                parentFormData.updateValue("selectspec", (Object)(this.getSpuMapName(itemId, auxptyId) + "\uff0c" + this.qtyAndUnit(itemInfo.getLong("unitid"))));
            } else {
                String auxptyName = ((BillFormData)this.billData).getAuxpty(auxptyId, false).getAuxptyName();
                parentFormData.updateValue("selectspec", (Object)(auxptyName + this.qtyAndUnit(itemInfo.getLong("unitid"))));
            }
            parentFormData.updateValue("auxptyid", (Object)auxptyId);
            parentFormData.updateValue("unitid", (Object)itemInfo.getLong("unitid"));
            parentFormData.updateValue("barcodeid", (Object)itemInfo.getLong("barcodeid"));
            parentFormData.updateValue("materielid", itemInfo.get((Object)"materielid"));
            parentFormData.updateValue("memberprice", (Object)itemInfo.getBigDecimal("memberprice"));
            parentFormData.updateValue("retailprice", (Object)itemInfo.getBigDecimal("retailprice"));
            parentFormData.updateValue("thumbnail", (Object)itemInfo.getString("thumbnail"));
            parentFormData.updateValue("cartcount", (Object)this.getCartSumCount());
            this.updateAttributeAndDetail(String.valueOf(itemId), parentForm);
            parentFormData.updateFormData();
        }
    }

    private void updateAttributeAndDetail(String itemId, AbstractExtFormPlugin parentForm) {
        ExtDynamicView parentView = parentForm.getDynamicView();
        AbstractFormData parentBillData = (AbstractFormData)parentForm.getBillData();
        DynamicObject itemInfo = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"ocdbd_iteminfo");
        String description = itemInfo.getString("description_tag");
        DynamicObjectCollection itemModelList = itemInfo.getDynamicObjectCollection("itemmodelentry");
        DynamicObjectCollection entryRowData = parentBillData.getEntryRowData(modellist);
        ArrayList<Integer> delList = new ArrayList<Integer>(entryRowData.size());
        for (int i = 0; i < entryRowData.size(); ++i) {
            delList.add(i);
        }
        parentBillData.delEntryRow(modellist, delList);
        if (itemModelList != null && itemModelList.size() > 0) {
            for (DynamicObject itemModel : itemModelList) {
                DynamicObject model = parentBillData.createNewEntryDynamicObject(modellist);
                model.set("modelkey", (Object)itemModel.getString("modelkey"));
                model.set("modelvalue", (Object)itemModel.getString("modelvalue"));
                parentBillData.addEntryRow(modellist, model);
            }
            parentView.hide(modelpanel, false);
        } else {
            parentView.hide(modelpanel, true);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            parentView.hide(detailpanel, false);
            parentBillData.updateValue("description", (Object)itemInfo.getString("description_tag"));
        } else {
            parentView.hide(detailpanel, true);
        }
    }

    private String qtyAndUnit(long unitId) {
        String unit = BusinessDataServiceHelper.loadSingle((Object)unitId, (String)"bd_measureunits").getString("name");
        int qty = ((BillFormData)this.billData).getInt("qty");
        return qty + unit;
    }

    private String getSpuMapName(long itemId, long auxptyId) {
        DynamicObject spuMapName = OlstoreItemHelper.getSpuMapName((long)itemId, (long)auxptyId);
        String mapName = spuMapName.getString("entryentity_specmap.spumapname");
        return mapName;
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "qty": {
                BigDecimal qty = BigDecimalUtil.toBigDecimal((Object)event.getValue());
                ((BillFormData)this.getBillData()).updateValue("ordernumber", event.getRow(), (Object)qty);
                ((ExtBillView)this.view).addCustomEvent(new CustomEvent("specInventory"));
                AbstractExtFormPlugin parentForm = ((ExtBillView)this.view).getParentForm();
                AbstractFormData parentFormData = (AbstractFormData)parentForm.getBillData();
                parentFormData.updateValue("qty", (Object)qty);
                parentFormData.updateFormData();
                break;
            }
        }
        super.onDataChange(event);
    }

    protected void onCustomEvent(CustomEvent event) {
        Long inventoryTypeByTicket;
        long itemId = ((BillFormData)this.billData).getLong("itemid");
        long auxptyId = ((BillFormData)this.getBillData()).getLong("auxptyid");
        long customerId = ((BillFormData)this.getBillData()).getLong("customerid");
        String ticketId = ((BillFormData)this.getBillData()).getString("ticketid");
        JSONObject product = this.getProductInfo(itemId, auxptyId);
        String storeName = ((BillFormData)this.getBillData()).getString("storename");
        DynamicObject branchDyn = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"ocdbd_channel", (String)"saleorg");
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branchDyn, (String)"saleorg");
        long invTypeId = StringUtils.isNotBlank((CharSequence)ticketId) ? ((inventoryTypeByTicket = OlstoreTicketHelper.getInventoryTypeByTicket((long)Long.parseLong(ticketId))) != null && inventoryTypeByTicket > 0L ? inventoryTypeByTicket : SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)customerId)) : SystemParamUtil.getSaleOrderDefInvTypeId((long)saleOrgId, (long)customerId);
        if (StringUtils.isNotBlank((CharSequence)storeName)) {
            this.checkPickUp(product, saleOrgId, customerId, invTypeId);
        } else {
            long districtId = ((BillFormData)this.billData).getLong("districtid");
            this.checkInventory(product, saleOrgId, customerId, districtId, invTypeId);
        }
        if (StringUtils.isNotBlank((CharSequence)ticketId)) {
            ((ExtBillView)this.view).disable("addcart", true);
        } else {
            ((ExtBillView)this.view).disable("addcart", false);
        }
        super.onCustomEvent(event);
    }
}

