/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.login.utils.DateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.enums.TicketStatusEnum;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.QRCodeUtil;

public class PosTicketDetailPlugin
extends ExtBillViewPlugin {
    public void afterDataLoad(LoadDataEvent event) {
        String id = event.getCustomParam().getString("id");
        DynamicObject ticket = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ocdbd_ticketinfo");
        if (ticket != null) {
            ((BillFormData)this.getBillData()).updateValue("ticketnumber", (Object)("\u5238\u53f7\uff1a" + ticket.getString("number")));
            ((BillFormData)this.getBillData()).updateValue("ticketid", (Object)id);
            String qrCodeimg = QRCodeUtil.generalQRCode((String)ticket.getString("number"));
            ((BillFormData)this.getBillData()).updateValue("qrcode", (Object)(PictureUtil.getFileServerUrl() + qrCodeimg));
            ((BillFormData)this.getBillData()).updateValue("starttime", (Object)DateUtils.formatDate((Date)ticket.getDate("starttime"), (Object[])new Object[]{"yyyy-MM-dd"}));
            ((BillFormData)this.getBillData()).updateValue("endtime", (Object)DateUtils.formatDate((Date)ticket.getDate("endtime"), (Object[])new Object[]{"yyyy-MM-dd"}));
            ((BillFormData)this.getBillData()).updateValue("ticketvalue", (Object)ticket.getBigDecimal("ticketvalue").setScale(2).stripTrailingZeros().toPlainString());
            ((BillFormData)this.getBillData()).updateValue("minconsumeamount", (Object)("\u6ee1" + OlstoreUtil.getBigDecimal((BigDecimal)ticket.getBigDecimal("tickettypeid.minconsumeamount")).intValue() + "\u5143\u53ef\u4ee5\u4f7f\u7528"));
            ((BillFormData)this.getBillData()).updateValue("codition1", (Object)"1\u3001\u672c\u5238\u4ec5\u53ef\u4ee5\u4f7f\u7528\u4e00\u6b21");
            ((BillFormData)this.getBillData()).updateValue("codition2", (Object)("2\u3001\u793c\u5238\u9002\u7528\u7ec8\u7aef\uff1a" + OlstoreUtil.getTicketApplyTerminal((int)ticket.getInt("ticketapplyterminal"))));
            ((BillFormData)this.getBillData()).updateValue("codition3", (Object)("3\u3001\u6700\u4f4e\u6d88\u8d39\u91d1\u989d\uff1a\u5355\u7b14\u6d88\u8d39\u91d1\u989d\u6ee1" + ticket.getBigDecimal("tickettypeid.minconsumeamount").setScale(2).stripTrailingZeros().toPlainString() + "\u5143\u4f7f\u7528"));
            if (ticket.getInt("tickettypeid.usagemode") == 0) {
                ((ExtBillView)this.view).hide("cashticketpanel", false);
                ((ExtBillView)this.view).hide("giftticketpanel", true);
            } else {
                ((ExtBillView)this.view).hide("cashticketpanel", true);
                ((ExtBillView)this.view).hide("giftticketpanel", false);
            }
            String ticketStatus = ticket.getString("ticketstatus");
            if (TicketStatusEnum.SEND.getName().equals(ticketStatus)) {
                ((ExtBillView)this.view).hide("use", false);
            } else if (TicketStatusEnum.CHECKED.getName().equals(ticketStatus)) {
                ((ExtBillView)this.view).hide("used", false);
            } else if (TicketStatusEnum.OVERRIDE.getName().equals(ticketStatus)) {
                ((ExtBillView)this.view).hide("overtime", false);
            } else if (TicketStatusEnum.WAIT_ACTIVATE.getName().equals(ticketStatus)) {
                ((ExtBillView)this.view).hide("wait", false);
            }
        }
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "use": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_ticketitem_search");
                openParam.addCustomParam("ticketId", ((BillFormData)this.billData).getString("ticketid"));
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }
}

