/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class PosTicketItemSearchPlugin
extends ExtListViewPlugin {
    private static final String itementrys = "itemlist";
    protected static Log logger = LogFactory.getLog(PosTicketItemSearchPlugin.class);

    public ListDataSet<DynamicObjectCollection> onDataLoad(LoadDataEvent event) {
        Long customerId;
        ListDataSet listDataSet = super.onDataLoad(event);
        String billId = event.getCustomParam().getString("ticketId");
        ((ListFormData)this.billData).updateValue("ticketid", (Object)billId);
        DynamicObject ticket = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(billId), (String)"ocdbd_ticketinfo");
        ((ListFormData)this.billData).updateValue("ticketpanel", (Object)("\u4ee5\u4e0b\u5546\u54c1\u9002\u7528\u6ee1" + OlstoreUtil.getBigDecimal((BigDecimal)ticket.getBigDecimal("tickettypeid.minconsumeamount")).intValue() + "\u5143\u53ef\u4f7f\u7528\u7684\u4f18\u60e0\u5238\uff08\u5238\u53f7\uff1a" + ticket.getString("number") + "\uff09"));
        String keyword = event.getFilterParam() != null && event.getFilterParam().containsKey("search") ? event.getFilterParam().get("search").toString() : event.getEventParam().getString("search");
        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
        if (currentStore == null) {
            DynamicObject defaultStore = OlstoreStoreInfoHelper.getDefaultStore();
            customerId = defaultStore.getLong("id");
            logger.info("\u5238\u5185\u641c\u7d22\u9ed8\u8ba4\u95e8\u5e97id\uff1a" + customerId);
        } else {
            customerId = currentStore.getLong("id");
        }
        DynamicObjectCollection pageDate = this.getItemList(customerId, billId, keyword, event.getPage(), event.getPageSize());
        if (pageDate.size() > 0) {
            ((ExtListView)this.view).hide(itementrys, false);
        }
        listDataSet.setRows((Object)pageDate);
        return listDataSet;
    }

    private DynamicObjectCollection getItemList(Long customerId, String billid, String keyword, int page, int pageSize) {
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        DynamicObject ticketInfo = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(billid), (String)"ocdbd_ticketinfo");
        DynamicObject ticketType = ticketInfo.getDynamicObject("tickettypeid");
        logger.info("PosTicketItemSearchPlugin getItemList \u793c\u5238\u5238\u5185\u5546\u54c1\u641c\u7d22 \u53c2\u6570\uff1a" + customerId, (Object)("," + billid + "," + keyword));
        List ticketItemList = OlstoreItemHelper.getTicketItemList((DynamicObject)ticketType, (long)customerId, (String)keyword, (int)(page - 1), (int)pageSize);
        logger.info("PosTicketItemSearchPlugin getItemList \u793c\u5238\u5238\u5185\u5546\u54c1\u641c\u7d22 \u8fd4\u56de\u503c\uff1a" + ticketItemList);
        if (ticketItemList != null && ticketItemList.size() > 0) {
            for (JSONObject item : ticketItemList) {
                DynamicObject dataObject = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
                dataObject.set("id", (Object)item.getString("itemid"));
                dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + item.get((Object)"thumbnail")));
                dataObject.set("itemname", (Object)item.getString("itemname"));
                dataObject.set("minmemberprice", (Object)item.getBigDecimal("memberprice"));
                dataObject.set("barcodeid", (Object)item.getString("barcodeid"));
                entryList.add((Object)dataObject);
            }
            ((ExtListView)this.view).hide("subpanel", true);
            ((ExtListView)this.view).hide(itementrys, false);
        } else {
            ((ExtListView)this.view).hide("subpanel", false);
            ((ExtListView)this.view).hide(itementrys, true);
        }
        return entryList;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "itempanel": {
                DynamicObject entryRowData = ((ListFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_itemdetails");
                openParam.addCustomParam("itemid", String.valueOf(entryRowData.get("id")));
                openParam.addCustomParam("barcodeid", String.valueOf(entryRowData.get("barcodeid")));
                openParam.addCustomParam("ticketid", ((ListFormData)this.billData).getString("ticketid"));
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }
}

