/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.olstore;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.enums.TicketStatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;

public class PosTicketListPlugin
extends ExtListViewPlugin {
    private static final String ticketentrys = "ticketlist";
    private static final String cid_searchstatus = "searchstatus";

    public ListDataSet<DynamicObjectCollection> onDataLoad(LoadDataEvent event) {
        DynamicObjectCollection ticketList;
        ListDataSet listDataSet = super.onDataLoad(event);
        String searchStatus = TicketStatusEnum.SEND.getName();
        if (event.getFilterParam() != null && event.getFilterParam().containsKey(cid_searchstatus)) {
            List searchStatusList = (List)event.getFilterParam().get(cid_searchstatus);
            searchStatus = StringUtil.joinList((String)",", (List)searchStatusList);
        }
        if ((ticketList = this.getTicketList(event, searchStatus)) != null && ticketList.size() > 0) {
            listDataSet.setRows((Object)ticketList);
            ((ExtListView)this.view).hide("subpanel", true);
        } else {
            ((ExtListView)this.view).hide("subpanel", false);
        }
        return listDataSet;
    }

    private DynamicObjectCollection getTicketList(LoadDataEvent event, String searchStatus) {
        DynamicObjectCollection entryList = new DynamicObjectCollection();
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        JSONObject currentStore = OlstoreUtil.getCurrentStore((ClientEvent)event);
        Long customerId = currentStore.getLong("id");
        Map map = OlstoreTicketHelper.getTicketInfoByBranchId((long)customerId, (String)searchStatus, (long)memberId);
        if (!CollectionUtils.isEmpty((Map)map)) {
            List ticketList = Arrays.stream(map.values().toArray(new DynamicObject[0])).collect(Collectors.toList());
            ticketList.sort(Comparator.comparing(r -> DynamicObjectUtils.getLong((DynamicObject)((DynamicObject)r), (String)"id")).reversed());
            for (int i = 0; i < ticketList.size(); ++i) {
                DynamicObject ticket = (DynamicObject)ticketList.get(i);
                DynamicObject dataObject = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(ticketentrys);
                dataObject.set("id", ticket.get("id"));
                dataObject.set("number", ticket.get("number"));
                dataObject.set("starttime", (Object)DateUtils.formatDate((Date)ticket.getDate("starttime"), (Object[])new Object[]{"yyyy-MM-dd"}));
                dataObject.set("endtime", (Object)DateUtils.formatDate((Date)ticket.getDate("endtime"), (Object[])new Object[]{"yyyy-MM-dd"}));
                dataObject.set("limitname", (Object)OlstoreUtil.getTicketApplyTerminal((int)ticket.getInt("ticketapplyterminal")));
                dataObject.set("ticketvalue", (Object)ticket.getBigDecimal("ticketvalue").setScale(2).stripTrailingZeros().toPlainString());
                dataObject.set("minconsumeamount", (Object)("\u6ee1" + ticket.getBigDecimal("tickettypeid.minconsumeamount").setScale(2).stripTrailingZeros().toPlainString() + "\u5143\u4f7f\u7528"));
                entryList.add((Object)dataObject);
                if (ticket.getInt("tickettypeid.usagemode") == 0) {
                    ((ExtListView)this.view).hide("cashticketpanel", false, i);
                    ((ExtListView)this.view).hide("giftticketpanel", true, i);
                } else {
                    ((ExtListView)this.view).hide("cashticketpanel", true, i);
                    ((ExtListView)this.view).hide("giftticketpanel", false, i);
                }
                if ("P".equals(searchStatus)) {
                    ((ExtListView)this.view).hide("use", false, i);
                    continue;
                }
                ((ExtListView)this.view).hide("use", true, i);
            }
            ((ExtListView)this.view).hide("ticketlistm_scroller", false);
            ((ExtListView)this.view).hide("subpanel", true);
        } else {
            ((ExtListView)this.view).hide("ticketlistm_scroller", true);
            ((ExtListView)this.view).hide("subpanel", false);
        }
        if (TicketStatusEnum.SEND.getName().equals(searchStatus)) {
            ((ExtListView)this.view).hide("use", false);
        } else {
            ((ExtListView)this.view).hide("use", true);
        }
        return entryList;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "detail": 
            case "ticketnumberpanel": 
            case "timepanel": 
            case "ticketvaluepanel": {
                OpenParam openParam = new OpenParam();
                DynamicObject entryRowData = ((ListFormData)this.getBillData()).getEntryRowData(ticketentrys, event.getCurrentRow());
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_ticketdetail");
                openParam.addCustomParam("billsource", "ocgcm_ticketquerydetail");
                openParam.addCustomParam("id", entryRowData.getString("id"));
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
            case "ticketorderlist": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_ticketorder_list");
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
            case "use": {
                OpenParam openParam = new OpenParam();
                DynamicObject entryRowData = ((ListFormData)this.getBillData()).getEntryRowData(ticketentrys, event.getCurrentRow());
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocpos_ticketitem_search");
                openParam.addCustomParam("billsource", "ocpos_ticketorder_list");
                openParam.addCustomParam("ticketId", entryRowData.getString("id"));
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
            case "receiveticket_list": {
                OpenParam receiveTicketListView = OlstoreUtil.createOpenParam((String)"ocpos_ticketlistm", (String)"ocpos_receiveticket_list");
                ((ExtListView)this.getView()).showView(receiveTicketListView);
                break;
            }
        }
        super.onClick(event);
    }
}

